/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ejb.TimerService;
import javax.ejb.TransactionAttributeType;
import javax.ejb.TransactionManagementType;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentConfigurator;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.ComponentNamingMode;
import org.jboss.as.ee.component.ComponentViewInstance;
import org.jboss.as.ee.component.NamespaceConfigurator;
import org.jboss.as.ee.component.ViewConfiguration;
import org.jboss.as.ee.component.ViewConfigurator;
import org.jboss.as.ee.component.ViewDescription;
import org.jboss.as.ejb3.EJBMethodIdentifier;
import org.jboss.as.ejb3.component.ArrayKey;
import org.jboss.as.ejb3.component.EJBComponentCreateServiceFactory;
import org.jboss.as.ejb3.component.EJBUtilities;
import org.jboss.as.ejb3.component.EJBViewDescription;
import org.jboss.as.ejb3.component.MethodIntf;
import org.jboss.as.ejb3.component.PopulatingMap;
import org.jboss.as.ejb3.deployment.EjbDeploymentAttachmentKeys;
import org.jboss.as.ejb3.deployment.EjbJarConfiguration;
import org.jboss.as.ejb3.deployment.EjbJarDescription;
import org.jboss.as.ejb3.security.EJBSecurityViewConfigurator;
import org.jboss.as.ejb3.timerservice.NonFunctionalTimerService;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.invocation.ImmediateInterceptorFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;

public abstract class EJBComponentDescription
extends ComponentDescription {
    private TransactionAttributeType beanTransactionAttribute = TransactionAttributeType.REQUIRED;
    private TransactionManagementType transactionManagementType = TransactionManagementType.CONTAINER;
    private final Map<MethodIntf, TransactionAttributeType> txPerViewStyle1 = new HashMap<MethodIntf, TransactionAttributeType>();
    private String securityDomain;
    private final Set<String> declaredRoles = new HashSet<String>();
    private String runAsRole;
    private final Map<String, Collection<EJBMethodIdentifier>> methodLevelDenyAll = new HashMap<String, Collection<EJBMethodIdentifier>>();
    private final Map<String, Collection<String>> classLevelDenyAll = new HashMap<String, Collection<String>>();
    private final Map<String, Map<EJBMethodIdentifier, Set<String>>> methodLevelRolesAllowed = new HashMap<String, Map<EJBMethodIdentifier, Set<String>>>();
    private final Map<String, Map<String, Set<String>>> classLevelRolesAllowed = new HashMap<String, Map<String, Set<String>>>();
    private final Map<String, Collection<String>> securityRoleLinks = new HashMap<String, Collection<String>>();
    private final Map<String, Collection<EJBMethodIdentifier>> methodLevelPermitAll = new HashMap<String, Collection<EJBMethodIdentifier>>();
    private final Map<String, Collection<String>> classLevelPermitAll = new HashMap<String, Collection<String>>();
    private final List<String> aroundInvokeDDMethods = new ArrayList<String>(0);
    private final List<String> preDestroyDDMethods = new ArrayList<String>(0);
    private final List<String> postConstructDDMethods = new ArrayList<String>(0);
    private TimerService timerService = NonFunctionalTimerService.INSTANCE;
    private final PopulatingMap<MethodIntf, Map<String, TransactionAttributeType>> txPerViewStyle2 = new PopulatingMap<MethodIntf, Map<String, TransactionAttributeType>>(){

        @Override
        Map<String, TransactionAttributeType> populate() {
            return new HashMap<String, TransactionAttributeType>();
        }
    };
    private final PopulatingMap<MethodIntf, PopulatingMap<String, Map<ArrayKey, TransactionAttributeType>>> txPerViewStyle3 = new PopulatingMap<MethodIntf, PopulatingMap<String, Map<ArrayKey, TransactionAttributeType>>>(){

        @Override
        PopulatingMap<String, Map<ArrayKey, TransactionAttributeType>> populate() {
            return new PopulatingMap<String, Map<ArrayKey, TransactionAttributeType>>(){

                @Override
                Map<ArrayKey, TransactionAttributeType> populate() {
                    return new HashMap<ArrayKey, TransactionAttributeType>();
                }
            };
        }
    };
    private final Map<String, TransactionAttributeType> txStyle1 = new HashMap<String, TransactionAttributeType>();
    private final Map<String, TransactionAttributeType> txStyle2 = new HashMap<String, TransactionAttributeType>();
    private final PopulatingMap<String, PopulatingMap<String, Map<ArrayKey, TransactionAttributeType>>> txStyle3 = new PopulatingMap<String, PopulatingMap<String, Map<ArrayKey, TransactionAttributeType>>>(){

        @Override
        PopulatingMap<String, Map<ArrayKey, TransactionAttributeType>> populate() {
            return new PopulatingMap<String, Map<ArrayKey, TransactionAttributeType>>(){

                @Override
                Map<ArrayKey, TransactionAttributeType> populate() {
                    return new HashMap<ArrayKey, TransactionAttributeType>();
                }
            };
        }
    };

    public EJBComponentDescription(String componentName, String componentClassName, EjbJarDescription ejbJarDescription, ServiceName deploymentUnitServiceName) {
        super(componentName, componentClassName, ejbJarDescription.getEEModuleDescription(), ejbJarDescription.getApplicationClassesDescription().getOrAddClassByName(componentClassName), deploymentUnitServiceName, ejbJarDescription.getApplicationClassesDescription());
        if (ejbJarDescription.isWar()) {
            this.setNamingMode(ComponentNamingMode.USE_MODULE);
        } else {
            this.setNamingMode(ComponentNamingMode.CREATE);
        }
        this.getConfigurators().addFirst(new NamespaceConfigurator());
        this.getConfigurators().add(new EjbJarConfigurationConfigurator());
        this.addDependency(EJBUtilities.SERVICE_NAME, ServiceBuilder.DependencyType.REQUIRED);
        this.addCurrentInvocationContextFactory();
    }

    private static <K, V> V get(Map<K, V> map, K key) {
        if (map == null) {
            return null;
        }
        return map.get(key);
    }

    public TransactionAttributeType getTransactionAttribute(MethodIntf methodIntf, String className, String methodName, String ... methodParams) {
        assert (methodIntf != null) : "methodIntf is null";
        assert (methodName != null) : "methodName is null";
        assert (methodParams != null) : "methodParams is null";
        ArrayKey methodParamsKey = new ArrayKey(methodParams);
        TransactionAttributeType txAttr = (TransactionAttributeType)EJBComponentDescription.get((Map)EJBComponentDescription.get(EJBComponentDescription.get(this.txPerViewStyle3, methodIntf), methodName), methodParamsKey);
        if (txAttr != null) {
            return txAttr;
        }
        txAttr = EJBComponentDescription.get(EJBComponentDescription.get(this.txPerViewStyle2, methodIntf), methodName);
        if (txAttr != null) {
            return txAttr;
        }
        txAttr = EJBComponentDescription.get(this.txPerViewStyle1, methodIntf);
        if (txAttr != null) {
            return txAttr;
        }
        txAttr = (TransactionAttributeType)EJBComponentDescription.get((Map)EJBComponentDescription.get(EJBComponentDescription.get(this.txStyle3, className), methodName), methodParamsKey);
        if (txAttr != null) {
            return txAttr;
        }
        txAttr = EJBComponentDescription.get(this.txStyle2, methodName);
        if (txAttr != null) {
            return txAttr;
        }
        txAttr = EJBComponentDescription.get(this.txStyle1, className);
        if (txAttr != null) {
            return txAttr;
        }
        return this.beanTransactionAttribute;
    }

    public TransactionManagementType getTransactionManagementType() {
        return this.transactionManagementType;
    }

    public void setTransactionAttribute(MethodIntf methodIntf, String className, TransactionAttributeType transactionAttribute) {
        if (methodIntf != null && className != null) {
            throw new IllegalArgumentException("both methodIntf and className are set on " + this.getComponentName());
        }
        if (methodIntf == null) {
            this.txStyle1.put(className, transactionAttribute);
        } else {
            this.txPerViewStyle1.put(methodIntf, transactionAttribute);
        }
    }

    public void setTransactionAttribute(MethodIntf methodIntf, TransactionAttributeType transactionAttribute, String methodName) {
        if (methodIntf == null) {
            this.txStyle2.put(methodName, transactionAttribute);
        } else {
            this.txPerViewStyle2.pick(methodIntf).put(methodName, transactionAttribute);
        }
    }

    public void setTransactionAttribute(MethodIntf methodIntf, TransactionAttributeType transactionAttribute, String className, String methodName, String ... methodParams) {
        ArrayKey methodParamsKey = new ArrayKey(methodParams);
        if (methodIntf == null) {
            this.txStyle3.pick(className).pick(methodName).put(methodParamsKey, transactionAttribute);
        } else {
            this.txPerViewStyle3.pick(methodIntf).pick(methodName).put(methodParamsKey, transactionAttribute);
        }
    }

    public void setTransactionManagementType(TransactionManagementType transactionManagementType) {
        this.transactionManagementType = transactionManagementType;
    }

    public String getEJBName() {
        return this.getComponentName();
    }

    public String getEJBClassName() {
        return this.getComponentClassName();
    }

    protected void setupViewInterceptors(ViewDescription view) {
        this.addCurrentInvocationContextFactory(view);
        this.setupSecurityInterceptors(view);
    }

    protected void setupClientViewInterceptors(ViewDescription view) {
        this.addToStringMethodInterceptor(view);
    }

    protected abstract void addCurrentInvocationContextFactory();

    protected abstract void addCurrentInvocationContextFactory(ViewDescription var1);

    protected void setupSecurityInterceptors(ViewDescription view) {
        view.getConfigurators().add(new EJBSecurityViewConfigurator());
    }

    private void addToStringMethodInterceptor(ViewDescription view) {
        view.getConfigurators().add(new ViewConfigurator(){

            public void configure(DeploymentPhaseContext context, ComponentConfiguration componentConfiguration, ViewDescription description, ViewConfiguration configuration) throws DeploymentUnitProcessingException {
                Method TO_STRING_METHOD;
                try {
                    TO_STRING_METHOD = Object.class.getMethod("toString", new Class[0]);
                }
                catch (NoSuchMethodException nsme) {
                    throw new DeploymentUnitProcessingException((Throwable)nsme);
                }
                List methods = configuration.getProxyFactory().getCachedMethods();
                for (Method method : methods) {
                    if (!TO_STRING_METHOD.equals(method)) continue;
                    configuration.addClientInterceptor(method, (InterceptorFactory)new ImmediateInterceptorFactory((Interceptor)new ToStringMethodInterceptor(EJBComponentDescription.this.getComponentName())), 256);
                    return;
                }
            }
        });
    }

    public boolean isMessageDriven() {
        return false;
    }

    public boolean isSingleton() {
        return false;
    }

    public boolean isStateful() {
        return false;
    }

    public boolean isStateless() {
        return false;
    }

    public void addDeclaredRoles(String ... roles) {
        this.declaredRoles.addAll(Arrays.asList(roles));
    }

    public void setDeclaredRoles(Collection<String> roles) {
        if (roles == null) {
            throw new IllegalArgumentException("Cannot set security roles to null");
        }
        this.declaredRoles.clear();
        this.declaredRoles.addAll(roles);
    }

    public Set<String> getDeclaredRoles() {
        return Collections.unmodifiableSet(this.declaredRoles);
    }

    public void setRunAs(String role) {
        this.runAsRole = role;
    }

    public String getRunAs() {
        return this.runAsRole;
    }

    public void setSecurityDomain(String securityDomain) {
        this.securityDomain = securityDomain;
    }

    public String getSecurityDomain() {
        return this.securityDomain;
    }

    public void applyDenyAllOnAllViewsForClass(String className) {
        if (className == null || className.trim().isEmpty()) {
            throw new IllegalArgumentException("Classname cannot be null or empty: " + className);
        }
        for (ViewDescription view : this.getViews()) {
            Collection<String> denyAllClasses = this.classLevelDenyAll.get(view.getViewClassName());
            if (denyAllClasses == null) {
                denyAllClasses = new HashSet<String>();
                this.classLevelDenyAll.put(view.getViewClassName(), denyAllClasses);
            }
            denyAllClasses.add(className);
        }
    }

    public void applyDenyAllOnAllViewsForMethod(EJBMethodIdentifier ejbMethodIdentifier) {
        for (ViewDescription view : this.getViews()) {
            Collection<EJBMethodIdentifier> denyAllViewMethods = this.methodLevelDenyAll.get(view.getViewClassName());
            if (denyAllViewMethods == null) {
                denyAllViewMethods = new ArrayList<EJBMethodIdentifier>();
                this.methodLevelDenyAll.put(view.getViewClassName(), denyAllViewMethods);
            }
            denyAllViewMethods.add(ejbMethodIdentifier);
        }
    }

    public void applyDenyAllOnViewTypeForMethod(MethodIntf viewType, EJBMethodIdentifier ejbMethodIdentifier) {
        for (ViewDescription view : this.getViews()) {
            EJBViewDescription ejbView;
            if (!(view instanceof EJBViewDescription) || (ejbView = (EJBViewDescription)view).getMethodIntf() != viewType) continue;
            Collection<EJBMethodIdentifier> denyAllViewMethods = this.methodLevelDenyAll.get(view.getViewClassName());
            if (denyAllViewMethods == null) {
                denyAllViewMethods = new ArrayList<EJBMethodIdentifier>();
                this.methodLevelDenyAll.put(view.getViewClassName(), denyAllViewMethods);
            }
            denyAllViewMethods.add(ejbMethodIdentifier);
        }
    }

    public void applyDenyAllOnAllMethodsOfAllViews() {
        this.applyDenyAllOnAllViewsForClass(this.getEJBClassName());
    }

    public void applyDenyAllOnAllMethodsOfViewType(MethodIntf viewType) {
        for (ViewDescription view : this.getViews()) {
            EJBViewDescription ejbView;
            if (!(view instanceof EJBViewDescription) || (ejbView = (EJBViewDescription)view).getMethodIntf() != viewType) continue;
            Collection<String> denyAllApplicableClasses = this.classLevelDenyAll.get(ejbView.getViewClassName());
            if (denyAllApplicableClasses == null) {
                denyAllApplicableClasses = new HashSet<String>();
                this.classLevelDenyAll.put(ejbView.getViewClassName(), denyAllApplicableClasses);
            }
            denyAllApplicableClasses.add(this.getEJBClassName());
        }
    }

    public Collection<EJBMethodIdentifier> getDenyAllMethodsForView(String viewClassName) {
        Collection<EJBMethodIdentifier> denyAllMethods = this.methodLevelDenyAll.get(viewClassName);
        if (denyAllMethods != null) {
            return Collections.unmodifiableCollection(denyAllMethods);
        }
        return Collections.emptySet();
    }

    public boolean isDenyAllApplicableToClass(String viewClassName, String className) {
        Collection<String> denyAllApplicableClasses = this.classLevelDenyAll.get(viewClassName);
        if (denyAllApplicableClasses == null) {
            return false;
        }
        return denyAllApplicableClasses.contains(className);
    }

    public void setRolesAllowedOnAllViewsForClass(String className, Set<String> roles) {
        if (className == null || className.trim().isEmpty()) {
            throw new IllegalArgumentException("Classname cannot be null or empty: " + className);
        }
        if (roles == null) {
            throw new IllegalArgumentException("Cannot set null roles for class " + className);
        }
        for (ViewDescription view : this.getViews()) {
            Map<String, Set<String>> perViewRoles = this.classLevelRolesAllowed.get(view.getViewClassName());
            if (perViewRoles == null) {
                perViewRoles = new HashMap<String, Set<String>>();
                this.classLevelRolesAllowed.put(view.getViewClassName(), perViewRoles);
            }
            perViewRoles.put(className, roles);
        }
    }

    public void setRolesAllowedForAllMethodsOfAllViews(Set<String> roles) {
        this.setRolesAllowedOnAllViewsForClass(this.getEJBClassName(), roles);
    }

    public void setRolesAllowedOnAllViewsForMethod(EJBMethodIdentifier ejbMethodIdentifier, Set<String> roles) {
        if (ejbMethodIdentifier == null) {
            throw new IllegalArgumentException("EJB method identifier cannot be null while setting roles on method");
        }
        if (roles == null) {
            throw new IllegalArgumentException("Roles cannot be null while setting roles on method: " + ejbMethodIdentifier);
        }
        for (ViewDescription view : this.getViews()) {
            Map<EJBMethodIdentifier, Set<String>> perViewMethodRoles = this.methodLevelRolesAllowed.get(view.getViewClassName());
            if (perViewMethodRoles == null) {
                perViewMethodRoles = new HashMap<EJBMethodIdentifier, Set<String>>();
                this.methodLevelRolesAllowed.put(view.getViewClassName(), perViewMethodRoles);
            }
            perViewMethodRoles.put(ejbMethodIdentifier, roles);
        }
    }

    public void setRolesAllowedForAllMethodsOnViewType(MethodIntf viewType, Set<String> roles) {
        if (roles == null) {
            throw new IllegalArgumentException("Roles cannot be null while setting roles on view type: " + (Object)((Object)viewType));
        }
        for (ViewDescription view : this.getViews()) {
            EJBViewDescription ejbView;
            if (!(view instanceof EJBViewDescription) || (ejbView = (EJBViewDescription)view).getMethodIntf() != viewType) continue;
            Map<String, Set<String>> perViewRoles = this.classLevelRolesAllowed.get(view.getViewClassName());
            if (perViewRoles == null) {
                perViewRoles = new HashMap<String, Set<String>>();
                this.classLevelRolesAllowed.put(view.getViewClassName(), perViewRoles);
            }
            perViewRoles.put(view.getViewClassName(), roles);
        }
    }

    public void setRolesAllowedForMethodOnViewType(MethodIntf viewType, EJBMethodIdentifier ejbMethodIdentifier, Set<String> roles) {
        if (ejbMethodIdentifier == null) {
            throw new IllegalArgumentException("EJB method identifier cannot be null while setting roles on view type: " + (Object)((Object)viewType));
        }
        if (roles == null) {
            throw new IllegalArgumentException("Roles cannot be null while setting roles on view type: " + (Object)((Object)viewType) + " and method: " + ejbMethodIdentifier);
        }
        for (ViewDescription view : this.getViews()) {
            EJBViewDescription ejbView;
            if (!(view instanceof EJBViewDescription) || (ejbView = (EJBViewDescription)view).getMethodIntf() != viewType) continue;
            Map<EJBMethodIdentifier, Set<String>> perViewMethodRoles = this.methodLevelRolesAllowed.get(view.getViewClassName());
            if (perViewMethodRoles == null) {
                perViewMethodRoles = new HashMap<EJBMethodIdentifier, Set<String>>();
                this.methodLevelRolesAllowed.put(view.getViewClassName(), perViewMethodRoles);
            }
            perViewMethodRoles.put(ejbMethodIdentifier, roles);
        }
    }

    public Set<String> getRolesAllowed(String viewClassName, EJBMethodIdentifier method) {
        Map<EJBMethodIdentifier, Set<String>> methods = this.methodLevelRolesAllowed.get(viewClassName);
        if (methods == null || methods.get(method) == null) {
            return Collections.emptySet();
        }
        return methods.get(method);
    }

    public Set<String> getRolesAllowedForClass(String viewClassName, String className) {
        Map<String, Set<String>> perClassRoles = this.classLevelRolesAllowed.get(viewClassName);
        if (perClassRoles == null || perClassRoles.get(className) == null) {
            return Collections.emptySet();
        }
        return perClassRoles.get(className);
    }

    public void linkSecurityRoles(String fromRole, String toRole) {
        if (fromRole == null || fromRole.trim().isEmpty()) {
            throw new IllegalArgumentException("Cannot link from a null or empty security role: " + fromRole);
        }
        if (toRole == null || toRole.trim().isEmpty()) {
            throw new IllegalArgumentException("Cannot link to a null or empty security role: " + toRole);
        }
        Collection<String> roleLinks = this.securityRoleLinks.get(fromRole);
        if (roleLinks == null) {
            roleLinks = new HashSet<String>();
            this.securityRoleLinks.put(fromRole, roleLinks);
        }
        roleLinks.add(toRole);
    }

    protected EJBViewDescription registerView(String viewClassName, MethodIntf viewType) {
        EJBViewDescription viewDescription = new EJBViewDescription(this, viewClassName, viewType);
        this.getViews().add(viewDescription);
        this.setupViewInterceptors(viewDescription);
        this.setupClientViewInterceptors(viewDescription);
        return viewDescription;
    }

    public Map<String, Collection<String>> getSecurityRoleLinks() {
        return Collections.unmodifiableMap(this.securityRoleLinks);
    }

    public void applyPermitAllOnAllViewsForClass(String className) {
        if (className == null || className.trim().isEmpty()) {
            throw new IllegalArgumentException("Classname cannot be null or empty: " + className);
        }
        for (ViewDescription view : this.getViews()) {
            Collection<String> permitAllClasses = this.classLevelPermitAll.get(view.getViewClassName());
            if (permitAllClasses == null) {
                permitAllClasses = new HashSet<String>();
                this.classLevelPermitAll.put(view.getViewClassName(), permitAllClasses);
            }
            permitAllClasses.add(className);
        }
    }

    public void applyPermitAllOnAllViewsForMethod(EJBMethodIdentifier ejbMethodIdentifier) {
        for (ViewDescription view : this.getViews()) {
            Collection<EJBMethodIdentifier> permitAllMethods = this.methodLevelPermitAll.get(view.getViewClassName());
            if (permitAllMethods == null) {
                permitAllMethods = new ArrayList<EJBMethodIdentifier>();
                this.methodLevelPermitAll.put(view.getViewClassName(), permitAllMethods);
            }
            permitAllMethods.add(ejbMethodIdentifier);
        }
    }

    public Collection<EJBMethodIdentifier> getPermitAllMethodsForView(String viewClassName) {
        Collection<EJBMethodIdentifier> permitAllMethods = this.methodLevelPermitAll.get(viewClassName);
        if (permitAllMethods != null) {
            return Collections.unmodifiableCollection(permitAllMethods);
        }
        return Collections.emptySet();
    }

    public boolean isPermitAllApplicableToClass(String viewClassName, String className) {
        Collection<String> permitAllApplicationClasses = this.classLevelPermitAll.get(viewClassName);
        if (permitAllApplicationClasses == null) {
            return false;
        }
        return permitAllApplicationClasses.contains(className);
    }

    public boolean isSecurityEnabled() {
        return this.securityDomain != null;
    }

    public List<String> getAroundInvokeDDMethods() {
        return this.aroundInvokeDDMethods;
    }

    public List<String> getPostConstructDDMethods() {
        return this.postConstructDDMethods;
    }

    public List<String> getPreDestroyDDMethods() {
        return this.preDestroyDDMethods;
    }

    public TimerService getTimerService() {
        return this.timerService;
    }

    public void setTimerService(TimerService timerService) {
        this.timerService = timerService;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + "{" + "serviceName=" + this.getServiceName() + '}' + "@" + Integer.toHexString(((Object)((Object)this)).hashCode());
    }

    private static class ToStringMethodInterceptor
    implements Interceptor {
        private final String name;

        public ToStringMethodInterceptor(String name) {
            this.name = name;
        }

        public Object processInvocation(InterceptorContext context) throws Exception {
            ComponentViewInstance componentViewInstance = (ComponentViewInstance)context.getPrivateData(ComponentViewInstance.class);
            if (componentViewInstance == null) {
                throw new IllegalStateException("ComponentViewInstance not available in interceptor context: " + context);
            }
            return "Proxy for view class: " + componentViewInstance.getViewClass().getName() + " of EJB: " + this.name;
        }
    }

    private class EjbJarConfigurationConfigurator
    implements ComponentConfigurator {
        private EjbJarConfigurationConfigurator() {
        }

        public void configure(DeploymentPhaseContext context, ComponentDescription description, ComponentConfiguration configuration) throws DeploymentUnitProcessingException {
            DeploymentUnit deploymentUnit = context.getDeploymentUnit();
            EjbJarConfiguration ejbJarConfiguration = (EjbJarConfiguration)deploymentUnit.getAttachment(EjbDeploymentAttachmentKeys.EJB_JAR_CONFIGURATION);
            if (ejbJarConfiguration == null) {
                throw new DeploymentUnitProcessingException("EjbJarConfiguration not found as an attachment in deployment unit: " + deploymentUnit);
            }
            EJBComponentCreateServiceFactory ejbComponentCreateServiceFactory = (EJBComponentCreateServiceFactory)configuration.getComponentCreateServiceFactory();
            ejbComponentCreateServiceFactory.setEjbJarConfiguration(ejbJarConfiguration);
        }
    }
}

