/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class LCS {
    public static String lcsHtml(String s1, String s2) {
        String rs1 = new StringBuffer(s1).reverse().toString();
        String rs2 = new StringBuffer(s2).reverse().toString();
        LcsString seq = new LcsString(rs1, rs2, true);
        return seq.getHtml(true);
    }

    public static <E> List<E> LongestCommonSubsequence(E[] s1, E[] s2) {
        int[][] num = new int[s1.length + 1][s2.length + 1];
        for (int i = 1; i <= s1.length; ++i) {
            for (int j = 1; j <= s2.length; ++j) {
                num[i][j] = s1[i - 1].equals(s2[j - 1]) ? 1 + num[i - 1][j - 1] : Math.max(num[i - 1][j], num[i][j - 1]);
            }
        }
        int s1position = s1.length;
        int s2position = s2.length;
        LinkedList<E> result = new LinkedList<E>();
        while (s1position != 0 && s2position != 0) {
            if (s1[s1position - 1].equals(s2[s2position - 1])) {
                result.add(s1[s1position - 1]);
                --s1position;
                --s2position;
                continue;
            }
            if (num[s1position][s2position - 1] >= num[s1position - 1][s2position]) {
                --s2position;
                continue;
            }
            --s1position;
        }
        Collections.reverse(result);
        return result;
    }

    public static class LcsString
    extends LongestCommonSubsequence<Character> {
        private String x;
        private String y;
        private final boolean ignoreCase;

        public LcsString(String from, String to, boolean ignoreCase) {
            this.x = from;
            this.y = to;
            this.ignoreCase = ignoreCase;
        }

        public LcsString(String from, String to) {
            this(from, to, false);
        }

        @Override
        protected int lengthOfY() {
            return this.y.length();
        }

        @Override
        protected int lengthOfX() {
            return this.x.length();
        }

        @Override
        protected Character valueOfX(int index) {
            return Character.valueOf(this.x.charAt(index));
        }

        @Override
        protected Character valueOfY(int index) {
            return Character.valueOf(this.y.charAt(index));
        }

        @Override
        protected boolean equals(Character x1, Character y1) {
            if (this.ignoreCase) {
                return null == x1 && null == y1 || Character.toLowerCase(x1.charValue()) == Character.toLowerCase(y1.charValue());
            }
            return super.equals(x1, y1);
        }

        public String getHtmlDiff() {
            LongestCommonSubsequence.DiffType type = null;
            List diffs = this.diff();
            StringBuffer buf = new StringBuffer();
            for (LongestCommonSubsequence.DiffEntry entry2 : diffs) {
                if (type != entry2.getType()) {
                    if (type != null) {
                        buf.append("</span>");
                    }
                    buf.append("<span class=\"" + entry2.getType().getName() + "\">");
                    type = entry2.getType();
                }
                buf.append(this.escapeHtml((Character)entry2.getValue()));
            }
            buf.append("</span>");
            return buf.toString();
        }

        private String getHtml(boolean reverse) {
            LongestCommonSubsequence.DiffType type = null;
            List diffs = this.diff();
            if (reverse) {
                Collections.reverse(diffs);
            }
            StringBuffer buf = new StringBuffer();
            block7: for (LongestCommonSubsequence.DiffEntry entry2 : diffs) {
                if (type != entry2.getType()) {
                    if (type != null) {
                        int indx = buf.lastIndexOf("<b>");
                        if (buf.length() - indx > 6) {
                            buf.append("</b>");
                        } else {
                            buf.replace(indx, indx + 3, "");
                        }
                    }
                    switch (entry2.getType()) {
                        case REMOVE: {
                            type = null;
                            break;
                        }
                        case ADD: {
                            type = null;
                            break;
                        }
                        default: {
                            buf.append("<b>");
                            type = entry2.getType();
                        }
                    }
                }
                switch (entry2.getType()) {
                    case REMOVE: {
                        continue block7;
                    }
                }
                buf.append(this.escapeHtml((Character)entry2.getValue()));
            }
            if (type != null) {
                buf.append("<b>");
            }
            return "<html>" + buf.toString() + "</html>";
        }

        private String escapeHtml(Character ch) {
            switch (ch.charValue()) {
                case '<': {
                    return "&lt;";
                }
                case '>': {
                    return "&gt;";
                }
                case '\"': {
                    return "\\&quot;";
                }
            }
            return ch.toString();
        }
    }

    public static abstract class LongestCommonSubsequence<VALUE> {
        private int[][] c;
        private ArrayList<DiffEntry<VALUE>> diff;
        private ArrayList<VALUE> backtrack;

        protected LongestCommonSubsequence() {
        }

        protected abstract int lengthOfY();

        protected abstract int lengthOfX();

        protected abstract VALUE valueOfX(int var1);

        protected abstract VALUE valueOfY(int var1);

        protected boolean equals(VALUE x1, VALUE y1) {
            return null == x1 && null == y1 || x1.equals(y1);
        }

        protected boolean isXYEqual(int i, int j) {
            return this.equals(this.valueOfXInternal(i), this.valueOfYInternal(j));
        }

        private VALUE valueOfXInternal(int i) {
            return this.valueOfX(i - 1);
        }

        private VALUE valueOfYInternal(int j) {
            return this.valueOfY(j - 1);
        }

        public void calculateLcs() {
            int i;
            if (this.c != null) {
                return;
            }
            this.c = new int[this.lengthOfX() + 1][];
            for (i = 0; i < this.c.length; ++i) {
                this.c[i] = new int[this.lengthOfY() + 1];
            }
            for (i = 1; i < this.c.length; ++i) {
                for (int j = 1; j < this.c[i].length; ++j) {
                    this.c[i][j] = this.isXYEqual(i, j) ? this.c[i - 1][j - 1] + 1 : Math.max(this.c[i][j - 1], this.c[i - 1][j]);
                }
            }
        }

        public int getLcsLength() {
            this.calculateLcs();
            return this.c[this.lengthOfX()][this.lengthOfY()];
        }

        public int getMinEditDistance() {
            this.calculateLcs();
            return this.lengthOfX() + this.lengthOfY() - 2 * Math.abs(this.getLcsLength());
        }

        public List<VALUE> backtrack() {
            this.calculateLcs();
            if (this.backtrack == null) {
                this.backtrack = new ArrayList();
                this.backtrack(this.lengthOfX(), this.lengthOfY());
            }
            return this.backtrack;
        }

        public void backtrack(int i, int j) {
            this.calculateLcs();
            if (i == 0 || j == 0) {
                return;
            }
            if (this.isXYEqual(i, j)) {
                this.backtrack(i - 1, j - 1);
                this.backtrack.add(this.valueOfXInternal(i));
            } else if (this.c[i][j - 1] > this.c[i - 1][j]) {
                this.backtrack(i, j - 1);
            } else {
                this.backtrack(i - 1, j);
            }
        }

        public List<DiffEntry<VALUE>> diff() {
            this.calculateLcs();
            if (this.diff == null) {
                this.diff = new ArrayList();
                this.diff(this.lengthOfX(), this.lengthOfY());
            }
            return this.diff;
        }

        private void diff(int i, int j) {
            this.calculateLcs();
            while (i != 0 || j != 0) {
                if (i > 0 && j > 0 && this.isXYEqual(i, j)) {
                    this.diff.add(new DiffEntry<VALUE>(DiffType.NONE, this.valueOfYInternal(j)));
                    --i;
                    --j;
                    continue;
                }
                if (j > 0 && (i == 0 || this.c[i][j - 1] >= this.c[i - 1][j])) {
                    this.diff.add(new DiffEntry<VALUE>(DiffType.ADD, this.valueOfYInternal(j)));
                    --j;
                    continue;
                }
                if (i <= 0 || j != 0 && this.c[i][j - 1] >= this.c[i - 1][j]) continue;
                this.diff.add(new DiffEntry<VALUE>(DiffType.REMOVE, this.valueOfXInternal(i)));
                --i;
            }
            Collections.reverse(this.diff);
        }

        public String toString() {
            int j;
            this.calculateLcs();
            StringBuffer buf = new StringBuffer();
            buf.append("  ");
            for (j = 1; j <= this.lengthOfY(); ++j) {
                buf.append(this.valueOfYInternal(j));
            }
            buf.append("\n");
            buf.append(" ");
            for (j = 0; j < this.c[0].length; ++j) {
                buf.append(Integer.toString(this.c[0][j]));
            }
            buf.append("\n");
            for (int i = 1; i < this.c.length; ++i) {
                buf.append(this.valueOfXInternal(i));
                for (int j2 = 0; j2 < this.c[i].length; ++j2) {
                    buf.append(Integer.toString(this.c[i][j2]));
                }
                buf.append("\n");
            }
            return buf.toString();
        }

        public static class DiffEntry<VALUE> {
            private DiffType type;
            private VALUE value;

            public DiffEntry(DiffType type, VALUE value) {
                this.type = type;
                this.value = value;
            }

            public DiffType getType() {
                return this.type;
            }

            public void setType(DiffType type) {
                this.type = type;
            }

            public VALUE getValue() {
                return this.value;
            }

            public void setValue(VALUE value) {
                this.value = value;
            }

            public String toString() {
                return this.type.toString() + this.value.toString();
            }
        }

        public static enum DiffType {
            ADD("+", "add"),
            REMOVE("-", "remove"),
            NONE(" ", "none");

            private String val;
            private String name;

            private DiffType(String val, String name) {
                this.val = val;
                this.name = name;
            }

            public String toString() {
                return this.val;
            }

            public String getName() {
                return this.name;
            }

            public String getVal() {
                return this.val;
            }
        }
    }
}

