/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.concurrent;

import org.limewire.service.ErrorService;

public class ManagedThread
extends Thread {
    private static Thread.UncaughtExceptionHandler HANDLER = new ErrorServiceHandler();

    public ManagedThread() {
        this.setPriority(5);
        this.setUncaughtExceptionHandler(HANDLER);
    }

    public ManagedThread(Runnable r) {
        super(r);
        this.setPriority(5);
        this.setUncaughtExceptionHandler(HANDLER);
    }

    public ManagedThread(String name) {
        super(name);
        this.setPriority(5);
        this.setUncaughtExceptionHandler(HANDLER);
    }

    public ManagedThread(Runnable r, String name) {
        super(r, name);
        this.setPriority(5);
        this.setUncaughtExceptionHandler(HANDLER);
    }

    private static class ErrorServiceHandler
    implements Thread.UncaughtExceptionHandler {
        private ErrorServiceHandler() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            ErrorService.error(e, "Uncaught thread error: " + t.getName());
        }
    }
}

