/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.iff;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.jaudiotagger.audio.generic.Utils;

public class ChunkHeader {
    public static final int CHUNK_HEADER_SIZE = 8;
    private long size;
    private String chunkId;
    private ByteOrder byteOrder;
    private long startLocationInFile;

    public ChunkHeader(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
    }

    public boolean readHeader(RandomAccessFile raf) throws IOException {
        ByteBuffer header = ByteBuffer.allocate(8);
        this.startLocationInFile = raf.getFilePointer();
        raf.getChannel().read(header);
        header.order(this.byteOrder);
        header.position(0);
        this.chunkId = Utils.readFourBytesAsChars(header);
        this.size = header.getInt();
        return true;
    }

    public ByteBuffer writeHeader() {
        ByteBuffer bb = ByteBuffer.allocate(8);
        bb.order(this.byteOrder);
        bb.put(this.chunkId.getBytes(StandardCharsets.US_ASCII));
        bb.putInt((int)this.size);
        bb.flip();
        return bb;
    }

    public void setID(String id) {
        this.chunkId = id;
    }

    public String getID() {
        return this.chunkId;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public long getStartLocationInFile() {
        return this.startLocationInFile;
    }
}

