/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.h2.command.ddl.CreateTableData;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.engine.SysProperties;
import org.h2.index.BaseIndex;
import org.h2.index.Cursor;
import org.h2.index.HashIndex;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.index.NonUniqueHashIndex;
import org.h2.index.PageBtreeIndex;
import org.h2.index.PageDataIndex;
import org.h2.index.PageDelegateIndex;
import org.h2.index.ScanIndex;
import org.h2.index.SpatialTreeIndex;
import org.h2.index.TreeIndex;
import org.h2.message.DbException;
import org.h2.message.Trace;
import org.h2.result.Row;
import org.h2.schema.SchemaObject;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.RegularTable;
import org.h2.util.MathUtils;
import org.h2.util.Utils;
import org.h2.value.CompareMode;

public class PageStoreTable
extends RegularTable {
    private Index scanIndex;
    private long rowCount;
    private final ArrayDeque<Session> waitingSessions = new ArrayDeque();
    private final Trace traceLock;
    private final ArrayList<Index> indexes = Utils.newSmallArrayList();
    private long lastModificationId;
    private final PageDataIndex mainIndex;
    private int changesSinceAnalyze;
    private int nextAnalyze;

    public PageStoreTable(CreateTableData createTableData) {
        super(createTableData);
        this.nextAnalyze = this.database.getSettings().analyzeAuto;
        if (createTableData.persistData && this.database.isPersistent()) {
            this.mainIndex = new PageDataIndex(this, createTableData.id, IndexColumn.wrap(this.getColumns()), IndexType.createScan(createTableData.persistData), createTableData.create, createTableData.session);
            this.scanIndex = this.mainIndex;
        } else {
            this.mainIndex = null;
            this.scanIndex = new ScanIndex(this, createTableData.id, IndexColumn.wrap(this.getColumns()), IndexType.createScan(createTableData.persistData));
        }
        this.indexes.add(this.scanIndex);
        this.traceLock = this.database.getTrace(7);
    }

    @Override
    public void close(Session session2) {
        for (Index index : this.indexes) {
            index.close(session2);
        }
    }

    @Override
    public Row getRow(Session session2, long l) {
        return this.scanIndex.getRow(session2, l);
    }

    @Override
    public void addRow(Session session2, Row row) {
        int n;
        this.lastModificationId = this.database.getNextModificationDataId();
        try {
            int n2 = this.indexes.size();
            for (n = 0; n < n2; ++n) {
                Index index = this.indexes.get(n);
                index.add(session2, row);
                this.checkRowCount(session2, index, 1);
            }
            ++this.rowCount;
        }
        catch (Throwable throwable) {
            try {
                while (--n >= 0) {
                    Index index = this.indexes.get(n);
                    index.remove(session2, row);
                    this.checkRowCount(session2, index, 0);
                }
            }
            catch (DbException dbException) {
                this.trace.error(dbException, "could not undo operation");
                throw dbException;
            }
            throw DbException.convert(throwable);
        }
        this.analyzeIfRequired(session2);
    }

    private void checkRowCount(Session session2, Index index, int n) {
        long l;
        if (SysProperties.CHECK && !(index instanceof PageDelegateIndex) && (l = index.getRowCount(session2)) != this.rowCount + (long)n) {
            DbException.throwInternalError("rowCount expected " + (this.rowCount + (long)n) + " got " + l + " " + this.getName() + "." + index.getName());
        }
    }

    @Override
    public Index getScanIndex(Session session2) {
        return this.indexes.get(0);
    }

    @Override
    public Index getUniqueIndex() {
        for (Index index : this.indexes) {
            if (!index.getIndexType().isUnique()) continue;
            return index;
        }
        return null;
    }

    @Override
    public ArrayList<Index> getIndexes() {
        return this.indexes;
    }

    @Override
    public Index addIndex(Session session2, String string, int n, IndexColumn[] indexColumnArray, IndexType indexType, boolean bl, String string2) {
        BaseIndex baseIndex;
        boolean bl2;
        if (indexType.isPrimaryKey()) {
            for (IndexColumn indexColumn : indexColumnArray) {
                Column column = indexColumn.column;
                if (column.isNullable()) {
                    throw DbException.get(90023, column.getName());
                }
                column.setPrimaryKey(true);
            }
        }
        boolean bl3 = bl2 = this.isTemporary() && !this.isGlobalTemporary();
        if (!bl2) {
            this.database.lockMeta(session2);
        }
        if (this.isPersistIndexes() && indexType.isPersistent()) {
            int n2 = this.database.isStarting() && this.database.getPageStore().getRootPageId(n) != 0 ? -1 : (!this.database.isStarting() && this.mainIndex.getRowCount(session2) != 0L || this.mainIndex.getMainIndexColumn() != -1 ? -1 : PageStoreTable.getMainIndexColumn(indexType, indexColumnArray));
            if (n2 != -1) {
                this.mainIndex.setMainIndexColumn(n2);
                baseIndex = new PageDelegateIndex(this, n, string, indexType, this.mainIndex, bl, session2);
            } else {
                baseIndex = indexType.isSpatial() ? new SpatialTreeIndex(this, n, string, indexColumnArray, indexType, true, bl, session2) : new PageBtreeIndex(this, n, string, indexColumnArray, indexType, bl, session2);
            }
        } else if (indexType.isHash()) {
            if (indexColumnArray.length != 1) {
                throw DbException.getUnsupportedException("hash indexes may index only one column");
            }
            baseIndex = indexType.isUnique() ? new HashIndex(this, n, string, indexColumnArray, indexType) : new NonUniqueHashIndex(this, n, string, indexColumnArray, indexType);
        } else {
            baseIndex = indexType.isSpatial() ? new SpatialTreeIndex(this, n, string, indexColumnArray, indexType, false, true, session2) : new TreeIndex(this, n, string, indexColumnArray, indexType);
        }
        if (baseIndex.needRebuild() && this.rowCount > 0L) {
            try {
                long l;
                Index index = this.getScanIndex(session2);
                long l2 = l = index.getRowCount(session2);
                Cursor cursor = index.find(session2, null, null);
                long l3 = 0L;
                int n3 = (int)Math.min(this.rowCount, (long)this.database.getMaxMemoryRows());
                ArrayList<Row> arrayList = new ArrayList<Row>(n3);
                String string3 = this.getName() + ":" + baseIndex.getName();
                int n4 = MathUtils.convertLongToInt(l2);
                while (cursor.next()) {
                    this.database.setProgress(1, string3, MathUtils.convertLongToInt(l3++), n4);
                    Row row = cursor.get();
                    arrayList.add(row);
                    if (arrayList.size() >= n3) {
                        PageStoreTable.addRowsToIndex(session2, arrayList, baseIndex);
                    }
                    --l;
                }
                PageStoreTable.addRowsToIndex(session2, arrayList, baseIndex);
                if (l != 0L) {
                    DbException.throwInternalError("rowcount remaining=" + l + " " + this.getName());
                }
            }
            catch (DbException dbException) {
                this.getSchema().freeUniqueName(string);
                try {
                    baseIndex.remove(session2);
                }
                catch (DbException dbException2) {
                    this.trace.error(dbException2, "could not remove index");
                    throw dbException2;
                }
                throw dbException;
            }
        }
        baseIndex.setTemporary(this.isTemporary());
        if (baseIndex.getCreateSQL() != null) {
            baseIndex.setComment(string2);
            if (bl2) {
                session2.addLocalTempTableIndex(baseIndex);
            } else {
                this.database.addSchemaObject(session2, baseIndex);
            }
        }
        this.indexes.add(baseIndex);
        this.setModified();
        return baseIndex;
    }

    @Override
    public long getRowCount(Session session2) {
        return this.rowCount;
    }

    @Override
    public void removeRow(Session session2, Row row) {
        int n;
        this.lastModificationId = this.database.getNextModificationDataId();
        try {
            for (n = this.indexes.size() - 1; n >= 0; --n) {
                Index index = this.indexes.get(n);
                index.remove(session2, row);
                this.checkRowCount(session2, index, -1);
            }
            --this.rowCount;
        }
        catch (Throwable throwable) {
            try {
                while (++n < this.indexes.size()) {
                    Index index = this.indexes.get(n);
                    index.add(session2, row);
                    this.checkRowCount(session2, index, 0);
                }
            }
            catch (DbException dbException) {
                this.trace.error(dbException, "could not undo operation");
                throw dbException;
            }
            throw DbException.convert(throwable);
        }
        this.analyzeIfRequired(session2);
    }

    @Override
    public void truncate(Session session2) {
        this.lastModificationId = this.database.getNextModificationDataId();
        for (int i = this.indexes.size() - 1; i >= 0; --i) {
            Index index = this.indexes.get(i);
            index.truncate(session2);
        }
        this.rowCount = 0L;
        this.changesSinceAnalyze = 0;
    }

    private void analyzeIfRequired(Session session2) {
        if (this.nextAnalyze == 0 || this.nextAnalyze > this.changesSinceAnalyze++) {
            return;
        }
        this.changesSinceAnalyze = 0;
        int n = 2 * this.nextAnalyze;
        if (n > 0) {
            this.nextAnalyze = n;
        }
        session2.markTableForAnalyze(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean lock(Session session2, boolean bl, boolean bl2) {
        int n = this.database.getLockMode();
        if (n == 0) {
            return this.lockExclusiveSession != null;
        }
        if (this.lockExclusiveSession == session2) {
            return true;
        }
        if (!bl && this.lockSharedSessions.containsKey(session2)) {
            return true;
        }
        Database database = this.database;
        synchronized (database) {
            if (!bl && this.lockSharedSessions.contains(session2)) {
                return true;
            }
            session2.setWaitForLock(this, Thread.currentThread());
            this.waitingSessions.addLast(session2);
            try {
                this.doLock1(session2, n, bl);
            }
            finally {
                session2.setWaitForLock(null, null);
                this.waitingSessions.remove(session2);
            }
        }
        return false;
    }

    private void doLock1(Session session2, int n, boolean bl) {
        this.traceLock(session2, bl, "requesting for");
        long l = 0L;
        boolean bl2 = false;
        while (this.waitingSessions.getFirst() != session2 || !this.doLock2(session2, n, bl)) {
            if (bl2) {
                ArrayList<Session> arrayList = this.checkDeadlock(session2, null, null);
                if (arrayList != null) {
                    throw DbException.get(40001, PageStoreTable.getDeadlockDetails(arrayList, bl));
                }
            } else {
                bl2 = true;
            }
            long l2 = System.nanoTime();
            if (l == 0L) {
                l = l2 + TimeUnit.MILLISECONDS.toNanos(session2.getLockTimeout());
            } else if (l2 >= l) {
                this.traceLock(session2, bl, "timeout after " + session2.getLockTimeout());
                throw DbException.get(50200, this.getName());
            }
            try {
                long l3;
                this.traceLock(session2, bl, "waiting for");
                if (this.database.getLockMode() == 2) {
                    for (int i = 0; i < 20; ++i) {
                        long l4 = Runtime.getRuntime().freeMemory();
                        System.gc();
                        long l5 = Runtime.getRuntime().freeMemory();
                        if (l4 == l5) break;
                    }
                }
                if ((l3 = Math.min(100L, TimeUnit.NANOSECONDS.toMillis(l - l2))) == 0L) {
                    l3 = 1L;
                }
                this.database.wait(l3);
            }
            catch (InterruptedException interruptedException) {
            }
        }
        return;
    }

    private boolean doLock2(Session session2, int n, boolean bl) {
        if (bl) {
            if (this.lockExclusiveSession == null) {
                if (this.lockSharedSessions.isEmpty()) {
                    this.traceLock(session2, bl, "added for");
                    session2.addLock(this);
                    this.lockExclusiveSession = session2;
                    return true;
                }
                if (this.lockSharedSessions.size() == 1 && this.lockSharedSessions.containsKey(session2)) {
                    this.traceLock(session2, bl, "add (upgraded) for ");
                    this.lockExclusiveSession = session2;
                    return true;
                }
            }
        } else if (this.lockExclusiveSession == null) {
            if (n == 3 && !this.database.isMultiThreaded()) {
                return true;
            }
            if (!this.lockSharedSessions.containsKey(session2)) {
                this.traceLock(session2, bl, "ok");
                session2.addLock(this);
                this.lockSharedSessions.put(session2, session2);
            }
            return true;
        }
        return false;
    }

    private void traceLock(Session session2, boolean bl, String string) {
        if (this.traceLock.isDebugEnabled()) {
            this.traceLock.debug("{0} {1} {2} {3}", session2.getId(), bl ? "exclusive write lock" : "shared read lock", string, this.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlock(Session session2) {
        if (this.database != null) {
            this.traceLock(session2, this.lockExclusiveSession == session2, "unlock");
            if (this.lockExclusiveSession == session2) {
                this.lockSharedSessions.remove(session2);
                this.lockExclusiveSession = null;
            }
            Database database = this.database;
            synchronized (database) {
                if (!this.lockSharedSessions.isEmpty()) {
                    this.lockSharedSessions.remove(session2);
                }
                if (!this.waitingSessions.isEmpty()) {
                    this.database.notifyAll();
                }
            }
        }
    }

    public void setRowCount(long l) {
        this.rowCount = l;
    }

    @Override
    public void removeChildrenAndResources(Session session2) {
        if (this.containsLargeObject) {
            this.truncate(session2);
            this.database.getLobStorage().removeAllForTable(this.getId());
            this.database.lockMeta(session2);
        }
        super.removeChildrenAndResources(session2);
        while (this.indexes.size() > 1) {
            Index index = this.indexes.get(1);
            if (index.getName() != null) {
                this.database.removeSchemaObject(session2, index);
            }
            this.indexes.remove(index);
        }
        if (SysProperties.CHECK) {
            for (SchemaObject schemaObject : this.database.getAllSchemaObjects(1)) {
                Index index = (Index)schemaObject;
                if (index.getTable() != this) continue;
                DbException.throwInternalError("index not dropped: " + index.getName());
            }
        }
        this.scanIndex.remove(session2);
        this.database.removeMeta(session2, this.getId());
        this.scanIndex = null;
        this.lockExclusiveSession = null;
        this.lockSharedSessions.clear();
        this.invalidate();
    }

    @Override
    public long getMaxDataModificationId() {
        return this.lastModificationId;
    }

    @Override
    public long getRowCountApproximation() {
        return this.scanIndex.getRowCountApproximation();
    }

    @Override
    public long getDiskSpaceUsed() {
        return this.scanIndex.getDiskSpaceUsed();
    }

    public void setCompareMode(CompareMode compareMode) {
        this.compareMode = compareMode;
    }
}

