/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.function;

import org.h2.command.Parser;
import org.h2.engine.FunctionAlias;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.ValueExpression;
import org.h2.expression.function.FunctionCall;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueCollectionBase;
import org.h2.value.ValueNull;
import org.h2.value.ValueResultSet;

public class JavaFunction
extends Expression
implements FunctionCall {
    private final FunctionAlias functionAlias;
    private final FunctionAlias.JavaMethod javaMethod;
    private final Expression[] args;

    public JavaFunction(FunctionAlias functionAlias, Expression[] expressionArray) {
        this.functionAlias = functionAlias;
        this.javaMethod = functionAlias.findJavaMethod(expressionArray);
        this.args = expressionArray;
    }

    @Override
    public Value getValue(Session session2) {
        return this.javaMethod.getValue(session2, this.args, false);
    }

    @Override
    public TypeInfo getType() {
        return TypeInfo.getTypeInfo(this.javaMethod.getDataType());
    }

    @Override
    public int getValueType() {
        return this.javaMethod.getDataType();
    }

    @Override
    public void mapColumns(ColumnResolver columnResolver, int n, int n2) {
        for (Expression expression : this.args) {
            expression.mapColumns(columnResolver, n, n2);
        }
    }

    @Override
    public Expression optimize(Session session2) {
        boolean bl = this.isDeterministic();
        int n = this.args.length;
        for (int i = 0; i < n; ++i) {
            Expression expression;
            this.args[i] = expression = this.args[i].optimize(session2);
            bl &= expression.isConstant();
        }
        if (bl) {
            return ValueExpression.get(this.getValue(session2));
        }
        return this;
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        for (Expression expression : this.args) {
            if (expression == null) continue;
            expression.setEvaluatable(tableFilter, bl);
        }
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder, boolean bl) {
        if (this.functionAlias.getDatabase().getSettings().functionsInSchema || this.functionAlias.getSchema().getId() != 0) {
            Parser.quoteIdentifier(stringBuilder, this.functionAlias.getSchema().getName(), bl).append('.');
        }
        Parser.quoteIdentifier(stringBuilder, this.functionAlias.getName(), bl).append('(');
        JavaFunction.writeExpressions(stringBuilder, this.args, bl);
        return stringBuilder.append(')');
    }

    @Override
    public void updateAggregate(Session session2, int n) {
        for (Expression expression : this.args) {
            if (expression == null) continue;
            expression.updateAggregate(session2, n);
        }
    }

    @Override
    public String getName() {
        return this.functionAlias.getName();
    }

    @Override
    public ValueResultSet getValueForColumnList(Session session2, Expression[] expressionArray) {
        Value value = this.javaMethod.getValue(session2, expressionArray, true);
        return value == ValueNull.INSTANCE ? null : (ValueResultSet)value;
    }

    @Override
    public Expression[] getArgs() {
        return this.args;
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        switch (expressionVisitor.getType()) {
            case 2: {
                if (this.isDeterministic()) break;
                return false;
            }
            case 7: {
                expressionVisitor.addDependency(this.functionAlias);
                break;
            }
        }
        for (Expression expression : this.args) {
            if (expression == null || expression.isEverything(expressionVisitor)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getCost() {
        int n = this.javaMethod.hasConnectionParam() ? 25 : 5;
        for (Expression expression : this.args) {
            n += expression.getCost();
        }
        return n;
    }

    @Override
    public boolean isDeterministic() {
        return this.functionAlias.isDeterministic();
    }

    @Override
    public Expression[] getExpressionColumns(Session session2) {
        switch (this.getValueType()) {
            case 18: {
                ValueResultSet valueResultSet = this.getValueForColumnList(session2, this.getArgs());
                return JavaFunction.getExpressionColumns(session2, valueResultSet.getResult());
            }
            case 17: 
            case 39: {
                return JavaFunction.getExpressionColumns(session2, (ValueCollectionBase)this.getValue(session2));
            }
        }
        return super.getExpressionColumns(session2);
    }

    @Override
    public boolean isBufferResultSetToLocalTemp() {
        return this.functionAlias.isBufferResultSetToLocalTemp();
    }

    @Override
    public int getSubexpressionCount() {
        return this.args.length;
    }

    @Override
    public Expression getSubexpression(int n) {
        return this.args[n];
    }
}

