/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.analysis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.h2.command.dml.Select;
import org.h2.command.dml.SelectGroups;
import org.h2.command.dml.SelectOrderBy;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.analysis.PartitionData;
import org.h2.expression.analysis.Window;
import org.h2.expression.analysis.WindowFrame;
import org.h2.expression.analysis.WindowFrameBound;
import org.h2.message.DbException;
import org.h2.result.SortOrder;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.value.Value;
import org.h2.value.ValueInt;

public abstract class DataAnalysisOperation
extends Expression {
    public static final int STAGE_RESET = 0;
    public static final int STAGE_GROUP = 1;
    public static final int STAGE_WINDOW = 2;
    protected final Select select;
    protected Window over;
    protected SortOrder overOrderBySort;
    private int numFrameExpressions;
    private int lastGroupRowId;

    protected static SortOrder createOrder(Session session2, ArrayList<SelectOrderBy> arrayList, int n) {
        int n2 = arrayList.size();
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        for (int i = 0; i < n2; ++i) {
            SelectOrderBy selectOrderBy = arrayList.get(i);
            nArray[i] = i + n;
            nArray2[i] = selectOrderBy.sortType;
        }
        return new SortOrder(session2.getDatabase(), nArray, nArray2, null);
    }

    protected DataAnalysisOperation(Select select) {
        this.select = select;
    }

    public void setOverCondition(Window window) {
        this.over = window;
    }

    public abstract boolean isAggregate();

    protected SortOrder getOverOrderBySort() {
        return this.overOrderBySort;
    }

    @Override
    public final void mapColumns(ColumnResolver columnResolver, int n, int n2) {
        if (this.over != null) {
            if (n2 != 0) {
                throw DbException.get(90054, this.getSQL(false));
            }
            n2 = 1;
        } else {
            if (n2 == 2) {
                throw DbException.get(90054, this.getSQL(false));
            }
            n2 = 2;
        }
        this.mapColumnsAnalysis(columnResolver, n, n2);
    }

    protected void mapColumnsAnalysis(ColumnResolver columnResolver, int n, int n2) {
        if (this.over != null) {
            this.over.mapColumns(columnResolver, n);
        }
    }

    @Override
    public Expression optimize(Session session2) {
        if (this.over != null) {
            this.over.optimize(session2);
            ArrayList<SelectOrderBy> arrayList = this.over.getOrderBy();
            if (arrayList != null) {
                this.overOrderBySort = DataAnalysisOperation.createOrder(session2, arrayList, this.getNumExpressions());
            } else if (!this.isAggregate()) {
                this.overOrderBySort = new SortOrder(session2.getDatabase(), new int[this.getNumExpressions()], new int[0], null);
            }
            WindowFrame windowFrame = this.over.getWindowFrame();
            if (windowFrame != null) {
                int n = this.getNumExpressions();
                int n2 = 0;
                if (arrayList != null) {
                    n2 = arrayList.size();
                    n += n2;
                }
                int n3 = 0;
                WindowFrameBound windowFrameBound = windowFrame.getStarting();
                if (windowFrameBound.isParameterized()) {
                    if (n2 != 1) {
                        throw this.getSingleSortKeyException();
                    }
                    if (windowFrameBound.isVariable()) {
                        windowFrameBound.setExpressionIndex(n);
                        ++n3;
                    }
                }
                if ((windowFrameBound = windowFrame.getFollowing()) != null && windowFrameBound.isParameterized()) {
                    if (n2 != 1) {
                        throw this.getSingleSortKeyException();
                    }
                    if (windowFrameBound.isVariable()) {
                        windowFrameBound.setExpressionIndex(n + n3);
                        ++n3;
                    }
                }
                this.numFrameExpressions = n3;
            }
        }
        return this;
    }

    private DbException getSingleSortKeyException() {
        String string = this.getSQL(false);
        return DbException.getSyntaxError(string, string.length() - 1, "exactly one sort key is required for RANGE units");
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        if (this.over != null) {
            this.over.setEvaluatable(tableFilter, bl);
        }
    }

    @Override
    public final void updateAggregate(Session session2, int n) {
        if (n == 0) {
            this.updateGroupAggregates(session2, 0);
            this.lastGroupRowId = 0;
            return;
        }
        boolean bl = n == 2;
        if (bl != (this.over != null)) {
            if (!bl && this.select.isWindowQuery()) {
                this.updateGroupAggregates(session2, n);
            }
            return;
        }
        SelectGroups selectGroups = this.select.getGroupDataIfCurrent(bl);
        if (selectGroups == null) {
            return;
        }
        int n2 = selectGroups.getCurrentGroupRowId();
        if (this.lastGroupRowId == n2) {
            return;
        }
        this.lastGroupRowId = n2;
        if (this.over != null && !this.select.isGroupQuery()) {
            this.over.updateAggregate(session2, n);
        }
        this.updateAggregate(session2, selectGroups, n2);
    }

    protected abstract void updateAggregate(Session var1, SelectGroups var2, int var3);

    protected void updateGroupAggregates(Session session2, int n) {
        if (this.over != null) {
            this.over.updateAggregate(session2, n);
        }
    }

    protected abstract int getNumExpressions();

    private int getNumFrameExpressions() {
        return this.numFrameExpressions;
    }

    protected abstract void rememberExpressions(Session var1, Value[] var2);

    protected Object getWindowData(Session session2, SelectGroups selectGroups, boolean bl) {
        Object object;
        Value value = this.over.getCurrentKey(session2);
        PartitionData partitionData = selectGroups.getWindowExprData(this, value);
        if (partitionData == null) {
            object = bl ? new ArrayList() : this.createAggregateData();
            selectGroups.setWindowExprData(this, value, new PartitionData(object));
        } else {
            object = partitionData.getData();
        }
        return object;
    }

    protected Object getGroupData(SelectGroups selectGroups, boolean bl) {
        Object object = selectGroups.getCurrentGroupExprData(this);
        if (object == null) {
            if (bl) {
                return null;
            }
            object = this.createAggregateData();
            selectGroups.setCurrentGroupExprData(this, object);
        }
        return object;
    }

    protected abstract Object createAggregateData();

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        if (this.over == null) {
            return true;
        }
        switch (expressionVisitor.getType()) {
            case 0: 
            case 1: 
            case 2: 
            case 8: {
                return false;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                return true;
            }
        }
        throw DbException.throwInternalError("type=" + expressionVisitor.getType());
    }

    @Override
    public Value getValue(Session session2) {
        SelectGroups selectGroups = this.select.getGroupDataIfCurrent(this.over != null);
        if (selectGroups == null) {
            throw DbException.get(90054, this.getSQL(false));
        }
        return this.over == null ? this.getAggregatedValue(session2, this.getGroupData(selectGroups, true)) : this.getWindowResult(session2, selectGroups);
    }

    private Value getWindowResult(Session session2, SelectGroups selectGroups) {
        Object object;
        boolean bl = this.over.getOrderBy() != null;
        Value value = this.over.getCurrentKey(session2);
        PartitionData partitionData = selectGroups.getWindowExprData(this, value);
        if (partitionData == null) {
            object = bl ? new ArrayList() : this.createAggregateData();
            partitionData = new PartitionData(object);
            selectGroups.setWindowExprData(this, value, partitionData);
        } else {
            object = partitionData.getData();
        }
        if (bl || !this.isAggregate()) {
            Value value2 = this.getOrderedResult(session2, selectGroups, partitionData, object);
            if (value2 == null) {
                return this.getAggregatedValue(session2, null);
            }
            return value2;
        }
        Value value3 = partitionData.getResult();
        if (value3 == null) {
            value3 = this.getAggregatedValue(session2, object);
            partitionData.setResult(value3);
        }
        return value3;
    }

    protected abstract Value getAggregatedValue(Session var1, Object var2);

    protected void updateOrderedAggregate(Session session2, SelectGroups selectGroups, int n, ArrayList<SelectOrderBy> arrayList) {
        Object object;
        int n2 = this.getNumExpressions();
        int n3 = arrayList != null ? arrayList.size() : 0;
        int n4 = this.getNumFrameExpressions();
        Value[] valueArray = new Value[n2 + n3 + n4 + 1];
        this.rememberExpressions(session2, valueArray);
        for (int i = 0; i < n3; ++i) {
            object = arrayList.get(i);
            valueArray[n2++] = ((SelectOrderBy)object).expression.getValue(session2);
        }
        if (n4 > 0) {
            WindowFrame windowFrame = this.over.getWindowFrame();
            object = windowFrame.getStarting();
            if (((WindowFrameBound)object).isVariable()) {
                valueArray[n2++] = ((WindowFrameBound)object).getValue().getValue(session2);
            }
            if ((object = windowFrame.getFollowing()) != null && ((WindowFrameBound)object).isVariable()) {
                valueArray[n2++] = ((WindowFrameBound)object).getValue().getValue(session2);
            }
        }
        valueArray[n2] = ValueInt.get(n);
        ArrayList arrayList2 = (ArrayList)this.getWindowData(session2, selectGroups, true);
        arrayList2.add(valueArray);
    }

    private Value getOrderedResult(Session session2, SelectGroups selectGroups, PartitionData partitionData, Object object) {
        HashMap<Integer, Value> hashMap = partitionData.getOrderedResult();
        if (hashMap == null) {
            hashMap = new HashMap();
            ArrayList arrayList = (ArrayList)object;
            int n = this.getNumExpressions();
            ArrayList<SelectOrderBy> arrayList2 = this.over.getOrderBy();
            if (arrayList2 != null) {
                n += arrayList2.size();
                Collections.sort(arrayList, this.overOrderBySort);
            }
            this.getOrderedResultLoop(session2, hashMap, arrayList, n += this.getNumFrameExpressions());
            partitionData.setOrderedResult(hashMap);
        }
        return hashMap.get(selectGroups.getCurrentGroupRowId());
    }

    protected abstract void getOrderedResultLoop(Session var1, HashMap<Integer, Value> var2, ArrayList<Value[]> var3, int var4);

    protected StringBuilder appendTailConditions(StringBuilder stringBuilder, boolean bl) {
        if (this.over != null) {
            stringBuilder.append(' ');
            this.over.getSQL(stringBuilder, bl);
        }
        return stringBuilder;
    }
}

