/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.util.ArrayList;
import org.h2.command.Command;
import org.h2.command.Prepared;
import org.h2.command.dml.CommandWithValues;
import org.h2.command.dml.Query;
import org.h2.engine.GeneratedKeys;
import org.h2.engine.Mode;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.Parameter;
import org.h2.index.Index;
import org.h2.message.DbException;
import org.h2.mvstore.db.MVPrimaryIndex;
import org.h2.result.ResultInterface;
import org.h2.result.Row;
import org.h2.table.Column;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.value.Value;

public class Merge
extends CommandWithValues {
    private Table targetTable;
    private TableFilter targetTableFilter;
    private Column[] columns;
    private Column[] keys;
    private Query query;
    private Prepared update;

    public Merge(Session session2) {
        super(session2);
    }

    @Override
    public void setCommand(Command command) {
        super.setCommand(command);
        if (this.query != null) {
            this.query.setCommand(command);
        }
    }

    public void setTargetTable(Table table) {
        this.targetTable = table;
    }

    public void setColumns(Column[] columnArray) {
        this.columns = columnArray;
    }

    public void setKeys(Column[] columnArray) {
        this.keys = columnArray;
    }

    public void setQuery(Query query) {
        this.query = query;
    }

    @Override
    public int update() {
        int n;
        this.session.getUser().checkRight(this.targetTable, 4);
        this.session.getUser().checkRight(this.targetTable, 8);
        this.setCurrentRowNumber(0L);
        GeneratedKeys generatedKeys = this.session.getGeneratedKeys();
        Mode mode = this.session.getDatabase().getMode();
        if (!this.valuesExpressionList.isEmpty()) {
            n = 0;
            generatedKeys.initialize(this.targetTable);
            int n2 = this.valuesExpressionList.size();
            for (int i = 0; i < n2; ++i) {
                this.setCurrentRowNumber(i + 1);
                generatedKeys.nextRow();
                Expression[] expressionArray = (Expression[])this.valuesExpressionList.get(i);
                Row row = this.targetTable.getTemplateRow();
                int n3 = this.columns.length;
                for (int j = 0; j < n3; ++j) {
                    Column column = this.columns[j];
                    int n4 = column.getColumnId();
                    Expression expression = expressionArray[j];
                    if (expression == null) continue;
                    try {
                        Value value = column.convert(expression.getValue(this.session), mode);
                        row.setValue(n4, value);
                        if (!expression.isGeneratedKey()) continue;
                        generatedKeys.add(column);
                        continue;
                    }
                    catch (DbException dbException) {
                        throw this.setRow(dbException, n, Merge.getSimpleSQL(expressionArray));
                    }
                }
                this.merge(row);
                ++n;
            }
        } else {
            this.query.setNeverLazy(true);
            ResultInterface resultInterface = this.query.query(0);
            n = 0;
            this.targetTable.fire(this.session, 3, true);
            this.targetTable.lock(this.session, true, false);
            while (resultInterface.next()) {
                generatedKeys.nextRow();
                Value[] valueArray = resultInterface.currentRow();
                Row row = this.targetTable.getTemplateRow();
                this.setCurrentRowNumber(++n);
                for (int i = 0; i < this.columns.length; ++i) {
                    Column column = this.columns[i];
                    int n5 = column.getColumnId();
                    try {
                        Value value = column.convert(valueArray[i], mode);
                        row.setValue(n5, value);
                        continue;
                    }
                    catch (DbException dbException) {
                        throw this.setRow(dbException, n, Merge.getSQL(valueArray));
                    }
                }
                this.merge(row);
            }
            resultInterface.close();
            this.targetTable.fire(this.session, 3, false);
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void merge(Row row) {
        Column[] columnArray;
        Object object;
        Column column;
        int n;
        ArrayList<Parameter> arrayList = this.update.getParameters();
        for (n = 0; n < this.columns.length; ++n) {
            column = this.columns[n];
            object = row.getValue(column.getColumnId());
            columnArray = arrayList.get(n);
            columnArray.setValue((Value)object);
        }
        for (n = 0; n < this.keys.length; ++n) {
            column = this.keys[n];
            object = row.getValue(column.getColumnId());
            if (object == null) {
                throw DbException.get(90081, column.getSQL(false));
            }
            columnArray = arrayList.get(this.columns.length + n);
            columnArray.setValue((Value)object);
        }
        n = this.update.update();
        if (n == 0) {
            try {
                this.targetTable.validateConvertUpdateSequence(this.session, row);
                boolean bl = this.targetTable.fireBeforeRow(this.session, null, row);
                if (bl) return;
                this.targetTable.lock(this.session, true, false);
                this.targetTable.addRow(this.session, row);
                this.session.getGeneratedKeys().confirmRow(row);
                this.session.log(this.targetTable, (short)0, row);
                this.targetTable.fireAfterRow(this.session, null, row, false);
                return;
            }
            catch (DbException dbException) {
                boolean bl;
                if (dbException.getErrorCode() != 23505 || (object = (Index)dbException.getSource()) == null) throw dbException;
                if (object instanceof MVPrimaryIndex) {
                    MVPrimaryIndex mVPrimaryIndex = (MVPrimaryIndex)object;
                    columnArray = new Column[]{mVPrimaryIndex.getIndexColumns()[mVPrimaryIndex.getMainIndexColumn()].column};
                } else {
                    columnArray = object.getColumns();
                }
                if (columnArray.length <= this.keys.length) {
                    bl = true;
                    for (int i = 0; i < columnArray.length; ++i) {
                        if (columnArray[i] == this.keys[i]) continue;
                        bl = false;
                        break;
                    }
                } else {
                    bl = false;
                }
                if (!bl) throw dbException;
                throw DbException.get(90131, this.targetTable.getName());
            }
        }
        if (n == 1) return;
        throw DbException.get(23505, this.targetTable.getSQL(false));
    }

    @Override
    public String getPlanSQL(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder("MERGE INTO ");
        this.targetTable.getSQL(stringBuilder, bl).append('(');
        Column.writeColumns(stringBuilder, this.columns, bl);
        stringBuilder.append(')');
        if (this.keys != null) {
            stringBuilder.append(" KEY(");
            Column.writeColumns(stringBuilder, this.keys, bl);
            stringBuilder.append(')');
        }
        stringBuilder.append('\n');
        if (!this.valuesExpressionList.isEmpty()) {
            stringBuilder.append("VALUES ");
            int n = 0;
            for (Expression[] expressionArray : this.valuesExpressionList) {
                if (n++ > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append('(');
                Expression.writeExpressions(stringBuilder, expressionArray, bl);
                stringBuilder.append(')');
            }
        } else {
            stringBuilder.append(this.query.getPlanSQL(bl));
        }
        return stringBuilder.toString();
    }

    @Override
    public void prepare() {
        Object object;
        if (this.columns == null) {
            this.columns = !this.valuesExpressionList.isEmpty() && ((Expression[])this.valuesExpressionList.get(0)).length == 0 ? new Column[0] : this.targetTable.getColumns();
        }
        if (!this.valuesExpressionList.isEmpty()) {
            for (Expression[] expressionArray : this.valuesExpressionList) {
                if (expressionArray.length != this.columns.length) {
                    throw DbException.get(21002);
                }
                for (int i = 0; i < expressionArray.length; ++i) {
                    Expression expression = expressionArray[i];
                    if (expression == null) continue;
                    expressionArray[i] = expression.optimize(this.session);
                }
            }
        } else {
            this.query.prepare();
            if (this.query.getColumnCount() != this.columns.length) {
                throw DbException.get(21002);
            }
        }
        if (this.keys == null) {
            object = this.targetTable.getPrimaryKey();
            if (object == null) {
                throw DbException.get(90057, "PRIMARY KEY");
            }
            this.keys = object.getColumns();
        }
        object = new StringBuilder("UPDATE ");
        this.targetTable.getSQL((StringBuilder)object, true).append(" SET ");
        Column.writeColumns((StringBuilder)object, this.columns, ", ", "=?", true).append(" WHERE ");
        Column.writeColumns((StringBuilder)object, this.keys, " AND ", "=?", true);
        this.update = this.session.prepare(((StringBuilder)object).toString());
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    @Override
    public ResultInterface queryMeta() {
        return null;
    }

    @Override
    public int getType() {
        return 62;
    }

    @Override
    public boolean isCacheable() {
        return true;
    }

    public Table getTargetTable() {
        return this.targetTable;
    }

    public TableFilter getTargetTableFilter() {
        return this.targetTableFilter;
    }

    public void setTargetTableFilter(TableFilter tableFilter) {
        this.targetTableFilter = tableFilter;
        this.setTargetTable(tableFilter.getTable());
    }
}

