/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.util.ArrayList;
import org.h2.command.Prepared;
import org.h2.command.ddl.DefineCommand;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.expression.Parameter;
import org.h2.table.Column;
import org.h2.table.Table;
import org.h2.table.TableType;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueInt;
import org.h2.value.ValueNull;

public class Analyze
extends DefineCommand {
    private int sampleRows;
    private Table table;

    public Analyze(Session session2) {
        super(session2);
        this.sampleRows = session2.getDatabase().getSettings().analyzeSample;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    @Override
    public int update() {
        this.session.commit(true);
        this.session.getUser().checkAdmin();
        Database database = this.session.getDatabase();
        if (this.table != null) {
            Analyze.analyzeTable(this.session, this.table, this.sampleRows, true);
        } else {
            for (Table table : database.getAllTablesAndViews(false)) {
                Analyze.analyzeTable(this.session, table, this.sampleRows, true);
            }
        }
        return 0;
    }

    public static void analyzeTable(Session session2, Table table, int n, boolean bl) {
        Object object;
        if (table.getTableType() != TableType.TABLE || table.isHidden() || session2 == null) {
            return;
        }
        if (!bl) {
            if (session2.getDatabase().isSysTableLocked()) {
                return;
            }
            if (table.hasSelectTrigger()) {
                return;
            }
        }
        if (table.isTemporary() && !table.isGlobalTemporary() && session2.findLocalTempTable(table.getName()) == null) {
            return;
        }
        if (table.isLockedExclusively() && !table.isLockedExclusivelyBy(session2)) {
            return;
        }
        if (!session2.getUser().hasRight(table, 1)) {
            return;
        }
        if (session2.getCancel() != 0L) {
            return;
        }
        Column[] columnArray = table.getColumns();
        if (columnArray.length == 0) {
            return;
        }
        Database database = session2.getDatabase();
        StringBuilder stringBuilder = new StringBuilder("SELECT ");
        int n2 = columnArray.length;
        for (int i = 0; i < n2; ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            if (DataType.isLargeObject(((Column)(object = columnArray[i])).getType().getValueType())) {
                stringBuilder.append("MAX(NULL)");
                continue;
            }
            stringBuilder.append("SELECTIVITY(");
            ((Column)object).getSQL(stringBuilder, true).append(')');
        }
        stringBuilder.append(" FROM ");
        table.getSQL(stringBuilder, true);
        if (n > 0) {
            stringBuilder.append(" FETCH FIRST ROW ONLY SAMPLE_SIZE ? ");
        }
        String string = stringBuilder.toString();
        Prepared prepared = session2.prepare(string);
        if (n > 0) {
            object = prepared.getParameters();
            ((Parameter)((ArrayList)object).get(0)).setValue(ValueInt.get(n));
        }
        object = prepared.query(0);
        object.next();
        for (int i = 0; i < columnArray.length; ++i) {
            Value value = object.currentRow()[i];
            if (value == ValueNull.INSTANCE) continue;
            int n3 = value.getInt();
            columnArray[i].setSelectivity(n3);
        }
        database.updateMeta(session2, table);
    }

    public void setTop(int n) {
        this.sampleRows = n;
    }

    @Override
    public int getType() {
        return 21;
    }
}

