/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.h2.api.IntervalQualifier;
import org.h2.command.Command;
import org.h2.command.CommandContainer;
import org.h2.command.CommandList;
import org.h2.command.Prepared;
import org.h2.command.ddl.AlterIndexRename;
import org.h2.command.ddl.AlterSchemaRename;
import org.h2.command.ddl.AlterSequence;
import org.h2.command.ddl.AlterTableAddConstraint;
import org.h2.command.ddl.AlterTableAlterColumn;
import org.h2.command.ddl.AlterTableDropConstraint;
import org.h2.command.ddl.AlterTableRename;
import org.h2.command.ddl.AlterTableRenameColumn;
import org.h2.command.ddl.AlterTableRenameConstraint;
import org.h2.command.ddl.AlterUser;
import org.h2.command.ddl.AlterView;
import org.h2.command.ddl.Analyze;
import org.h2.command.ddl.CommandWithColumns;
import org.h2.command.ddl.CreateAggregate;
import org.h2.command.ddl.CreateConstant;
import org.h2.command.ddl.CreateDomain;
import org.h2.command.ddl.CreateFunctionAlias;
import org.h2.command.ddl.CreateIndex;
import org.h2.command.ddl.CreateLinkedTable;
import org.h2.command.ddl.CreateRole;
import org.h2.command.ddl.CreateSchema;
import org.h2.command.ddl.CreateSequence;
import org.h2.command.ddl.CreateSynonym;
import org.h2.command.ddl.CreateTable;
import org.h2.command.ddl.CreateTrigger;
import org.h2.command.ddl.CreateUser;
import org.h2.command.ddl.CreateView;
import org.h2.command.ddl.DeallocateProcedure;
import org.h2.command.ddl.DefineCommand;
import org.h2.command.ddl.DropAggregate;
import org.h2.command.ddl.DropConstant;
import org.h2.command.ddl.DropDatabase;
import org.h2.command.ddl.DropDomain;
import org.h2.command.ddl.DropFunctionAlias;
import org.h2.command.ddl.DropIndex;
import org.h2.command.ddl.DropRole;
import org.h2.command.ddl.DropSchema;
import org.h2.command.ddl.DropSequence;
import org.h2.command.ddl.DropSynonym;
import org.h2.command.ddl.DropTable;
import org.h2.command.ddl.DropTrigger;
import org.h2.command.ddl.DropUser;
import org.h2.command.ddl.DropView;
import org.h2.command.ddl.GrantRevoke;
import org.h2.command.ddl.PrepareProcedure;
import org.h2.command.ddl.SchemaCommand;
import org.h2.command.ddl.SequenceOptions;
import org.h2.command.ddl.SetComment;
import org.h2.command.ddl.TruncateTable;
import org.h2.command.dml.AlterTableSet;
import org.h2.command.dml.BackupCommand;
import org.h2.command.dml.Call;
import org.h2.command.dml.CommandWithValues;
import org.h2.command.dml.Delete;
import org.h2.command.dml.ExecuteProcedure;
import org.h2.command.dml.Explain;
import org.h2.command.dml.Insert;
import org.h2.command.dml.Merge;
import org.h2.command.dml.MergeUsing;
import org.h2.command.dml.NoOperation;
import org.h2.command.dml.Query;
import org.h2.command.dml.Replace;
import org.h2.command.dml.RunScriptCommand;
import org.h2.command.dml.ScriptCommand;
import org.h2.command.dml.Select;
import org.h2.command.dml.SelectOrderBy;
import org.h2.command.dml.SelectUnion;
import org.h2.command.dml.Set;
import org.h2.command.dml.SetTypes;
import org.h2.command.dml.TransactionCommand;
import org.h2.command.dml.Update;
import org.h2.constraint.ConstraintActionType;
import org.h2.engine.Database;
import org.h2.engine.Domain;
import org.h2.engine.FunctionAlias;
import org.h2.engine.Mode;
import org.h2.engine.Procedure;
import org.h2.engine.Session;
import org.h2.engine.User;
import org.h2.engine.UserAggregate;
import org.h2.expression.Alias;
import org.h2.expression.BinaryOperation;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionList;
import org.h2.expression.Parameter;
import org.h2.expression.Rownum;
import org.h2.expression.SequenceValue;
import org.h2.expression.Subquery;
import org.h2.expression.UnaryOperation;
import org.h2.expression.ValueExpression;
import org.h2.expression.Variable;
import org.h2.expression.Wildcard;
import org.h2.expression.aggregate.AbstractAggregate;
import org.h2.expression.aggregate.Aggregate;
import org.h2.expression.aggregate.AggregateType;
import org.h2.expression.aggregate.JavaAggregate;
import org.h2.expression.analysis.DataAnalysisOperation;
import org.h2.expression.analysis.Window;
import org.h2.expression.analysis.WindowFrame;
import org.h2.expression.analysis.WindowFrameBound;
import org.h2.expression.analysis.WindowFrameBoundType;
import org.h2.expression.analysis.WindowFrameExclusion;
import org.h2.expression.analysis.WindowFrameUnits;
import org.h2.expression.analysis.WindowFunction;
import org.h2.expression.analysis.WindowFunctionType;
import org.h2.expression.condition.CompareLike;
import org.h2.expression.condition.Comparison;
import org.h2.expression.condition.Condition;
import org.h2.expression.condition.ConditionAndOr;
import org.h2.expression.condition.ConditionExists;
import org.h2.expression.condition.ConditionIn;
import org.h2.expression.condition.ConditionInParameter;
import org.h2.expression.condition.ConditionInSelect;
import org.h2.expression.condition.ConditionNot;
import org.h2.expression.function.Function;
import org.h2.expression.function.FunctionCall;
import org.h2.expression.function.JavaFunction;
import org.h2.expression.function.TableFunction;
import org.h2.index.Index;
import org.h2.message.DbException;
import org.h2.schema.Schema;
import org.h2.schema.SchemaObject;
import org.h2.schema.Sequence;
import org.h2.table.Column;
import org.h2.table.FunctionTable;
import org.h2.table.IndexColumn;
import org.h2.table.IndexHints;
import org.h2.table.RangeTable;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.table.TableView;
import org.h2.util.IntervalUtils;
import org.h2.util.ParserUtil;
import org.h2.util.StringUtils;
import org.h2.util.Utils;
import org.h2.util.geometry.EWKTUtils;
import org.h2.value.CompareMode;
import org.h2.value.DataType;
import org.h2.value.ExtTypeInfo;
import org.h2.value.ExtTypeInfoEnum;
import org.h2.value.ExtTypeInfoGeometry;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueBytes;
import org.h2.value.ValueDate;
import org.h2.value.ValueDecimal;
import org.h2.value.ValueInt;
import org.h2.value.ValueLong;
import org.h2.value.ValueNull;
import org.h2.value.ValueRow;
import org.h2.value.ValueString;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimestamp;
import org.h2.value.ValueTimestampTimeZone;

public class Parser {
    private static final String WITH_STATEMENT_SUPPORTS_LIMITED_SUB_STATEMENTS = "WITH statement supports only SELECT, TABLE, VALUES, CREATE TABLE, INSERT, UPDATE, MERGE or DELETE statements";
    private static final int CHAR_END = 1;
    private static final int CHAR_VALUE = 2;
    private static final int CHAR_QUOTED = 3;
    private static final int CHAR_NAME = 4;
    private static final int CHAR_SPECIAL_1 = 5;
    private static final int CHAR_SPECIAL_2 = 6;
    private static final int CHAR_STRING = 7;
    private static final int CHAR_DOT = 8;
    private static final int CHAR_DOLLAR_QUOTED_STRING = 9;
    private static final int PARAMETER = 56;
    private static final int END = 57;
    private static final int VALUE = 58;
    private static final int EQUAL = 59;
    private static final int BIGGER_EQUAL = 60;
    private static final int BIGGER = 61;
    private static final int SMALLER = 62;
    private static final int SMALLER_EQUAL = 63;
    private static final int NOT_EQUAL = 64;
    private static final int AT = 65;
    private static final int MINUS_SIGN = 66;
    private static final int PLUS_SIGN = 67;
    private static final int STRING_CONCAT = 68;
    private static final int OPEN_PAREN = 69;
    private static final int CLOSE_PAREN = 70;
    private static final int SPATIAL_INTERSECTS = 71;
    private static final int ASTERISK = 72;
    private static final int COMMA = 73;
    private static final int DOT = 74;
    private static final int OPEN_BRACE = 75;
    private static final int CLOSE_BRACE = 76;
    private static final int SLASH = 77;
    private static final int PERCENT = 78;
    private static final int SEMICOLON = 79;
    private static final int COLON = 80;
    private static final int OPEN_BRACKET = 81;
    private static final int CLOSE_BRACKET = 82;
    private static final int TILDE = 83;
    private static final int COLON_COLON = 84;
    private static final int COLON_EQ = 85;
    private static final int NOT_TILDE = 86;
    private static final String[] TOKENS = new String[]{null, null, null, "ALL", "ARRAY", "CASE", "CHECK", "CONSTRAINT", "CROSS", "CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "DISTINCT", "EXCEPT", "EXISTS", "FALSE", "FETCH", "FOR", "FOREIGN", "FROM", "FULL", "GROUP", "HAVING", "IF", "INNER", "INTERSECT", "INTERSECTS", "INTERVAL", "IS", "JOIN", "LIKE", "LIMIT", "LOCALTIME", "LOCALTIMESTAMP", "MINUS", "NATURAL", "NOT", "NULL", "OFFSET", "ON", "ORDER", "PRIMARY", "QUALIFY", "ROW", "_ROWID_", "ROWNUM", "SELECT", "TABLE", "TRUE", "UNION", "UNIQUE", "VALUES", "WHERE", "WINDOW", "WITH", "?", null, null, "=", ">=", ">", "<", "<=", "<>", "@", "-", "+", "||", "(", ")", "&&", "*", ",", ".", "{", "}", "/", "%", ";", ":", "[", "]", "~", "::", ":=", "!~"};
    private static final Comparator<TableFilter> TABLE_FILTER_COMPARATOR = new Comparator<TableFilter>(){

        @Override
        public int compare(TableFilter tableFilter, TableFilter tableFilter2) {
            if (tableFilter == tableFilter2) {
                return 0;
            }
            assert (tableFilter.getOrderInFrom() != tableFilter2.getOrderInFrom());
            return tableFilter.getOrderInFrom() > tableFilter2.getOrderInFrom() ? 1 : -1;
        }
    };
    private final Database database;
    private final Session session;
    private final boolean identifiersToLower;
    private final boolean identifiersToUpper;
    private int[] characterTypes;
    private int currentTokenType;
    private String currentToken;
    private boolean currentTokenQuoted;
    private Value currentValue;
    private String originalSQL;
    private String sqlCommand;
    private char[] sqlCommandChars;
    private int lastParseIndex;
    private int parseIndex;
    private CreateView createView;
    private Prepared currentPrepared;
    private Select currentSelect;
    private ArrayList<Parameter> parameters;
    private ArrayList<Parameter> indexedParameterList;
    private ArrayList<Parameter> suppliedParameters;
    private ArrayList<Parameter> suppliedParameterList;
    private String schemaName;
    private ArrayList<String> expectedList;
    private boolean rightsChecked;
    private boolean recompileAlways;
    private boolean literalsChecked;
    private int orderInFrom;

    public Parser(Session session2) {
        this.database = session2.getDatabase();
        this.identifiersToLower = this.database.getSettings().databaseToLower;
        this.identifiersToUpper = this.database.getSettings().databaseToUpper;
        this.session = session2;
    }

    public Prepared prepare(String string) {
        Prepared prepared = this.parse(string);
        prepared.prepare();
        if (this.currentTokenType != 57) {
            throw this.getSyntaxError();
        }
        return prepared;
    }

    public Command prepareCommand(String string) {
        try {
            String string2;
            Prepared prepared = this.parse(string);
            if (this.currentTokenType != 79 && this.currentTokenType != 57) {
                this.addExpected(79);
                throw this.getSyntaxError();
            }
            try {
                prepared.prepare();
            }
            catch (Throwable throwable) {
                CommandContainer.clearCTE(this.session, prepared);
                throw throwable;
            }
            if (this.parseIndex < string.length()) {
                string = string.substring(0, this.parseIndex);
            }
            CommandContainer commandContainer = new CommandContainer(this.session, string, prepared);
            if (this.currentTokenType == 79 && !StringUtils.isWhitespaceOrEmpty(string2 = this.originalSQL.substring(this.parseIndex))) {
                return this.prepareCommandList(commandContainer, string, string2);
            }
            return commandContainer;
        }
        catch (DbException dbException) {
            throw dbException.addSQL(this.originalSQL);
        }
    }

    private CommandList prepareCommandList(CommandContainer commandContainer, String string, String string2) {
        try {
            ArrayList<Prepared> arrayList = Utils.newSmallArrayList();
            boolean bl = false;
            do {
                Prepared prepared;
                if (bl) {
                    return new CommandList(this.session, string, commandContainer, arrayList, this.parameters, string2);
                }
                this.suppliedParameters = this.parameters;
                this.suppliedParameterList = this.indexedParameterList;
                try {
                    prepared = this.parse(string2);
                }
                catch (DbException dbException) {
                    if (dbException.getErrorCode() == 90123) {
                        throw dbException;
                    }
                    return new CommandList(this.session, string, commandContainer, arrayList, this.parameters, string2);
                }
                if (prepared instanceof DefineCommand) {
                    bl = true;
                }
                arrayList.add(prepared);
                if (this.currentTokenType == 57) break;
                if (this.currentTokenType == 79) continue;
                this.addExpected(79);
                throw this.getSyntaxError();
            } while (!StringUtils.isWhitespaceOrEmpty(string2 = this.originalSQL.substring(this.parseIndex)));
            return new CommandList(this.session, string, commandContainer, arrayList, this.parameters, null);
        }
        catch (Throwable throwable) {
            commandContainer.clearCTE();
            throw throwable;
        }
    }

    Prepared parse(String string) {
        Prepared prepared;
        try {
            prepared = this.parse(string, false);
        }
        catch (DbException dbException) {
            if (dbException.getErrorCode() == 42000) {
                prepared = this.parse(string, true);
            }
            throw dbException.addSQL(string);
        }
        prepared.setPrepareAlways(this.recompileAlways);
        prepared.setParameterList(this.parameters);
        return prepared;
    }

    private Prepared parse(String string, boolean bl) {
        this.initialize(string);
        this.expectedList = bl ? new ArrayList() : null;
        this.parameters = this.suppliedParameters != null ? this.suppliedParameters : Utils.newSmallArrayList();
        this.indexedParameterList = this.suppliedParameterList;
        this.currentSelect = null;
        this.currentPrepared = null;
        this.createView = null;
        this.recompileAlways = false;
        this.read();
        return this.parsePrepared();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private Prepared parsePrepared() {
        int n;
        void var2_40;
        int n2 = this.lastParseIndex;
        Object var2_2 = null;
        switch (this.currentTokenType) {
            case 57: 
            case 79: {
                NoOperation noOperation = new NoOperation(this.session);
                this.setSQL(noOperation, null, n2);
                return noOperation;
            }
            case 56: {
                this.readTerm();
                this.parameters.get(0).setValue(ValueNull.INSTANCE);
                this.read(59);
                this.read("CALL");
                Call call = this.parseCall();
                break;
            }
            case 20: 
            case 47: 
            case 48: 
            case 52: 
            case 69: {
                Query query = this.parseSelect();
                break;
            }
            case 55: {
                this.read();
                Prepared prepared = this.parseWithStatementOrQuery();
                break;
            }
            case 2: {
                if (this.currentTokenQuoted) break;
                switch (this.currentToken.charAt(0)) {
                    case 'A': 
                    case 'a': {
                        if (this.readIf("ALTER")) {
                            Prepared prepared = this.parseAlter();
                            break;
                        }
                        if (!this.readIf("ANALYZE")) break;
                        Prepared prepared = this.parseAnalyze();
                        break;
                    }
                    case 'B': 
                    case 'b': {
                        if (this.readIf("BACKUP")) {
                            Prepared prepared = this.parseBackup();
                            break;
                        }
                        if (!this.readIf("BEGIN")) break;
                        TransactionCommand transactionCommand = this.parseBegin();
                        break;
                    }
                    case 'C': 
                    case 'c': {
                        if (this.readIf("COMMIT")) {
                            TransactionCommand transactionCommand = this.parseCommit();
                            break;
                        }
                        if (this.readIf("CREATE")) {
                            Prepared prepared = this.parseCreate();
                            break;
                        }
                        if (this.readIf("CALL")) {
                            Call call = this.parseCall();
                            break;
                        }
                        if (this.readIf("CHECKPOINT")) {
                            TransactionCommand transactionCommand = this.parseCheckpoint();
                            break;
                        }
                        if (!this.readIf("COMMENT")) break;
                        Prepared prepared = this.parseComment();
                        break;
                    }
                    case 'D': 
                    case 'd': {
                        if (this.readIf("DELETE")) {
                            Delete delete = this.parseDelete();
                            break;
                        }
                        if (this.readIf("DROP")) {
                            Prepared prepared = this.parseDrop();
                            break;
                        }
                        if (this.readIf("DECLARE")) {
                            Prepared prepared = this.parseCreate();
                            break;
                        }
                        if (!this.readIf("DEALLOCATE")) break;
                        DeallocateProcedure deallocateProcedure = this.parseDeallocate();
                        break;
                    }
                    case 'E': 
                    case 'e': {
                        if (this.readIf("EXPLAIN")) {
                            Explain explain = this.parseExplain();
                            break;
                        }
                        if (!this.readIf("EXECUTE")) break;
                        Prepared prepared = this.parseExecute();
                        break;
                    }
                    case 'G': 
                    case 'g': {
                        if (!this.readIf("GRANT")) break;
                        GrantRevoke grantRevoke = this.parseGrantRevoke(49);
                        break;
                    }
                    case 'H': 
                    case 'h': {
                        if (!this.readIf("HELP")) break;
                        Prepared prepared = this.parseHelp();
                        break;
                    }
                    case 'I': 
                    case 'i': {
                        if (!this.readIf("INSERT")) break;
                        Insert insert = this.parseInsert();
                        break;
                    }
                    case 'M': 
                    case 'm': {
                        if (!this.readIf("MERGE")) break;
                        Prepared prepared = this.parseMerge();
                        break;
                    }
                    case 'P': 
                    case 'p': {
                        if (!this.readIf("PREPARE")) break;
                        Prepared prepared = this.parsePrepare();
                        break;
                    }
                    case 'R': 
                    case 'r': {
                        if (this.readIf("ROLLBACK")) {
                            TransactionCommand transactionCommand = this.parseRollback();
                            break;
                        }
                        if (this.readIf("REVOKE")) {
                            GrantRevoke grantRevoke = this.parseGrantRevoke(50);
                            break;
                        }
                        if (this.readIf("RUNSCRIPT")) {
                            RunScriptCommand runScriptCommand = this.parseRunScript();
                            break;
                        }
                        if (this.readIf("RELEASE")) {
                            Prepared prepared = this.parseReleaseSavepoint();
                            break;
                        }
                        if (!this.readIf("REPLACE")) break;
                        Replace replace = this.parseReplace();
                        break;
                    }
                    case 'S': 
                    case 's': {
                        if (this.readIf("SET")) {
                            Prepared prepared = this.parseSet();
                            break;
                        }
                        if (this.readIf("SAVEPOINT")) {
                            TransactionCommand transactionCommand = this.parseSavepoint();
                            break;
                        }
                        if (this.readIf("SCRIPT")) {
                            ScriptCommand scriptCommand = this.parseScript();
                            break;
                        }
                        if (this.readIf("SHUTDOWN")) {
                            TransactionCommand transactionCommand = this.parseShutdown();
                            break;
                        }
                        if (!this.readIf("SHOW")) break;
                        Prepared prepared = this.parseShow();
                        break;
                    }
                    case 'T': 
                    case 't': {
                        if (!this.readIf("TRUNCATE")) break;
                        Prepared prepared = this.parseTruncate();
                        break;
                    }
                    case 'U': 
                    case 'u': {
                        if (this.readIf("UPDATE")) {
                            Update update = this.parseUpdate();
                            break;
                        }
                        if (!this.readIf("USE")) break;
                        Prepared prepared = this.parseUse();
                    }
                }
                break;
            }
        }
        if (var2_40 == null) {
            throw this.getSyntaxError();
        }
        if (this.indexedParameterList != null) {
            int n3 = this.indexedParameterList.size();
            for (n = 0; n < n3; ++n) {
                if (this.indexedParameterList.get(n) != null) continue;
                this.indexedParameterList.set(n, new Parameter(n));
            }
            this.parameters = this.indexedParameterList;
        }
        if (this.readIf(75)) {
            do {
                if ((n = (int)this.readLong() - 1) < 0 || n >= this.parameters.size()) {
                    throw this.getSyntaxError();
                }
                Parameter parameter = this.parameters.get(n);
                if (parameter == null) {
                    throw this.getSyntaxError();
                }
                this.read(80);
                Expression expression = this.readExpression();
                expression = expression.optimize(this.session);
                parameter.setValue(expression.getValue(this.session));
            } while (this.readIf(73));
            this.read(76);
            for (Parameter parameter : this.parameters) {
                parameter.checkSet();
            }
            this.parameters.clear();
        }
        this.setSQL((Prepared)var2_40, null, n2);
        return var2_40;
    }

    private DbException getSyntaxError() {
        if (this.expectedList == null || this.expectedList.isEmpty()) {
            return DbException.getSyntaxError(this.sqlCommand, this.parseIndex);
        }
        return DbException.getSyntaxError(this.sqlCommand, this.parseIndex, StringUtils.join(new StringBuilder(), this.expectedList, ", ").toString());
    }

    private Prepared parseBackup() {
        BackupCommand backupCommand = new BackupCommand(this.session);
        this.read("TO");
        backupCommand.setFileName(this.readExpression());
        return backupCommand;
    }

    private Prepared parseAnalyze() {
        Analyze analyze = new Analyze(this.session);
        if (this.readIf(48)) {
            Table table = this.readTableOrView();
            analyze.setTable(table);
        }
        if (this.readIf("SAMPLE_SIZE")) {
            analyze.setTop(this.readNonNegativeInt());
        }
        return analyze;
    }

    private TransactionCommand parseBegin() {
        if (!this.readIf("WORK")) {
            this.readIf("TRANSACTION");
        }
        TransactionCommand transactionCommand = new TransactionCommand(this.session, 83);
        return transactionCommand;
    }

    private TransactionCommand parseCommit() {
        if (this.readIf("TRANSACTION")) {
            TransactionCommand transactionCommand = new TransactionCommand(this.session, 78);
            transactionCommand.setTransactionName(this.readUniqueIdentifier());
            return transactionCommand;
        }
        TransactionCommand transactionCommand = new TransactionCommand(this.session, 71);
        this.readIf("WORK");
        return transactionCommand;
    }

    private TransactionCommand parseShutdown() {
        int n = 80;
        if (this.readIf("IMMEDIATELY")) {
            n = 81;
        } else if (this.readIf("COMPACT")) {
            n = 82;
        } else if (this.readIf("DEFRAG")) {
            n = 84;
        } else {
            this.readIf("SCRIPT");
        }
        return new TransactionCommand(this.session, n);
    }

    private TransactionCommand parseRollback() {
        TransactionCommand transactionCommand;
        if (this.readIf("TRANSACTION")) {
            TransactionCommand transactionCommand2 = new TransactionCommand(this.session, 79);
            transactionCommand2.setTransactionName(this.readUniqueIdentifier());
            return transactionCommand2;
        }
        if (this.readIf("TO")) {
            this.read("SAVEPOINT");
            transactionCommand = new TransactionCommand(this.session, 75);
            transactionCommand.setSavepointName(this.readUniqueIdentifier());
        } else {
            this.readIf("WORK");
            transactionCommand = new TransactionCommand(this.session, 72);
        }
        return transactionCommand;
    }

    private Prepared parsePrepare() {
        Object object;
        if (this.readIf("COMMIT")) {
            TransactionCommand transactionCommand = new TransactionCommand(this.session, 77);
            transactionCommand.setTransactionName(this.readUniqueIdentifier());
            return transactionCommand;
        }
        String string = this.readAliasIdentifier();
        if (this.readIf(69)) {
            object = Utils.newSmallArrayList();
            int n = 0;
            while (true) {
                Column column = this.parseColumnForTable("C" + n, true, false);
                ((ArrayList)object).add(column);
                if (!this.readIfMore(true)) break;
                ++n;
            }
        }
        this.read("AS");
        object = this.parsePrepared();
        PrepareProcedure prepareProcedure = new PrepareProcedure(this.session);
        prepareProcedure.setProcedureName(string);
        prepareProcedure.setPrepared((Prepared)object);
        return prepareProcedure;
    }

    private TransactionCommand parseSavepoint() {
        TransactionCommand transactionCommand = new TransactionCommand(this.session, 74);
        transactionCommand.setSavepointName(this.readUniqueIdentifier());
        return transactionCommand;
    }

    private Prepared parseReleaseSavepoint() {
        NoOperation noOperation = new NoOperation(this.session);
        this.readIf("SAVEPOINT");
        this.readUniqueIdentifier();
        return noOperation;
    }

    private Schema findSchema(String string) {
        if (string == null) {
            return null;
        }
        Schema schema = this.database.findSchema(string);
        if (schema == null && this.equalsToken("SESSION", string)) {
            schema = this.database.getSchema(this.session.getCurrentSchemaName());
        }
        return schema;
    }

    private Schema getSchema(String string) {
        if (string == null) {
            return null;
        }
        Schema schema = this.findSchema(string);
        if (schema == null) {
            throw DbException.get(90079, string);
        }
        return schema;
    }

    private Schema getSchema() {
        return this.getSchema(this.schemaName);
    }

    private Schema getSchemaWithDefault() {
        if (this.schemaName == null) {
            this.schemaName = this.session.getCurrentSchemaName();
        }
        return this.getSchema(this.schemaName);
    }

    private Column readTableColumn(TableFilter tableFilter) {
        boolean bl = false;
        String string = null;
        if (this.currentTokenType == 45) {
            this.read();
            bl = true;
        } else {
            string = this.readColumnIdentifier();
            if (this.readIf(74)) {
                String string2 = string;
                if (this.currentTokenType == 45) {
                    this.read();
                    bl = true;
                } else {
                    string = this.readColumnIdentifier();
                    if (this.readIf(74)) {
                        String string3 = string2;
                        string2 = string;
                        if (this.currentTokenType == 45) {
                            this.read();
                            bl = true;
                        } else {
                            string = this.readColumnIdentifier();
                            if (this.readIf(74)) {
                                if (!this.equalsToken(string3, this.database.getShortName())) {
                                    throw DbException.get(90013, string3);
                                }
                                string3 = string2;
                                string2 = string;
                                if (this.currentTokenType == 45) {
                                    this.read();
                                    bl = true;
                                } else {
                                    string = this.readColumnIdentifier();
                                }
                            }
                        }
                        if (!this.equalsToken(string3, tableFilter.getTable().getSchema().getName())) {
                            throw DbException.get(90079, string3);
                        }
                    }
                }
                if (!this.equalsToken(string2, tableFilter.getTableAlias())) {
                    throw DbException.get(42102, string2);
                }
            }
        }
        return bl ? tableFilter.getRowIdColumn() : tableFilter.getTable().getColumn(string);
    }

    private Update parseUpdate() {
        Update update = new Update(this.session);
        this.currentPrepared = update;
        int n = this.lastParseIndex;
        TableFilter tableFilter = this.readSimpleTableFilter(0, null);
        update.setTableFilter(tableFilter);
        this.parseUpdateSetClause(update, tableFilter, n, true);
        return update;
    }

    private void parseUpdateSetClause(Update update, TableFilter tableFilter, int n, boolean bl) {
        Object object;
        this.read("SET");
        if (this.readIf(69)) {
            Object object2;
            object = Utils.newSmallArrayList();
            do {
                object2 = this.readTableColumn(tableFilter);
                ((ArrayList)object).add(object2);
            } while (this.readIfMore(true));
            this.read(59);
            object2 = this.readExpression();
            if (((ArrayList)object).size() == 1 && ((Expression)object2).getType().getValueType() != 39) {
                update.setAssignment((Column)((ArrayList)object).get(0), (Expression)object2);
            } else {
                int n2 = ((ArrayList)object).size();
                for (int i = 0; i < n2; ++i) {
                    Column column = (Column)((ArrayList)object).get(i);
                    Function function = Function.getFunction(this.database, "ARRAY_GET");
                    function.setParameter(0, (Expression)object2);
                    function.setParameter(1, ValueExpression.get(ValueInt.get(i + 1)));
                    function.doneWithParameters();
                    update.setAssignment(column, function);
                }
            }
        } else {
            do {
                object = this.readTableColumn(tableFilter);
                this.read(59);
                update.setAssignment((Column)object, this.readExpressionOrDefault());
            } while (this.readIf(73));
        }
        if (this.readIf(53)) {
            object = this.readExpression();
            update.setCondition((Expression)object);
        }
        if (bl) {
            if (this.readIf(41)) {
                this.read("BY");
                this.parseSimpleOrderList();
            }
            if (this.readIf(32)) {
                object = this.readTerm().optimize(this.session);
                update.setLimit((Expression)object);
            }
        }
        this.setSQL(update, "UPDATE", n);
    }

    private TableFilter readSimpleTableFilter(int n, Collection<String> collection) {
        Table table = this.readTableOrView();
        String string = null;
        if (this.readIf("AS")) {
            string = this.readAliasIdentifier();
        } else if (!(this.currentTokenType != 2 || Parser.equalsTokenIgnoreCase(this.currentToken, "SET") || collection != null && this.isTokenInList(collection))) {
            string = this.readAliasIdentifier();
        }
        return new TableFilter(this.session, table, string, this.rightsChecked, this.currentSelect, n, null);
    }

    private Delete parseDelete() {
        Delete delete = new Delete(this.session);
        Expression expression = null;
        if (this.readIf("TOP")) {
            expression = this.readTerm().optimize(this.session);
        }
        this.currentPrepared = delete;
        int n = this.lastParseIndex;
        if (!this.readIf(20) && this.database.getMode().getEnum() == Mode.ModeEnum.MySQL) {
            this.readIdentifierWithSchema();
            this.read(20);
        }
        TableFilter tableFilter = this.readSimpleTableFilter(0, null);
        delete.setTableFilter(tableFilter);
        if (this.readIf(53)) {
            delete.setCondition(this.readExpression());
        }
        if (expression == null && this.readIf(32)) {
            expression = this.readTerm().optimize(this.session);
        }
        delete.setLimit(expression);
        this.setSQL(delete, "DELETE", n);
        return delete;
    }

    private IndexColumn[] parseIndexColumnList() {
        ArrayList<IndexColumn> arrayList = Utils.newSmallArrayList();
        do {
            IndexColumn indexColumn = new IndexColumn();
            indexColumn.columnName = this.readColumnIdentifier();
            indexColumn.sortType = this.parseSortType();
            arrayList.add(indexColumn);
        } while (this.readIfMore(true));
        return arrayList.toArray(new IndexColumn[0]);
    }

    private int parseSortType() {
        int n = this.parseSimpleSortType();
        if (this.readIf("NULLS")) {
            if (this.readIf("FIRST")) {
                n |= 2;
            } else {
                this.read("LAST");
                n |= 4;
            }
        }
        return n;
    }

    private int parseSimpleSortType() {
        if (!this.readIf("ASC") && this.readIf("DESC")) {
            return 1;
        }
        return 0;
    }

    private String[] parseColumnList() {
        ArrayList<String> arrayList = Utils.newSmallArrayList();
        do {
            String string = this.readColumnIdentifier();
            arrayList.add(string);
        } while (this.readIfMore(false));
        return arrayList.toArray(new String[0]);
    }

    private Column[] parseColumnList(Table table) {
        ArrayList<Column> arrayList = Utils.newSmallArrayList();
        HashSet<Column> hashSet = new HashSet<Column>();
        if (!this.readIf(70)) {
            do {
                Column column;
                if (!hashSet.add(column = this.parseColumn(table))) {
                    throw DbException.get(42121, column.getSQL(false));
                }
                arrayList.add(column);
            } while (this.readIfMore(false));
        }
        return arrayList.toArray(new Column[0]);
    }

    private Column parseColumn(Table table) {
        if (this.currentTokenType == 45) {
            this.read();
            return table.getRowIdColumn();
        }
        return table.getColumn(this.readColumnIdentifier());
    }

    private boolean readIfMore(boolean bl) {
        if (this.readIf(73)) {
            return bl || !this.readIf(70);
        }
        this.read(70);
        return false;
    }

    private Prepared parseHelp() {
        Select select = new Select(this.session, null);
        select.setWildcard();
        String string = this.database.sysIdentifier("INFORMATION_SCHEMA");
        Table table = this.database.getSchema(string).resolveTableOrView(this.session, this.database.sysIdentifier("HELP"));
        Function function = Function.getFunction(this.database, "UPPER");
        function.setParameter(0, new ExpressionColumn(this.database, string, this.database.sysIdentifier("HELP"), this.database.sysIdentifier("TOPIC"), false));
        function.doneWithParameters();
        TableFilter tableFilter = new TableFilter(this.session, table, null, this.rightsChecked, select, 0, null);
        select.addTableFilter(tableFilter, true);
        while (this.currentTokenType != 57) {
            String string2 = this.currentToken;
            this.read();
            CompareLike compareLike = new CompareLike(this.database, function, ValueExpression.get(ValueString.get('%' + string2 + '%')), null, false);
            select.addCondition(compareLike);
        }
        select.init();
        return select;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Prepared parseShow() {
        Object object;
        String string;
        ArrayList<Value> arrayList = Utils.newSmallArrayList();
        StringBuilder stringBuilder = new StringBuilder("SELECT ");
        if (this.readIf("CLIENT_ENCODING")) {
            stringBuilder.append("'UNICODE' AS CLIENT_ENCODING FROM DUAL");
        } else if (this.readIf("DEFAULT_TRANSACTION_ISOLATION")) {
            stringBuilder.append("'read committed' AS DEFAULT_TRANSACTION_ISOLATION FROM DUAL");
        } else if (this.readIf("TRANSACTION")) {
            this.read("ISOLATION");
            this.read("LEVEL");
            stringBuilder.append("'read committed' AS TRANSACTION_ISOLATION FROM DUAL");
        } else if (this.readIf("DATESTYLE")) {
            stringBuilder.append("'ISO' AS DATESTYLE FROM DUAL");
        } else if (this.readIf("SERVER_VERSION")) {
            stringBuilder.append("'8.2.23' AS SERVER_VERSION FROM DUAL");
        } else if (this.readIf("SERVER_ENCODING")) {
            stringBuilder.append("'UTF8' AS SERVER_ENCODING FROM DUAL");
        } else if (this.readIf("TABLES")) {
            string = this.database.getMainSchema().getName();
            if (this.readIf(20)) {
                string = this.readUniqueIdentifier();
            }
            stringBuilder.append("TABLE_NAME, TABLE_SCHEMA FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA=? ORDER BY TABLE_NAME");
            arrayList.add(ValueString.get(string));
        } else if (this.readIf("COLUMNS")) {
            this.read(20);
            string = this.readIdentifierWithSchema();
            object = this.getSchema().getName();
            arrayList.add(ValueString.get(string));
            if (this.readIf(20)) {
                object = this.readUniqueIdentifier();
            }
            stringBuilder.append("C.COLUMN_NAME FIELD, C.TYPE_NAME || '(' || C.NUMERIC_PRECISION || ')' TYPE, C.IS_NULLABLE \"NULL\", CASE (SELECT MAX(I.INDEX_TYPE_NAME) FROM INFORMATION_SCHEMA.INDEXES I WHERE I.TABLE_SCHEMA=C.TABLE_SCHEMA AND I.TABLE_NAME=C.TABLE_NAME AND I.COLUMN_NAME=C.COLUMN_NAME)WHEN 'PRIMARY KEY' THEN 'PRI' WHEN 'UNIQUE INDEX' THEN 'UNI' ELSE '' END KEY, IFNULL(COLUMN_DEFAULT, 'NULL') DEFAULT FROM INFORMATION_SCHEMA.COLUMNS C WHERE C.TABLE_NAME=? AND C.TABLE_SCHEMA=? ORDER BY C.ORDINAL_POSITION");
            arrayList.add(ValueString.get((String)object));
        } else if (this.readIf("DATABASES") || this.readIf("SCHEMAS")) {
            stringBuilder.append("SCHEMA_NAME FROM INFORMATION_SCHEMA.SCHEMATA");
        }
        boolean bl = this.session.getAllowLiterals();
        try {
            this.session.setAllowLiterals(true);
            object = Parser.prepare(this.session, stringBuilder.toString(), arrayList);
            return object;
        }
        finally {
            this.session.setAllowLiterals(bl);
        }
    }

    private static Prepared prepare(Session session2, String string, ArrayList<Value> arrayList) {
        Prepared prepared = session2.prepare(string);
        ArrayList<Parameter> arrayList2 = prepared.getParameters();
        if (arrayList2 != null) {
            int n = arrayList2.size();
            for (int i = 0; i < n; ++i) {
                Parameter parameter = arrayList2.get(i);
                parameter.setValue(arrayList.get(i));
            }
        }
        return prepared;
    }

    private boolean isSelect() {
        boolean bl;
        int n = this.lastParseIndex;
        while (this.readIf(69)) {
        }
        switch (this.currentTokenType) {
            case 20: 
            case 47: 
            case 52: 
            case 55: {
                bl = true;
                break;
            }
            case 48: {
                this.read();
                bl = !this.readIf(69);
                break;
            }
            default: {
                bl = false;
            }
        }
        this.parseIndex = n;
        this.read();
        return bl;
    }

    private Prepared parseMerge() {
        Column[] columnArray;
        int n = this.lastParseIndex;
        this.read("INTO");
        List<String> list = Arrays.asList("USING", "KEY");
        TableFilter tableFilter = this.readSimpleTableFilter(0, list);
        if (this.readIf("USING")) {
            return this.parseMergeUsing(tableFilter, n);
        }
        Merge merge = new Merge(this.session);
        this.currentPrepared = merge;
        merge.setTargetTableFilter(tableFilter);
        Table table = merge.getTargetTable();
        if (this.readIf(69)) {
            if (this.isSelect()) {
                merge.setQuery(this.parseSelect());
                this.read(70);
                return merge;
            }
            columnArray = this.parseColumnList(table);
            merge.setColumns(columnArray);
        }
        if (this.readIf("KEY")) {
            this.read(69);
            columnArray = this.parseColumnList(table);
            merge.setKeys(columnArray);
        }
        if (this.readIf(52)) {
            this.parseValuesForCommand(merge);
        } else {
            merge.setQuery(this.parseSelect());
        }
        return merge;
    }

    private MergeUsing parseMergeUsing(TableFilter tableFilter, int n) {
        Object object;
        String[] stringArray;
        Object object2;
        MergeUsing mergeUsing = new MergeUsing(this.session, tableFilter);
        this.currentPrepared = mergeUsing;
        if (this.readIf(69)) {
            if (this.isSelect()) {
                mergeUsing.setQuery(this.parseSelect());
                this.read(70);
            }
            if ((object2 = this.readFromAlias(null, null)) == null) {
                object2 = "QUERY_ALIAS_" + this.parseIndex;
            }
            mergeUsing.setQueryAlias((String)object2);
            stringArray = new String[]{null};
            object = TableView.createQueryColumnTemplateList(null, mergeUsing.getQuery(), stringArray);
            TableView tableView = this.createCTEView((String)object2, stringArray[0], (List<Column>)object, false, false, true);
            TableFilter tableFilter2 = new TableFilter(this.session, tableView, (String)object2, this.rightsChecked, (Select)mergeUsing.getQuery(), 0, null);
            mergeUsing.setSourceTableFilter(tableFilter2);
        } else {
            object2 = this.readSimpleTableFilter(0, null);
            mergeUsing.setSourceTableFilter((TableFilter)object2);
            stringArray = new Select(this.session, null);
            stringArray.setWildcard();
            object = new TableFilter(this.session, ((TableFilter)object2).getTable(), ((TableFilter)object2).getTableAlias(), this.rightsChecked, (Select)stringArray, 0, null);
            stringArray.addTableFilter((TableFilter)object, true);
            stringArray.init();
            mergeUsing.setQuery((Query)stringArray);
        }
        this.read(40);
        object2 = this.readExpression();
        mergeUsing.setOnCondition((Expression)object2);
        this.read("WHEN");
        do {
            boolean bl;
            if (bl = this.readIf("MATCHED")) {
                this.parseWhenMatched(mergeUsing);
                continue;
            }
            this.parseWhenNotMatched(mergeUsing);
        } while (this.readIf("WHEN"));
        this.setSQL(mergeUsing, "MERGE", n);
        return mergeUsing;
    }

    private void parseWhenMatched(MergeUsing mergeUsing) {
        Object object;
        Expression expression = this.readIf("AND") ? this.readExpression() : null;
        this.read("THEN");
        int n = this.lastParseIndex;
        Update update = null;
        if (this.readIf("UPDATE")) {
            update = new Update(this.session);
            object = mergeUsing.getTargetTableFilter();
            update.setTableFilter((TableFilter)object);
            this.parseUpdateSetClause(update, (TableFilter)object, n, false);
            n = this.lastParseIndex;
        }
        object = null;
        if (this.readIf("DELETE")) {
            object = new Delete(this.session);
            ((Delete)object).setTableFilter(mergeUsing.getTargetTableFilter());
            if (this.readIf(53)) {
                ((Delete)object).setCondition(this.readExpression());
            }
            this.setSQL((Prepared)object, "DELETE", n);
        }
        if (update == null && object == null) {
            throw this.getSyntaxError();
        }
        MergeUsing.WhenMatched whenMatched = new MergeUsing.WhenMatched(mergeUsing);
        whenMatched.setAndCondition(expression);
        whenMatched.setUpdateCommand(update);
        whenMatched.setDeleteCommand((Delete)object);
        mergeUsing.addWhen(whenMatched);
    }

    private void parseWhenNotMatched(MergeUsing mergeUsing) {
        this.read(37);
        this.read("MATCHED");
        Expression expression = this.readIf("AND") ? this.readExpression() : null;
        this.read("THEN");
        if (!this.readIf("INSERT")) {
            throw this.getSyntaxError();
        }
        Insert insert = new Insert(this.session);
        insert.setTable(mergeUsing.getTargetTable());
        this.parseInsertGivenTable(insert, mergeUsing.getTargetTable());
        MergeUsing.WhenNotMatched whenNotMatched = new MergeUsing.WhenNotMatched(mergeUsing);
        whenNotMatched.setAndCondition(expression);
        whenNotMatched.setInsertCommand(insert);
        mergeUsing.addWhen(whenNotMatched);
    }

    private Insert parseInsert() {
        Insert insert = new Insert(this.session);
        this.currentPrepared = insert;
        if (this.database.getMode().onDuplicateKeyUpdate && this.readIf("IGNORE")) {
            insert.setIgnore(true);
        }
        this.read("INTO");
        Table table = this.readTableOrView();
        insert.setTable(table);
        Insert insert2 = this.parseInsertGivenTable(insert, table);
        if (insert2 != null) {
            return insert2;
        }
        if (this.database.getMode().onDuplicateKeyUpdate && this.readIf(40)) {
            this.read("DUPLICATE");
            this.read("KEY");
            this.read("UPDATE");
            do {
                Object object;
                String string = this.readColumnIdentifier();
                if (this.readIf(74)) {
                    object = string;
                    Object object2 = this.readColumnIdentifier();
                    if (this.readIf(74)) {
                        if (!table.getSchema().getName().equals(object)) {
                            throw DbException.get(90080);
                        }
                        string = this.readColumnIdentifier();
                    } else {
                        string = object2;
                        object2 = object;
                    }
                    if (!table.getName().equals(object2)) {
                        throw DbException.get(42102, (String)object2);
                    }
                }
                object = table.getColumn(string);
                this.read(59);
                insert.addAssignmentForDuplicate((Column)object, this.readExpressionOrDefault());
            } while (this.readIf(73));
        }
        if (this.database.getMode().isolationLevelInSelectOrInsertStatement) {
            this.parseIsolationClause();
        }
        return insert;
    }

    private Insert parseInsertGivenTable(Insert insert, Table table) {
        Column[] columnArray = null;
        if (this.readIf(69)) {
            if (this.isSelect()) {
                insert.setQuery(this.parseSelect());
                this.read(70);
                return insert;
            }
            columnArray = this.parseColumnList(table);
            insert.setColumns(columnArray);
        }
        if (this.readIf("DIRECT")) {
            insert.setInsertFromSelect(true);
        }
        if (this.readIf("SORTED")) {
            insert.setSortedInsertMode(true);
        }
        if (this.readIf("DEFAULT")) {
            this.read(52);
            insert.addRow(new Expression[0]);
        } else if (this.readIf(52)) {
            this.parseValuesForCommand(insert);
        } else if (this.readIf("SET")) {
            if (columnArray != null) {
                throw this.getSyntaxError();
            }
            ArrayList<Column> arrayList = Utils.newSmallArrayList();
            ArrayList<Expression> arrayList2 = Utils.newSmallArrayList();
            do {
                arrayList.add(this.parseColumn(table));
                this.read(59);
                arrayList2.add(this.readExpressionOrDefault());
            } while (this.readIf(73));
            insert.setColumns(arrayList.toArray(new Column[0]));
            insert.addRow(arrayList2.toArray(new Expression[0]));
        } else {
            insert.setQuery(this.parseSelect());
        }
        return null;
    }

    private Replace parseReplace() {
        Replace replace = new Replace(this.session);
        this.currentPrepared = replace;
        this.read("INTO");
        Table table = this.readTableOrView();
        replace.setTable(table);
        if (this.readIf(69)) {
            if (this.isSelect()) {
                replace.setQuery(this.parseSelect());
                this.read(70);
                return replace;
            }
            Column[] columnArray = this.parseColumnList(table);
            replace.setColumns(columnArray);
        }
        if (this.readIf(52)) {
            this.parseValuesForCommand(replace);
        } else {
            replace.setQuery(this.parseSelect());
        }
        return replace;
    }

    private void parseValuesForCommand(CommandWithValues commandWithValues) {
        ArrayList<Expression> arrayList = Utils.newSmallArrayList();
        do {
            boolean bl;
            arrayList.clear();
            if (this.readIf(44)) {
                this.read(69);
                bl = true;
            } else {
                bl = this.readIf(69);
            }
            if (bl) {
                if (!this.readIf(70)) {
                    do {
                        arrayList.add(this.readIf("DEFAULT") ? null : this.readExpression());
                    } while (this.readIfMore(false));
                }
            } else {
                arrayList.add(this.readIf("DEFAULT") ? null : this.readExpression());
            }
            commandWithValues.addRow(arrayList.toArray(new Expression[0]));
        } while (this.readIf(73));
    }

    /*
     * Enabled aggressive block sorting
     */
    private TableFilter readTableFilter() {
        Table table;
        Object object;
        ArrayList<String> arrayList;
        String string;
        block20: {
            block26: {
                block25: {
                    block24: {
                        block23: {
                            block22: {
                                string = null;
                                if (this.readIf(69)) {
                                    if (this.isSelect()) {
                                        arrayList = this.parseSelectUnion();
                                        this.read(70);
                                        ((Prepared)((Object)arrayList)).setParameterList(new ArrayList<Parameter>(this.parameters));
                                        ((Query)((Object)arrayList)).init();
                                        object = this.createView != null ? this.database.getSystemSession() : this.session;
                                        string = this.session.getNextSystemIdentifier(this.sqlCommand);
                                        table = TableView.createTempView((Session)object, this.session.getUser(), string, arrayList, this.currentSelect);
                                        break block20;
                                    } else {
                                        TableFilter tableFilter = this.readTableFilter();
                                        tableFilter = this.readJoin(tableFilter);
                                        this.read(70);
                                        string = this.readFromAlias(null);
                                        if (string != null) {
                                            tableFilter.setAlias(string);
                                            ArrayList<String> arrayList2 = this.readDerivedColumnNames();
                                            if (arrayList2 != null) {
                                                tableFilter.setDerivedColumns(arrayList2);
                                            }
                                        }
                                        return tableFilter;
                                    }
                                }
                                if (!this.readIf(52)) break block22;
                                table = this.parseValuesTable(0).getTable();
                                break block20;
                            }
                            if (!this.readIf(48)) break block23;
                            this.read(69);
                            table = this.readTableFunction("TABLE", null, this.database.getMainSchema());
                            break block20;
                        }
                        arrayList = this.readIdentifierWithSchema(null);
                        if (this.schemaName != null) break block24;
                        object = null;
                        break block25;
                    }
                    object = this.findSchema(this.schemaName);
                    if (object != null) break block25;
                    if (!this.isDualTable((String)((Object)arrayList))) {
                        throw DbException.get(90079, this.schemaName);
                    }
                    table = this.getDualTable(false);
                    break block20;
                }
                boolean bl = this.readIf(69);
                if (bl && this.readIf("INDEX")) {
                    this.readIdentifierWithSchema(null);
                    this.read(70);
                    bl = false;
                }
                if (!bl) break block26;
                Schema schema = this.database.getMainSchema();
                if (this.equalsToken((String)((Object)arrayList), "SYSTEM_RANGE") || this.equalsToken((String)((Object)arrayList), "GENERATE_SERIES")) {
                    Expression expression = this.readExpression();
                    this.read(73);
                    Expression expression2 = this.readExpression();
                    if (this.readIf(73)) {
                        Expression expression3 = this.readExpression();
                        this.read(70);
                        table = new RangeTable(schema, expression, expression2, expression3, false);
                        break block20;
                    } else {
                        this.read(70);
                        table = new RangeTable(schema, expression, expression2, false);
                    }
                    break block20;
                } else {
                    table = this.readTableFunction((String)((Object)arrayList), (Schema)object, schema);
                }
                break block20;
            }
            table = this.readTableOrView((String)((Object)arrayList));
        }
        arrayList = null;
        object = null;
        if (this.readIf("USE")) {
            if (this.readIf("INDEX")) {
                object = this.parseIndexHints(table);
            } else {
                string = "USE";
                arrayList = this.readDerivedColumnNames();
            }
        } else if ((string = this.readFromAlias(string)) != null) {
            arrayList = this.readDerivedColumnNames();
            if (this.readIf("USE")) {
                this.read("INDEX");
                object = this.parseIndexHints(table);
            }
        }
        if (this.database.getMode().discardWithTableHints) {
            this.discardWithTableHints();
        }
        if (table.isView() && table.isTableExpression() && string == null) {
            string = table.getName();
        }
        TableFilter tableFilter = new TableFilter(this.session, table, string, this.rightsChecked, this.currentSelect, this.orderInFrom++, (IndexHints)object);
        if (arrayList != null) {
            tableFilter.setDerivedColumns(arrayList);
        }
        return tableFilter;
    }

    private Table readTableFunction(String string, Schema schema, Schema schema2) {
        Expression expression = this.readFunction(schema, string);
        if (!(expression instanceof FunctionCall)) {
            throw this.getSyntaxError();
        }
        FunctionCall functionCall = (FunctionCall)((Object)expression);
        if (!functionCall.isDeterministic()) {
            this.recompileAlways = true;
        }
        return new FunctionTable(schema2, this.session, expression, functionCall);
    }

    private IndexHints parseIndexHints(Table table) {
        this.read(69);
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        if (!this.readIf(70)) {
            do {
                String string = this.readIdentifierWithSchema();
                Index index = table.getIndex(string);
                linkedHashSet.add(index.getName());
            } while (this.readIfMore(true));
        }
        return IndexHints.createUseIndexHints(linkedHashSet);
    }

    private String readFromAlias(String string, List<String> list) {
        if (this.readIf("AS")) {
            string = this.readAliasIdentifier();
        } else if (!(this.currentTokenType != 2 || list != null && this.isTokenInList(list))) {
            string = this.readAliasIdentifier();
        }
        return string;
    }

    private String readFromAlias(String string) {
        List<String> list = Arrays.asList("LEFT", "RIGHT");
        return this.readFromAlias(string, list);
    }

    private ArrayList<String> readDerivedColumnNames() {
        if (this.readIf(69)) {
            ArrayList<String> arrayList = new ArrayList<String>();
            do {
                arrayList.add(this.readAliasIdentifier());
            } while (this.readIfMore(true));
            return arrayList;
        }
        return null;
    }

    private void discardWithTableHints() {
        if (this.readIf(55)) {
            this.read(69);
            do {
                this.discardTableHint();
            } while (this.readIfMore(true));
        }
    }

    private void discardTableHint() {
        if (this.readIf("INDEX")) {
            if (this.readIf(69)) {
                do {
                    this.readExpression();
                } while (this.readIfMore(true));
            } else {
                this.read(59);
                this.readExpression();
            }
        } else {
            this.readExpression();
        }
    }

    private Prepared parseTruncate() {
        boolean bl;
        this.read(48);
        Table table = this.readTableOrView();
        if (this.readIf("CONTINUE")) {
            this.read("IDENTITY");
            bl = false;
        } else if (this.readIf("RESTART")) {
            this.read("IDENTITY");
            bl = true;
        } else {
            bl = false;
        }
        TruncateTable truncateTable = new TruncateTable(this.session);
        truncateTable.setTable(table);
        truncateTable.setRestart(bl);
        return truncateTable;
    }

    private boolean readIfExists(boolean bl) {
        if (this.readIf(24)) {
            this.read(15);
            bl = true;
        }
        return bl;
    }

    private Prepared parseComment() {
        String string;
        int n = 0;
        this.read(40);
        boolean bl = false;
        if (this.readIf(48) || this.readIf("VIEW")) {
            n = 0;
        } else if (this.readIf("COLUMN")) {
            bl = true;
            n = 0;
        } else if (this.readIf("CONSTANT")) {
            n = 11;
        } else if (this.readIf(7)) {
            n = 5;
        } else if (this.readIf("ALIAS")) {
            n = 9;
        } else if (this.readIf("INDEX")) {
            n = 1;
        } else if (this.readIf("ROLE")) {
            n = 7;
        } else if (this.readIf("SCHEMA")) {
            n = 10;
        } else if (this.readIf("SEQUENCE")) {
            n = 3;
        } else if (this.readIf("TRIGGER")) {
            n = 4;
        } else if (this.readIf("USER")) {
            n = 2;
        } else if (this.readIf("DOMAIN")) {
            n = 12;
        } else {
            throw this.getSyntaxError();
        }
        SetComment setComment = new SetComment(this.session);
        if (bl) {
            ArrayList arrayList = Utils.newSmallArrayList();
            do {
                arrayList.add(this.readUniqueIdentifier());
            } while (this.readIf(74));
            this.schemaName = this.session.getCurrentSchemaName();
            if (arrayList.size() == 4 && !this.equalsToken(this.database.getShortName(), (String)arrayList.remove(0))) {
                throw DbException.getSyntaxError(this.sqlCommand, this.parseIndex, "database name");
            }
            if (arrayList.size() == 3) {
                this.schemaName = (String)arrayList.remove(0);
            }
            if (arrayList.size() != 2) {
                throw DbException.getSyntaxError(this.sqlCommand, this.parseIndex, "table.column");
            }
            string = (String)arrayList.get(0);
            setComment.setColumn(true);
            setComment.setColumnName((String)arrayList.get(1));
        } else {
            string = this.readIdentifierWithSchema();
        }
        setComment.setSchemaName(this.schemaName);
        setComment.setObjectName(string);
        setComment.setObjectType(n);
        this.read(29);
        setComment.setCommentExpression(this.readExpression());
        return setComment;
    }

    private Prepared parseDrop() {
        if (this.readIf(48)) {
            boolean bl = this.readIfExists(false);
            String string = this.readIdentifierWithSchema();
            DropTable dropTable = new DropTable(this.session, this.getSchema());
            dropTable.setTableName(string);
            while (this.readIf(73)) {
                string = this.readIdentifierWithSchema();
                DropTable dropTable2 = new DropTable(this.session, this.getSchema());
                dropTable2.setTableName(string);
                dropTable.addNextDropTable(dropTable2);
            }
            bl = this.readIfExists(bl);
            dropTable.setIfExists(bl);
            if (this.readIf("CASCADE")) {
                dropTable.setDropAction(ConstraintActionType.CASCADE);
                this.readIf("CONSTRAINTS");
            } else if (this.readIf("RESTRICT")) {
                dropTable.setDropAction(ConstraintActionType.RESTRICT);
            } else if (this.readIf("IGNORE")) {
                dropTable.setDropAction(ConstraintActionType.SET_DEFAULT);
            }
            return dropTable;
        }
        if (this.readIf("INDEX")) {
            boolean bl = this.readIfExists(false);
            String string = this.readIdentifierWithSchema();
            DropIndex dropIndex = new DropIndex(this.session, this.getSchema());
            dropIndex.setIndexName(string);
            bl = this.readIfExists(bl);
            dropIndex.setIfExists(bl);
            if (this.readIf(40)) {
                this.readIdentifierWithSchema();
            }
            return dropIndex;
        }
        if (this.readIf("USER")) {
            boolean bl = this.readIfExists(false);
            DropUser dropUser = new DropUser(this.session);
            dropUser.setUserName(this.readUniqueIdentifier());
            bl = this.readIfExists(bl);
            this.readIf("CASCADE");
            dropUser.setIfExists(bl);
            return dropUser;
        }
        if (this.readIf("SEQUENCE")) {
            boolean bl = this.readIfExists(false);
            String string = this.readIdentifierWithSchema();
            DropSequence dropSequence = new DropSequence(this.session, this.getSchema());
            dropSequence.setSequenceName(string);
            bl = this.readIfExists(bl);
            dropSequence.setIfExists(bl);
            return dropSequence;
        }
        if (this.readIf("CONSTANT")) {
            boolean bl = this.readIfExists(false);
            String string = this.readIdentifierWithSchema();
            DropConstant dropConstant = new DropConstant(this.session, this.getSchema());
            dropConstant.setConstantName(string);
            bl = this.readIfExists(bl);
            dropConstant.setIfExists(bl);
            return dropConstant;
        }
        if (this.readIf("TRIGGER")) {
            boolean bl = this.readIfExists(false);
            String string = this.readIdentifierWithSchema();
            DropTrigger dropTrigger = new DropTrigger(this.session, this.getSchema());
            dropTrigger.setTriggerName(string);
            bl = this.readIfExists(bl);
            dropTrigger.setIfExists(bl);
            return dropTrigger;
        }
        if (this.readIf("VIEW")) {
            boolean bl = this.readIfExists(false);
            String string = this.readIdentifierWithSchema();
            DropView dropView = new DropView(this.session, this.getSchema());
            dropView.setViewName(string);
            bl = this.readIfExists(bl);
            dropView.setIfExists(bl);
            ConstraintActionType constraintActionType = this.parseCascadeOrRestrict();
            if (constraintActionType != null) {
                dropView.setDropAction(constraintActionType);
            }
            return dropView;
        }
        if (this.readIf("ROLE")) {
            boolean bl = this.readIfExists(false);
            DropRole dropRole = new DropRole(this.session);
            dropRole.setRoleName(this.readUniqueIdentifier());
            bl = this.readIfExists(bl);
            dropRole.setIfExists(bl);
            return dropRole;
        }
        if (this.readIf("ALIAS")) {
            boolean bl = this.readIfExists(false);
            String string = this.readIdentifierWithSchema();
            DropFunctionAlias dropFunctionAlias = new DropFunctionAlias(this.session, this.getSchema());
            dropFunctionAlias.setAliasName(string);
            bl = this.readIfExists(bl);
            dropFunctionAlias.setIfExists(bl);
            return dropFunctionAlias;
        }
        if (this.readIf("SCHEMA")) {
            boolean bl = this.readIfExists(false);
            DropSchema dropSchema = new DropSchema(this.session);
            dropSchema.setSchemaName(this.readUniqueIdentifier());
            bl = this.readIfExists(bl);
            dropSchema.setIfExists(bl);
            ConstraintActionType constraintActionType = this.parseCascadeOrRestrict();
            if (constraintActionType != null) {
                dropSchema.setDropAction(constraintActionType);
            }
            return dropSchema;
        }
        if (this.readIf(3)) {
            this.read("OBJECTS");
            DropDatabase dropDatabase = new DropDatabase(this.session);
            dropDatabase.setDropAllObjects(true);
            if (this.readIf("DELETE")) {
                this.read("FILES");
                dropDatabase.setDeleteFiles(true);
            }
            return dropDatabase;
        }
        if (this.readIf("DOMAIN") || this.readIf("TYPE") || this.readIf("DATATYPE")) {
            return this.parseDropDomain();
        }
        if (this.readIf("AGGREGATE")) {
            return this.parseDropAggregate();
        }
        if (this.readIf("SYNONYM")) {
            boolean bl = this.readIfExists(false);
            String string = this.readIdentifierWithSchema();
            DropSynonym dropSynonym = new DropSynonym(this.session, this.getSchema());
            dropSynonym.setSynonymName(string);
            bl = this.readIfExists(bl);
            dropSynonym.setIfExists(bl);
            return dropSynonym;
        }
        throw this.getSyntaxError();
    }

    private DropDomain parseDropDomain() {
        boolean bl = this.readIfExists(false);
        DropDomain dropDomain = new DropDomain(this.session);
        dropDomain.setTypeName(this.readUniqueIdentifier());
        bl = this.readIfExists(bl);
        dropDomain.setIfExists(bl);
        ConstraintActionType constraintActionType = this.parseCascadeOrRestrict();
        if (constraintActionType != null) {
            dropDomain.setDropAction(constraintActionType);
        }
        return dropDomain;
    }

    private DropAggregate parseDropAggregate() {
        boolean bl = this.readIfExists(false);
        DropAggregate dropAggregate = new DropAggregate(this.session);
        dropAggregate.setName(this.readUniqueIdentifier());
        bl = this.readIfExists(bl);
        dropAggregate.setIfExists(bl);
        return dropAggregate;
    }

    private TableFilter readJoin(TableFilter tableFilter) {
        TableFilter tableFilter2 = tableFilter;
        while (true) {
            Column[] columnArray;
            TableFilter tableFilter3;
            if (this.readIf("RIGHT")) {
                this.readIf("OUTER");
                this.read(30);
                tableFilter3 = this.readTableFilter();
                tableFilter3 = this.readJoin(tableFilter3);
                columnArray = null;
                if (this.readIf(40)) {
                    columnArray = this.readExpression();
                }
                this.addJoin(tableFilter3, tableFilter, true, (Expression)columnArray);
                tableFilter = tableFilter3;
            } else if (this.readIf("LEFT")) {
                this.readIf("OUTER");
                this.read(30);
                tableFilter3 = this.readTableFilter();
                tableFilter3 = this.readJoin(tableFilter3);
                columnArray = null;
                if (this.readIf(40)) {
                    columnArray = this.readExpression();
                }
                this.addJoin(tableFilter, tableFilter3, true, (Expression)columnArray);
            } else {
                if (this.readIf(21)) {
                    throw this.getSyntaxError();
                }
                if (this.readIf(25)) {
                    this.read(30);
                    tableFilter3 = this.readTableFilter();
                    tableFilter = this.readJoin(tableFilter);
                    columnArray = null;
                    if (this.readIf(40)) {
                        columnArray = this.readExpression();
                    }
                    this.addJoin(tableFilter, tableFilter3, false, (Expression)columnArray);
                } else if (this.readIf(30)) {
                    tableFilter3 = this.readTableFilter();
                    tableFilter = this.readJoin(tableFilter);
                    columnArray = null;
                    if (this.readIf(40)) {
                        columnArray = this.readExpression();
                    }
                    this.addJoin(tableFilter, tableFilter3, false, (Expression)columnArray);
                } else if (this.readIf(8)) {
                    this.read(30);
                    tableFilter3 = this.readTableFilter();
                    this.addJoin(tableFilter, tableFilter3, false, null);
                } else {
                    if (!this.readIf(36)) break;
                    this.read(30);
                    tableFilter3 = this.readTableFilter();
                    columnArray = tableFilter2.getTable().getColumns();
                    Column[] columnArray2 = tableFilter3.getTable().getColumns();
                    String string = tableFilter2.getTable().getSchema().getName();
                    String string2 = tableFilter3.getTable().getSchema().getName();
                    Condition condition = null;
                    for (Column column : columnArray) {
                        String string3 = column.getName();
                        for (Column column2 : columnArray2) {
                            String string4 = column2.getName();
                            if (!this.equalsToken(string3, string4)) continue;
                            tableFilter3.addNaturalJoinColumn(column2);
                            ExpressionColumn expressionColumn = new ExpressionColumn(this.database, string, tableFilter2.getTableAlias(), string3, false);
                            ExpressionColumn expressionColumn2 = new ExpressionColumn(this.database, string2, tableFilter3.getTableAlias(), string4, false);
                            Comparison comparison = new Comparison(this.session, 0, expressionColumn, expressionColumn2);
                            condition = condition == null ? comparison : new ConditionAndOr(0, condition, comparison);
                        }
                    }
                    this.addJoin(tableFilter, tableFilter3, false, condition);
                }
            }
            tableFilter2 = tableFilter3;
        }
        return tableFilter;
    }

    private void addJoin(TableFilter tableFilter, TableFilter tableFilter2, boolean bl, Expression expression) {
        if (tableFilter2.getJoin() != null) {
            String string = "SYSTEM_JOIN_" + this.parseIndex;
            TableFilter tableFilter3 = new TableFilter(this.session, this.getDualTable(true), string, this.rightsChecked, this.currentSelect, tableFilter2.getOrderInFrom(), null);
            tableFilter3.setNestedJoin(tableFilter2);
            tableFilter2 = tableFilter3;
        }
        tableFilter.addJoin(tableFilter2, bl, expression);
    }

    private Prepared parseExecute() {
        ExecuteProcedure executeProcedure = new ExecuteProcedure(this.session);
        String string = this.readAliasIdentifier();
        Procedure procedure = this.session.getProcedure(string);
        if (procedure == null) {
            throw DbException.get(90077, string);
        }
        executeProcedure.setProcedure(procedure);
        if (this.readIf(69)) {
            int n = 0;
            while (true) {
                executeProcedure.setExpression(n, this.readExpression());
                if (!this.readIfMore(true)) break;
                ++n;
            }
        }
        return executeProcedure;
    }

    private DeallocateProcedure parseDeallocate() {
        this.readIf("PLAN");
        String string = this.readAliasIdentifier();
        DeallocateProcedure deallocateProcedure = new DeallocateProcedure(this.session);
        deallocateProcedure.setProcedureName(string);
        return deallocateProcedure;
    }

    private Explain parseExplain() {
        Explain explain = new Explain(this.session);
        if (this.readIf("ANALYZE")) {
            explain.setExecuteCommand(true);
        } else if (this.readIf("PLAN")) {
            this.readIf(18);
        }
        switch (this.currentTokenType) {
            case 20: 
            case 47: 
            case 48: 
            case 52: 
            case 55: 
            case 69: {
                Query query = this.parseSelect();
                query.setNeverLazy(true);
                explain.setCommand(query);
                break;
            }
            default: {
                if (this.readIf("DELETE")) {
                    explain.setCommand(this.parseDelete());
                    break;
                }
                if (this.readIf("UPDATE")) {
                    explain.setCommand(this.parseUpdate());
                    break;
                }
                if (this.readIf("INSERT")) {
                    explain.setCommand(this.parseInsert());
                    break;
                }
                if (this.readIf("MERGE")) {
                    explain.setCommand(this.parseMerge());
                    break;
                }
                throw this.getSyntaxError();
            }
        }
        return explain;
    }

    private Query parseSelect() {
        int n = this.parameters.size();
        Query query = this.parseSelectUnion();
        int n2 = this.parameters.size();
        ArrayList<Parameter> arrayList = new ArrayList<Parameter>(n2);
        for (int i = n; i < n2; ++i) {
            arrayList.add(this.parameters.get(i));
        }
        query.setParameterList(arrayList);
        query.init();
        return query;
    }

    private Prepared parseWithStatementOrQuery() {
        int n = this.parameters.size();
        Prepared prepared = this.parseWith();
        int n2 = this.parameters.size();
        ArrayList<Parameter> arrayList = new ArrayList<Parameter>(n2);
        for (int i = n; i < n2; ++i) {
            arrayList.add(this.parameters.get(i));
        }
        prepared.setParameterList(arrayList);
        if (prepared instanceof Query) {
            Query query = (Query)prepared;
            query.init();
        }
        return prepared;
    }

    private Query parseSelectUnion() {
        int n = this.lastParseIndex;
        Query query = this.parseSelectSub();
        while (true) {
            SelectUnion.UnionType unionType;
            if (this.readIf(50)) {
                if (this.readIf(3)) {
                    unionType = SelectUnion.UnionType.UNION_ALL;
                } else {
                    this.readIf(13);
                    unionType = SelectUnion.UnionType.UNION;
                }
            } else if (this.readIf(14) || this.readIf(35)) {
                unionType = SelectUnion.UnionType.EXCEPT;
            } else {
                if (!this.readIf(26)) break;
                unionType = SelectUnion.UnionType.INTERSECT;
            }
            query = new SelectUnion(this.session, unionType, query, this.parseSelectSub());
        }
        this.parseEndOfQuery(query);
        this.setSQL(query, null, n);
        return query;
    }

    private void parseEndOfQuery(Query query) {
        Object object;
        Select select;
        if (this.readIf(41)) {
            this.read("BY");
            select = this.currentSelect;
            if (query instanceof Select) {
                this.currentSelect = (Select)query;
            }
            ArrayList<SelectOrderBy> arrayList = Utils.newSmallArrayList();
            do {
                boolean bl = !this.readIf(59);
                object = new SelectOrderBy();
                Expression expression = this.readExpression();
                if (bl && expression instanceof ValueExpression && expression.getType().getValueType() == 4) {
                    ((SelectOrderBy)object).columnIndexExpr = expression;
                } else if (expression instanceof Parameter) {
                    this.recompileAlways = true;
                    ((SelectOrderBy)object).columnIndexExpr = expression;
                } else {
                    ((SelectOrderBy)object).expression = expression;
                }
                ((SelectOrderBy)object).sortType = this.parseSortType();
                arrayList.add((SelectOrderBy)object);
            } while (this.readIf(73));
            query.setOrder(arrayList);
            this.currentSelect = select;
        }
        if (query.getLimit() == null) {
            select = this.currentSelect;
            this.currentSelect = null;
            boolean bl = false;
            if (this.readIf(39)) {
                bl = true;
                query.setOffset(this.readExpression().optimize(this.session));
                if (!this.readIf(44)) {
                    this.readIf("ROWS");
                }
            }
            if (this.readIf(17)) {
                bl = true;
                if (!this.readIf("FIRST")) {
                    this.read("NEXT");
                }
                if (this.readIf(44) || this.readIf("ROWS")) {
                    query.setLimit(ValueExpression.get(ValueInt.get(1)));
                } else {
                    Expression expression = this.readExpression().optimize(this.session);
                    query.setLimit(expression);
                    if (this.readIf("PERCENT")) {
                        query.setFetchPercent(true);
                    }
                    if (!this.readIf(44)) {
                        this.read("ROWS");
                    }
                }
                if (this.readIf(55)) {
                    this.read("TIES");
                    query.setWithTies(true);
                } else {
                    this.read("ONLY");
                }
            }
            if (!bl && this.readIf(32)) {
                Expression expression = this.readExpression().optimize(this.session);
                query.setLimit(expression);
                if (this.readIf(39)) {
                    object = this.readExpression().optimize(this.session);
                    query.setOffset((Expression)object);
                } else if (this.readIf(73)) {
                    object = expression;
                    expression = this.readExpression().optimize(this.session);
                    query.setOffset((Expression)object);
                    query.setLimit(expression);
                }
            }
            if (this.readIf("SAMPLE_SIZE")) {
                Expression expression = this.readExpression().optimize(this.session);
                query.setSampleSize(expression);
            }
            this.currentSelect = select;
        }
        if (this.readIf(18)) {
            if (this.readIf("UPDATE")) {
                if (this.readIf("OF")) {
                    do {
                        this.readIdentifierWithSchema();
                    } while (this.readIf(73));
                } else if (this.readIf("NOWAIT")) {
                    // empty if block
                }
                query.setForUpdate(true);
            } else if (this.readIf("READ") || this.readIf(17)) {
                this.read("ONLY");
            }
        }
        if (this.database.getMode().isolationLevelInSelectOrInsertStatement) {
            this.parseIsolationClause();
        }
    }

    private void parseIsolationClause() {
        if (this.readIf(55)) {
            if (this.readIf("RR") || this.readIf("RS")) {
                if (this.readIf("USE")) {
                    this.read("AND");
                    this.read("KEEP");
                    if (this.readIf("SHARE") || this.readIf("UPDATE") || this.readIf("EXCLUSIVE")) {
                        // empty if block
                    }
                    this.read("LOCKS");
                }
            } else if (this.readIf("CS") || this.readIf("UR")) {
                // empty if block
            }
        }
    }

    private Query parseSelectSub() {
        if (this.readIf(69)) {
            Query query = this.parseSelectUnion();
            this.read(70);
            return query;
        }
        if (this.readIf(55)) {
            Query query;
            try {
                query = (Query)this.parseWith();
            }
            catch (ClassCastException classCastException) {
                throw DbException.get(42000, "WITH statement supports only SELECT (query) in this context");
            }
            query.setNeverLazy(true);
            return query;
        }
        return this.parseSelectSimple();
    }

    private void parseSelectSimpleFromPart(Select select) {
        do {
            TableFilter tableFilter = this.readTableFilter();
            this.parseJoinTableFilter(tableFilter, select);
        } while (this.readIf(73));
        if (this.session.isForceJoinOrder()) {
            Collections.sort(select.getTopFilters(), TABLE_FILTER_COMPARATOR);
        }
    }

    private void parseJoinTableFilter(TableFilter tableFilter, final Select select) {
        tableFilter = this.readJoin(tableFilter);
        select.addTableFilter(tableFilter, true);
        boolean bl = false;
        while (true) {
            TableFilter tableFilter2;
            TableFilter tableFilter3;
            if ((tableFilter3 = tableFilter.getNestedJoin()) != null) {
                tableFilter3.visit(new TableFilter.TableFilterVisitor(){

                    @Override
                    public void accept(TableFilter tableFilter) {
                        select.addTableFilter(tableFilter, false);
                    }
                });
            }
            if ((tableFilter2 = tableFilter.getJoin()) == null) break;
            if (bl |= tableFilter2.isJoinOuter()) {
                select.addTableFilter(tableFilter2, false);
            } else {
                Expression expression = tableFilter2.getJoinCondition();
                if (expression != null) {
                    select.addCondition(expression);
                }
                tableFilter2.removeJoinCondition();
                tableFilter.removeJoin();
                select.addTableFilter(tableFilter2, true);
            }
            tableFilter = tableFilter2;
        }
    }

    private void parseSelectSimpleSelectPart(Select select) {
        Expression expression;
        ArrayList<Expression> arrayList;
        Select select2 = this.currentSelect;
        this.currentSelect = null;
        if (this.readIf("TOP")) {
            arrayList = this.readTerm().optimize(this.session);
            select.setLimit((Expression)((Object)arrayList));
            if (this.readIf("PERCENT")) {
                select.setFetchPercent(true);
            }
            if (this.readIf(55)) {
                this.read("TIES");
                select.setWithTies(true);
            }
        } else if (this.readIf(32)) {
            arrayList = this.readTerm().optimize(this.session);
            select.setOffset((Expression)((Object)arrayList));
            expression = this.readTerm().optimize(this.session);
            select.setLimit(expression);
        }
        this.currentSelect = select2;
        if (this.readIf(13)) {
            if (this.readIf(40)) {
                this.read(69);
                arrayList = Utils.newSmallArrayList();
                do {
                    arrayList.add(this.readExpression());
                } while (this.readIfMore(true));
                select.setDistinct(arrayList.toArray(new Expression[0]));
            } else {
                select.setDistinct();
            }
        } else {
            this.readIf(3);
        }
        arrayList = Utils.newSmallArrayList();
        do {
            if (this.readIf(72)) {
                arrayList.add(this.parseWildcard(null, null));
                continue;
            }
            expression = this.readExpression();
            if (this.readIf("AS") || this.currentTokenType == 2) {
                String string = this.readAliasIdentifier();
                boolean bl = this.database.getSettings().aliasColumnName;
                expression = new Alias(expression, string, bl |= this.database.getMode().aliasColumnName);
            }
            arrayList.add(expression);
        } while (this.readIf(73));
        select.setExpressions(arrayList);
    }

    private Select parseSelectSimple() {
        Object object;
        Object object2;
        boolean bl;
        if (this.readIf(47)) {
            bl = false;
        } else if (this.readIf(20)) {
            bl = true;
        } else {
            if (this.readIf(48)) {
                int n = this.lastParseIndex;
                Table table = this.readTableOrView();
                Select select = new Select(this.session, this.currentSelect);
                TableFilter tableFilter = new TableFilter(this.session, table, null, this.rightsChecked, select, this.orderInFrom++, null);
                select.addTableFilter(tableFilter, true);
                ArrayList<Expression> arrayList = new ArrayList<Expression>();
                arrayList.add(new Wildcard(null, null));
                select.setExpressions(arrayList);
                this.setSQL(select, "TABLE", n);
                return select;
            }
            if (this.readIf(52)) {
                return this.parseValues();
            }
            throw this.getSyntaxError();
        }
        Select select = new Select(this.session, this.currentSelect);
        int n = this.lastParseIndex;
        Select select2 = this.currentSelect;
        Prepared prepared = this.currentPrepared;
        this.currentSelect = select;
        this.currentPrepared = select;
        if (bl) {
            this.parseSelectSimpleFromPart(select);
            this.read(47);
            this.parseSelectSimpleSelectPart(select);
        } else {
            this.parseSelectSimpleSelectPart(select);
            if (!this.readIf(20)) {
                object2 = this.getDualTable(false);
                object = new TableFilter(this.session, (Table)object2, null, this.rightsChecked, this.currentSelect, 0, null);
                select.addTableFilter((TableFilter)object, true);
            } else {
                this.parseSelectSimpleFromPart(select);
            }
        }
        if (this.readIf(53)) {
            object2 = this.readExpression();
            select.addCondition((Expression)object2);
        }
        this.currentSelect = select2;
        if (this.readIf(22)) {
            this.read("BY");
            select.setGroupQuery();
            object2 = Utils.newSmallArrayList();
            do {
                object = this.readExpression();
                ((ArrayList)object2).add(object);
            } while (this.readIf(73));
            select.setGroupBy((ArrayList<Expression>)object2);
        }
        this.currentSelect = select;
        if (this.readIf(23)) {
            select.setGroupQuery();
            object2 = this.readExpression();
            select.setHaving((Expression)object2);
        }
        if (this.readIf(54)) {
            do {
                int n2 = this.parseIndex;
                object = this.readAliasIdentifier();
                this.read("AS");
                Window window = this.readWindowSpecification();
                if (this.currentSelect.addWindow((String)object, window)) continue;
                throw DbException.getSyntaxError(this.sqlCommand, n2, "unique identifier");
            } while (this.readIf(73));
        }
        if (this.readIf(43)) {
            select.setWindowQuery();
            Expression expression = this.readExpression();
            select.setQualify(expression);
        }
        select.setParameterList(this.parameters);
        this.currentSelect = select2;
        this.currentPrepared = prepared;
        this.setSQL(select, "SELECT", n);
        return select;
    }

    private Table getDualTable(boolean bl) {
        Schema schema = this.database.getMainSchema();
        ValueExpression valueExpression = ValueExpression.get(ValueLong.get(1L));
        return new RangeTable(schema, valueExpression, valueExpression, bl);
    }

    private void setSQL(Prepared prepared, String string, int n) {
        String string2;
        int n2 = this.lastParseIndex;
        if (string != null) {
            StringBuilder stringBuilder = new StringBuilder(string.length() + n2 - n + 1).append(string).append(' ');
            string2 = StringUtils.trimSubstring(stringBuilder, this.originalSQL, n, n2).toString();
        } else {
            string2 = StringUtils.trimSubstring(this.originalSQL, n, n2);
        }
        prepared.setSQL(string2);
    }

    private Expression readExpressionOrDefault() {
        if (this.readIf("DEFAULT")) {
            return ValueExpression.getDefault();
        }
        return this.readExpression();
    }

    private Expression readExpression() {
        Expression expression = this.readAnd();
        while (this.readIf("OR")) {
            expression = new ConditionAndOr(1, expression, this.readAnd());
        }
        return expression;
    }

    private Expression readAnd() {
        Expression expression = this.readCondition();
        while (this.readIf("AND")) {
            expression = new ConditionAndOr(0, expression, this.readCondition());
        }
        return expression;
    }

    private Expression readCondition() {
        if (this.readIf(37)) {
            return new ConditionNot(this.readCondition());
        }
        if (this.readIf(15)) {
            this.read(69);
            Query query = this.parseSelect();
            this.read(70);
            return new ConditionExists(query);
        }
        if (this.readIf(27)) {
            this.read(69);
            Expression expression = this.readConcat();
            this.read(73);
            Expression expression2 = this.readConcat();
            this.read(70);
            return new Comparison(this.session, 11, expression, expression2);
        }
        Expression expression = this.readConcat();
        while (true) {
            Object object;
            Object object2;
            int n = this.parseIndex;
            boolean bl = this.readIf(37);
            if (bl && this.isToken(38)) {
                this.parseIndex = n;
                this.currentToken = "NOT";
                this.currentTokenType = 37;
                break;
            }
            if (this.readIf(31)) {
                Expression expression3 = this.readConcat();
                Expression expression4 = null;
                if (this.readIf("ESCAPE")) {
                    expression4 = this.readConcat();
                }
                this.recompileAlways = true;
                expression = new CompareLike(this.database, expression, expression3, expression4, false);
            } else if (this.readIf("ILIKE")) {
                Function function = Function.getFunction(this.database, "CAST");
                function.setDataType(new Column("X", 14));
                function.setParameter(0, expression);
                expression = function;
                Expression expression5 = this.readConcat();
                object2 = null;
                if (this.readIf("ESCAPE")) {
                    object2 = this.readConcat();
                }
                this.recompileAlways = true;
                expression = new CompareLike(this.database, expression, expression5, (Expression)object2, false);
            } else if (this.readIf("REGEXP")) {
                Expression expression6 = this.readConcat();
                this.recompileAlways = true;
                expression = new CompareLike(this.database, expression, expression6, null, true);
            } else if (this.readIf(29)) {
                if (this.readIf(37)) {
                    if (this.readIf(38)) {
                        expression = new Comparison(this.session, 7, expression, null);
                    } else if (this.readIf(13)) {
                        this.read(20);
                        expression = new Comparison(this.session, 16, expression, this.readConcat());
                    } else {
                        expression = new Comparison(this.session, 21, expression, this.readConcat());
                    }
                } else if (this.readIf(38)) {
                    expression = new Comparison(this.session, 6, expression, null);
                } else if (this.readIf(13)) {
                    this.read(20);
                    expression = new Comparison(this.session, 21, expression, this.readConcat());
                } else {
                    expression = new Comparison(this.session, 16, expression, this.readConcat());
                }
            } else if (this.readIf("IN")) {
                this.read(69);
                if (this.readIf(70)) {
                    if (this.database.getMode().prohibitEmptyInPredicate) {
                        throw this.getSyntaxError();
                    }
                    expression = ValueExpression.get(ValueBoolean.FALSE);
                } else {
                    Object object3;
                    if (this.isSelect()) {
                        object3 = this.parseSelect();
                        expression = new ConditionInSelect(this.database, expression, (Query)object3, false, 0);
                    } else {
                        Expression expression7;
                        object3 = Utils.newSmallArrayList();
                        do {
                            expression7 = this.readExpression();
                            ((ArrayList)object3).add(expression7);
                        } while (this.readIf(73));
                        if (((ArrayList)object3).size() == 1 && expression7 instanceof Subquery) {
                            object2 = (Subquery)expression7;
                            object = ((Subquery)object2).getQuery();
                            expression = new ConditionInSelect(this.database, expression, (Query)object, false, 0);
                        } else {
                            expression = new ConditionIn(this.database, expression, (ArrayList<Expression>)object3);
                        }
                    }
                    this.read(70);
                }
            } else if (this.readIf("BETWEEN")) {
                Expression expression8 = this.readConcat();
                this.read("AND");
                Expression expression9 = this.readConcat();
                object2 = new Comparison(this.session, 3, expression8, expression);
                object = new Comparison(this.session, 1, expression9, expression);
                expression = new ConditionAndOr(0, (Expression)object2, (Expression)object);
            } else {
                if (bl) {
                    throw this.getSyntaxError();
                }
                int n2 = Parser.getCompareType(this.currentTokenType);
                if (n2 < 0) break;
                this.read();
                int n3 = this.lastParseIndex;
                if (this.readIf(3)) {
                    this.read(69);
                    if (this.isSelect()) {
                        object2 = this.parseSelect();
                        expression = new ConditionInSelect(this.database, expression, (Query)object2, true, n2);
                        this.read(70);
                    } else {
                        this.parseIndex = n3;
                        this.read();
                        expression = new Comparison(this.session, n2, expression, this.readConcat());
                    }
                } else if (this.readIf("ANY") || this.readIf("SOME")) {
                    this.read(69);
                    if (this.currentTokenType == 56 && n2 == 0) {
                        object2 = this.readParameter();
                        expression = new ConditionInParameter(this.database, expression, (Parameter)object2);
                        this.read(70);
                    } else if (this.isSelect()) {
                        object2 = this.parseSelect();
                        expression = new ConditionInSelect(this.database, expression, (Query)object2, false, n2);
                        this.read(70);
                    } else {
                        this.parseIndex = n3;
                        this.read();
                        expression = new Comparison(this.session, n2, expression, this.readConcat());
                    }
                } else {
                    expression = new Comparison(this.session, n2, expression, this.readConcat());
                }
            }
            if (!bl) continue;
            expression = new ConditionNot(expression);
        }
        return expression;
    }

    private Expression readConcat() {
        Expression expression = this.readSum();
        while (true) {
            Function function;
            if (this.readIf(68)) {
                expression = new BinaryOperation(BinaryOperation.OpType.CONCAT, expression, this.readSum());
                continue;
            }
            if (this.readIf(83)) {
                if (this.readIf(72)) {
                    function = Function.getFunction(this.database, "CAST");
                    function.setDataType(new Column("X", 14));
                    function.setParameter(0, expression);
                    expression = function;
                }
                expression = new CompareLike(this.database, expression, this.readSum(), null, true);
                continue;
            }
            if (!this.readIf(86)) break;
            if (this.readIf(72)) {
                function = Function.getFunction(this.database, "CAST");
                function.setDataType(new Column("X", 14));
                function.setParameter(0, expression);
                expression = function;
            }
            expression = new ConditionNot(new CompareLike(this.database, expression, this.readSum(), null, true));
        }
        return expression;
    }

    private Expression readSum() {
        Expression expression = this.readFactor();
        while (true) {
            if (this.readIf(67)) {
                expression = new BinaryOperation(BinaryOperation.OpType.PLUS, expression, this.readFactor());
                continue;
            }
            if (!this.readIf(66)) break;
            expression = new BinaryOperation(BinaryOperation.OpType.MINUS, expression, this.readFactor());
        }
        return expression;
    }

    private Expression readFactor() {
        Expression expression = this.readTerm();
        while (true) {
            if (this.readIf(72)) {
                expression = new BinaryOperation(BinaryOperation.OpType.MULTIPLY, expression, this.readTerm());
                continue;
            }
            if (this.readIf(77)) {
                expression = new BinaryOperation(BinaryOperation.OpType.DIVIDE, expression, this.readTerm());
                continue;
            }
            if (!this.readIf(78)) break;
            expression = new BinaryOperation(BinaryOperation.OpType.MODULUS, expression, this.readTerm());
        }
        return expression;
    }

    private Expression readAggregate(AggregateType aggregateType, String string) {
        Aggregate aggregate;
        if (this.currentSelect == null) {
            throw this.getSyntaxError();
        }
        switch (aggregateType) {
            case COUNT: {
                if (this.readIf(72)) {
                    aggregate = new Aggregate(AggregateType.COUNT_ALL, new Expression[0], this.currentSelect, false);
                    break;
                }
                boolean bl = this.readDistinctAgg();
                Expression expression = this.readExpression();
                if (expression instanceof Wildcard && !bl) {
                    aggregate = new Aggregate(AggregateType.COUNT_ALL, new Expression[0], this.currentSelect, false);
                    break;
                }
                aggregate = new Aggregate(AggregateType.COUNT, new Expression[]{expression}, this.currentSelect, bl);
                break;
            }
            case LISTAGG: {
                Expression[] expressionArray;
                boolean bl = this.readDistinctAgg();
                Expression expression = this.readExpression();
                Expression expression2 = null;
                ArrayList<SelectOrderBy> arrayList = null;
                if (this.equalsToken("STRING_AGG", string)) {
                    this.read(73);
                    expression2 = this.readExpression();
                    if (this.readIf(41)) {
                        this.read("BY");
                        arrayList = this.parseSimpleOrderList();
                    }
                } else if (this.equalsToken("GROUP_CONCAT", string)) {
                    if (this.readIf(41)) {
                        this.read("BY");
                        arrayList = this.parseSimpleOrderList();
                    }
                    if (this.readIf("SEPARATOR")) {
                        expression2 = this.readExpression();
                    }
                } else {
                    if (this.readIf(73)) {
                        expression2 = this.readExpression();
                    }
                    if (this.readIf(40)) {
                        this.read("OVERFLOW");
                        this.read("ERROR");
                    }
                }
                if (expression2 == null) {
                    Expression[] expressionArray2 = new Expression[1];
                    expressionArray = expressionArray2;
                    expressionArray2[0] = expression;
                } else {
                    Expression[] expressionArray3 = new Expression[2];
                    expressionArray3[0] = expression;
                    expressionArray = expressionArray3;
                    expressionArray3[1] = expression2;
                }
                Expression[] expressionArray4 = expressionArray;
                int n = this.lastParseIndex;
                this.read(70);
                if (arrayList == null && this.isToken("WITHIN")) {
                    aggregate = this.readWithinGroup(aggregateType, expressionArray4, bl, false);
                    break;
                }
                this.parseIndex = n;
                this.read();
                aggregate = new Aggregate(AggregateType.LISTAGG, expressionArray4, this.currentSelect, bl);
                if (arrayList == null) break;
                aggregate.setOrderByList(arrayList);
                break;
            }
            case ARRAY_AGG: {
                boolean bl = this.readDistinctAgg();
                aggregate = new Aggregate(AggregateType.ARRAY_AGG, new Expression[]{this.readExpression()}, this.currentSelect, bl);
                if (!this.readIf(41)) break;
                this.read("BY");
                aggregate.setOrderByList(this.parseSimpleOrderList());
                break;
            }
            case RANK: 
            case DENSE_RANK: 
            case PERCENT_RANK: 
            case CUME_DIST: {
                if (this.isToken(70)) {
                    return this.readWindowFunction(string);
                }
                ArrayList<Expression> arrayList = Utils.newSmallArrayList();
                do {
                    arrayList.add(this.readExpression());
                } while (this.readIfMore(true));
                aggregate = this.readWithinGroup(aggregateType, arrayList.toArray(new Expression[0]), false, true);
                break;
            }
            case PERCENTILE_CONT: 
            case PERCENTILE_DISC: {
                Expression expression = this.readExpression();
                this.read(70);
                aggregate = this.readWithinGroup(aggregateType, new Expression[]{expression}, false, false);
                break;
            }
            case MODE: {
                if (this.readIf(70)) {
                    aggregate = this.readWithinGroup(AggregateType.MODE, new Expression[0], false, false);
                    break;
                }
                Expression expression = this.readExpression();
                aggregate = new Aggregate(aggregateType, new Expression[0], this.currentSelect, false);
                if (this.readIf(41)) {
                    this.read("BY");
                    Expression expression3 = this.readExpression();
                    String string2 = expression.getSQL(true);
                    String string3 = expression3.getSQL(true);
                    if (!string2.equals(string3)) {
                        throw DbException.getSyntaxError(42131, this.sqlCommand, this.lastParseIndex, string2, string3);
                    }
                    this.readAggregateOrder(aggregate, expression, true);
                    break;
                }
                this.readAggregateOrder(aggregate, expression, false);
                break;
            }
            default: {
                boolean bl = this.readDistinctAgg();
                aggregate = new Aggregate(aggregateType, new Expression[]{this.readExpression()}, this.currentSelect, bl);
            }
        }
        this.read(70);
        this.readFilterAndOver(aggregate);
        return aggregate;
    }

    private Aggregate readWithinGroup(AggregateType aggregateType, Expression[] expressionArray, boolean bl, boolean bl2) {
        this.read("WITHIN");
        this.read(22);
        this.read(69);
        this.read(41);
        this.read("BY");
        Aggregate aggregate = new Aggregate(aggregateType, expressionArray, this.currentSelect, bl);
        if (bl2) {
            int n = expressionArray.length;
            ArrayList<SelectOrderBy> arrayList = new ArrayList<SelectOrderBy>(n);
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    this.read(73);
                }
                SelectOrderBy selectOrderBy = new SelectOrderBy();
                selectOrderBy.expression = this.readExpression();
                selectOrderBy.sortType = this.parseSimpleSortType();
                arrayList.add(selectOrderBy);
            }
            aggregate.setOrderByList(arrayList);
        } else {
            this.readAggregateOrder(aggregate, this.readExpression(), true);
        }
        return aggregate;
    }

    private void readAggregateOrder(Aggregate aggregate, Expression expression, boolean bl) {
        ArrayList<SelectOrderBy> arrayList = new ArrayList<SelectOrderBy>(1);
        SelectOrderBy selectOrderBy = new SelectOrderBy();
        selectOrderBy.expression = expression;
        if (bl) {
            selectOrderBy.sortType = this.parseSimpleSortType();
        }
        arrayList.add(selectOrderBy);
        aggregate.setOrderByList(arrayList);
    }

    private ArrayList<SelectOrderBy> parseSimpleOrderList() {
        ArrayList<SelectOrderBy> arrayList = Utils.newSmallArrayList();
        do {
            SelectOrderBy selectOrderBy = new SelectOrderBy();
            selectOrderBy.expression = this.readExpression();
            selectOrderBy.sortType = this.parseSortType();
            arrayList.add(selectOrderBy);
        } while (this.readIf(73));
        return arrayList;
    }

    private JavaFunction readJavaFunction(Schema schema, String string, boolean bl) {
        FunctionAlias functionAlias = schema != null ? schema.findFunction(string) : this.findFunctionAlias(this.session.getCurrentSchemaName(), string);
        if (functionAlias == null) {
            if (bl) {
                throw DbException.get(90022, string);
            }
            return null;
        }
        ArrayList<Expression> arrayList = Utils.newSmallArrayList();
        if (!this.readIf(70)) {
            do {
                arrayList.add(this.readExpression());
            } while (this.readIfMore(true));
        }
        Expression[] expressionArray = arrayList.toArray(new Expression[0]);
        return new JavaFunction(functionAlias, expressionArray);
    }

    private JavaAggregate readJavaAggregate(UserAggregate userAggregate) {
        boolean bl = this.readDistinctAgg();
        ArrayList<Expression> arrayList = Utils.newSmallArrayList();
        do {
            arrayList.add(this.readExpression());
        } while (this.readIfMore(true));
        Expression[] expressionArray = arrayList.toArray(new Expression[0]);
        JavaAggregate javaAggregate = new JavaAggregate(userAggregate, expressionArray, this.currentSelect, bl);
        this.readFilterAndOver(javaAggregate);
        return javaAggregate;
    }

    private boolean readDistinctAgg() {
        if (this.readIf(13)) {
            return true;
        }
        this.readIf(3);
        return false;
    }

    private void readFilterAndOver(AbstractAggregate abstractAggregate) {
        if (this.readIf("FILTER")) {
            this.read(69);
            this.read(53);
            Expression expression = this.readExpression();
            this.read(70);
            abstractAggregate.setFilterCondition(expression);
        }
        this.readOver(abstractAggregate);
    }

    private void readOver(DataAnalysisOperation dataAnalysisOperation) {
        if (this.readIf("OVER")) {
            dataAnalysisOperation.setOverCondition(this.readWindowNameOrSpecification());
            this.currentSelect.setWindowQuery();
        } else if (dataAnalysisOperation.isAggregate()) {
            this.currentSelect.setGroupQuery();
        } else {
            throw this.getSyntaxError();
        }
    }

    private Window readWindowNameOrSpecification() {
        return this.isToken(69) ? this.readWindowSpecification() : new Window(this.readAliasIdentifier(), null, null, null);
    }

    private Window readWindowSpecification() {
        Object object;
        Object object2;
        this.read(69);
        String string = null;
        if (this.currentTokenType == 2) {
            object2 = this.currentToken;
            if (this.currentTokenQuoted || !this.equalsToken((String)object2, "PARTITION") && !this.equalsToken((String)object2, "ROWS") && !this.equalsToken((String)object2, "RANGE") && !this.equalsToken((String)object2, "GROUPS")) {
                string = object2;
                this.read();
            }
        }
        object2 = null;
        if (this.readIf("PARTITION")) {
            this.read("BY");
            object2 = Utils.newSmallArrayList();
            do {
                object = this.readExpression();
                ((ArrayList)object2).add(object);
            } while (this.readIf(73));
        }
        object = null;
        if (this.readIf(41)) {
            this.read("BY");
            object = this.parseSimpleOrderList();
        }
        WindowFrame windowFrame = this.readWindowFrame();
        this.read(70);
        return new Window(string, (ArrayList<Expression>)object2, (ArrayList<SelectOrderBy>)object, windowFrame);
    }

    private WindowFrame readWindowFrame() {
        WindowFrame windowFrame;
        WindowFrameBound windowFrameBound;
        WindowFrameBound windowFrameBound2;
        WindowFrameUnits windowFrameUnits;
        if (this.readIf("ROWS")) {
            windowFrameUnits = WindowFrameUnits.ROWS;
        } else if (this.readIf("RANGE")) {
            windowFrameUnits = WindowFrameUnits.RANGE;
        } else if (this.readIf("GROUPS")) {
            windowFrameUnits = WindowFrameUnits.GROUPS;
        } else {
            return null;
        }
        if (this.readIf("BETWEEN")) {
            windowFrameBound2 = this.readWindowFrameRange();
            this.read("AND");
            windowFrameBound = this.readWindowFrameRange();
        } else {
            windowFrameBound2 = this.readWindowFrameStarting();
            windowFrameBound = null;
        }
        int n = this.lastParseIndex;
        WindowFrameExclusion windowFrameExclusion = WindowFrameExclusion.EXCLUDE_NO_OTHERS;
        if (this.readIf("EXCLUDE")) {
            if (this.readIf("CURRENT")) {
                this.read(44);
                windowFrameExclusion = WindowFrameExclusion.EXCLUDE_CURRENT_ROW;
            } else if (this.readIf(22)) {
                windowFrameExclusion = WindowFrameExclusion.EXCLUDE_GROUP;
            } else if (this.readIf("TIES")) {
                windowFrameExclusion = WindowFrameExclusion.EXCLUDE_TIES;
            } else {
                this.read("NO");
                this.read("OTHERS");
            }
        }
        if (!(windowFrame = new WindowFrame(windowFrameUnits, windowFrameBound2, windowFrameBound, windowFrameExclusion)).isValid()) {
            throw DbException.getSyntaxError(this.sqlCommand, n);
        }
        return windowFrame;
    }

    private WindowFrameBound readWindowFrameStarting() {
        if (this.readIf("UNBOUNDED")) {
            this.read("PRECEDING");
            return new WindowFrameBound(WindowFrameBoundType.UNBOUNDED_PRECEDING, null);
        }
        if (this.readIf("CURRENT")) {
            this.read(44);
            return new WindowFrameBound(WindowFrameBoundType.CURRENT_ROW, null);
        }
        Expression expression = this.readExpression();
        this.read("PRECEDING");
        return new WindowFrameBound(WindowFrameBoundType.PRECEDING, expression);
    }

    private WindowFrameBound readWindowFrameRange() {
        if (this.readIf("UNBOUNDED")) {
            if (this.readIf("PRECEDING")) {
                return new WindowFrameBound(WindowFrameBoundType.UNBOUNDED_PRECEDING, null);
            }
            this.read("FOLLOWING");
            return new WindowFrameBound(WindowFrameBoundType.UNBOUNDED_FOLLOWING, null);
        }
        if (this.readIf("CURRENT")) {
            this.read(44);
            return new WindowFrameBound(WindowFrameBoundType.CURRENT_ROW, null);
        }
        Expression expression = this.readExpression();
        if (this.readIf("PRECEDING")) {
            return new WindowFrameBound(WindowFrameBoundType.PRECEDING, expression);
        }
        this.read("FOLLOWING");
        return new WindowFrameBound(WindowFrameBoundType.FOLLOWING, expression);
    }

    private AggregateType getAggregateType(String string) {
        if (!this.identifiersToUpper) {
            string = StringUtils.toUpperEnglish(string);
        }
        return Aggregate.getAggregateType(string);
    }

    private Expression readFunction(Schema schema, String string) {
        Object object;
        if (schema != null) {
            return this.readJavaFunction(schema, string, true);
        }
        boolean bl = this.database.isAllowBuiltinAliasOverride();
        if (bl && (object = this.readJavaFunction(null, string, false)) != null) {
            return object;
        }
        object = this.getAggregateType(string);
        if (object != null) {
            return this.readAggregate((AggregateType)((Object)object), string);
        }
        Function function = Function.getFunction(this.database, string);
        if (function == null) {
            WindowFunction windowFunction = this.readWindowFunction(string);
            if (windowFunction != null) {
                return windowFunction;
            }
            UserAggregate userAggregate = this.database.findAggregate(string);
            if (userAggregate != null) {
                return this.readJavaAggregate(userAggregate);
            }
            if (bl) {
                throw DbException.get(90022, string);
            }
            return this.readJavaFunction(null, string, true);
        }
        switch (function.getFunctionType()) {
            case 203: {
                function.setParameter(0, this.readExpression());
                this.read("AS");
                Column column = this.parseColumnWithType(null, false);
                function.setDataType(column);
                this.read(70);
                break;
            }
            case 202: {
                if (this.database.getMode().swapConvertFunctionParameters) {
                    Column column = this.parseColumnWithType(null, false);
                    function.setDataType(column);
                    this.read(73);
                    function.setParameter(0, this.readExpression());
                    this.read(70);
                    break;
                }
                function.setParameter(0, this.readExpression());
                this.read(73);
                Column column = this.parseColumnWithType(null, false);
                function.setDataType(column);
                this.read(70);
                break;
            }
            case 119: {
                function.setParameter(0, ValueExpression.get(ValueString.get(this.currentToken)));
                this.read();
                this.read(20);
                function.setParameter(1, this.readExpression());
                this.read(70);
                break;
            }
            case 105: 
            case 106: {
                if (this.currentTokenType == 58) {
                    function.setParameter(0, ValueExpression.get(this.currentValue.convertTo(13)));
                } else {
                    function.setParameter(0, ValueExpression.get(ValueString.get(this.currentToken)));
                }
                this.read();
                this.read(73);
                function.setParameter(1, this.readExpression());
                this.read(73);
                function.setParameter(2, this.readExpression());
                this.read(70);
                break;
            }
            case 73: {
                function.setParameter(0, this.readExpression());
                if (this.readIf(20)) {
                    function.setParameter(1, this.readExpression());
                    if (this.readIf(18)) {
                        function.setParameter(2, this.readExpression());
                    }
                } else if (this.readIf(18)) {
                    function.setParameter(1, ValueExpression.get(ValueInt.get(0)));
                    function.setParameter(2, this.readExpression());
                } else {
                    this.read(73);
                    function.setParameter(1, this.readExpression());
                    if (this.readIf(73)) {
                        function.setParameter(2, this.readExpression());
                    }
                }
                this.read(70);
                break;
            }
            case 77: {
                function.setParameter(0, this.readConcat());
                if (!this.readIf(73)) {
                    this.read("IN");
                }
                function.setParameter(1, this.readExpression());
                this.read(70);
                break;
            }
            case 78: {
                Expression expression;
                int n;
                boolean bl2 = false;
                if (this.readIf("LEADING")) {
                    n = 1;
                    bl2 = true;
                } else if (this.readIf("TRAILING")) {
                    n = 2;
                    bl2 = true;
                } else {
                    bl2 = this.readIf("BOTH");
                    n = 3;
                }
                Expression expression2 = null;
                function.setFlags(n);
                if (bl2) {
                    if (!this.readIf(20)) {
                        expression2 = this.readExpression();
                        this.read(20);
                    }
                    expression = this.readExpression();
                } else if (this.readIf(20)) {
                    expression = this.readExpression();
                } else {
                    expression = this.readExpression();
                    if (this.readIf(20)) {
                        expression2 = expression;
                        expression = this.readExpression();
                    }
                }
                if (!bl2 && expression2 == null && this.readIf(73)) {
                    expression2 = this.readExpression();
                }
                function.setParameter(0, expression);
                if (expression2 != null) {
                    function.setParameter(1, expression2);
                }
                this.read(70);
                break;
            }
            case 223: 
            case 224: {
                Object object2;
                int n = 0;
                ArrayList<Column> arrayList = Utils.newSmallArrayList();
                do {
                    object2 = this.readAliasIdentifier();
                    Column column = this.parseColumnWithType((String)object2, false);
                    arrayList.add(column);
                    this.read(59);
                    function.setParameter(n, this.readExpression());
                    ++n;
                } while (this.readIfMore(true));
                object2 = (TableFunction)function;
                ((TableFunction)object2).setColumns(arrayList);
                break;
            }
            case 233: {
                ArrayList<Column> arrayList = Utils.newSmallArrayList();
                if (!this.readIf(70)) {
                    int n = 0;
                    do {
                        function.setParameter(n++, this.readExpression());
                        arrayList.add(new Column("C" + n, 0));
                    } while (this.readIfMore(true));
                }
                if (this.readIf(55)) {
                    this.read("ORDINALITY");
                    arrayList.add(new Column("NORD", 4));
                }
                TableFunction tableFunction = (TableFunction)function;
                tableFunction.setColumns(arrayList);
                break;
            }
            default: {
                if (this.readIf(70)) break;
                int n = 0;
                do {
                    function.setParameter(n++, this.readExpression());
                } while (this.readIfMore(true));
            }
        }
        function.doneWithParameters();
        return function;
    }

    private WindowFunction readWindowFunction(String string) {
        WindowFunctionType windowFunctionType;
        if (!this.identifiersToUpper) {
            string = StringUtils.toUpperEnglish(string);
        }
        if ((windowFunctionType = WindowFunctionType.get(string)) == null) {
            return null;
        }
        if (this.currentSelect == null) {
            throw this.getSyntaxError();
        }
        int n = WindowFunction.getMinArgumentCount(windowFunctionType);
        Expression[] expressionArray = null;
        if (n > 0) {
            int n2 = WindowFunction.getMaxArgumentCount(windowFunctionType);
            expressionArray = new Expression[n2];
            if (n == n2) {
                for (int i = 0; i < n; ++i) {
                    if (i > 0) {
                        this.read(73);
                    }
                    expressionArray[i] = this.readExpression();
                }
            } else {
                int n3;
                for (n3 = 0; n3 < n2 && (n3 <= 0 || this.readIf(73)); ++n3) {
                    expressionArray[n3] = this.readExpression();
                }
                if (n3 < n) {
                    throw this.getSyntaxError();
                }
                if (n3 != n2) {
                    expressionArray = Arrays.copyOf(expressionArray, n3);
                }
            }
        }
        this.read(70);
        WindowFunction windowFunction = new WindowFunction(windowFunctionType, this.currentSelect, expressionArray);
        if (windowFunctionType == WindowFunctionType.NTH_VALUE) {
            this.readFromFirstOrLast(windowFunction);
        }
        switch (windowFunctionType) {
            case LEAD: 
            case LAG: 
            case FIRST_VALUE: 
            case LAST_VALUE: 
            case NTH_VALUE: {
                this.readRespectOrIgnoreNulls(windowFunction);
            }
        }
        this.readOver(windowFunction);
        return windowFunction;
    }

    private void readFromFirstOrLast(WindowFunction windowFunction) {
        if (this.readIf(20) && !this.readIf("FIRST")) {
            this.read("LAST");
            windowFunction.setFromLast(true);
        }
    }

    private void readRespectOrIgnoreNulls(WindowFunction windowFunction) {
        if (this.readIf("RESPECT")) {
            this.read("NULLS");
        } else if (this.readIf("IGNORE")) {
            this.read("NULLS");
            windowFunction.setIgnoreNulls(true);
        }
    }

    private Expression readKeywordFunction(String string) {
        if (this.readIf(69)) {
            return this.readFunction(null, string);
        }
        return this.readFunctionWithoutParameters(string);
    }

    private Expression readFunctionWithoutParameters(String string) {
        Object object;
        if (this.database.isAllowBuiltinAliasOverride() && (object = this.database.getSchema(this.session.getCurrentSchemaName()).findFunction(string)) != null) {
            return new JavaFunction((FunctionAlias)object, new Expression[0]);
        }
        object = Function.getFunction(this.database, string);
        ((Function)object).doneWithParameters();
        return object;
    }

    private Expression readWildcardRowidOrSequenceValue(String string, String string2) {
        Sequence sequence;
        if (this.readIf(72)) {
            return this.parseWildcard(string, string2);
        }
        if (this.readIf(45)) {
            return new ExpressionColumn(this.database, string, string2, "_ROWID_", true);
        }
        if (string == null) {
            string = this.session.getCurrentSchemaName();
        }
        if (this.readIf("NEXTVAL")) {
            Sequence sequence2 = this.findSequence(string, string2);
            if (sequence2 != null) {
                return new SequenceValue(sequence2);
            }
        } else if (this.readIf("CURRVAL") && (sequence = this.findSequence(string, string2)) != null) {
            Function function = Function.getFunction(this.database, "CURRVAL");
            function.setParameter(0, ValueExpression.get(ValueString.get(sequence.getSchema().getName())));
            function.setParameter(1, ValueExpression.get(ValueString.get(sequence.getName())));
            function.doneWithParameters();
            return function;
        }
        return null;
    }

    private Wildcard parseWildcard(String string, String string2) {
        Wildcard wildcard = new Wildcard(string, string2);
        if (this.readIf(14)) {
            this.read(69);
            ArrayList<ExpressionColumn> arrayList = Utils.newSmallArrayList();
            do {
                String string3 = null;
                String string4 = null;
                String string5 = this.readColumnIdentifier();
                if (this.readIf(74)) {
                    string4 = string5;
                    string5 = this.readColumnIdentifier();
                    if (this.readIf(74)) {
                        string3 = string4;
                        string4 = string5;
                        string5 = this.readColumnIdentifier();
                        if (this.readIf(74)) {
                            if (!this.equalsToken(this.database.getShortName(), string3)) {
                                throw DbException.get(90013, string3);
                            }
                            string3 = string4;
                            string4 = string5;
                            string5 = this.readColumnIdentifier();
                        }
                    }
                }
                arrayList.add(new ExpressionColumn(this.database, string3, string4, string5, false));
            } while (this.readIfMore(true));
            wildcard.setExceptColumns(arrayList);
        }
        return wildcard;
    }

    private Expression readTermObjectDot(String string) {
        Expression expression = this.readWildcardRowidOrSequenceValue(null, string);
        if (expression != null) {
            return expression;
        }
        String string2 = this.readColumnIdentifier();
        Schema schema = this.database.findSchema(string);
        if (this.readIf(69)) {
            return this.readFunction(schema, string2);
        }
        if (this.readIf(74)) {
            String string3 = string;
            expression = this.readWildcardRowidOrSequenceValue(string3, string = string2);
            if (expression != null) {
                return expression;
            }
            string2 = this.readColumnIdentifier();
            if (this.readIf(69)) {
                String string4 = string3;
                if (!this.equalsToken(this.database.getShortName(), string4)) {
                    throw DbException.get(90013, string4);
                }
                string3 = string;
                return this.readFunction(this.database.getSchema(string3), string2);
            }
            if (this.readIf(74)) {
                String string5 = string3;
                if (!this.equalsToken(this.database.getShortName(), string5)) {
                    throw DbException.get(90013, string5);
                }
                string3 = string;
                expression = this.readWildcardRowidOrSequenceValue(string3, string = string2);
                if (expression != null) {
                    return expression;
                }
                string2 = this.readColumnIdentifier();
                return new ExpressionColumn(this.database, string3, string, string2, false);
            }
            return new ExpressionColumn(this.database, string3, string, string2, false);
        }
        return new ExpressionColumn(this.database, null, string, string2, false);
    }

    private Parameter readParameter() {
        Parameter parameter;
        boolean bl = Character.isDigit(this.sqlCommandChars[this.parseIndex]);
        if (bl) {
            int n;
            this.readParameterIndex();
            if (this.indexedParameterList == null) {
                if (this.parameters == null) {
                    throw this.getSyntaxError();
                }
                if (!this.parameters.isEmpty()) {
                    throw DbException.get(90123);
                }
                this.indexedParameterList = Utils.newSmallArrayList();
            }
            if ((n = this.currentValue.getInt() - 1) < 0 || n >= 100000) {
                throw DbException.getInvalidValueException("parameter index", n + 1);
            }
            if (this.indexedParameterList.size() <= n) {
                this.indexedParameterList.ensureCapacity(n + 1);
                while (this.indexedParameterList.size() <= n) {
                    this.indexedParameterList.add(null);
                }
            }
            if ((parameter = this.indexedParameterList.get(n)) == null) {
                parameter = new Parameter(n);
                this.indexedParameterList.set(n, parameter);
                this.parameters.add(parameter);
            }
            this.read();
        } else {
            this.read();
            if (this.indexedParameterList != null) {
                throw DbException.get(90123);
            }
            parameter = new Parameter(this.parameters.size());
            this.parameters.add(parameter);
        }
        return parameter;
    }

    private Expression readTerm() {
        Expression[] expressionArray;
        Object object;
        Object object2;
        switch (this.currentTokenType) {
            case 65: {
                this.read();
                object2 = new Variable(this.session, this.readAliasIdentifier());
                if (!this.readIf(85)) break;
                object = this.readExpression();
                expressionArray = Function.getFunction(this.database, "SET");
                expressionArray.setParameter(0, (Expression)object2);
                expressionArray.setParameter(1, (Expression)object);
                object2 = expressionArray;
                break;
            }
            case 56: {
                object2 = this.readParameter();
                break;
            }
            case 20: 
            case 47: 
            case 55: {
                object2 = new Subquery(this.parseSelect());
                break;
            }
            case 48: {
                int n = this.lastParseIndex;
                this.read();
                if (this.readIf(69)) {
                    object2 = this.readFunction(null, "TABLE");
                    break;
                }
                this.parseIndex = n;
                this.read();
                object2 = new Subquery(this.parseSelect());
                break;
            }
            case 2: {
                expressionArray = this.currentToken;
                if (this.currentTokenQuoted) {
                    this.read();
                    if (this.readIf(69)) {
                        object2 = this.readFunction(null, (String)expressionArray);
                        break;
                    }
                    if (this.readIf(74)) {
                        object2 = this.readTermObjectDot((String)expressionArray);
                        break;
                    }
                    object2 = new ExpressionColumn(this.database, null, null, (String)expressionArray, false);
                    break;
                }
                this.read();
                if (this.readIf(74)) {
                    object2 = this.readTermObjectDot((String)expressionArray);
                    break;
                }
                if (this.readIf(69)) {
                    object2 = this.readFunction(null, (String)expressionArray);
                    break;
                }
                object2 = this.readTermWithIdentifier((String)expressionArray);
                break;
            }
            case 66: {
                this.read();
                if (this.currentTokenType == 58) {
                    object2 = ValueExpression.get(this.currentValue.negate());
                    int n = object2.getType().getValueType();
                    if (n == 5 && object2.getValue(this.session).getLong() == Integer.MIN_VALUE) {
                        object2 = ValueExpression.get(ValueInt.get(Integer.MIN_VALUE));
                    } else if (n == 6 && object2.getValue(this.session).getBigDecimal().compareTo(Value.MIN_LONG_DECIMAL) == 0) {
                        object2 = ValueExpression.get(ValueLong.MIN);
                    }
                    this.read();
                    break;
                }
                object2 = new UnaryOperation(this.readTerm());
                break;
            }
            case 67: {
                this.read();
                object2 = this.readTerm();
                break;
            }
            case 69: {
                this.read();
                if (this.readIf(70)) {
                    object2 = ValueExpression.get(ValueRow.getEmpty());
                    break;
                }
                object2 = this.readExpression();
                if (!this.readIfMore(true)) break;
                ArrayList<Expression> arrayList = Utils.newSmallArrayList();
                arrayList.add((Expression)object2);
                if (!this.readIf(70)) {
                    do {
                        arrayList.add(this.readExpression());
                    } while (this.readIfMore(false));
                }
                object2 = new ExpressionList(arrayList.toArray(new Expression[0]), false);
                break;
            }
            case 4: {
                this.read();
                this.read(81);
                if (this.readIf(82)) {
                    object2 = ValueExpression.get(ValueArray.getEmpty());
                    break;
                }
                ArrayList<Expression> arrayList = Utils.newSmallArrayList();
                arrayList.add(this.readExpression());
                while (this.readIf(73)) {
                    arrayList.add(this.readExpression());
                }
                this.read(82);
                object2 = new ExpressionList(arrayList.toArray(new Expression[0]), true);
                break;
            }
            case 28: {
                this.read();
                object2 = this.readInterval();
                break;
            }
            case 44: {
                this.read();
                this.read(69);
                if (this.readIf(70)) {
                    object2 = ValueExpression.get(ValueRow.getEmpty());
                    break;
                }
                ArrayList<Expression> arrayList = Utils.newSmallArrayList();
                do {
                    arrayList.add(this.readExpression());
                } while (this.readIfMore(true));
                object2 = new ExpressionList(arrayList.toArray(new Expression[0]), false);
                break;
            }
            case 49: {
                this.read();
                object2 = ValueExpression.get(ValueBoolean.TRUE);
                break;
            }
            case 16: {
                this.read();
                object2 = ValueExpression.get(ValueBoolean.FALSE);
                break;
            }
            case 46: {
                this.read();
                if (this.readIf(69)) {
                    this.read(70);
                }
                if (this.currentSelect == null && this.currentPrepared == null) {
                    throw this.getSyntaxError();
                }
                object2 = new Rownum(this.currentSelect == null ? this.currentPrepared : this.currentSelect);
                break;
            }
            case 38: {
                this.read();
                object2 = ValueExpression.getNull();
                break;
            }
            case 45: {
                this.read();
                object2 = new ExpressionColumn(this.database, null, null, "_ROWID_", true);
                break;
            }
            case 58: {
                object2 = ValueExpression.get(this.currentValue);
                this.read();
                break;
            }
            case 52: {
                if (this.database.getMode().onDuplicateKeyUpdate) {
                    this.read();
                    object2 = this.readKeywordFunction("VALUES");
                    break;
                }
                object2 = new Subquery(this.parseSelect());
                break;
            }
            case 5: {
                this.read();
                object2 = this.readCase();
                break;
            }
            case 9: {
                this.read();
                object2 = this.readKeywordFunction("CURRENT_DATE");
                break;
            }
            case 10: {
                this.read();
                object2 = this.readKeywordFunction("CURRENT_TIME");
                break;
            }
            case 11: {
                this.read();
                object2 = this.readKeywordFunction("CURRENT_TIMESTAMP");
                break;
            }
            case 12: {
                this.read();
                object2 = this.readKeywordFunction("USER");
                break;
            }
            case 33: {
                this.read();
                object2 = this.readKeywordFunction("LOCALTIME");
                break;
            }
            case 34: {
                this.read();
                object2 = this.readKeywordFunction("LOCALTIMESTAMP");
                break;
            }
            default: {
                throw this.getSyntaxError();
            }
        }
        if (this.readIf(81)) {
            object = Function.getFunction(this.database, "ARRAY_GET");
            ((Function)object).setParameter(0, (Expression)object2);
            ((Function)object).setParameter(1, this.readExpression());
            object2 = object;
            this.read(82);
        }
        if (this.readIf(84)) {
            if (this.isToken("PG_CATALOG")) {
                this.read("PG_CATALOG");
                this.read(74);
            }
            if (this.readIf("REGCLASS")) {
                object = this.findFunctionAlias(this.database.getMainSchema().getName(), "PG_GET_OID");
                if (object == null) {
                    throw this.getSyntaxError();
                }
                expressionArray = new Expression[]{object2};
                object2 = new JavaFunction((FunctionAlias)object, expressionArray);
            } else {
                object = this.parseColumnWithType(null, false);
                expressionArray = Function.getFunction(this.database, "CAST");
                expressionArray.setDataType((Column)object);
                expressionArray.setParameter(0, (Expression)object2);
                object2 = expressionArray;
            }
        }
        return object2;
    }

    private Expression readTermWithIdentifier(String string) {
        char c = string.charAt(0);
        if (!this.identifiersToUpper) {
            c = (char)(c & 0xFFDF);
        }
        switch (c) {
            case 'C': {
                if (this.database.getMode().getEnum() != Mode.ModeEnum.DB2 || !this.equalsToken("CURRENT", string)) break;
                return this.parseDB2SpecialRegisters(string);
            }
            case 'D': {
                if (this.currentTokenType != 58 || this.currentValue.getValueType() != 13 || !this.equalsToken("DATE", string) && !this.equalsToken("D", string)) break;
                String string2 = this.currentValue.getString();
                this.read();
                return ValueExpression.get(ValueDate.parse(string2));
            }
            case 'E': {
                if (this.currentTokenType != 58 || this.currentValue.getValueType() != 13 || !this.equalsToken("E", string)) break;
                String string3 = this.currentValue.getString();
                string3 = StringUtils.replaceAll(string3, "\\\\", "\\");
                this.read();
                return ValueExpression.get(ValueString.get(string3));
            }
            case 'N': {
                if (this.equalsToken("NEXT", string) && this.readIf("VALUE")) {
                    this.read(18);
                    return new SequenceValue(this.readSequence());
                }
                if (this.currentTokenType != 58 || this.currentValue.getValueType() != 13 || !this.equalsToken("N", string)) break;
                String string4 = this.currentValue.getString();
                this.read();
                return ValueExpression.get(ValueString.get(string4));
            }
            case 'S': {
                if (this.equalsToken("SYSDATE", string)) {
                    return this.readFunctionWithoutParameters("CURRENT_TIMESTAMP");
                }
                if (this.equalsToken("SYSTIME", string)) {
                    return this.readFunctionWithoutParameters("CURRENT_TIME");
                }
                if (!this.equalsToken("SYSTIMESTAMP", string)) break;
                return this.readFunctionWithoutParameters("CURRENT_TIMESTAMP");
            }
            case 'T': {
                if (this.equalsToken("TIME", string)) {
                    boolean bl = this.readIf("WITHOUT");
                    if (bl) {
                        this.read("TIME");
                        this.read("ZONE");
                    }
                    if (this.currentTokenType == 58 && this.currentValue.getValueType() == 13) {
                        String string5 = this.currentValue.getString();
                        this.read();
                        return ValueExpression.get(ValueTime.parse(string5));
                    }
                    if (!bl) break;
                    throw this.getSyntaxError();
                }
                if (this.equalsToken("TIMESTAMP", string)) {
                    if (this.readIf(55)) {
                        this.read("TIME");
                        this.read("ZONE");
                        if (this.currentTokenType != 58 || this.currentValue.getValueType() != 13) {
                            throw this.getSyntaxError();
                        }
                        String string6 = this.currentValue.getString();
                        this.read();
                        return ValueExpression.get(ValueTimestampTimeZone.parse(string6));
                    }
                    boolean bl = this.readIf("WITHOUT");
                    if (bl) {
                        this.read("TIME");
                        this.read("ZONE");
                    }
                    if (this.currentTokenType == 58 && this.currentValue.getValueType() == 13) {
                        String string7 = this.currentValue.getString();
                        this.read();
                        return ValueExpression.get(ValueTimestamp.parse(string7, this.database.getMode()));
                    }
                    if (!bl) break;
                    throw this.getSyntaxError();
                }
                if (this.equalsToken("TODAY", string)) {
                    return this.readFunctionWithoutParameters("CURRENT_DATE");
                }
                if (this.currentTokenType != 58 || this.currentValue.getValueType() != 13) break;
                if (this.equalsToken("T", string)) {
                    String string8 = this.currentValue.getString();
                    this.read();
                    return ValueExpression.get(ValueTime.parse(string8));
                }
                if (!this.equalsToken("TS", string)) break;
                String string9 = this.currentValue.getString();
                this.read();
                return ValueExpression.get(ValueTimestamp.parse(string9, this.database.getMode()));
            }
            case 'X': {
                if (this.currentTokenType != 58 || this.currentValue.getValueType() != 13 || !this.equalsToken("X", string)) break;
                byte[] byArray = StringUtils.convertHexToBytes(this.currentValue.getString());
                this.read();
                return ValueExpression.get(ValueBytes.getNoCopy(byArray));
            }
        }
        return new ExpressionColumn(this.database, null, null, string, false);
    }

    private Expression readInterval() {
        IntervalQualifier intervalQualifier;
        boolean bl = this.readIf(66);
        if (!bl) {
            this.readIf(67);
        }
        String string = this.readString();
        if (this.readIf("YEAR")) {
            if (this.readIf("TO")) {
                this.read("MONTH");
                intervalQualifier = IntervalQualifier.YEAR_TO_MONTH;
            } else {
                intervalQualifier = IntervalQualifier.YEAR;
            }
        } else if (this.readIf("MONTH")) {
            intervalQualifier = IntervalQualifier.MONTH;
        } else if (this.readIf("DAY")) {
            if (this.readIf("TO")) {
                if (this.readIf("HOUR")) {
                    intervalQualifier = IntervalQualifier.DAY_TO_HOUR;
                } else if (this.readIf("MINUTE")) {
                    intervalQualifier = IntervalQualifier.DAY_TO_MINUTE;
                } else {
                    this.read("SECOND");
                    intervalQualifier = IntervalQualifier.DAY_TO_SECOND;
                }
            } else {
                intervalQualifier = IntervalQualifier.DAY;
            }
        } else if (this.readIf("HOUR")) {
            if (this.readIf("TO")) {
                if (this.readIf("MINUTE")) {
                    intervalQualifier = IntervalQualifier.HOUR_TO_MINUTE;
                } else {
                    this.read("SECOND");
                    intervalQualifier = IntervalQualifier.HOUR_TO_SECOND;
                }
            } else {
                intervalQualifier = IntervalQualifier.HOUR;
            }
        } else if (this.readIf("MINUTE")) {
            if (this.readIf("TO")) {
                this.read("SECOND");
                intervalQualifier = IntervalQualifier.MINUTE_TO_SECOND;
            } else {
                intervalQualifier = IntervalQualifier.MINUTE;
            }
        } else {
            this.read("SECOND");
            intervalQualifier = IntervalQualifier.SECOND;
        }
        try {
            return ValueExpression.get(IntervalUtils.parseInterval(intervalQualifier, bl, string));
        }
        catch (Exception exception) {
            throw DbException.get(22007, exception, "INTERVAL", string);
        }
    }

    private Expression parseDB2SpecialRegisters(String string) {
        if (this.readIf("TIMESTAMP")) {
            if (this.readIf(55)) {
                this.read("TIME");
                this.read("ZONE");
                return this.readKeywordFunction("CURRENT_TIMESTAMP");
            }
            return this.readKeywordFunction("LOCALTIMESTAMP");
        }
        if (this.readIf("TIME")) {
            return this.readFunctionWithoutParameters("CURRENT_TIME");
        }
        if (this.readIf("DATE")) {
            return this.readFunctionWithoutParameters("CURRENT_DATE");
        }
        return new ExpressionColumn(this.database, null, null, string, false);
    }

    private Expression readCase() {
        int n;
        Function function;
        if (this.readIf("END")) {
            this.readIf(5);
            return ValueExpression.getNull();
        }
        if (this.readIf("ELSE")) {
            Expression expression = this.readExpression().optimize(this.session);
            this.read("END");
            this.readIf(5);
            return expression;
        }
        if (this.readIf("WHEN")) {
            function = Function.getFunction(this.database, "CASE");
            function.setParameter(0, null);
            n = 1;
            do {
                function.setParameter(n++, this.readExpression());
                this.read("THEN");
                function.setParameter(n++, this.readExpression());
            } while (this.readIf("WHEN"));
        } else {
            Expression expression = this.readExpression();
            if (this.readIf("END")) {
                this.readIf(5);
                return ValueExpression.getNull();
            }
            if (this.readIf("ELSE")) {
                Expression expression2 = this.readExpression().optimize(this.session);
                this.read("END");
                this.readIf(5);
                return expression2;
            }
            function = Function.getFunction(this.database, "CASE");
            function.setParameter(0, expression);
            n = 1;
            this.read("WHEN");
            do {
                function.setParameter(n++, this.readExpression());
                this.read("THEN");
                function.setParameter(n++, this.readExpression());
            } while (this.readIf("WHEN"));
        }
        if (this.readIf("ELSE")) {
            function.setParameter(n, this.readExpression());
        }
        this.read("END");
        this.readIf("CASE");
        function.doneWithParameters();
        return function;
    }

    private int readNonNegativeInt() {
        int n = this.readInt();
        if (n < 0) {
            throw DbException.getInvalidValueException("non-negative integer", n);
        }
        return n;
    }

    private int readInt() {
        boolean bl = false;
        if (this.currentTokenType == 66) {
            bl = true;
            this.read();
        } else if (this.currentTokenType == 67) {
            this.read();
        }
        if (this.currentTokenType != 58) {
            throw DbException.getSyntaxError(this.sqlCommand, this.parseIndex, "integer");
        }
        if (bl) {
            this.currentValue = this.currentValue.negate();
        }
        int n = this.currentValue.getInt();
        this.read();
        return n;
    }

    private long readNonNegativeLong() {
        long l = this.readLong();
        if (l < 0L) {
            throw DbException.getInvalidValueException("non-negative long", l);
        }
        return l;
    }

    private long readLong() {
        boolean bl = false;
        if (this.currentTokenType == 66) {
            bl = true;
            this.read();
        } else if (this.currentTokenType == 67) {
            this.read();
        }
        if (this.currentTokenType != 58) {
            throw DbException.getSyntaxError(this.sqlCommand, this.parseIndex, "long");
        }
        if (bl) {
            this.currentValue = this.currentValue.negate();
        }
        long l = this.currentValue.getLong();
        this.read();
        return l;
    }

    private boolean readBooleanSetting() {
        switch (this.currentTokenType) {
            case 40: 
            case 49: {
                this.read();
                return true;
            }
            case 16: {
                this.read();
                return false;
            }
            case 58: {
                boolean bl = this.currentValue.getBoolean();
                this.read();
                return bl;
            }
        }
        if (this.readIf("OFF")) {
            return false;
        }
        throw this.getSyntaxError();
    }

    private String readString() {
        Expression expression = this.readExpression().optimize(this.session);
        if (!(expression instanceof ValueExpression)) {
            throw DbException.getSyntaxError(this.sqlCommand, this.parseIndex, "string");
        }
        return expression.getValue(this.session).getString();
    }

    private String readIdentifierWithSchema(String string) {
        String string2 = this.readColumnIdentifier();
        this.schemaName = string;
        if (this.readIf(74)) {
            this.schemaName = string2;
            string2 = this.readColumnIdentifier();
        }
        if (this.currentTokenType == 74 && this.equalsToken(this.schemaName, this.database.getShortName())) {
            this.read();
            this.schemaName = string2;
            string2 = this.readColumnIdentifier();
        }
        return string2;
    }

    private String readIdentifierWithSchema() {
        return this.readIdentifierWithSchema(this.session.getCurrentSchemaName());
    }

    private String readAliasIdentifier() {
        return this.readColumnIdentifier();
    }

    private String readUniqueIdentifier() {
        return this.readColumnIdentifier();
    }

    private String readColumnIdentifier() {
        if (!(this.currentTokenType == 2 || this.session.getDatabase().isStarting() && this.isKeyword(this.currentToken))) {
            throw DbException.getSyntaxError(this.sqlCommand, this.parseIndex, "identifier");
        }
        String string = this.currentToken;
        this.read();
        return string;
    }

    private void read(String string) {
        if (this.currentTokenQuoted || !this.equalsToken(string, this.currentToken)) {
            this.addExpected(string);
            throw this.getSyntaxError();
        }
        this.read();
    }

    private void read(int n) {
        if (n != this.currentTokenType) {
            this.addExpected(n);
            throw this.getSyntaxError();
        }
        this.read();
    }

    private boolean readIf(String string) {
        if (!this.currentTokenQuoted && this.equalsToken(string, this.currentToken)) {
            this.read();
            return true;
        }
        this.addExpected(string);
        return false;
    }

    private boolean readIf(int n) {
        if (n == this.currentTokenType) {
            this.read();
            return true;
        }
        this.addExpected(n);
        return false;
    }

    private boolean isToken(String string) {
        if (!this.currentTokenQuoted && this.equalsToken(string, this.currentToken)) {
            return true;
        }
        this.addExpected(string);
        return false;
    }

    private boolean isToken(int n) {
        if (n == this.currentTokenType) {
            return true;
        }
        this.addExpected(n);
        return false;
    }

    private boolean equalsToken(String string, String string2) {
        if (string == null) {
            return string2 == null;
        }
        return string.equals(string2) || !this.identifiersToUpper && string.equalsIgnoreCase(string2);
    }

    private static boolean equalsTokenIgnoreCase(String string, String string2) {
        if (string == null) {
            return string2 == null;
        }
        return string.equals(string2) || string.equalsIgnoreCase(string2);
    }

    private boolean isTokenInList(Collection<String> collection) {
        String string = this.currentToken.toUpperCase();
        return collection.contains(string);
    }

    private void addExpected(String string) {
        if (this.expectedList != null) {
            this.expectedList.add(string);
        }
    }

    private void addExpected(int n) {
        if (this.expectedList != null) {
            this.expectedList.add(TOKENS[n]);
        }
    }

    private void read() {
        this.currentTokenQuoted = false;
        if (this.expectedList != null) {
            this.expectedList.clear();
        }
        int[] nArray = this.characterTypes;
        this.lastParseIndex = this.parseIndex;
        int n = this.parseIndex;
        int n2 = nArray[n];
        while (n2 == 0) {
            n2 = nArray[++n];
        }
        int n3 = n;
        char[] cArray = this.sqlCommandChars;
        char c = cArray[n++];
        this.currentToken = "";
        switch (n2) {
            case 4: {
                while ((n2 = nArray[n]) == 4 || n2 == 2) {
                    ++n;
                }
                this.currentTokenType = ParserUtil.getSaveTokenType(this.sqlCommand, !this.identifiersToUpper, n3, n, false);
                this.currentToken = this.currentTokenType == 2 ? StringUtils.cache(this.sqlCommand.substring(n3, n)) : TOKENS[this.currentTokenType];
                this.parseIndex = n;
                return;
            }
            case 3: {
                String string = null;
                while (true) {
                    int n4 = ++n;
                    while (true) {
                        if (cArray[n] == c) {
                            if (string == null) {
                                string = this.sqlCommand.substring(n4, n);
                                break;
                            }
                            string = string + this.sqlCommand.substring(n4 - 1, n);
                            break;
                        }
                        ++n;
                    }
                    if (cArray[++n] != c) break;
                }
                this.currentToken = StringUtils.cache(string);
                this.parseIndex = n;
                this.currentTokenQuoted = true;
                this.currentTokenType = 2;
                return;
            }
            case 6: {
                if (nArray[n] == 6) {
                    char c2 = cArray[n++];
                    this.currentTokenType = this.getSpecialType2(c, c2);
                } else {
                    this.currentTokenType = this.getSpecialType1(c);
                }
                this.parseIndex = n;
                return;
            }
            case 5: {
                this.currentTokenType = this.getSpecialType1(c);
                this.parseIndex = n;
                return;
            }
            case 2: {
                if (c == '0' && (cArray[n] == 'X' || cArray[n] == 'x')) {
                    long l = 0L;
                    n3 += 2;
                    ++n;
                    while (true) {
                        if ((c = cArray[n]) >= '0' && c <= '9') {
                            l = (l << 4) + (long)c - 48L;
                        } else if (c >= 'A' && c <= 'F') {
                            l = (l << 4) + (long)c - 55L;
                        } else if (c >= 'a' && c <= 'f') {
                            l = (l << 4) + (long)c - 87L;
                        } else {
                            this.checkLiterals(false);
                            this.currentValue = ValueInt.get((int)l);
                            this.currentTokenType = 58;
                            this.currentToken = "0";
                            this.parseIndex = n;
                            return;
                        }
                        if (l > Integer.MAX_VALUE) {
                            this.readHexDecimal(n3, n);
                            return;
                        }
                        ++n;
                    }
                }
                long l = c - 48;
                while (true) {
                    if ((c = cArray[n]) < '0' || c > '9') {
                        switch (c) {
                            case '.': 
                            case 'E': 
                            case 'e': {
                                this.readDecimal(n3, n, false);
                                break;
                            }
                            case 'L': 
                            case 'l': {
                                this.readDecimal(n3, n, true);
                                break;
                            }
                            default: {
                                this.checkLiterals(false);
                                this.currentValue = ValueInt.get((int)l);
                                this.currentTokenType = 58;
                                this.currentToken = "0";
                                this.parseIndex = n;
                                break;
                            }
                        }
                        break;
                    }
                    if ((l = l * 10L + (long)(c - 48)) > Integer.MAX_VALUE) {
                        this.readDecimal(n3, n, true);
                        break;
                    }
                    ++n;
                }
                return;
            }
            case 8: {
                if (nArray[n] != 2) {
                    this.currentTokenType = 74;
                    this.currentToken = ".";
                    this.parseIndex = n;
                    return;
                }
                this.readDecimal(n - 1, n, false);
                return;
            }
            case 7: {
                String string = null;
                while (true) {
                    int n5 = ++n;
                    while (true) {
                        if (cArray[n] == '\'') {
                            if (string == null) {
                                string = this.sqlCommand.substring(n5, n);
                                break;
                            }
                            string = string + this.sqlCommand.substring(n5 - 1, n);
                            break;
                        }
                        ++n;
                    }
                    if (cArray[++n] != '\'') break;
                }
                this.currentToken = "'";
                this.checkLiterals(true);
                this.currentValue = ValueString.get(string, this.database.getMode().treatEmptyStringsAsNull);
                this.parseIndex = n;
                this.currentTokenType = 58;
                return;
            }
            case 9: {
                int n6 = n - 1;
                while (nArray[n] == 9) {
                    ++n;
                }
                String string = this.sqlCommand.substring(n6, n);
                this.currentToken = "'";
                this.checkLiterals(true);
                this.currentValue = ValueString.get(string, this.database.getMode().treatEmptyStringsAsNull);
                this.parseIndex = n;
                this.currentTokenType = 58;
                return;
            }
            case 1: {
                this.currentTokenType = 57;
                this.parseIndex = n;
                return;
            }
        }
        throw this.getSyntaxError();
    }

    private void readParameterIndex() {
        int n = this.parseIndex;
        char[] cArray = this.sqlCommandChars;
        char c = cArray[n++];
        long l = c - 48;
        while (true) {
            if ((c = cArray[n]) < '0' || c > '9') break;
            if ((l = l * 10L + (long)(c - 48)) > Integer.MAX_VALUE) {
                throw DbException.getInvalidValueException("parameter index", l);
            }
            ++n;
        }
        this.currentValue = ValueInt.get((int)l);
        this.currentTokenType = 58;
        this.currentToken = "0";
        this.parseIndex = n;
    }

    private void checkLiterals(boolean bl) {
        int n;
        if (!this.literalsChecked && !this.session.getAllowLiterals() && ((n = this.database.getAllowLiterals()) == 0 || bl && n != 2)) {
            throw DbException.get(90116);
        }
    }

    private void readHexDecimal(int n, int n2) {
        char c;
        char[] cArray = this.sqlCommandChars;
        while ((c = cArray[++n2]) >= '0' && c <= '9' || c >= 'A' && c <= 'F') {
        }
        this.parseIndex = n2;
        String string = this.sqlCommand.substring(n, n2);
        BigDecimal bigDecimal = new BigDecimal(new BigInteger(string, 16));
        this.checkLiterals(false);
        this.currentValue = ValueDecimal.get(bigDecimal);
        this.currentTokenType = 58;
    }

    private void readDecimal(int n, int n2, boolean bl) {
        BigDecimal bigDecimal;
        int n3;
        char[] cArray = this.sqlCommandChars;
        int[] nArray = this.characterTypes;
        while (true) {
            if ((n3 = nArray[n2]) == 8) {
                bl = false;
            } else if (n3 != 2) break;
            ++n2;
        }
        n3 = cArray[n2];
        if (n3 == 69 || n3 == 101) {
            bl = false;
            if ((n3 = cArray[++n2]) == 43 || n3 == 45) {
                ++n2;
            }
            if (nArray[n2] != 2) {
                throw this.getSyntaxError();
            }
            while (nArray[++n2] == 2) {
            }
        }
        this.parseIndex = n2;
        this.checkLiterals(false);
        if (bl && n2 - n <= 19) {
            BigInteger bigInteger = new BigInteger(this.sqlCommand.substring(n, n2));
            if (bigInteger.compareTo(ValueLong.MAX_BI) <= 0) {
                n3 = cArray[n2];
                if (n3 == 76 || n3 == 108) {
                    ++this.parseIndex;
                }
                this.currentValue = ValueLong.get(bigInteger.longValue());
                this.currentTokenType = 58;
                return;
            }
            bigDecimal = new BigDecimal(bigInteger);
        } else {
            try {
                bigDecimal = new BigDecimal(this.sqlCommandChars, n, n2 - n);
            }
            catch (NumberFormatException numberFormatException) {
                throw DbException.get(22018, numberFormatException, this.sqlCommand.substring(n, n2));
            }
        }
        this.currentValue = ValueDecimal.get(bigDecimal);
        this.currentTokenType = 58;
    }

    private void initialize(String string) {
        if (string == null) {
            string = "";
        }
        this.originalSQL = string;
        this.sqlCommand = string;
        int n = string.length() + 1;
        char[] cArray = new char[n];
        int[] nArray = new int[n];
        string.getChars(0, --n, cArray, 0);
        boolean bl = false;
        cArray[n] = 32;
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            char c = cArray[i];
            int n4 = 0;
            switch (c) {
                case '/': {
                    if (cArray[i + 1] == '*') {
                        bl = true;
                        cArray[i] = 32;
                        cArray[i + 1] = 32;
                        n2 = i;
                        this.checkRunOver(i += 2, n, n2);
                        while (cArray[i] != '*' || cArray[i + 1] != '/') {
                            cArray[i++] = 32;
                            this.checkRunOver(i, n, n2);
                        }
                        cArray[i] = 32;
                        cArray[i + 1] = 32;
                        ++i;
                        break;
                    }
                    if (cArray[i + 1] == '/') {
                        bl = true;
                        n2 = i;
                        while ((c = cArray[i]) != '\n' && c != '\r' && i < n - 1) {
                            cArray[i++] = 32;
                            this.checkRunOver(i, n, n2);
                        }
                        break;
                    }
                    n4 = 5;
                    break;
                }
                case '-': {
                    if (cArray[i + 1] == '-') {
                        bl = true;
                        n2 = i;
                        while ((c = cArray[i]) != '\n' && c != '\r' && i < n - 1) {
                            cArray[i++] = 32;
                            this.checkRunOver(i, n, n2);
                        }
                        break;
                    }
                    n4 = 5;
                    break;
                }
                case '$': {
                    if (cArray[i + 1] == '$' && (i == 0 || cArray[i - 1] <= ' ')) {
                        bl = true;
                        cArray[i] = 32;
                        cArray[i + 1] = 32;
                        n2 = i;
                        this.checkRunOver(i += 2, n, n2);
                        while (cArray[i] != '$' || cArray[i + 1] != '$') {
                            nArray[i++] = 9;
                            this.checkRunOver(i, n, n2);
                        }
                        cArray[i] = 32;
                        cArray[i + 1] = 32;
                        ++i;
                        break;
                    }
                    if (n3 == 4 || n3 == 2) {
                        n4 = 4;
                        break;
                    }
                    n4 = 5;
                    break;
                }
                case '%': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case ';': 
                case '?': 
                case '@': 
                case ']': 
                case '{': 
                case '}': {
                    n4 = 5;
                    break;
                }
                case '!': 
                case '&': 
                case ':': 
                case '<': 
                case '=': 
                case '>': 
                case '|': 
                case '~': {
                    n4 = 6;
                    break;
                }
                case '.': {
                    n4 = 8;
                    break;
                }
                case '\'': {
                    nArray[i] = 7;
                    n4 = 7;
                    n2 = i;
                    while (cArray[++i] != '\'') {
                        this.checkRunOver(i, n, n2);
                    }
                    break;
                }
                case '[': {
                    if (this.database.getMode().squareBracketQuotedNames) {
                        cArray[i] = 34;
                        bl = true;
                        nArray[i] = 3;
                        n4 = 3;
                        n2 = i;
                        while (cArray[++i] != ']') {
                            this.checkRunOver(i, n, n2);
                        }
                        cArray[i] = 34;
                        break;
                    }
                    n4 = 5;
                    break;
                }
                case '`': {
                    char c2;
                    nArray[i] = 3;
                    n4 = 3;
                    n2 = i;
                    while (cArray[++i] != '`') {
                        this.checkRunOver(i, n, n2);
                        c = cArray[i];
                        if (!this.identifiersToUpper && !this.identifiersToLower || (c2 = this.identifiersToUpper ? Character.toUpperCase(c) : Character.toLowerCase(c)) == c) continue;
                        cArray[i] = c2;
                        bl = true;
                    }
                    break;
                }
                case '\"': {
                    nArray[i] = 3;
                    n4 = 3;
                    n2 = i;
                    while (cArray[++i] != '\"') {
                        this.checkRunOver(i, n, n2);
                    }
                    break;
                }
                case '_': {
                    n4 = 4;
                    break;
                }
                case '#': {
                    if (this.database.getMode().supportPoundSymbolForColumnNames) {
                        n4 = 4;
                        break;
                    }
                    n4 = 5;
                    break;
                }
                default: {
                    char c2;
                    if (c >= 'a' && c <= 'z') {
                        if (this.identifiersToUpper) {
                            cArray[i] = (char)(c - 32);
                            bl = true;
                        }
                        n4 = 4;
                        break;
                    }
                    if (c >= 'A' && c <= 'Z') {
                        if (this.identifiersToLower) {
                            cArray[i] = (char)(c + 32);
                            bl = true;
                        }
                        n4 = 4;
                        break;
                    }
                    if (c >= '0' && c <= '9') {
                        n4 = 2;
                        break;
                    }
                    if (c <= ' ' || Character.isSpaceChar(c)) break;
                    if (Character.isJavaIdentifierPart(c)) {
                        n4 = 4;
                        if (!this.identifiersToUpper && !this.identifiersToLower) break;
                        char c3 = c2 = this.identifiersToUpper ? Character.toUpperCase(c) : Character.toLowerCase(c);
                        if (c2 == c) break;
                        cArray[i] = c2;
                        bl = true;
                        break;
                    }
                    n4 = 5;
                }
            }
            nArray[i] = n4;
            n3 = n4;
        }
        this.sqlCommandChars = cArray;
        nArray[n] = 1;
        this.characterTypes = nArray;
        if (bl) {
            this.sqlCommand = new String(cArray);
        }
        this.parseIndex = 0;
    }

    private void checkRunOver(int n, int n2, int n3) {
        if (n >= n2) {
            this.parseIndex = n3;
            throw this.getSyntaxError();
        }
    }

    private int getSpecialType1(char c) {
        switch (c) {
            case '$': 
            case '?': {
                return 56;
            }
            case '@': {
                return 65;
            }
            case '+': {
                return 67;
            }
            case '-': {
                return 66;
            }
            case '*': {
                return 72;
            }
            case ',': {
                return 73;
            }
            case '{': {
                return 75;
            }
            case '}': {
                return 76;
            }
            case '/': {
                return 77;
            }
            case '%': {
                return 78;
            }
            case ';': {
                return 79;
            }
            case ':': {
                return 80;
            }
            case '[': {
                return 81;
            }
            case ']': {
                return 82;
            }
            case '~': {
                return 83;
            }
            case '(': {
                return 69;
            }
            case ')': {
                return 70;
            }
            case '<': {
                return 62;
            }
            case '>': {
                return 61;
            }
            case '=': {
                return 59;
            }
        }
        throw this.getSyntaxError();
    }

    private int getSpecialType2(char c, char c2) {
        switch (c) {
            case ':': {
                if (c2 == ':') {
                    return 84;
                }
                if (c2 != '=') break;
                return 85;
            }
            case '>': {
                if (c2 != '=') break;
                return 60;
            }
            case '<': {
                if (c2 == '=') {
                    return 63;
                }
                if (c2 != '>') break;
                return 64;
            }
            case '!': {
                if (c2 == '=') {
                    return 64;
                }
                if (c2 != '~') break;
                return 86;
            }
            case '|': {
                if (c2 != '|') break;
                return 68;
            }
            case '&': {
                if (c2 != '&') break;
                return 71;
            }
        }
        throw this.getSyntaxError();
    }

    private boolean isKeyword(String string) {
        return ParserUtil.isKeyword(string, !this.identifiersToUpper);
    }

    private Column parseColumnForTable(String string, boolean bl, boolean bl2) {
        String string2;
        Object object;
        Column column;
        boolean bl3 = this.readIf("IDENTITY");
        if (bl3 || this.readIf("BIGSERIAL")) {
            if (bl3 && this.database.getMode().disallowedTypes.contains("IDENTITY")) {
                throw DbException.get(50004, this.currentToken);
            }
            column = new Column(string, 5);
            column.setOriginalSQL("IDENTITY");
            this.parseAutoIncrement(column);
            if (!this.database.getMode().serialColumnIsNotPK) {
                column.setPrimaryKey(true);
            }
        } else if (this.readIf("SERIAL")) {
            column = new Column(string, 4);
            column.setOriginalSQL("SERIAL");
            this.parseAutoIncrement(column);
            if (!this.database.getMode().serialColumnIsNotPK) {
                column.setPrimaryKey(true);
            }
        } else {
            column = this.parseColumnWithType(string, bl2);
        }
        if (this.readIf("INVISIBLE")) {
            column.setVisible(false);
        } else if (this.readIf("VISIBLE")) {
            column.setVisible(true);
        }
        NullConstraintType nullConstraintType = this.parseNotNullConstraint();
        switch (nullConstraintType) {
            case NULL_IS_ALLOWED: {
                column.setNullable(true);
                break;
            }
            case NULL_IS_NOT_ALLOWED: {
                column.setNullable(false);
                break;
            }
            case NO_NULL_CONSTRAINT_FOUND: {
                column.setNullable(bl & column.isNullable());
                break;
            }
            default: {
                throw DbException.get(90088, "Internal Error - unhandled case: " + nullConstraintType.name());
            }
        }
        if (this.readIf("AS")) {
            if (bl3) {
                this.getSyntaxError();
            }
            object = this.readExpression();
            column.setComputedExpression((Expression)object);
        } else if (this.readIf("DEFAULT")) {
            object = this.readExpression();
            column.setDefaultExpression(this.session, (Expression)object);
        } else if (this.readIf("GENERATED")) {
            if (!this.readIf("ALWAYS")) {
                this.read("BY");
                this.read("DEFAULT");
            }
            this.read("AS");
            this.read("IDENTITY");
            object = new SequenceOptions();
            if (this.readIf(69)) {
                this.parseSequenceOptions((SequenceOptions)object, null, true);
                this.read(70);
            }
            column.setAutoIncrementOptions((SequenceOptions)object);
        }
        if (this.readIf(40)) {
            this.read("UPDATE");
            object = this.readExpression();
            column.setOnUpdateExpression(this.session, (Expression)object);
        }
        if (NullConstraintType.NULL_IS_NOT_ALLOWED == this.parseNotNullConstraint()) {
            column.setNullable(false);
        }
        if (this.readIf("AUTO_INCREMENT") || this.readIf("BIGSERIAL") || this.readIf("SERIAL")) {
            this.parseAutoIncrement(column);
            this.parseNotNullConstraint();
        } else if (this.readIf("IDENTITY")) {
            this.parseAutoIncrement(column);
            column.setPrimaryKey(true);
            this.parseNotNullConstraint();
        }
        if (this.readIf("NULL_TO_DEFAULT")) {
            column.setConvertNullToDefault(true);
        }
        if (this.readIf("SEQUENCE")) {
            object = this.readSequence();
            column.setSequence((Sequence)object);
        }
        if (this.readIf("SELECTIVITY")) {
            int n = this.readNonNegativeInt();
            column.setSelectivity(n);
        }
        if ((string2 = this.readCommentIf()) != null) {
            column.setComment(string2);
        }
        return column;
    }

    private void parseAutoIncrement(Column column) {
        SequenceOptions sequenceOptions = new SequenceOptions();
        if (this.readIf(69)) {
            sequenceOptions.setStartValue(ValueExpression.get(ValueLong.get(this.readLong())));
            if (this.readIf(73)) {
                sequenceOptions.setIncrement(ValueExpression.get(ValueLong.get(this.readLong())));
            }
            this.read(70);
        }
        column.setAutoIncrementOptions(sequenceOptions);
    }

    private String readCommentIf() {
        if (this.readIf("COMMENT")) {
            this.readIf(29);
            return this.readString();
        }
        return null;
    }

    private Column parseColumnWithType(String string, boolean bl) {
        Object object;
        Object object2;
        DataType dataType;
        Object object3;
        Domain domain;
        String string2 = this.currentToken;
        boolean bl2 = false;
        int n = -1;
        int n2 = -1;
        if (this.readIf("LONG")) {
            if (this.readIf("RAW")) {
                string2 = "LONG RAW";
            }
        } else if (this.readIf("DOUBLE")) {
            if (this.readIf("PRECISION")) {
                string2 = "DOUBLE PRECISION";
            }
        } else if (this.readIf("CHARACTER")) {
            if (this.readIf("VARYING")) {
                string2 = "CHARACTER VARYING";
            } else if (this.readIf("LARGE")) {
                this.read("OBJECT");
                string2 = "CHARACTER LARGE OBJECT";
            }
        } else if (this.readIf("BINARY")) {
            if (this.readIf("VARYING")) {
                string2 = "BINARY VARYING";
            } else if (this.readIf("LARGE")) {
                this.read("OBJECT");
                string2 = "BINARY LARGE OBJECT";
            }
        } else if (this.readIf("TIME")) {
            if (this.readIf(69)) {
                n2 = this.readNonNegativeInt();
                if (n2 > 9) {
                    throw DbException.get(90051, Integer.toString(n2));
                }
                this.read(70);
            }
            if (this.readIf("WITHOUT")) {
                this.read("TIME");
                this.read("ZONE");
                string2 = "TIME WITHOUT TIME ZONE";
            }
        } else if (this.readIf("TIMESTAMP")) {
            if (this.readIf(69)) {
                n2 = this.readNonNegativeInt();
                if (this.readIf(73)) {
                    n2 = this.readNonNegativeInt();
                }
                if (n2 > 9) {
                    throw DbException.get(90051, Integer.toString(n2));
                }
                this.read(70);
            }
            if (this.readIf(55)) {
                this.read("TIME");
                this.read("ZONE");
                string2 = "TIMESTAMP WITH TIME ZONE";
            } else if (this.readIf("WITHOUT")) {
                this.read("TIME");
                this.read("ZONE");
                string2 = "TIMESTAMP WITHOUT TIME ZONE";
            }
        } else if (this.readIf(28)) {
            if (this.readIf("YEAR")) {
                if (this.readIf(69)) {
                    n = this.readNonNegativeInt();
                    this.read(70);
                }
                if (this.readIf("TO")) {
                    this.read("MONTH");
                    string2 = "INTERVAL YEAR TO MONTH";
                } else {
                    string2 = "INTERVAL YEAR";
                }
            } else if (this.readIf("MONTH")) {
                if (this.readIf(69)) {
                    n = this.readNonNegativeInt();
                    this.read(70);
                }
                string2 = "INTERVAL MONTH";
            } else if (this.readIf("DAY")) {
                if (this.readIf(69)) {
                    n = this.readNonNegativeInt();
                    this.read(70);
                }
                if (this.readIf("TO")) {
                    if (this.readIf("HOUR")) {
                        string2 = "INTERVAL DAY TO HOUR";
                    } else if (this.readIf("MINUTE")) {
                        string2 = "INTERVAL DAY TO MINUTE";
                    } else {
                        this.read("SECOND");
                        if (this.readIf(69)) {
                            n2 = this.readNonNegativeInt();
                            this.read(70);
                        }
                        string2 = "INTERVAL DAY TO SECOND";
                    }
                } else {
                    string2 = "INTERVAL DAY";
                }
            } else if (this.readIf("HOUR")) {
                if (this.readIf(69)) {
                    n = this.readNonNegativeInt();
                    this.read(70);
                }
                if (this.readIf("TO")) {
                    if (this.readIf("MINUTE")) {
                        string2 = "INTERVAL HOUR TO MINUTE";
                    } else {
                        this.read("SECOND");
                        if (this.readIf(69)) {
                            n2 = this.readNonNegativeInt();
                            this.read(70);
                        }
                        string2 = "INTERVAL HOUR TO SECOND";
                    }
                } else {
                    string2 = "INTERVAL HOUR";
                }
            } else if (this.readIf("MINUTE")) {
                if (this.readIf(69)) {
                    n = this.readNonNegativeInt();
                    this.read(70);
                }
                if (this.readIf("TO")) {
                    this.read("SECOND");
                    if (this.readIf(69)) {
                        n2 = this.readNonNegativeInt();
                        this.read(70);
                    }
                    string2 = "INTERVAL MINUTE TO SECOND";
                } else {
                    string2 = "INTERVAL MINUTE";
                }
            } else {
                this.read("SECOND");
                if (this.readIf(69)) {
                    n = this.readNonNegativeInt();
                    if (this.readIf(73)) {
                        n2 = this.readNonNegativeInt();
                    }
                    this.read(70);
                }
                string2 = "INTERVAL SECOND";
            }
        } else {
            bl2 = true;
        }
        long l = -1L;
        ExtTypeInfo extTypeInfo = null;
        int n3 = -1;
        String string3 = null;
        Column column = null;
        if (!this.identifiersToUpper) {
            string2 = StringUtils.toUpperEnglish(string2);
        }
        if ((domain = this.database.findDomain(string2)) != null) {
            column = domain.getColumn();
            object3 = column.getType();
            dataType = DataType.getDataType(object3.getValueType());
            string3 = column.getComment();
            string2 = bl ? domain.getSQL(true) : column.getOriginalSQL();
            l = object3.getPrecision();
            n3 = object3.getScale();
            extTypeInfo = object3.getExtTypeInfo();
        } else {
            object3 = this.database.getMode();
            dataType = DataType.getTypeByName(string2, (Mode)object3);
            if (dataType == null || object3.disallowedTypes.contains(string2)) {
                throw DbException.get(50004, this.currentToken);
            }
        }
        if (this.database.getIgnoreCase() && dataType.type == 13 && !this.equalsToken("VARCHAR_CASESENSITIVE", string2)) {
            string2 = "VARCHAR_IGNORECASE";
            dataType = DataType.getTypeByName(string2, this.database.getMode());
        }
        if (bl2) {
            this.read();
        }
        l = l == -1L ? dataType.defaultPrecision : l;
        int n4 = n3 = n3 == -1 ? dataType.defaultScale : n3;
        if (dataType.supportsPrecision || dataType.supportsScale) {
            int n5 = dataType.type;
            if (n5 == 9 || n5 == 11 || n5 == 24) {
                if (n2 >= 0) {
                    n3 = n2;
                    switch (n5) {
                        case 9: {
                            if (string2.equals("TIME WITHOUT TIME ZONE")) {
                                string2 = "TIME(" + n2 + ") WITHOUT TIME ZONE";
                                break;
                            }
                            string2 = string2 + '(' + n2 + ')';
                            break;
                        }
                        case 11: {
                            if (string2.equals("TIMESTAMP WITHOUT TIME ZONE")) {
                                string2 = "TIMESTAMP(" + n2 + ") WITHOUT TIME ZONE";
                                break;
                            }
                            string2 = string2 + '(' + n2 + ')';
                            break;
                        }
                        case 24: {
                            string2 = "TIMESTAMP(" + n2 + ") WITH TIME ZONE";
                        }
                    }
                } else if (string2.equals("DATETIME") || string2.equals("DATETIME2")) {
                    if (this.readIf(69)) {
                        n2 = this.readNonNegativeInt();
                        if (n2 > 9) {
                            throw DbException.get(90051, Integer.toString(n2));
                        }
                        this.read(70);
                        n3 = n2;
                        string2 = string2 + '(' + n2 + ')';
                    }
                } else if (string2.equals("SMALLDATETIME")) {
                    n3 = 0;
                }
            } else if (DataType.isIntervalType(n5)) {
                if (n >= 0 || n2 >= 0) {
                    object2 = IntervalQualifier.valueOf(n5 - 26);
                    string2 = ((IntervalQualifier)((Object)object2)).getTypeName(n, n2);
                    if (n >= 0) {
                        if (n <= 0 || n > 18) {
                            throw DbException.get(90051, Integer.toString(n));
                        }
                        l = n;
                    }
                    if (n2 >= 0) {
                        if (n2 > 9) {
                            throw DbException.get(90051, Integer.toString(n2));
                        }
                        n3 = n2;
                    }
                }
            } else if (this.readIf(69)) {
                if (!this.readIf("MAX")) {
                    long l2 = this.readPrecision();
                    string2 = string2 + "(" + l2;
                    if (dataType.supportsScale) {
                        if (this.readIf(73)) {
                            n3 = this.readInt();
                            string2 = string2 + ", " + n3;
                        } else {
                            n3 = 0;
                        }
                    }
                    l = l2;
                    string2 = string2 + ")";
                }
                this.read(70);
            }
        } else if (dataType.type == 7 && string2.equals("FLOAT")) {
            if (this.readIf(69)) {
                int n6 = this.readNonNegativeInt();
                this.read(70);
                if (n6 > 53) {
                    throw DbException.get(90051, Integer.toString(n6));
                }
                if (n6 <= 24) {
                    dataType = DataType.getDataType(8);
                }
                string2 = string2 + '(' + n6 + ')';
            }
        } else if (dataType.type == 25) {
            if (extTypeInfo == null) {
                object3 = null;
                if (this.readIf(69)) {
                    object2 = new ArrayList();
                    String string4 = this.readString();
                    object2.add(string4);
                    while (this.readIfMore(true)) {
                        object = this.readString();
                        object2.add(object);
                    }
                    object3 = object2.toArray(new String[0]);
                }
                try {
                    extTypeInfo = new ExtTypeInfoEnum((String[])object3);
                }
                catch (DbException dbException) {
                    throw dbException.addSQL(string2);
                }
                string2 = string2 + extTypeInfo.getCreateSQL();
            }
        } else if (dataType.type == 22) {
            if (extTypeInfo == null && this.readIf(69)) {
                int n7 = 0;
                if (this.currentTokenType != 2 || this.currentTokenQuoted) {
                    throw this.getSyntaxError();
                }
                if (!this.readIf("GEOMETRY")) {
                    try {
                        n7 = EWKTUtils.parseGeometryType(this.currentToken);
                        this.read();
                        if (n7 / 1000 == 0 && this.currentTokenType == 2 && !this.currentTokenQuoted) {
                            n7 += EWKTUtils.parseDimensionSystem(this.currentToken) * 1000;
                            this.read();
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw this.getSyntaxError();
                    }
                }
                object2 = null;
                if (this.readIf(73)) {
                    object2 = this.readInt();
                }
                this.read(70);
                extTypeInfo = new ExtTypeInfoGeometry(n7, (Integer)object2);
                string2 = string2 + extTypeInfo.getCreateSQL();
            }
        } else if (this.readIf(69)) {
            this.readNonNegativeInt();
            this.read(70);
        }
        if (this.readIf(18)) {
            this.read("BIT");
            this.read("DATA");
            if (dataType.type == 13) {
                dataType = DataType.getTypeByName("BINARY", this.database.getMode());
            }
        }
        this.readIf("UNSIGNED");
        int n8 = dataType.type;
        if ((long)n3 > l && dataType.supportsPrecision && dataType.supportsScale && !DataType.isIntervalType(n8)) {
            throw DbException.get(90051, Integer.toString(n3), Long.toString(l));
        }
        object2 = new Column(string, TypeInfo.getTypeInfo(n8, l, n3, extTypeInfo));
        if (column != null) {
            ((Column)object2).setNullable(column.isNullable());
            ((Column)object2).setDefaultExpression(this.session, column.getDefaultExpression());
            int n9 = column.getSelectivity();
            if (n9 != 50) {
                ((Column)object2).setSelectivity(n9);
            }
            object = column.getCheckConstraint(this.session, string);
            ((Column)object2).addCheckConstraint(this.session, (Expression)object);
        }
        ((Column)object2).setComment(string3);
        ((Column)object2).setOriginalSQL(string2);
        if (bl) {
            ((Column)object2).setDomain(domain);
        }
        return object2;
    }

    private long readPrecision() {
        long l = this.readNonNegativeLong();
        if (this.currentTokenType == 2 && !this.currentTokenQuoted && this.currentToken.length() == 1) {
            long l2;
            char c = this.currentToken.charAt(0);
            switch (this.identifiersToUpper ? c : Character.toUpperCase(c)) {
                case 'K': {
                    l2 = 1024L;
                    break;
                }
                case 'M': {
                    l2 = 0x100000L;
                    break;
                }
                case 'G': {
                    l2 = 0x40000000L;
                    break;
                }
                case 'T': {
                    l2 = 0x10000000000L;
                    break;
                }
                case 'P': {
                    l2 = 0x4000000000000L;
                    break;
                }
                default: {
                    throw this.getSyntaxError();
                }
            }
            if (l > Long.MAX_VALUE / l2) {
                throw DbException.getInvalidValueException("precision", l + this.currentToken);
            }
            l *= l2;
            this.read();
        }
        if (!(this.currentTokenType != 2 || this.currentTokenQuoted || this.readIf("CHARACTERS") || this.readIf("OCTETS") || this.readIf("CHAR"))) {
            this.readIf("BYTE");
        }
        return l;
    }

    private Prepared parseCreate() {
        boolean bl = false;
        if (this.readIf("OR")) {
            this.read("REPLACE");
            bl = true;
        }
        boolean bl2 = this.readIf("FORCE");
        if (this.readIf("VIEW")) {
            return this.parseCreateView(bl2, bl);
        }
        if (this.readIf("ALIAS")) {
            return this.parseCreateFunctionAlias(bl2);
        }
        if (this.readIf("SEQUENCE")) {
            return this.parseCreateSequence();
        }
        if (this.readIf("USER")) {
            return this.parseCreateUser();
        }
        if (this.readIf("TRIGGER")) {
            return this.parseCreateTrigger(bl2);
        }
        if (this.readIf("ROLE")) {
            return this.parseCreateRole();
        }
        if (this.readIf("SCHEMA")) {
            return this.parseCreateSchema();
        }
        if (this.readIf("CONSTANT")) {
            return this.parseCreateConstant();
        }
        if (this.readIf("DOMAIN") || this.readIf("TYPE") || this.readIf("DATATYPE")) {
            return this.parseCreateDomain();
        }
        if (this.readIf("AGGREGATE")) {
            return this.parseCreateAggregate(bl2);
        }
        if (this.readIf("LINKED")) {
            return this.parseCreateLinkedTable(false, false, bl2);
        }
        boolean bl3 = false;
        boolean bl4 = false;
        if (this.readIf("MEMORY")) {
            bl3 = true;
        } else if (this.readIf("CACHED")) {
            bl4 = true;
        }
        if (this.readIf("LOCAL")) {
            this.read("TEMPORARY");
            if (this.readIf("LINKED")) {
                return this.parseCreateLinkedTable(true, false, bl2);
            }
            this.read(48);
            return this.parseCreateTable(true, false, bl4);
        }
        if (this.readIf("GLOBAL")) {
            this.read("TEMPORARY");
            if (this.readIf("LINKED")) {
                return this.parseCreateLinkedTable(true, true, bl2);
            }
            this.read(48);
            return this.parseCreateTable(true, true, bl4);
        }
        if (this.readIf("TEMP") || this.readIf("TEMPORARY")) {
            if (this.readIf("LINKED")) {
                return this.parseCreateLinkedTable(true, true, bl2);
            }
            this.read(48);
            return this.parseCreateTable(true, true, bl4);
        }
        if (this.readIf(48)) {
            if (!bl4 && !bl3) {
                bl4 = this.database.getDefaultTableType() == 0;
            }
            return this.parseCreateTable(false, false, bl4);
        }
        if (this.readIf("SYNONYM")) {
            return this.parseCreateSynonym(bl);
        }
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        String string = null;
        Schema schema = null;
        boolean bl9 = false;
        if (this.readIf(42)) {
            this.read("KEY");
            if (this.readIf("HASH")) {
                bl5 = true;
            }
            bl6 = true;
            if (!this.isToken(40)) {
                bl9 = this.readIfNotExists();
                string = this.readIdentifierWithSchema(null);
                schema = this.getSchema();
            }
        } else {
            if (this.readIf(51)) {
                bl7 = true;
            }
            if (this.readIf("HASH")) {
                bl5 = true;
            }
            if (this.readIf("SPATIAL")) {
                bl8 = true;
            }
            if (this.readIf("INDEX")) {
                if (!this.isToken(40)) {
                    bl9 = this.readIfNotExists();
                    string = this.readIdentifierWithSchema(null);
                    schema = this.getSchema();
                }
            } else {
                throw this.getSyntaxError();
            }
        }
        this.read(40);
        String string2 = this.readIdentifierWithSchema();
        this.checkSchema(schema);
        CreateIndex createIndex = new CreateIndex(this.session, this.getSchema());
        createIndex.setIfNotExists(bl9);
        createIndex.setPrimaryKey(bl6);
        createIndex.setTableName(string2);
        createIndex.setUnique(bl7);
        createIndex.setIndexName(string);
        createIndex.setComment(this.readCommentIf());
        this.read(69);
        createIndex.setIndexColumns(this.parseIndexColumnList());
        if (this.readIf("USING")) {
            if (bl5) {
                throw this.getSyntaxError();
            }
            if (bl8) {
                throw this.getSyntaxError();
            }
            if (!this.readIf("BTREE")) {
                if (this.readIf("RTREE")) {
                    bl8 = true;
                } else if (this.readIf("HASH")) {
                    bl5 = true;
                } else {
                    throw this.getSyntaxError();
                }
            }
        }
        createIndex.setHash(bl5);
        createIndex.setSpatial(bl8);
        return createIndex;
    }

    private boolean addRoleOrRight(GrantRevoke grantRevoke) {
        if (this.readIf(47)) {
            grantRevoke.addRight(1);
            return true;
        }
        if (this.readIf("DELETE")) {
            grantRevoke.addRight(2);
            return true;
        }
        if (this.readIf("INSERT")) {
            grantRevoke.addRight(4);
            return true;
        }
        if (this.readIf("UPDATE")) {
            grantRevoke.addRight(8);
            return true;
        }
        if (this.readIf(3)) {
            grantRevoke.addRight(15);
            return true;
        }
        if (this.readIf("ALTER")) {
            this.read("ANY");
            this.read("SCHEMA");
            grantRevoke.addRight(16);
            grantRevoke.addTable(null);
            return false;
        }
        if (this.readIf("CONNECT")) {
            return true;
        }
        if (this.readIf("RESOURCE")) {
            return true;
        }
        grantRevoke.addRoleName(this.readUniqueIdentifier());
        return false;
    }

    private GrantRevoke parseGrantRevoke(int n) {
        GrantRevoke grantRevoke = new GrantRevoke(this.session);
        grantRevoke.setOperationType(n);
        boolean bl = this.addRoleOrRight(grantRevoke);
        while (this.readIf(73)) {
            this.addRoleOrRight(grantRevoke);
            if (!grantRevoke.isRightMode() || !grantRevoke.isRoleMode()) continue;
            throw DbException.get(90072);
        }
        if (bl && this.readIf(40)) {
            if (this.readIf("SCHEMA")) {
                Schema schema = this.database.getSchema(this.readAliasIdentifier());
                grantRevoke.setSchema(schema);
            } else {
                do {
                    Table table = this.readTableOrView();
                    grantRevoke.addTable(table);
                } while (this.readIf(73));
            }
        }
        if (n == 49) {
            this.read("TO");
        } else {
            this.read(20);
        }
        grantRevoke.setGranteeName(this.readUniqueIdentifier());
        return grantRevoke;
    }

    private Select parseValues() {
        Select select;
        this.currentSelect = select = new Select(this.session, this.currentSelect);
        TableFilter tableFilter = this.parseValuesTable(0);
        select.setWildcard();
        select.addTableFilter(tableFilter, true);
        return select;
    }

    private TableFilter parseValuesTable(int n) {
        Object object;
        Expression[] expressionArray;
        Object object222;
        int n2;
        Schema schema = this.database.getMainSchema();
        TableFunction tableFunction = (TableFunction)Function.getFunction(this.database, "TABLE");
        ArrayList<Column> arrayList = Utils.newSmallArrayList();
        ArrayList<Object> arrayList2 = Utils.newSmallArrayList();
        do {
            boolean bl;
            n2 = 0;
            ArrayList arrayList3 = Utils.newSmallArrayList();
            if (this.readIf(44)) {
                this.read(69);
                bl = true;
            } else {
                bl = this.readIf(69);
            }
            do {
                object222 = this.readExpression();
                object222 = ((Expression)object222).optimize(this.session);
                expressionArray = ((Expression)object222).getType();
                String string = "C" + (n2 + 1);
                if (arrayList2.isEmpty()) {
                    if (expressionArray.getValueType() == -1) {
                        expressionArray = TypeInfo.TYPE_STRING;
                    }
                    object = new Column(string, (TypeInfo)expressionArray);
                    arrayList.add((Column)object);
                } else {
                    if (n2 >= arrayList.size()) {
                        throw DbException.get(21002);
                    }
                    expressionArray = Value.getHigherType(((Column)arrayList.get(n2)).getType(), (TypeInfo)expressionArray);
                    object = new Column(string, (TypeInfo)expressionArray);
                    arrayList.set(n2, (Column)object);
                }
                arrayList3.add(object222);
                ++n2;
            } while (bl && this.readIfMore(true));
            arrayList2.add(arrayList3);
        } while (this.readIf(73));
        n2 = arrayList.size();
        int n3 = arrayList2.size();
        for (Object object222 : arrayList2) {
            if (((ArrayList)object222).size() == n2) continue;
            throw DbException.get(21002);
        }
        for (int i = 0; i < n2; ++i) {
            object222 = (Column)arrayList.get(i);
            if (((Column)object222).getType().getValueType() == -1) {
                object222 = new Column(((Column)object222).getName(), 13);
                arrayList.set(i, (Column)object222);
            }
            expressionArray = new Expression[n3];
            for (int j = 0; j < n3; ++j) {
                expressionArray[j] = (Expression)((ArrayList)arrayList2.get(j)).get(i);
            }
            object = new ExpressionList(expressionArray, false);
            tableFunction.setParameter(i, (Expression)object);
        }
        tableFunction.setColumns(arrayList);
        tableFunction.doneWithParameters();
        FunctionTable functionTable = new FunctionTable(schema, this.session, tableFunction, tableFunction);
        return new TableFilter(this.session, functionTable, null, this.rightsChecked, this.currentSelect, n, null);
    }

    private Call parseCall() {
        Call call = new Call(this.session);
        this.currentPrepared = call;
        call.setExpression(this.readExpression());
        return call;
    }

    private CreateRole parseCreateRole() {
        CreateRole createRole = new CreateRole(this.session);
        createRole.setIfNotExists(this.readIfNotExists());
        createRole.setRoleName(this.readUniqueIdentifier());
        return createRole;
    }

    private CreateSchema parseCreateSchema() {
        CreateSchema createSchema = new CreateSchema(this.session);
        createSchema.setIfNotExists(this.readIfNotExists());
        createSchema.setSchemaName(this.readUniqueIdentifier());
        if (this.readIf("AUTHORIZATION")) {
            createSchema.setAuthorization(this.readUniqueIdentifier());
        } else {
            createSchema.setAuthorization(this.session.getUser().getName());
        }
        if (this.readIf(55)) {
            createSchema.setTableEngineParams(this.readTableEngineParams());
        }
        return createSchema;
    }

    private ArrayList<String> readTableEngineParams() {
        ArrayList<String> arrayList = Utils.newSmallArrayList();
        do {
            arrayList.add(this.readUniqueIdentifier());
        } while (this.readIf(73));
        return arrayList;
    }

    private CreateSequence parseCreateSequence() {
        boolean bl = this.readIfNotExists();
        String string = this.readIdentifierWithSchema();
        CreateSequence createSequence = new CreateSequence(this.session, this.getSchema());
        createSequence.setIfNotExists(bl);
        createSequence.setSequenceName(string);
        SequenceOptions sequenceOptions = new SequenceOptions();
        this.parseSequenceOptions(sequenceOptions, createSequence, true);
        createSequence.setOptions(sequenceOptions);
        return createSequence;
    }

    private boolean readIfNotExists() {
        if (this.readIf(24)) {
            this.read(37);
            this.read(15);
            return true;
        }
        return false;
    }

    private boolean readIfAffinity() {
        return this.readIf("AFFINITY") || this.readIf("SHARD");
    }

    private CreateConstant parseCreateConstant() {
        boolean bl = this.readIfNotExists();
        String string = this.readIdentifierWithSchema();
        Schema schema = this.getSchema();
        if (this.isKeyword(string)) {
            throw DbException.get(90114, string);
        }
        this.read("VALUE");
        Expression expression = this.readExpression();
        CreateConstant createConstant = new CreateConstant(this.session, schema);
        createConstant.setConstantName(string);
        createConstant.setExpression(expression);
        createConstant.setIfNotExists(bl);
        return createConstant;
    }

    private CreateAggregate parseCreateAggregate(boolean bl) {
        boolean bl2 = this.readIfNotExists();
        CreateAggregate createAggregate = new CreateAggregate(this.session);
        createAggregate.setForce(bl);
        String string = this.readIdentifierWithSchema();
        if (this.isKeyword(string) || Function.getFunction(this.database, string) != null || this.getAggregateType(string) != null) {
            throw DbException.get(90076, string);
        }
        createAggregate.setName(string);
        createAggregate.setSchema(this.getSchema());
        createAggregate.setIfNotExists(bl2);
        this.read(18);
        createAggregate.setJavaClassMethod(this.readUniqueIdentifier());
        return createAggregate;
    }

    private CreateDomain parseCreateDomain() {
        boolean bl = this.readIfNotExists();
        CreateDomain createDomain = new CreateDomain(this.session);
        createDomain.setTypeName(this.readUniqueIdentifier());
        this.read("AS");
        Column column = this.parseColumnForTable("VALUE", true, false);
        if (this.readIf(6)) {
            Expression expression = this.readExpression();
            column.addCheckConstraint(this.session, expression);
        }
        column.rename(null);
        createDomain.setColumn(column);
        createDomain.setIfNotExists(bl);
        return createDomain;
    }

    private CreateTrigger parseCreateTrigger(boolean bl) {
        boolean bl2;
        boolean bl3;
        boolean bl4 = this.readIfNotExists();
        String string = this.readIdentifierWithSchema(null);
        Schema schema = this.getSchema();
        if (this.readIf("INSTEAD")) {
            this.read("OF");
            bl3 = true;
            bl2 = true;
        } else if (this.readIf("BEFORE")) {
            bl2 = false;
            bl3 = true;
        } else {
            this.read("AFTER");
            bl2 = false;
            bl3 = false;
        }
        int n = 0;
        boolean bl5 = false;
        do {
            if (this.readIf("INSERT")) {
                n |= 1;
                continue;
            }
            if (this.readIf("UPDATE")) {
                n |= 2;
                continue;
            }
            if (this.readIf("DELETE")) {
                n |= 4;
                continue;
            }
            if (this.readIf(47)) {
                n |= 8;
                continue;
            }
            if (this.readIf("ROLLBACK")) {
                bl5 = true;
                continue;
            }
            throw this.getSyntaxError();
        } while (this.readIf(73) || this.database.getMode().getEnum() == Mode.ModeEnum.PostgreSQL && this.readIf("OR"));
        this.read(40);
        String string2 = this.readIdentifierWithSchema();
        this.checkSchema(schema);
        CreateTrigger createTrigger = new CreateTrigger(this.session, this.getSchema());
        createTrigger.setForce(bl);
        createTrigger.setTriggerName(string);
        createTrigger.setIfNotExists(bl4);
        createTrigger.setInsteadOf(bl2);
        createTrigger.setBefore(bl3);
        createTrigger.setOnRollback(bl5);
        createTrigger.setTypeMask(n);
        createTrigger.setTableName(string2);
        if (this.readIf(18)) {
            this.read("EACH");
            this.read(44);
            createTrigger.setRowBased(true);
        } else {
            createTrigger.setRowBased(false);
        }
        if (this.readIf("QUEUE")) {
            createTrigger.setQueueSize(this.readNonNegativeInt());
        }
        createTrigger.setNoWait(this.readIf("NOWAIT"));
        if (this.readIf("AS")) {
            createTrigger.setTriggerSource(this.readString());
        } else {
            this.read("CALL");
            createTrigger.setTriggerClassName(this.readUniqueIdentifier());
        }
        return createTrigger;
    }

    private CreateUser parseCreateUser() {
        CreateUser createUser = new CreateUser(this.session);
        createUser.setIfNotExists(this.readIfNotExists());
        createUser.setUserName(this.readUniqueIdentifier());
        createUser.setComment(this.readCommentIf());
        if (this.readIf("PASSWORD")) {
            createUser.setPassword(this.readExpression());
        } else if (this.readIf("SALT")) {
            createUser.setSalt(this.readExpression());
            this.read("HASH");
            createUser.setHash(this.readExpression());
        } else if (this.readIf("IDENTIFIED")) {
            this.read("BY");
            createUser.setPassword(ValueExpression.get(ValueString.get(this.readColumnIdentifier())));
        } else {
            throw this.getSyntaxError();
        }
        if (this.readIf("ADMIN")) {
            createUser.setAdmin(true);
        }
        return createUser;
    }

    private CreateFunctionAlias parseCreateFunctionAlias(boolean bl) {
        boolean bl2;
        String string;
        boolean bl3 = this.readIfNotExists();
        if (this.currentTokenType != 2) {
            string = this.currentToken;
            this.read();
            this.schemaName = this.session.getCurrentSchemaName();
        } else {
            string = this.readIdentifierWithSchema();
        }
        boolean bl4 = bl2 = Function.getFunction(this.database, string) != null;
        if (!(this.database.isAllowBuiltinAliasOverride() && bl2 || !this.isKeyword(string) && !bl2 && this.getAggregateType(string) == null)) {
            throw DbException.get(90076, string);
        }
        CreateFunctionAlias createFunctionAlias = new CreateFunctionAlias(this.session, this.getSchema());
        createFunctionAlias.setForce(bl);
        createFunctionAlias.setAliasName(string);
        createFunctionAlias.setIfNotExists(bl3);
        createFunctionAlias.setDeterministic(this.readIf("DETERMINISTIC"));
        createFunctionAlias.setBufferResultSetToLocalTemp(!this.readIf("NOBUFFER"));
        if (this.readIf("AS")) {
            createFunctionAlias.setSource(this.readString());
        } else {
            this.read(18);
            createFunctionAlias.setJavaClassMethod(this.readUniqueIdentifier());
        }
        return createFunctionAlias;
    }

    private Prepared parseWith() {
        ArrayList<TableView> arrayList = new ArrayList<TableView>();
        try {
            return this.parseWith1(arrayList);
        }
        catch (Throwable throwable) {
            CommandContainer.clearCTE(this.session, arrayList);
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Prepared parseWith1(List<TableView> list) {
        Prepared prepared;
        this.readIf("RECURSIVE");
        boolean bl = !this.session.isParsingCreateView();
        do {
            list.add(this.parseSingleCommonTableExpression(bl));
        } while (this.readIf(73));
        Collections.reverse(list);
        int n = 0;
        while (this.readIf(69)) {
            ++n;
        }
        if (this.isToken(47) || this.isToken(52)) {
            prepared = this.parseWithQuery();
        } else if (this.isToken(48)) {
            int n2 = this.lastParseIndex;
            this.read();
            if (this.isToken(69)) throw DbException.get(42000, WITH_STATEMENT_SUPPORTS_LIMITED_SUB_STATEMENTS);
            this.parseIndex = n2;
            this.read();
            prepared = this.parseWithQuery();
        } else if (this.readIf("INSERT")) {
            prepared = this.parseInsert();
            prepared.setPrepareAlways(true);
        } else if (this.readIf("UPDATE")) {
            prepared = this.parseUpdate();
            prepared.setPrepareAlways(true);
        } else if (this.readIf("MERGE")) {
            prepared = this.parseMerge();
            prepared.setPrepareAlways(true);
        } else if (this.readIf("DELETE")) {
            prepared = this.parseDelete();
            prepared.setPrepareAlways(true);
        } else {
            if (!this.readIf("CREATE")) throw DbException.get(42000, WITH_STATEMENT_SUPPORTS_LIMITED_SUB_STATEMENTS);
            if (!this.isToken(48)) {
                throw DbException.get(42000, WITH_STATEMENT_SUPPORTS_LIMITED_SUB_STATEMENTS);
            }
            prepared = this.parseCreate();
            prepared.setPrepareAlways(true);
        }
        while (n > 0) {
            this.read(70);
            --n;
        }
        if (!bl) return prepared;
        prepared.setCteCleanups(list);
        return prepared;
    }

    private Prepared parseWithQuery() {
        Query query = this.parseSelectUnion();
        query.setPrepareAlways(true);
        query.setNeverLazy(true);
        return query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TableView parseSingleCommonTableExpression(boolean bl) {
        List<Column> list;
        String[] stringArray;
        Object object;
        String string = this.readIdentifierWithSchema();
        Schema schema = this.getSchema();
        ArrayList<Column> arrayList = Utils.newSmallArrayList();
        String[] stringArray2 = null;
        if (this.readIf(69)) {
            stringArray2 = this.parseColumnList();
            object = stringArray2;
            int n = ((String[])object).length;
            for (int i = 0; i < n; ++i) {
                stringArray = object[i];
                arrayList.add(new Column((String)stringArray, 13));
            }
        }
        if ((object = !bl ? this.getSchema().findTableOrView(this.session, string) : this.session.findLocalTempTable(string)) != null) {
            if (!(object instanceof TableView)) {
                throw DbException.get(42101, string);
            }
            TableView tableView = (TableView)object;
            if (!tableView.isTableExpression()) {
                throw DbException.get(42101, string);
            }
            if (!bl) {
                ((Table)object).lock(this.session, true, true);
                this.database.removeSchemaObject(this.session, (SchemaObject)object);
            } else {
                this.session.removeLocalTempTable((Table)object);
            }
        }
        Table table = TableView.createShadowTableForRecursiveTableExpression(bl, this.session, string, schema, arrayList, this.database);
        stringArray = new String[]{null};
        try {
            this.read("AS");
            this.read(69);
            Query query = this.parseSelect();
            if (!bl) {
                query.session = this.session;
            }
            this.read(70);
            list = TableView.createQueryColumnTemplateList(stringArray2, query, stringArray);
        }
        finally {
            TableView.destroyShadowTableForRecursiveExpression(bl, this.session, table);
        }
        return this.createCTEView(string, stringArray[0], list, true, true, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TableView createCTEView(String string, String string2, List<Column> list, boolean bl, boolean bl2, boolean bl3) {
        TableView tableView;
        Database database = this.session.getDatabase();
        Schema schema = this.getSchemaWithDefault();
        int n = database.allocateObjectId();
        Column[] columnArray = list.toArray(new Column[0]);
        Session session2 = this.session;
        synchronized (session2) {
            tableView = new TableView(schema, n, string, string2, this.parameters, columnArray, this.session, bl, false, true, bl3);
            if (!tableView.isRecursiveQueryDetected() && bl) {
                if (!bl3) {
                    database.addSchemaObject(this.session, tableView);
                    tableView.lock(this.session, true, true);
                    database.removeSchemaObject(this.session, tableView);
                } else {
                    this.session.removeLocalTempTable(tableView);
                }
                tableView = new TableView(schema, n, string, string2, this.parameters, columnArray, this.session, false, false, true, bl3);
            }
            database.unlockMeta(this.session);
        }
        tableView.setTableExpression(true);
        tableView.setTemporary(bl3);
        tableView.setHidden(true);
        tableView.setOnCommitDrop(false);
        if (bl2) {
            if (!bl3) {
                database.addSchemaObject(this.session, tableView);
                tableView.unlock(this.session);
                database.unlockMeta(this.session);
            } else {
                this.session.addLocalTempTable(tableView);
            }
        }
        return tableView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CreateView parseCreateView(boolean bl, boolean bl2) {
        Object object;
        CreateView createView;
        boolean bl3 = this.readIfNotExists();
        boolean bl4 = this.readIf("TABLE_EXPRESSION");
        String string = this.readIdentifierWithSchema();
        this.createView = createView = new CreateView(this.session, this.getSchema());
        createView.setViewName(string);
        createView.setIfNotExists(bl3);
        createView.setComment(this.readCommentIf());
        createView.setOrReplace(bl2);
        createView.setForce(bl);
        createView.setTableExpression(bl4);
        if (this.readIf(69)) {
            object = this.parseColumnList();
            createView.setColumnNames((String[])object);
        }
        object = StringUtils.cache(this.sqlCommand.substring(this.parseIndex));
        this.read("AS");
        try {
            Query query;
            this.session.setParsingCreateView(true, string);
            try {
                query = this.parseSelect();
                query.prepare();
            }
            finally {
                this.session.setParsingCreateView(false, string);
            }
            createView.setSelect(query);
        }
        catch (DbException dbException) {
            if (bl) {
                createView.setSelectSQL((String)object);
                while (this.currentTokenType != 57) {
                    this.read();
                }
            }
            throw dbException;
        }
        return createView;
    }

    private TransactionCommand parseCheckpoint() {
        TransactionCommand transactionCommand = this.readIf("SYNC") ? new TransactionCommand(this.session, 76) : new TransactionCommand(this.session, 73);
        return transactionCommand;
    }

    private Prepared parseAlter() {
        if (this.readIf(48)) {
            return this.parseAlterTable();
        }
        if (this.readIf("USER")) {
            return this.parseAlterUser();
        }
        if (this.readIf("INDEX")) {
            return this.parseAlterIndex();
        }
        if (this.readIf("SCHEMA")) {
            return this.parseAlterSchema();
        }
        if (this.readIf("SEQUENCE")) {
            return this.parseAlterSequence();
        }
        if (this.readIf("VIEW")) {
            return this.parseAlterView();
        }
        throw this.getSyntaxError();
    }

    private void checkSchema(Schema schema) {
        if (schema != null && this.getSchema() != schema) {
            throw DbException.get(90080);
        }
    }

    private AlterIndexRename parseAlterIndex() {
        boolean bl = this.readIfExists(false);
        String string = this.readIdentifierWithSchema();
        Schema schema = this.getSchema();
        AlterIndexRename alterIndexRename = new AlterIndexRename(this.session);
        alterIndexRename.setOldSchema(schema);
        alterIndexRename.setOldName(string);
        alterIndexRename.setIfExists(bl);
        this.read("RENAME");
        this.read("TO");
        String string2 = this.readIdentifierWithSchema(schema.getName());
        this.checkSchema(schema);
        alterIndexRename.setNewName(string2);
        return alterIndexRename;
    }

    private DefineCommand parseAlterView() {
        boolean bl = this.readIfExists(false);
        String string = this.readIdentifierWithSchema();
        Schema schema = this.getSchema();
        Table table = schema.findTableOrView(this.session, string);
        if (!(table instanceof TableView) && !bl) {
            throw DbException.get(90037, string);
        }
        if (this.readIf("RENAME")) {
            this.read("TO");
            String string2 = this.readIdentifierWithSchema(schema.getName());
            this.checkSchema(schema);
            AlterTableRename alterTableRename = new AlterTableRename(this.session, this.getSchema());
            alterTableRename.setOldTableName(string);
            alterTableRename.setNewTableName(string2);
            alterTableRename.setIfTableExists(bl);
            return alterTableRename;
        }
        this.read("RECOMPILE");
        TableView tableView = (TableView)table;
        AlterView alterView = new AlterView(this.session);
        alterView.setIfExists(bl);
        alterView.setView(tableView);
        return alterView;
    }

    private Prepared parseAlterSchema() {
        boolean bl = this.readIfExists(false);
        String string = this.readIdentifierWithSchema();
        Schema schema = this.getSchema();
        this.read("RENAME");
        this.read("TO");
        String string2 = this.readIdentifierWithSchema(schema.getName());
        Schema schema2 = this.findSchema(string);
        if (schema2 == null) {
            if (bl) {
                return new NoOperation(this.session);
            }
            throw DbException.get(90079, string);
        }
        AlterSchemaRename alterSchemaRename = new AlterSchemaRename(this.session);
        alterSchemaRename.setOldSchema(schema2);
        this.checkSchema(schema);
        alterSchemaRename.setNewName(string2);
        return alterSchemaRename;
    }

    private AlterSequence parseAlterSequence() {
        boolean bl = this.readIfExists(false);
        String string = this.readIdentifierWithSchema();
        AlterSequence alterSequence = new AlterSequence(this.session, this.getSchema());
        alterSequence.setSequenceName(string);
        alterSequence.setIfExists(bl);
        SequenceOptions sequenceOptions = new SequenceOptions();
        this.parseSequenceOptions(sequenceOptions, null, false);
        alterSequence.setOptions(sequenceOptions);
        return alterSequence;
    }

    private void parseSequenceOptions(SequenceOptions sequenceOptions, CreateSequence createSequence, boolean bl) {
        while (true) {
            if (this.readIf(bl ? "START" : "RESTART")) {
                this.readIf(55);
                sequenceOptions.setStartValue(this.readExpression());
                continue;
            }
            if (this.readIf("INCREMENT")) {
                this.readIf("BY");
                sequenceOptions.setIncrement(this.readExpression());
                continue;
            }
            if (this.readIf("MINVALUE")) {
                sequenceOptions.setMinValue(this.readExpression());
                continue;
            }
            if (this.readIf("NOMINVALUE")) {
                sequenceOptions.setMinValue(ValueExpression.getNull());
                continue;
            }
            if (this.readIf("MAXVALUE")) {
                sequenceOptions.setMaxValue(this.readExpression());
                continue;
            }
            if (this.readIf("NOMAXVALUE")) {
                sequenceOptions.setMaxValue(ValueExpression.getNull());
                continue;
            }
            if (this.readIf("CYCLE")) {
                sequenceOptions.setCycle(true);
                continue;
            }
            if (this.readIf("NOCYCLE")) {
                sequenceOptions.setCycle(false);
                continue;
            }
            if (this.readIf("NO")) {
                if (this.readIf("MINVALUE")) {
                    sequenceOptions.setMinValue(ValueExpression.getNull());
                    continue;
                }
                if (this.readIf("MAXVALUE")) {
                    sequenceOptions.setMaxValue(ValueExpression.getNull());
                    continue;
                }
                if (this.readIf("CYCLE")) {
                    sequenceOptions.setCycle(false);
                    continue;
                }
                if (!this.readIf("CACHE")) break;
                sequenceOptions.setCacheSize(ValueExpression.get(ValueLong.get(1L)));
                continue;
            }
            if (this.readIf("CACHE")) {
                sequenceOptions.setCacheSize(this.readExpression());
                continue;
            }
            if (this.readIf("NOCACHE")) {
                sequenceOptions.setCacheSize(ValueExpression.get(ValueLong.get(1L)));
                continue;
            }
            if (createSequence == null) break;
            if (this.readIf("BELONGS_TO_TABLE")) {
                createSequence.setBelongsToTable(true);
                continue;
            }
            if (!this.readIf(41)) break;
        }
    }

    private AlterUser parseAlterUser() {
        String string = this.readUniqueIdentifier();
        if (this.readIf("SET")) {
            AlterUser alterUser = new AlterUser(this.session);
            alterUser.setType(19);
            alterUser.setUser(this.database.getUser(string));
            if (this.readIf("PASSWORD")) {
                alterUser.setPassword(this.readExpression());
            } else if (this.readIf("SALT")) {
                alterUser.setSalt(this.readExpression());
                this.read("HASH");
                alterUser.setHash(this.readExpression());
            } else {
                throw this.getSyntaxError();
            }
            return alterUser;
        }
        if (this.readIf("RENAME")) {
            this.read("TO");
            AlterUser alterUser = new AlterUser(this.session);
            alterUser.setType(18);
            alterUser.setUser(this.database.getUser(string));
            String string2 = this.readUniqueIdentifier();
            alterUser.setNewName(string2);
            return alterUser;
        }
        if (this.readIf("ADMIN")) {
            AlterUser alterUser = new AlterUser(this.session);
            alterUser.setType(17);
            User user = this.database.getUser(string);
            alterUser.setUser(user);
            if (this.readIf(49)) {
                alterUser.setAdmin(true);
            } else if (this.readIf(16)) {
                alterUser.setAdmin(false);
            } else {
                throw this.getSyntaxError();
            }
            return alterUser;
        }
        throw this.getSyntaxError();
    }

    private void readIfEqualOrTo() {
        if (!this.readIf(59)) {
            this.readIf("TO");
        }
    }

    private Prepared parseSet() {
        int n;
        if (this.readIf(65)) {
            Set set = new Set(this.session, 34);
            set.setString(this.readAliasIdentifier());
            this.readIfEqualOrTo();
            set.setExpression(this.readExpression());
            return set;
        }
        if (this.readIf("AUTOCOMMIT")) {
            this.readIfEqualOrTo();
            boolean bl = this.readBooleanSetting();
            int n2 = bl ? 69 : 70;
            return new TransactionCommand(this.session, n2);
        }
        if (this.readIf("MVCC")) {
            this.readIfEqualOrTo();
            this.readBooleanSetting();
            return new NoOperation(this.session);
        }
        if (this.readIf("EXCLUSIVE")) {
            this.readIfEqualOrTo();
            Set set = new Set(this.session, 32);
            set.setExpression(this.readExpression());
            return set;
        }
        if (this.readIf("IGNORECASE")) {
            this.readIfEqualOrTo();
            boolean bl = this.readBooleanSetting();
            Set set = new Set(this.session, 1);
            set.setInt(bl ? 1 : 0);
            return set;
        }
        if (this.readIf("PASSWORD")) {
            this.readIfEqualOrTo();
            AlterUser alterUser = new AlterUser(this.session);
            alterUser.setType(19);
            alterUser.setUser(this.session.getUser());
            alterUser.setPassword(this.readExpression());
            return alterUser;
        }
        if (this.readIf("SALT")) {
            this.readIfEqualOrTo();
            AlterUser alterUser = new AlterUser(this.session);
            alterUser.setType(19);
            alterUser.setUser(this.session.getUser());
            alterUser.setSalt(this.readExpression());
            this.read("HASH");
            alterUser.setHash(this.readExpression());
            return alterUser;
        }
        if (this.readIf("MODE")) {
            this.readIfEqualOrTo();
            Set set = new Set(this.session, 3);
            set.setString(this.readAliasIdentifier());
            return set;
        }
        if (this.readIf("COMPRESS_LOB")) {
            this.readIfEqualOrTo();
            Set set = new Set(this.session, 23);
            if (this.currentTokenType == 58) {
                set.setString(this.readString());
            } else {
                set.setString(this.readUniqueIdentifier());
            }
            return set;
        }
        if (this.readIf("DATABASE")) {
            this.readIfEqualOrTo();
            this.read("COLLATION");
            return this.parseSetCollation();
        }
        if (this.readIf("COLLATION")) {
            this.readIfEqualOrTo();
            return this.parseSetCollation();
        }
        if (this.readIf("BINARY_COLLATION")) {
            this.readIfEqualOrTo();
            return this.parseSetBinaryCollation(37);
        }
        if (this.readIf("UUID_COLLATION")) {
            this.readIfEqualOrTo();
            return this.parseSetBinaryCollation(50);
        }
        if (this.readIf("CLUSTER")) {
            this.readIfEqualOrTo();
            Set set = new Set(this.session, 13);
            set.setString(this.readString());
            return set;
        }
        if (this.readIf("DATABASE_EVENT_LISTENER")) {
            this.readIfEqualOrTo();
            Set set = new Set(this.session, 15);
            set.setString(this.readString());
            return set;
        }
        if (this.readIf("ALLOW_LITERALS")) {
            this.readIfEqualOrTo();
            Set set = new Set(this.session, 24);
            if (this.readIf("NONE")) {
                set.setInt(0);
            } else if (this.readIf(3)) {
                set.setInt(2);
            } else if (this.readIf("NUMBERS")) {
                set.setInt(1);
            } else {
                set.setInt(this.readNonNegativeInt());
            }
            return set;
        }
        if (this.readIf("DEFAULT_TABLE_TYPE")) {
            this.readIfEqualOrTo();
            Set set = new Set(this.session, 7);
            if (this.readIf("MEMORY")) {
                set.setInt(1);
            } else if (this.readIf("CACHED")) {
                set.setInt(0);
            } else {
                set.setInt(this.readNonNegativeInt());
            }
            return set;
        }
        if (this.readIf("CREATE")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("HSQLDB.DEFAULT_TABLE_TYPE")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("PAGE_STORE")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("CACHE_TYPE")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("FILE_LOCK")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("DB_CLOSE_ON_EXIT")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("AUTO_SERVER")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("AUTO_SERVER_PORT")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("AUTO_RECONNECT")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("ASSERT")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("ACCESS_MODE_DATA")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("OPEN_NEW")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("JMX")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("PAGE_SIZE")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("RECOVER")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("NAMES")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("SCOPE_GENERATED_KEYS")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("SCHEMA")) {
            this.readIfEqualOrTo();
            Set set = new Set(this.session, 26);
            set.setString(this.readAliasIdentifier());
            return set;
        }
        if (this.readIf("DATESTYLE")) {
            String string;
            this.readIfEqualOrTo();
            if (!this.readIf("ISO") && !this.equalsToken(string = this.readString(), "ISO")) {
                throw this.getSyntaxError();
            }
            return new NoOperation(this.session);
        }
        if (this.readIf("SEARCH_PATH") || this.readIf(SetTypes.getTypeName(28))) {
            this.readIfEqualOrTo();
            Set set = new Set(this.session, 28);
            ArrayList<String> arrayList = Utils.newSmallArrayList();
            do {
                arrayList.add(this.readAliasIdentifier());
            } while (this.readIf(73));
            set.setStringArray(arrayList.toArray(new String[0]));
            return set;
        }
        if (this.readIf("JAVA_OBJECT_SERIALIZER")) {
            this.readIfEqualOrTo();
            return this.parseSetJavaObjectSerializer();
        }
        if (this.isToken("LOGSIZE")) {
            this.currentToken = SetTypes.getTypeName(2);
        }
        if (this.isToken("FOREIGN_KEY_CHECKS")) {
            this.currentToken = SetTypes.getTypeName(30);
        }
        String string = this.currentToken;
        if (!this.identifiersToUpper) {
            string = StringUtils.toUpperEnglish(string);
        }
        if ((n = SetTypes.getType(string)) < 0) {
            throw this.getSyntaxError();
        }
        this.read();
        this.readIfEqualOrTo();
        Set set = new Set(this.session, n);
        set.setExpression(this.readExpression());
        return set;
    }

    private Prepared parseUse() {
        this.readIfEqualOrTo();
        Set set = new Set(this.session, 26);
        set.setString(this.readAliasIdentifier());
        return set;
    }

    private Set parseSetCollation() {
        Set set = new Set(this.session, 12);
        String string = this.readAliasIdentifier();
        set.setString(string);
        if (this.equalsToken(string, "OFF")) {
            return set;
        }
        Collator collator = CompareMode.getCollator(string);
        if (collator == null) {
            throw DbException.getInvalidValueException("collation", string);
        }
        if (this.readIf("STRENGTH")) {
            if (this.readIf(42)) {
                set.setInt(0);
            } else if (this.readIf("SECONDARY")) {
                set.setInt(1);
            } else if (this.readIf("TERTIARY")) {
                set.setInt(2);
            } else if (this.readIf("IDENTICAL")) {
                set.setInt(3);
            }
        } else {
            set.setInt(collator.getStrength());
        }
        return set;
    }

    private Set parseSetBinaryCollation(int n) {
        String string = this.readAliasIdentifier();
        if (this.equalsToken(string, "UNSIGNED") || this.equalsToken(string, "SIGNED")) {
            Set set = new Set(this.session, n);
            set.setString(string);
            return set;
        }
        throw DbException.getInvalidValueException(SetTypes.getTypeName(n), string);
    }

    private Set parseSetJavaObjectSerializer() {
        Set set = new Set(this.session, 38);
        String string = this.readString();
        set.setString(string);
        return set;
    }

    private RunScriptCommand parseRunScript() {
        RunScriptCommand runScriptCommand = new RunScriptCommand(this.session);
        this.read(20);
        runScriptCommand.setFileNameExpr(this.readExpression());
        if (this.readIf("COMPRESSION")) {
            runScriptCommand.setCompressionAlgorithm(this.readUniqueIdentifier());
        }
        if (this.readIf("CIPHER")) {
            runScriptCommand.setCipher(this.readUniqueIdentifier());
            if (this.readIf("PASSWORD")) {
                runScriptCommand.setPassword(this.readExpression());
            }
        }
        if (this.readIf("CHARSET")) {
            runScriptCommand.setCharset(Charset.forName(this.readString()));
        }
        return runScriptCommand;
    }

    private ScriptCommand parseScript() {
        ScriptCommand scriptCommand = new ScriptCommand(this.session);
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        if (this.readIf("NODATA")) {
            bl = false;
        } else {
            if (this.readIf("SIMPLE")) {
                bl5 = true;
            }
            if (this.readIf("COLUMNS")) {
                bl6 = true;
            }
        }
        if (this.readIf("NOPASSWORDS")) {
            bl2 = false;
        }
        if (this.readIf("NOSETTINGS")) {
            bl3 = false;
        }
        if (this.readIf("DROP")) {
            bl4 = true;
        }
        if (this.readIf("BLOCKSIZE")) {
            long l = this.readLong();
            scriptCommand.setLobBlockSize(l);
        }
        scriptCommand.setData(bl);
        scriptCommand.setPasswords(bl2);
        scriptCommand.setSettings(bl3);
        scriptCommand.setDrop(bl4);
        scriptCommand.setSimple(bl5);
        scriptCommand.setWithColumns(bl6);
        if (this.readIf("TO")) {
            scriptCommand.setFileNameExpr(this.readExpression());
            if (this.readIf("COMPRESSION")) {
                scriptCommand.setCompressionAlgorithm(this.readUniqueIdentifier());
            }
            if (this.readIf("CIPHER")) {
                scriptCommand.setCipher(this.readUniqueIdentifier());
                if (this.readIf("PASSWORD")) {
                    scriptCommand.setPassword(this.readExpression());
                }
            }
            if (this.readIf("CHARSET")) {
                scriptCommand.setCharset(Charset.forName(this.readString()));
            }
        }
        if (this.readIf("SCHEMA")) {
            HashSet<String> hashSet = new HashSet<String>();
            do {
                hashSet.add(this.readUniqueIdentifier());
            } while (this.readIf(73));
            scriptCommand.setSchemaNames(hashSet);
        } else if (this.readIf(48)) {
            ArrayList<Table> arrayList = Utils.newSmallArrayList();
            do {
                arrayList.add(this.readTableOrView());
            } while (this.readIf(73));
            scriptCommand.setTables(arrayList);
        }
        return scriptCommand;
    }

    boolean isDualTable(String string) {
        return (this.schemaName == null || this.equalsToken(this.schemaName, "SYS")) && this.equalsToken("DUAL", string) || this.database.getMode().sysDummy1 && (this.schemaName == null || this.equalsToken(this.schemaName, "SYSIBM")) && this.equalsToken("SYSDUMMY1", string);
    }

    private Table readTableOrView() {
        return this.readTableOrView(this.readIdentifierWithSchema(null));
    }

    private Table readTableOrView(String string) {
        if (this.schemaName != null) {
            Table table = this.getSchema().resolveTableOrView(this.session, string);
            if (table != null) {
                return table;
            }
        } else {
            Table table = this.database.getSchema(this.session.getCurrentSchemaName()).resolveTableOrView(this.session, string);
            if (table != null) {
                return table;
            }
            String[] stringArray = this.session.getSchemaSearchPath();
            if (stringArray != null) {
                for (String string2 : stringArray) {
                    Schema schema = this.database.getSchema(string2);
                    table = schema.resolveTableOrView(this.session, string);
                    if (table == null) continue;
                    return table;
                }
            }
        }
        if (this.isDualTable(string)) {
            return this.getDualTable(false);
        }
        throw DbException.get(42102, string);
    }

    private FunctionAlias findFunctionAlias(String string, String string2) {
        FunctionAlias functionAlias = this.database.getSchema(string).findFunction(string2);
        if (functionAlias != null) {
            return functionAlias;
        }
        String[] stringArray = this.session.getSchemaSearchPath();
        if (stringArray != null) {
            for (String string3 : stringArray) {
                functionAlias = this.database.getSchema(string3).findFunction(string2);
                if (functionAlias == null) continue;
                return functionAlias;
            }
        }
        return null;
    }

    private Sequence findSequence(String string, String string2) {
        Sequence sequence = this.database.getSchema(string).findSequence(string2);
        if (sequence != null) {
            return sequence;
        }
        String[] stringArray = this.session.getSchemaSearchPath();
        if (stringArray != null) {
            for (String string3 : stringArray) {
                sequence = this.database.getSchema(string3).findSequence(string2);
                if (sequence == null) continue;
                return sequence;
            }
        }
        return null;
    }

    private Sequence readSequence() {
        String string = this.readIdentifierWithSchema(null);
        if (this.schemaName != null) {
            return this.getSchema().getSequence(string);
        }
        Sequence sequence = this.findSequence(this.session.getCurrentSchemaName(), string);
        if (sequence != null) {
            return sequence;
        }
        throw DbException.get(90036, string);
    }

    private Prepared parseAlterTable() {
        boolean bl = this.readIfExists(false);
        String string = this.readIdentifierWithSchema();
        Schema schema = this.getSchema();
        if (this.readIf("ADD")) {
            DefineCommand defineCommand = this.parseAlterTableAddConstraintIf(string, schema, bl);
            if (defineCommand != null) {
                return defineCommand;
            }
            return this.parseAlterTableAddColumn(string, schema, bl);
        }
        if (this.readIf("SET")) {
            this.read("REFERENTIAL_INTEGRITY");
            int n = 55;
            boolean bl2 = this.readBooleanSetting();
            AlterTableSet alterTableSet = new AlterTableSet(this.session, schema, n, bl2);
            alterTableSet.setTableName(string);
            alterTableSet.setIfTableExists(bl);
            if (this.readIf(6)) {
                alterTableSet.setCheckExisting(true);
            } else if (this.readIf("NOCHECK")) {
                alterTableSet.setCheckExisting(false);
            }
            return alterTableSet;
        }
        if (this.readIf("RENAME")) {
            if (this.readIf("COLUMN")) {
                String string2 = this.readColumnIdentifier();
                this.read("TO");
                AlterTableRenameColumn alterTableRenameColumn = new AlterTableRenameColumn(this.session, schema);
                alterTableRenameColumn.setTableName(string);
                alterTableRenameColumn.setIfTableExists(bl);
                alterTableRenameColumn.setOldColumnName(string2);
                String string3 = this.readColumnIdentifier();
                alterTableRenameColumn.setNewColumnName(string3);
                return alterTableRenameColumn;
            }
            if (this.readIf(7)) {
                String string4 = this.readIdentifierWithSchema(schema.getName());
                this.checkSchema(schema);
                this.read("TO");
                AlterTableRenameConstraint alterTableRenameConstraint = new AlterTableRenameConstraint(this.session, schema);
                alterTableRenameConstraint.setConstraintName(string4);
                String string5 = this.readColumnIdentifier();
                alterTableRenameConstraint.setNewConstraintName(string5);
                return this.commandIfTableExists(schema, string, bl, alterTableRenameConstraint);
            }
            this.read("TO");
            String string6 = this.readIdentifierWithSchema(schema.getName());
            this.checkSchema(schema);
            AlterTableRename alterTableRename = new AlterTableRename(this.session, this.getSchema());
            alterTableRename.setOldTableName(string);
            alterTableRename.setNewTableName(string6);
            alterTableRename.setIfTableExists(bl);
            alterTableRename.setHidden(this.readIf("HIDDEN"));
            return alterTableRename;
        }
        if (this.readIf("DROP")) {
            Object object;
            if (this.readIf(7)) {
                boolean bl3 = this.readIfExists(false);
                String string7 = this.readIdentifierWithSchema(schema.getName());
                bl3 = this.readIfExists(bl3);
                this.checkSchema(schema);
                AlterTableDropConstraint alterTableDropConstraint = new AlterTableDropConstraint(this.session, this.getSchema(), bl3);
                alterTableDropConstraint.setConstraintName(string7);
                return this.commandIfTableExists(schema, string, bl, alterTableDropConstraint);
            }
            if (this.readIf(19)) {
                this.read("KEY");
                String string8 = this.readIdentifierWithSchema(schema.getName());
                this.checkSchema(schema);
                AlterTableDropConstraint alterTableDropConstraint = new AlterTableDropConstraint(this.session, this.getSchema(), false);
                alterTableDropConstraint.setConstraintName(string8);
                return this.commandIfTableExists(schema, string, bl, alterTableDropConstraint);
            }
            if (this.readIf("INDEX")) {
                SchemaCommand schemaCommand;
                String string9 = this.readIdentifierWithSchema(schema.getName());
                if (schema.findIndex(this.session, string9) != null) {
                    DropIndex dropIndex = new DropIndex(this.session, this.getSchema());
                    dropIndex.setIndexName(string9);
                    schemaCommand = dropIndex;
                } else {
                    AlterTableDropConstraint alterTableDropConstraint = new AlterTableDropConstraint(this.session, this.getSchema(), false);
                    alterTableDropConstraint.setConstraintName(string9);
                    schemaCommand = alterTableDropConstraint;
                }
                return this.commandIfTableExists(schema, string, bl, schemaCommand);
            }
            if (this.readIf(42)) {
                this.read("KEY");
                Table table = this.tableIfTableExists(schema, string, bl);
                if (table == null) {
                    return new NoOperation(this.session);
                }
                Index index = table.getPrimaryKey();
                DropIndex dropIndex = new DropIndex(this.session, schema);
                dropIndex.setIndexName(index.getName());
                return dropIndex;
            }
            this.readIf("COLUMN");
            boolean bl4 = this.readIfExists(false);
            ArrayList<Column> arrayList = new ArrayList<Column>();
            Table table = this.tableIfTableExists(schema, string, bl);
            boolean bl5 = this.readIf(69);
            do {
                object = this.readColumnIdentifier();
                if (table == null || bl4 && !table.doesColumnExist((String)object)) continue;
                Column column = table.getColumn((String)object);
                arrayList.add(column);
            } while (this.readIf(73));
            if (bl5) {
                this.read(70);
            }
            if (table == null || arrayList.isEmpty()) {
                return new NoOperation(this.session);
            }
            object = new AlterTableAlterColumn(this.session, schema);
            ((AlterTableAlterColumn)object).setType(12);
            ((AlterTableAlterColumn)object).setTableName(string);
            ((AlterTableAlterColumn)object).setIfTableExists(bl);
            ((AlterTableAlterColumn)object).setColumnsToRemove(arrayList);
            return object;
        }
        if (this.readIf("CHANGE")) {
            this.readIf("COLUMN");
            String string10 = this.readColumnIdentifier();
            String string11 = this.readColumnIdentifier();
            Column column = this.columnIfTableExists(schema, string, string10, bl);
            boolean bl6 = column == null ? true : column.isNullable();
            this.parseColumnForTable(string11, bl6, true);
            AlterTableRenameColumn alterTableRenameColumn = new AlterTableRenameColumn(this.session, schema);
            alterTableRenameColumn.setTableName(string);
            alterTableRenameColumn.setIfTableExists(bl);
            alterTableRenameColumn.setOldColumnName(string10);
            alterTableRenameColumn.setNewColumnName(string11);
            return alterTableRenameColumn;
        }
        if (this.readIf("MODIFY")) {
            AlterTableAlterColumn alterTableAlterColumn;
            this.readIf("COLUMN");
            boolean bl7 = this.readIf(69);
            String string12 = this.readColumnIdentifier();
            NullConstraintType nullConstraintType = this.parseNotNullConstraint();
            switch (nullConstraintType) {
                case NULL_IS_ALLOWED: 
                case NULL_IS_NOT_ALLOWED: {
                    alterTableAlterColumn = new AlterTableAlterColumn(this.session, schema);
                    alterTableAlterColumn.setTableName(string);
                    alterTableAlterColumn.setIfTableExists(bl);
                    Column column = this.columnIfTableExists(schema, string, string12, bl);
                    alterTableAlterColumn.setOldColumn(column);
                    if (nullConstraintType == NullConstraintType.NULL_IS_ALLOWED) {
                        alterTableAlterColumn.setType(9);
                        break;
                    }
                    alterTableAlterColumn.setType(8);
                    break;
                }
                case NO_NULL_CONSTRAINT_FOUND: {
                    alterTableAlterColumn = this.parseAlterTableAlterColumnType(schema, string, string12, bl);
                    break;
                }
                default: {
                    throw DbException.get(90088, "Internal Error - unhandled case: " + nullConstraintType.name());
                }
            }
            if (bl7) {
                this.read(70);
            }
            return alterTableAlterColumn;
        }
        if (this.readIf("ALTER")) {
            this.readIf("COLUMN");
            String string13 = this.readColumnIdentifier();
            Column column = this.columnIfTableExists(schema, string, string13, bl);
            if (this.readIf("RENAME")) {
                this.read("TO");
                AlterTableRenameColumn alterTableRenameColumn = new AlterTableRenameColumn(this.session, schema);
                alterTableRenameColumn.setTableName(string);
                alterTableRenameColumn.setIfTableExists(bl);
                alterTableRenameColumn.setOldColumnName(string13);
                String string14 = this.readColumnIdentifier();
                alterTableRenameColumn.setNewColumnName(string14);
                return alterTableRenameColumn;
            }
            if (this.readIf("DROP")) {
                if (this.readIf("DEFAULT")) {
                    AlterTableAlterColumn alterTableAlterColumn = new AlterTableAlterColumn(this.session, schema);
                    alterTableAlterColumn.setTableName(string);
                    alterTableAlterColumn.setIfTableExists(bl);
                    alterTableAlterColumn.setOldColumn(column);
                    alterTableAlterColumn.setType(10);
                    alterTableAlterColumn.setDefaultExpression(null);
                    return alterTableAlterColumn;
                }
                if (this.readIf(40)) {
                    this.read("UPDATE");
                    AlterTableAlterColumn alterTableAlterColumn = new AlterTableAlterColumn(this.session, schema);
                    alterTableAlterColumn.setTableName(string);
                    alterTableAlterColumn.setIfTableExists(bl);
                    alterTableAlterColumn.setOldColumn(column);
                    alterTableAlterColumn.setType(90);
                    alterTableAlterColumn.setDefaultExpression(null);
                    return alterTableAlterColumn;
                }
                this.read(37);
                this.read(38);
                AlterTableAlterColumn alterTableAlterColumn = new AlterTableAlterColumn(this.session, schema);
                alterTableAlterColumn.setTableName(string);
                alterTableAlterColumn.setIfTableExists(bl);
                alterTableAlterColumn.setOldColumn(column);
                alterTableAlterColumn.setType(9);
                return alterTableAlterColumn;
            }
            if (this.readIf("TYPE")) {
                return this.parseAlterTableAlterColumnDataType(schema, string, string13, bl);
            }
            if (this.readIf("SET")) {
                if (this.readIf("DATA")) {
                    this.read("TYPE");
                    return this.parseAlterTableAlterColumnDataType(schema, string, string13, bl);
                }
                AlterTableAlterColumn alterTableAlterColumn = new AlterTableAlterColumn(this.session, schema);
                alterTableAlterColumn.setTableName(string);
                alterTableAlterColumn.setIfTableExists(bl);
                alterTableAlterColumn.setOldColumn(column);
                NullConstraintType nullConstraintType = this.parseNotNullConstraint();
                switch (nullConstraintType) {
                    case NULL_IS_ALLOWED: {
                        alterTableAlterColumn.setType(9);
                        break;
                    }
                    case NULL_IS_NOT_ALLOWED: {
                        alterTableAlterColumn.setType(8);
                        break;
                    }
                    case NO_NULL_CONSTRAINT_FOUND: {
                        if (this.readIf("DEFAULT")) {
                            Expression expression = this.readExpression();
                            alterTableAlterColumn.setType(10);
                            alterTableAlterColumn.setDefaultExpression(expression);
                            break;
                        }
                        if (this.readIf(40)) {
                            this.read("UPDATE");
                            Expression expression = this.readExpression();
                            alterTableAlterColumn.setType(90);
                            alterTableAlterColumn.setDefaultExpression(expression);
                            break;
                        }
                        if (this.readIf("INVISIBLE")) {
                            alterTableAlterColumn.setType(87);
                            alterTableAlterColumn.setVisible(false);
                            break;
                        }
                        if (!this.readIf("VISIBLE")) break;
                        alterTableAlterColumn.setType(87);
                        alterTableAlterColumn.setVisible(true);
                        break;
                    }
                    default: {
                        throw DbException.get(90088, "Internal Error - unhandled case: " + nullConstraintType.name());
                    }
                }
                return alterTableAlterColumn;
            }
            if (this.readIf("RESTART")) {
                this.readIf(55);
                Expression expression = this.readExpression();
                AlterSequence alterSequence = new AlterSequence(this.session, schema);
                alterSequence.setColumn(column);
                SequenceOptions sequenceOptions = new SequenceOptions();
                sequenceOptions.setStartValue(expression);
                alterSequence.setOptions(sequenceOptions);
                return this.commandIfTableExists(schema, string, bl, alterSequence);
            }
            if (this.readIf("SELECTIVITY")) {
                AlterTableAlterColumn alterTableAlterColumn = new AlterTableAlterColumn(this.session, schema);
                alterTableAlterColumn.setTableName(string);
                alterTableAlterColumn.setIfTableExists(bl);
                alterTableAlterColumn.setType(13);
                alterTableAlterColumn.setOldColumn(column);
                alterTableAlterColumn.setSelectivity(this.readExpression());
                return alterTableAlterColumn;
            }
            return this.parseAlterTableAlterColumnType(schema, string, string13, bl);
        }
        throw this.getSyntaxError();
    }

    private Table tableIfTableExists(Schema schema, String string, boolean bl) {
        Table table = schema.resolveTableOrView(this.session, string);
        if (table == null && !bl) {
            throw DbException.get(42102, string);
        }
        return table;
    }

    private Column columnIfTableExists(Schema schema, String string, String string2, boolean bl) {
        Table table = this.tableIfTableExists(schema, string, bl);
        return table == null ? null : table.getColumn(string2);
    }

    private Prepared commandIfTableExists(Schema schema, String string, boolean bl, Prepared prepared) {
        return this.tableIfTableExists(schema, string, bl) == null ? new NoOperation(this.session) : prepared;
    }

    private AlterTableAlterColumn parseAlterTableAlterColumnType(Schema schema, String string, String string2, boolean bl) {
        Object object;
        Column column = this.columnIfTableExists(schema, string, string2, bl);
        Column column2 = this.parseColumnForTable(string2, column == null ? true : column.isNullable(), true);
        if (this.readIf(6)) {
            object = this.readExpression();
            column2.addCheckConstraint(this.session, (Expression)object);
        }
        object = new AlterTableAlterColumn(this.session, schema);
        ((AlterTableAlterColumn)object).setTableName(string);
        ((AlterTableAlterColumn)object).setIfTableExists(bl);
        ((AlterTableAlterColumn)object).setType(11);
        ((AlterTableAlterColumn)object).setOldColumn(column);
        ((AlterTableAlterColumn)object).setNewColumn(column2);
        return object;
    }

    private AlterTableAlterColumn parseAlterTableAlterColumnDataType(Schema schema, String string, String string2, boolean bl) {
        Object object;
        Column column = this.columnIfTableExists(schema, string, string2, bl);
        Column column2 = this.parseColumnWithType(string2, true);
        if (column != null) {
            String string3;
            if (!column.isNullable()) {
                column2.setNullable(false);
            }
            if (!column.getVisible()) {
                column2.setVisible(false);
            }
            if ((object = column.getDefaultExpression()) != null) {
                column2.setDefaultExpression(this.session, (Expression)object);
            }
            if ((object = column.getOnUpdateExpression()) != null) {
                column2.setOnUpdateExpression(this.session, (Expression)object);
            }
            if ((object = column.getCheckConstraint(this.session, string2)) != null) {
                column2.addCheckConstraint(this.session, (Expression)object);
            }
            if ((string3 = column.getComment()) != null) {
                column2.setComment(string3);
            }
        }
        object = new AlterTableAlterColumn(this.session, schema);
        ((AlterTableAlterColumn)object).setTableName(string);
        ((AlterTableAlterColumn)object).setIfTableExists(bl);
        ((AlterTableAlterColumn)object).setType(11);
        ((AlterTableAlterColumn)object).setOldColumn(column);
        ((AlterTableAlterColumn)object).setNewColumn(column2);
        return object;
    }

    private AlterTableAlterColumn parseAlterTableAddColumn(String string, Schema schema, boolean bl) {
        this.readIf("COLUMN");
        AlterTableAlterColumn alterTableAlterColumn = new AlterTableAlterColumn(this.session, schema);
        alterTableAlterColumn.setType(7);
        alterTableAlterColumn.setTableName(string);
        alterTableAlterColumn.setIfTableExists(bl);
        if (this.readIf(69)) {
            alterTableAlterColumn.setIfNotExists(false);
            do {
                this.parseTableColumnDefinition(alterTableAlterColumn, schema, string, false);
            } while (this.readIfMore(true));
        } else {
            boolean bl2 = this.readIfNotExists();
            alterTableAlterColumn.setIfNotExists(bl2);
            this.parseTableColumnDefinition(alterTableAlterColumn, schema, string, false);
        }
        if (this.readIf("BEFORE")) {
            alterTableAlterColumn.setAddBefore(this.readColumnIdentifier());
        } else if (this.readIf("AFTER")) {
            alterTableAlterColumn.setAddAfter(this.readColumnIdentifier());
        } else if (this.readIf("FIRST")) {
            alterTableAlterColumn.setAddFirst();
        }
        return alterTableAlterColumn;
    }

    private ConstraintActionType parseAction() {
        ConstraintActionType constraintActionType = this.parseCascadeOrRestrict();
        if (constraintActionType != null) {
            return constraintActionType;
        }
        if (this.readIf("NO")) {
            this.read("ACTION");
            return ConstraintActionType.RESTRICT;
        }
        this.read("SET");
        if (this.readIf(38)) {
            return ConstraintActionType.SET_NULL;
        }
        this.read("DEFAULT");
        return ConstraintActionType.SET_DEFAULT;
    }

    private ConstraintActionType parseCascadeOrRestrict() {
        if (this.readIf("CASCADE")) {
            return ConstraintActionType.CASCADE;
        }
        if (this.readIf("RESTRICT")) {
            return ConstraintActionType.RESTRICT;
        }
        return null;
    }

    private DefineCommand parseAlterTableAddConstraintIf(String string, Schema schema, boolean bl) {
        AlterTableAddConstraint alterTableAddConstraint;
        String string2 = null;
        String string3 = null;
        boolean bl2 = false;
        boolean bl3 = this.database.getMode().indexDefinitionInCreateTable;
        boolean bl4 = this.database.getMode().allowAffinityKey;
        if (this.readIf(7)) {
            bl2 = this.readIfNotExists();
            string2 = this.readIdentifierWithSchema(schema.getName());
            this.checkSchema(schema);
            string3 = this.readCommentIf();
            bl3 = true;
        }
        if (this.readIf(42)) {
            this.read("KEY");
            AlterTableAddConstraint alterTableAddConstraint2 = new AlterTableAddConstraint(this.session, schema, bl2);
            alterTableAddConstraint2.setType(6);
            alterTableAddConstraint2.setComment(string3);
            alterTableAddConstraint2.setConstraintName(string2);
            alterTableAddConstraint2.setTableName(string);
            alterTableAddConstraint2.setIfTableExists(bl);
            if (this.readIf("HASH")) {
                alterTableAddConstraint2.setPrimaryKeyHash(true);
            }
            this.read(69);
            alterTableAddConstraint2.setIndexColumns(this.parseIndexColumnList());
            if (this.readIf("INDEX")) {
                String string4 = this.readIdentifierWithSchema();
                alterTableAddConstraint2.setIndex(this.getSchema().findIndex(this.session, string4));
            }
            return alterTableAddConstraint2;
        }
        if (bl3 && (this.isToken("INDEX") || this.isToken("KEY"))) {
            int n = this.lastParseIndex;
            this.read();
            if (DataType.getTypeByName(this.currentToken, this.database.getMode()) != null) {
                this.parseIndex = n;
                this.read();
                return null;
            }
            CreateIndex createIndex = new CreateIndex(this.session, schema);
            createIndex.setComment(string3);
            createIndex.setTableName(string);
            createIndex.setIfTableExists(bl);
            if (!this.readIf(69)) {
                createIndex.setIndexName(this.readUniqueIdentifier());
                this.read(69);
            }
            createIndex.setIndexColumns(this.parseIndexColumnList());
            if (this.readIf("USING")) {
                this.read("BTREE");
            }
            return createIndex;
        }
        if (bl4 && this.readIfAffinity()) {
            this.read("KEY");
            this.read(69);
            CreateIndex createIndex = this.createAffinityIndex(schema, string, this.parseIndexColumnList());
            createIndex.setIfTableExists(bl);
            return createIndex;
        }
        if (this.readIf(6)) {
            alterTableAddConstraint = new AlterTableAddConstraint(this.session, schema, bl2);
            alterTableAddConstraint.setType(3);
            alterTableAddConstraint.setCheckExpression(this.readExpression());
        } else if (this.readIf(51)) {
            this.readIf("KEY");
            this.readIf("INDEX");
            alterTableAddConstraint = new AlterTableAddConstraint(this.session, schema, bl2);
            alterTableAddConstraint.setType(4);
            if (!this.readIf(69)) {
                string2 = this.readUniqueIdentifier();
                this.read(69);
            }
            alterTableAddConstraint.setIndexColumns(this.parseIndexColumnList());
            if (this.readIf("INDEX")) {
                String string5 = this.readIdentifierWithSchema();
                alterTableAddConstraint.setIndex(this.getSchema().findIndex(this.session, string5));
            }
            if (this.readIf("USING")) {
                this.read("BTREE");
            }
        } else if (this.readIf(19)) {
            alterTableAddConstraint = new AlterTableAddConstraint(this.session, schema, bl2);
            alterTableAddConstraint.setType(5);
            this.read("KEY");
            this.read(69);
            alterTableAddConstraint.setIndexColumns(this.parseIndexColumnList());
            if (this.readIf("INDEX")) {
                String string6 = this.readIdentifierWithSchema();
                alterTableAddConstraint.setIndex(schema.findIndex(this.session, string6));
            }
            this.read("REFERENCES");
            this.parseReferences(alterTableAddConstraint, schema, string);
        } else {
            if (string2 != null) {
                throw this.getSyntaxError();
            }
            return null;
        }
        if (this.readIf("NOCHECK")) {
            alterTableAddConstraint.setCheckExisting(false);
        } else {
            this.readIf(6);
            alterTableAddConstraint.setCheckExisting(true);
        }
        alterTableAddConstraint.setTableName(string);
        alterTableAddConstraint.setIfTableExists(bl);
        alterTableAddConstraint.setConstraintName(string2);
        alterTableAddConstraint.setComment(string3);
        return alterTableAddConstraint;
    }

    private void parseReferences(AlterTableAddConstraint alterTableAddConstraint, Schema schema, String string) {
        String string2;
        if (this.readIf(69)) {
            alterTableAddConstraint.setRefTableName(schema, string);
            alterTableAddConstraint.setRefIndexColumns(this.parseIndexColumnList());
        } else {
            string2 = this.readIdentifierWithSchema(schema.getName());
            alterTableAddConstraint.setRefTableName(this.getSchema(), string2);
            if (this.readIf(69)) {
                alterTableAddConstraint.setRefIndexColumns(this.parseIndexColumnList());
            }
        }
        if (this.readIf("INDEX")) {
            string2 = this.readIdentifierWithSchema();
            alterTableAddConstraint.setRefIndex(this.getSchema().findIndex(this.session, string2));
        }
        while (this.readIf(40)) {
            if (this.readIf("DELETE")) {
                alterTableAddConstraint.setDeleteAction(this.parseAction());
                continue;
            }
            this.read("UPDATE");
            alterTableAddConstraint.setUpdateAction(this.parseAction());
        }
        if (this.readIf(37)) {
            this.read("DEFERRABLE");
        } else {
            this.readIf("DEFERRABLE");
        }
    }

    private CreateLinkedTable parseCreateLinkedTable(boolean bl, boolean bl2, boolean bl3) {
        this.read(48);
        boolean bl4 = this.readIfNotExists();
        String string = this.readIdentifierWithSchema();
        CreateLinkedTable createLinkedTable = new CreateLinkedTable(this.session, this.getSchema());
        createLinkedTable.setTemporary(bl);
        createLinkedTable.setGlobalTemporary(bl2);
        createLinkedTable.setForce(bl3);
        createLinkedTable.setIfNotExists(bl4);
        createLinkedTable.setTableName(string);
        createLinkedTable.setComment(this.readCommentIf());
        this.read(69);
        createLinkedTable.setDriver(this.readString());
        this.read(73);
        createLinkedTable.setUrl(this.readString());
        this.read(73);
        createLinkedTable.setUser(this.readString());
        this.read(73);
        createLinkedTable.setPassword(this.readString());
        this.read(73);
        String string2 = this.readString();
        if (this.readIf(73)) {
            createLinkedTable.setOriginalSchema(string2);
            string2 = this.readString();
        }
        createLinkedTable.setOriginalTable(string2);
        this.read(70);
        if (this.readIf("EMIT")) {
            this.read("UPDATES");
            createLinkedTable.setEmitUpdates(true);
        } else if (this.readIf("READONLY")) {
            createLinkedTable.setReadOnly(true);
        }
        return createLinkedTable;
    }

    private CreateTable parseCreateTable(boolean bl, boolean bl2, boolean bl3) {
        boolean bl4 = this.readIfNotExists();
        String string = this.readIdentifierWithSchema();
        if (bl && bl2 && this.equalsToken("SESSION", this.schemaName)) {
            this.schemaName = this.session.getCurrentSchemaName();
            bl2 = false;
        }
        Schema schema = this.getSchema();
        CreateTable createTable = new CreateTable(this.session, schema);
        createTable.setPersistIndexes(bl3);
        createTable.setTemporary(bl);
        createTable.setGlobalTemporary(bl2);
        createTable.setIfNotExists(bl4);
        createTable.setTableName(string);
        createTable.setComment(this.readCommentIf());
        if (this.readIf(69) && !this.readIf(70)) {
            do {
                this.parseTableColumnDefinition(createTable, schema, string, true);
            } while (this.readIfMore(false));
        }
        if (this.readIf("COMMENT") && this.readIf(59)) {
            this.readString();
        }
        if (this.readIf("ENGINE")) {
            if (this.readIf(59)) {
                String string2 = this.readUniqueIdentifier();
                if (!"InnoDb".equalsIgnoreCase(string2) && !"MyISAM".equalsIgnoreCase(string2)) {
                    throw DbException.getUnsupportedException(string2);
                }
            } else {
                createTable.setTableEngine(this.readUniqueIdentifier());
            }
        }
        if (this.readIf(55)) {
            createTable.setTableEngineParams(this.readTableEngineParams());
        }
        if (this.readIf("AUTO_INCREMENT")) {
            this.read(59);
            if (this.currentTokenType != 58 || this.currentValue.getValueType() != 4) {
                throw DbException.getSyntaxError(this.sqlCommand, this.parseIndex, "integer");
            }
            this.read();
        }
        this.readIf("DEFAULT");
        if (this.readIf("CHARSET")) {
            this.read(59);
            if (!this.readIf("UTF8")) {
                this.read("UTF8MB4");
            }
        }
        if (bl) {
            if (this.readIf(40)) {
                this.read("COMMIT");
                if (this.readIf("DROP")) {
                    createTable.setOnCommitDrop();
                } else if (this.readIf("DELETE")) {
                    this.read("ROWS");
                    createTable.setOnCommitTruncate();
                }
            } else if (this.readIf(37)) {
                if (this.readIf("PERSISTENT")) {
                    createTable.setPersistData(false);
                } else {
                    this.read("LOGGED");
                }
            }
            if (this.readIf("TRANSACTIONAL")) {
                createTable.setTransactional(true);
            }
        } else if (!bl3 && this.readIf(37)) {
            this.read("PERSISTENT");
            createTable.setPersistData(false);
        }
        if (this.readIf("HIDDEN")) {
            createTable.setHidden(true);
        }
        if (this.readIf("AS")) {
            if (this.readIf("SORTED")) {
                createTable.setSortedInsertMode(true);
            }
            createTable.setQuery(this.parseSelect());
            if (this.readIf(55)) {
                createTable.setWithNoData(this.readIf("NO"));
                this.read("DATA");
            }
        }
        if (this.readIf("ROW_FORMAT") && this.readIf(59)) {
            this.readColumnIdentifier();
        }
        return createTable;
    }

    private void parseTableColumnDefinition(CommandWithColumns commandWithColumns, Schema schema, String string, boolean bl) {
        DefineCommand defineCommand = this.parseAlterTableAddConstraintIf(string, schema, false);
        if (defineCommand != null) {
            commandWithColumns.addConstraintCommand(defineCommand);
        } else {
            IndexColumn[] indexColumnArray;
            boolean bl2;
            boolean bl3;
            IndexColumn[] indexColumnArray2;
            String string2 = this.readColumnIdentifier();
            if (bl && (this.currentTokenType == 73 || this.currentTokenType == 70)) {
                commandWithColumns.addColumn(new Column(string2, TypeInfo.TYPE_UNKNOWN));
                return;
            }
            Column column = this.parseColumnForTable(string2, true, true);
            if (column.isAutoIncrement() && column.isPrimaryKey()) {
                column.setPrimaryKey(false);
                indexColumnArray2 = new IndexColumn[]{new IndexColumn()};
                indexColumnArray2[0].columnName = column.getName();
                AlterTableAddConstraint alterTableAddConstraint = new AlterTableAddConstraint(this.session, schema, false);
                alterTableAddConstraint.setType(6);
                alterTableAddConstraint.setTableName(string);
                alterTableAddConstraint.setIndexColumns(indexColumnArray2);
                commandWithColumns.addConstraintCommand(alterTableAddConstraint);
            }
            commandWithColumns.addColumn(column);
            indexColumnArray2 = null;
            if (this.readIf(7)) {
                indexColumnArray2 = this.readColumnIdentifier();
            }
            boolean bl4 = bl3 = (bl2 = this.database.getMode().allowAffinityKey) && this.readIfAffinity();
            if (this.readIf(42)) {
                this.read("KEY");
                boolean bl5 = this.readIf("HASH");
                indexColumnArray = new IndexColumn[]{new IndexColumn()};
                indexColumnArray[0].columnName = column.getName();
                AlterTableAddConstraint alterTableAddConstraint = new AlterTableAddConstraint(this.session, schema, false);
                alterTableAddConstraint.setConstraintName((String)indexColumnArray2);
                alterTableAddConstraint.setPrimaryKeyHash(bl5);
                alterTableAddConstraint.setType(6);
                alterTableAddConstraint.setTableName(string);
                alterTableAddConstraint.setIndexColumns(indexColumnArray);
                commandWithColumns.addConstraintCommand(alterTableAddConstraint);
                if (this.readIf("AUTO_INCREMENT")) {
                    this.parseAutoIncrement(column);
                }
                if (this.database.getMode().useIdentityAsAutoIncrement) {
                    if (this.readIf(37)) {
                        this.read(38);
                        column.setNullable(false);
                    }
                    if (this.readIf("IDENTITY")) {
                        this.parseAutoIncrement(column);
                    }
                }
                if (bl3) {
                    CreateIndex createIndex = this.createAffinityIndex(schema, string, indexColumnArray);
                    commandWithColumns.addConstraintCommand(createIndex);
                }
            } else if (bl3) {
                this.read("KEY");
                IndexColumn[] indexColumnArray3 = new IndexColumn[]{new IndexColumn()};
                indexColumnArray3[0].columnName = column.getName();
                indexColumnArray = this.createAffinityIndex(schema, string, indexColumnArray3);
                commandWithColumns.addConstraintCommand((DefineCommand)indexColumnArray);
            } else if (this.readIf(51)) {
                AlterTableAddConstraint alterTableAddConstraint = new AlterTableAddConstraint(this.session, schema, false);
                alterTableAddConstraint.setConstraintName((String)indexColumnArray2);
                alterTableAddConstraint.setType(4);
                indexColumnArray = new IndexColumn[]{new IndexColumn()};
                indexColumnArray[0].columnName = string2;
                alterTableAddConstraint.setIndexColumns(indexColumnArray);
                alterTableAddConstraint.setTableName(string);
                commandWithColumns.addConstraintCommand(alterTableAddConstraint);
            }
            if (NullConstraintType.NULL_IS_NOT_ALLOWED == this.parseNotNullConstraint()) {
                column.setNullable(false);
            }
            if (this.readIf(6)) {
                Expression expression = this.readExpression();
                column.addCheckConstraint(this.session, expression);
            }
            if (this.readIf("REFERENCES")) {
                AlterTableAddConstraint alterTableAddConstraint = new AlterTableAddConstraint(this.session, schema, false);
                alterTableAddConstraint.setConstraintName((String)indexColumnArray2);
                alterTableAddConstraint.setType(5);
                indexColumnArray = new IndexColumn[]{new IndexColumn()};
                indexColumnArray[0].columnName = string2;
                alterTableAddConstraint.setIndexColumns(indexColumnArray);
                alterTableAddConstraint.setTableName(string);
                this.parseReferences(alterTableAddConstraint, schema, string);
                commandWithColumns.addConstraintCommand(alterTableAddConstraint);
            }
        }
    }

    private NullConstraintType parseNotNullConstraint() {
        NullConstraintType nullConstraintType = NullConstraintType.NO_NULL_CONSTRAINT_FOUND;
        if (this.isToken(37) || this.isToken(38)) {
            if (this.readIf(37)) {
                this.read(38);
                nullConstraintType = NullConstraintType.NULL_IS_NOT_ALLOWED;
            } else {
                this.read(38);
                nullConstraintType = NullConstraintType.NULL_IS_ALLOWED;
            }
            if (this.database.getMode().getEnum() == Mode.ModeEnum.Oracle) {
                if (this.readIf("ENABLE")) {
                    this.readIf("VALIDATE");
                    if (this.readIf("NOVALIDATE")) {
                        nullConstraintType = NullConstraintType.NULL_IS_ALLOWED;
                    }
                }
                if (this.readIf("DISABLE")) {
                    nullConstraintType = NullConstraintType.NULL_IS_ALLOWED;
                    this.readIf("VALIDATE");
                    this.readIf("NOVALIDATE");
                }
            }
        }
        return nullConstraintType;
    }

    private CreateSynonym parseCreateSynonym(boolean bl) {
        boolean bl2 = this.readIfNotExists();
        String string = this.readIdentifierWithSchema();
        Schema schema = this.getSchema();
        this.read(18);
        String string2 = this.readIdentifierWithSchema();
        Schema schema2 = this.getSchema();
        CreateSynonym createSynonym = new CreateSynonym(this.session, schema);
        createSynonym.setName(string);
        createSynonym.setSynonymFor(string2);
        createSynonym.setSynonymForSchema(schema2);
        createSynonym.setComment(this.readCommentIf());
        createSynonym.setIfNotExists(bl2);
        createSynonym.setOrReplace(bl);
        return createSynonym;
    }

    private CreateIndex createAffinityIndex(Schema schema, String string, IndexColumn[] indexColumnArray) {
        CreateIndex createIndex = new CreateIndex(this.session, schema);
        createIndex.setTableName(string);
        createIndex.setIndexColumns(indexColumnArray);
        createIndex.setAffinity(true);
        return createIndex;
    }

    private static int getCompareType(int n) {
        switch (n) {
            case 59: {
                return 0;
            }
            case 60: {
                return 1;
            }
            case 61: {
                return 2;
            }
            case 62: {
                return 4;
            }
            case 63: {
                return 3;
            }
            case 64: {
                return 5;
            }
            case 71: {
                return 11;
            }
        }
        return -1;
    }

    public static String quoteIdentifier(String string, boolean bl) {
        if (string == null) {
            return "\"\"";
        }
        if (!bl && ParserUtil.isSimpleIdentifier(string, false, false)) {
            return string;
        }
        return StringUtils.quoteIdentifier(string);
    }

    public static StringBuilder quoteIdentifier(StringBuilder stringBuilder, String string, boolean bl) {
        if (string == null) {
            return stringBuilder.append("\"\"");
        }
        if (!bl && ParserUtil.isSimpleIdentifier(string, false, false)) {
            return stringBuilder.append(string);
        }
        return StringUtils.quoteIdentifier(stringBuilder, string);
    }

    public void setLiteralsChecked(boolean bl) {
        this.literalsChecked = bl;
    }

    public void setRightsChecked(boolean bl) {
        this.rightsChecked = bl;
    }

    public void setSuppliedParameterList(ArrayList<Parameter> arrayList) {
        this.suppliedParameterList = arrayList;
    }

    public Expression parseExpression(String string) {
        this.parameters = Utils.newSmallArrayList();
        this.initialize(string);
        this.read();
        return this.readExpression();
    }

    public Table parseTableName(String string) {
        this.parameters = Utils.newSmallArrayList();
        this.initialize(string);
        this.read();
        return this.readTableOrView();
    }

    public String toString() {
        return StringUtils.addAsterisk(this.sqlCommand, this.parseIndex);
    }

    private static enum NullConstraintType {
        NULL_IS_ALLOWED,
        NULL_IS_NOT_ALLOWED,
        NO_NULL_CONSTRAINT_FOUND;

    }
}

