/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command;

import java.util.ArrayList;
import org.h2.command.Command;
import org.h2.command.CommandContainer;
import org.h2.command.Prepared;
import org.h2.engine.Session;
import org.h2.expression.Parameter;
import org.h2.expression.ParameterInterface;
import org.h2.result.ResultInterface;

class CommandList
extends Command {
    private CommandContainer command;
    private final ArrayList<Prepared> commands;
    private final ArrayList<Parameter> parameters;
    private String remaining;
    private Command remainingCommand;

    CommandList(Session session2, String string, CommandContainer commandContainer, ArrayList<Prepared> arrayList, ArrayList<Parameter> arrayList2, String string2) {
        super(session2, string);
        this.command = commandContainer;
        this.commands = arrayList;
        this.parameters = arrayList2;
        this.remaining = string2;
    }

    @Override
    public ArrayList<? extends ParameterInterface> getParameters() {
        return this.parameters;
    }

    private void executeRemaining() {
        for (Prepared prepared : this.commands) {
            prepared.prepare();
            if (prepared.isQuery()) {
                prepared.query(0);
                continue;
            }
            prepared.update();
        }
        if (this.remaining != null) {
            this.remainingCommand = this.session.prepareLocal(this.remaining);
            this.remaining = null;
            if (this.remainingCommand.isQuery()) {
                this.remainingCommand.query(0);
            } else {
                this.remainingCommand.update();
            }
        }
    }

    @Override
    public int update() {
        int n = this.command.executeUpdate(false).getUpdateCount();
        this.executeRemaining();
        return n;
    }

    @Override
    public void prepareJoinBatch() {
        this.command.prepareJoinBatch();
    }

    @Override
    public ResultInterface query(int n) {
        ResultInterface resultInterface = this.command.query(n);
        this.executeRemaining();
        return resultInterface;
    }

    @Override
    public void stop() {
        this.command.stop();
        for (Prepared prepared : this.commands) {
            CommandContainer.clearCTE(this.session, prepared);
        }
        if (this.remainingCommand != null) {
            this.remainingCommand.stop();
        }
    }

    @Override
    public boolean isQuery() {
        return this.command.isQuery();
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public ResultInterface queryMeta() {
        return this.command.queryMeta();
    }

    @Override
    public int getCommandType() {
        return this.command.getCommandType();
    }
}

