/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import org.gudy.azureus2.core3.util.DebugLight;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.Timer;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;

public class TimerEventPeriodic
implements TimerEventPerformer {
    private Timer timer;
    private long frequency;
    private boolean absolute;
    private TimerEventPerformer performer;
    private String name;
    private TimerEvent current_event;
    private boolean cancelled;

    protected TimerEventPeriodic(Timer _timer, long _frequency, boolean _absolute, TimerEventPerformer _performer) {
        this.timer = _timer;
        this.frequency = _frequency;
        this.absolute = _absolute;
        this.performer = _performer;
        long now = SystemTime.getCurrentTime();
        this.current_event = this.timer.addEvent(now, now + this.frequency, this.absolute, (TimerEventPerformer)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setName(String _name) {
        this.name = _name;
        TimerEventPeriodic timerEventPeriodic = this;
        synchronized (timerEventPeriodic) {
            if (this.current_event != null) {
                this.current_event.setName(this.name);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    protected TimerEventPerformer getPerformer() {
        return this.performer;
    }

    public long getFrequency() {
        return this.frequency;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void perform(TimerEvent event) {
        if (!this.cancelled) {
            try {
                this.performer.perform(event);
            }
            catch (Throwable e) {
                DebugLight.printStackTrace(e);
            }
            TimerEventPeriodic timerEventPeriodic = this;
            synchronized (timerEventPeriodic) {
                if (!this.cancelled) {
                    long now = SystemTime.getCurrentTime();
                    this.current_event = this.timer.addEvent(this.name, now, now + this.frequency, this.absolute, this);
                }
            }
        }
    }

    public synchronized void cancel() {
        if (this.current_event != null) {
            this.current_event.cancel();
            this.cancelled = true;
        }
    }

    protected String getString() {
        TimerEvent ce = this.current_event;
        String ev_data = ce == null ? "?" : "when=" + ce.getWhen() + ",run=" + ce.hasRun() + ", can=" + ce.isCancelled();
        return ev_data + ",freq=" + this.getFrequency() + ",target=" + this.getPerformer() + (this.name == null ? "" : ",name=" + this.name);
    }
}

