/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.ThreadPool;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TimerEventPeriodic;

public class Timer
extends AERunnable
implements SystemTime.ChangeListener {
    private static boolean DEBUG_TIMERS = true;
    private static ArrayList<WeakReference<Timer>> timers = null;
    private static AEMonitor timers_mon = new AEMonitor("timers list");
    private ThreadPool thread_pool;
    private Set<TimerEvent> events = new TreeSet<TimerEvent>();
    private long unique_id_next = 0L;
    private long current_when;
    private volatile boolean destroyed;
    private boolean indestructable;
    private boolean log;
    private int max_events_logged;

    public Timer(String name) {
        this(name, 1);
    }

    public Timer(String name, int thread_pool_size) {
        this(name, thread_pool_size, 5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timer(String name, int thread_pool_size, int thread_priority) {
        if (DEBUG_TIMERS) {
            try {
                timers_mon.enter();
                if (timers == null) {
                    timers = new ArrayList();
                    AEDiagnostics.addEvidenceGenerator(new evidenceGenerator());
                }
                timers.add(new WeakReference<Timer>(this));
            }
            finally {
                timers_mon.exit();
            }
        }
        this.thread_pool = new ThreadPool(name, thread_pool_size);
        SystemTime.registerClockChangeListener(this);
        Thread t = new Thread((Runnable)this, "Timer:" + name);
        t.setDaemon(true);
        t.setPriority(thread_priority);
        t.start();
    }

    public void setIndestructable() {
        this.indestructable = true;
    }

    public synchronized List<TimerEvent> getEvents() {
        return new ArrayList<TimerEvent>(this.events);
    }

    public void setLogging(boolean _log) {
        this.log = _log;
    }

    public boolean getLogging() {
        return this.log;
    }

    public void setWarnWhenFull() {
        this.thread_pool.setWarnWhenFull();
    }

    public void setLogCPU() {
        this.thread_pool.setLogCPU();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runSupport() {
        block11: while (true) {
            try {
                while (true) {
                    TimerEvent event_to_run = null;
                    Timer timer = this;
                    synchronized (timer) {
                        if (this.destroyed) {
                            break block11;
                        }
                        if (this.events.isEmpty()) {
                            try {
                                this.current_when = Integer.MAX_VALUE;
                                this.wait();
                            }
                            finally {
                                this.current_when = 0L;
                            }
                        }
                        long now = SystemTime.getCurrentTime();
                        TimerEvent next_event = this.events.iterator().next();
                        long when = next_event.getWhen();
                        long delay = when - now;
                        if (delay > 0L) {
                            try {
                                this.current_when = when;
                                this.wait(delay);
                            }
                            finally {
                                this.current_when = 0L;
                            }
                        }
                        if (this.destroyed) {
                            break block11;
                        }
                        if (this.events.isEmpty()) {
                            continue;
                        }
                        now = SystemTime.getCurrentTime();
                        Iterator<TimerEvent> it = this.events.iterator();
                        TimerEvent next_event2 = it.next();
                        long rem = next_event2.getWhen() - now;
                        if (rem <= 25L) {
                            event_to_run = next_event2;
                            it.remove();
                        }
                    }
                    if (event_to_run == null) continue;
                    event_to_run.setHasRun();
                    if (this.log) {
                        System.out.println("running: " + event_to_run.getString());
                    }
                    this.thread_pool.run(event_to_run.getRunnable());
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clockChangeDetected(long current_time, long offset) {
        if (Math.abs(offset) >= 60000L) {
            Timer timer = this;
            synchronized (timer) {
                Iterator<TimerEvent> it = this.events.iterator();
                ArrayList<TimerEvent> updated_events = new ArrayList<TimerEvent>(this.events.size());
                while (it.hasNext()) {
                    TimerEvent event = it.next();
                    if (!event.isAbsolute()) {
                        TimerEventPeriodic periodic_event;
                        long freq;
                        long old_when = event.getWhen();
                        long new_when = old_when + offset;
                        TimerEventPerformer performer = event.getPerformer();
                        if (performer instanceof TimerEventPeriodic && new_when > current_time + (freq = (periodic_event = (TimerEventPeriodic)performer).getFrequency()) + 5000L) {
                            long adjusted_when;
                            new_when = adjusted_when = current_time + freq;
                        }
                        event.setWhen(new_when);
                    }
                    updated_events.add(event);
                }
                this.events = new TreeSet<TimerEvent>(updated_events);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clockChangeCompleted(long current_time, long offset) {
        if (Math.abs(offset) >= 60000L) {
            Timer timer = this;
            synchronized (timer) {
                Iterator<TimerEvent> it = this.events.iterator();
                boolean updated = false;
                while (it.hasNext()) {
                    TimerEventPerformer performer;
                    TimerEvent event = it.next();
                    if (event.isAbsolute() || !((performer = event.getPerformer()) instanceof TimerEventPeriodic)) continue;
                    TimerEventPeriodic periodic_event = (TimerEventPeriodic)performer;
                    long freq = periodic_event.getFrequency();
                    long old_when = event.getWhen();
                    if (old_when <= current_time + freq + 5000L) continue;
                    long adjusted_when = current_time + freq;
                    event.setWhen(adjusted_when);
                    updated = true;
                }
                if (updated) {
                    this.events = new TreeSet<TimerEvent>(new ArrayList<TimerEvent>(this.events));
                }
                this.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void adjustAllBy(long offset) {
        Timer timer = this;
        synchronized (timer) {
            Iterator<TimerEvent> it = this.events.iterator();
            boolean resort = false;
            while (it.hasNext()) {
                TimerEvent event = it.next();
                long old_when = event.getWhen();
                long new_when = old_when + offset;
                if (old_when > 0L && new_when < 0L && offset > 0L) {
                    resort = true;
                    continue;
                }
                event.setWhen(new_when);
            }
            if (resort) {
                this.events = new TreeSet<TimerEvent>(new ArrayList<TimerEvent>(this.events));
            }
            this.notify();
        }
    }

    public synchronized TimerEvent addEvent(long when, TimerEventPerformer performer) {
        return this.addEvent(SystemTime.getCurrentTime(), when, performer);
    }

    public synchronized TimerEvent addEvent(String name, long when, TimerEventPerformer performer) {
        return this.addEvent(name, SystemTime.getCurrentTime(), when, performer);
    }

    public synchronized TimerEvent addEvent(String name, long when, boolean absolute, TimerEventPerformer performer) {
        return this.addEvent(name, SystemTime.getCurrentTime(), when, absolute, performer);
    }

    public synchronized TimerEvent addEvent(long creation_time, long when, TimerEventPerformer performer) {
        return this.addEvent(null, creation_time, when, performer);
    }

    public synchronized TimerEvent addEvent(long creation_time, long when, boolean absolute, TimerEventPerformer performer) {
        return this.addEvent(null, creation_time, when, absolute, performer);
    }

    public synchronized TimerEvent addEvent(String name, long creation_time, long when, TimerEventPerformer performer) {
        return this.addEvent(name, creation_time, when, false, performer);
    }

    public synchronized TimerEvent addEvent(String name, long creation_time, long when, boolean absolute, TimerEventPerformer performer) {
        TimerEvent event = new TimerEvent(this, this.unique_id_next++, creation_time, when, absolute, performer);
        if (name != null) {
            event.setName(name);
        }
        this.events.add(event);
        if (this.log && this.events.size() > this.max_events_logged) {
            this.max_events_logged = this.events.size();
            System.out.println("Timer '" + this.thread_pool.getName() + "' - events = " + this.max_events_logged);
        }
        if (this.current_when == Integer.MAX_VALUE || when < this.current_when) {
            this.notify();
        }
        return event;
    }

    public synchronized TimerEventPeriodic addPeriodicEvent(long frequency, TimerEventPerformer performer) {
        return this.addPeriodicEvent(null, frequency, performer);
    }

    public synchronized TimerEventPeriodic addPeriodicEvent(String name, long frequency, TimerEventPerformer performer) {
        return this.addPeriodicEvent(name, frequency, false, performer);
    }

    public synchronized TimerEventPeriodic addPeriodicEvent(String name, long frequency, boolean absolute, TimerEventPerformer performer) {
        TimerEventPeriodic periodic_performer = new TimerEventPeriodic(this, frequency, absolute, performer);
        if (name != null) {
            periodic_performer.setName(name);
        }
        if (this.log) {
            System.out.println("Timer '" + this.thread_pool.getName() + "' - added " + periodic_performer.getString());
        }
        return periodic_performer;
    }

    protected synchronized void cancelEvent(TimerEvent event) {
        if (this.events.contains(event)) {
            this.events.remove(event);
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void destroy() {
        if (this.indestructable) {
            Debug.out("Attempt to destroy indestructable timer '" + this.getName() + "'");
        } else {
            this.destroyed = true;
            this.notify();
            SystemTime.unregisterClockChangeListener(this);
        }
        if (DEBUG_TIMERS) {
            try {
                timers_mon.enter();
                Iterator<WeakReference<Timer>> iter = timers.iterator();
                while (iter.hasNext()) {
                    WeakReference<Timer> timerRef = iter.next();
                    Object timer = timerRef.get();
                    if (timer != null && timer != this) continue;
                    iter.remove();
                }
            }
            finally {
                timers_mon.exit();
            }
        }
    }

    public String getName() {
        return this.thread_pool.getName();
    }

    public synchronized void dump() {
        System.out.println("Timer '" + this.thread_pool.getName() + "': dump");
        for (TimerEvent ev : this.events) {
            System.out.println("\t" + ev.getString());
        }
    }

    private class evidenceGenerator
    implements AEDiagnosticsEvidenceGenerator {
        private evidenceGenerator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void generate(IndentWriter writer) {
            if (!DEBUG_TIMERS) {
                return;
            }
            ArrayList<String> lines = new ArrayList<String>();
            int count = 0;
            try {
                try {
                    timers_mon.enter();
                    Iterator iter = timers.iterator();
                    while (iter.hasNext()) {
                        WeakReference timerRef = (WeakReference)iter.next();
                        Timer timer = (Timer)timerRef.get();
                        if (timer == null) {
                            iter.remove();
                            continue;
                        }
                        ++count;
                        List<TimerEvent> events = timer.getEvents();
                        lines.add(timer.thread_pool.getName() + ", " + events.size() + " events:");
                        for (TimerEvent ev : events) {
                            lines.add("  " + ev.getString());
                        }
                    }
                }
                finally {
                    timers_mon.exit();
                }
                writer.println("Timers: " + count + " (time=" + SystemTime.getCurrentTime() + "/" + SystemTime.getMonotonousTime() + ")");
                writer.indent();
                for (String line : lines) {
                    writer.println(line);
                }
                writer.exdent();
            }
            catch (Throwable e) {
                writer.println(e.toString());
            }
        }
    }
}

