/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.security.AccessControlException;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class Constants {
    public static final String DEFAULT_ENCODING = "UTF8";
    static final Locale LOCALE_ENGLISH;
    static final String INFINITY_STRING = "\u221e";
    static final int CRAPPY_INFINITY_AS_INT = 31536000;
    static final long CRAPPY_INFINITE_AS_LONG = 1827387392L;
    static String APP_NAME;
    static final String AZUREUS_VERSION = "5.4.0.1_CVS";
    private static final boolean FORCE_NON_CVS;
    static final boolean IS_CVS_VERSION;
    private static final String OSName;
    public static final boolean isOSX;
    public static final boolean isLinux;
    public static final boolean isWindows;
    private static final boolean isWindowsVista;
    private static final boolean isAndroid;
    static final String JAVA_VERSION;

    private static boolean isCVSVersion(String version) {
        return version.indexOf("_") != -1;
    }

    private static int compareVersions(String version_1, String version_2) {
        try {
            block7: {
                version_1 = version_1.replaceAll("_CVS", "_B100");
                version_2 = version_2.replaceAll("_CVS", "_B100");
                if (version_1.startsWith(".")) {
                    version_1 = "0" + version_1;
                }
                if (version_2.startsWith(".")) {
                    version_2 = "0" + version_2;
                }
                version_1 = version_1.replaceAll("[^0-9.]", ".");
                version_2 = version_2.replaceAll("[^0-9.]", ".");
                StringTokenizer tok1 = new StringTokenizer(version_1, ".");
                StringTokenizer tok2 = new StringTokenizer(version_2, ".");
                while (true) {
                    int i1;
                    if (tok1.hasMoreTokens() && tok2.hasMoreTokens()) {
                        int i2;
                        i1 = Integer.parseInt(tok1.nextToken());
                        if (i1 == (i2 = Integer.parseInt(tok2.nextToken()))) continue;
                        return i1 - i2;
                    }
                    if (tok1.hasMoreTokens()) {
                        i1 = Integer.parseInt(tok1.nextToken());
                        if (i1 == 0) continue;
                        return 1;
                    }
                    if (!tok2.hasMoreTokens()) break block7;
                    int i2 = Integer.parseInt(tok2.nextToken());
                    if (i2 != 0) break;
                }
                return -1;
            }
            return 0;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static void main(String[] args) {
        System.out.println(Constants.compareVersions("3.0.0.1", "3.0.0.0"));
        System.out.println(Constants.compareVersions("3.0.0.0_B1", "3.0.0.0"));
        System.out.println(Constants.compareVersions("3.0.0.0", "3.0.0.0_B1"));
        System.out.println(Constants.compareVersions("3.0.0.0_B1", "3.0.0.0_B4"));
        System.out.println(Constants.compareVersions("3.0.0.0..B1", "3.0.0.0_B4"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        String vm_name;
        String java_version;
        block26: {
            LOCALE_ENGLISH = new Locale("en", "");
            try {
                String timezone = System.getProperty("azureus.timezone", null);
                if (timezone != null) {
                    TimeZone.setDefault(TimeZone.getTimeZone(timezone));
                }
            }
            catch (Throwable e) {
                if (e instanceof AccessControlException) break block26;
                e.printStackTrace();
            }
        }
        APP_NAME = "Vuze";
        FORCE_NON_CVS = System.getProperty("az.force.noncvs", "0").equals("1");
        IS_CVS_VERSION = Constants.isCVSVersion(AZUREUS_VERSION) && !FORCE_NON_CVS;
        OSName = System.getProperty("os.name");
        isOSX = OSName.toLowerCase().startsWith("mac os");
        isLinux = OSName.equalsIgnoreCase("Linux");
        isWindows = OSName.toLowerCase().startsWith("windows");
        if (isWindows) {
            Float ver = null;
            try {
                ver = new Float(System.getProperty("os.version"));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (ver == null) {
                isWindowsVista = false;
            } else {
                float f_ver = ver.floatValue();
                boolean bl = isWindowsVista = f_ver == 6.0f;
                if (isWindowsVista) {
                    BufferedReader lnr = null;
                    try {
                        String line;
                        Process p = Runtime.getRuntime().exec(new String[]{"reg", "query", "HKLM\\Software\\Microsoft\\Windows NT\\CurrentVersion", "/v", "CSDVersion"});
                        lnr = new LineNumberReader(new InputStreamReader(p.getInputStream()));
                        do {
                            if ((line = ((LineNumberReader)lnr).readLine()) != null) continue;
                        } while (!line.matches(".*CSDVersion.*"));
                    }
                    catch (Throwable throwable) {
                    }
                    finally {
                        if (lnr != null) {
                            try {
                                lnr.close();
                            }
                            catch (Throwable throwable) {}
                        }
                    }
                }
            }
        } else {
            isWindowsVista = false;
        }
        String string = java_version = (isAndroid = (vm_name = System.getProperty("java.vm.name", "")).equalsIgnoreCase("Dalvik")) ? "1.6" : System.getProperty("java.version");
        if (isAndroid) {
            String sdk_int = System.getProperty("android.os.build.version.sdk_int", "0");
            try {
                int api_level = Integer.parseInt(sdk_int);
                if (api_level > 0 && api_level <= 8) {
                    java_version = "1.5";
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        JAVA_VERSION = java_version;
    }
}

