/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.shell;

import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.shell.FileTypeAssociation;
import com.limegroup.gnutella.gui.shell.LimeAssociationOption;
import com.limegroup.gnutella.gui.shell.MagnetAssociation;
import com.limegroup.gnutella.settings.ApplicationSettings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.limewire.util.CommonUtils;
import org.limewire.util.OSUtils;
import org.limewire.util.SystemUtils;

public class FrostAssociations {
    public static final int CURRENT_ASSOCIATIONS = 2;
    private static final String PROGRAM = OSUtils.isWindows() ? "FrostWire" : (OSUtils.isUnix() ? System.getProperty("unix.executable", "") : "");
    private static final String UNSUPPORTED_PLATFORM = "";
    private static Collection<LimeAssociationOption> options;

    public static synchronized Collection<LimeAssociationOption> getSupportedAssociations() {
        if (options == null) {
            options = FrostAssociations.getSupportedAssociationsImpl();
        }
        return options;
    }

    public static synchronized boolean anyAssociationsSupported() {
        return !FrostAssociations.getSupportedAssociations().isEmpty();
    }

    private static Collection<LimeAssociationOption> getSupportedAssociationsImpl() {
        if (CommonUtils.isPortable()) {
            return Collections.emptyList();
        }
        ArrayList<LimeAssociationOption> ret = new ArrayList<LimeAssociationOption>();
        String fileOpener = null;
        String fileIcon = null;
        String protocolOpener = null;
        if (OSUtils.isWindows()) {
            String runningPath = SystemUtils.getRunningPath();
            if (CommonUtils.isDebugMode()) {
                runningPath = PROGRAM + ".exe";
            }
            if (runningPath != null && runningPath.endsWith(PROGRAM + ".exe")) {
                protocolOpener = runningPath;
                fileOpener = "\"" + runningPath + "\" \"%1\"";
                fileIcon = runningPath.replace(".exe", ".ico");
            }
        }
        if (fileOpener != null) {
            if (OSUtils.isWindows()) {
                FileTypeAssociation tor = new FileTypeAssociation("torrent", "application/x-bittorrent", fileOpener, "open", I18n.tr("FrostWire Torrent"), fileIcon);
                LimeAssociationOption torrentwin = new LimeAssociationOption(tor, ApplicationSettings.HANDLE_TORRENTS, ".torrent", I18n.tr("\".torrent\" files"));
                ret.add(torrentwin);
            } else {
                FileTypeAssociation file = new FileTypeAssociation("torrent", "Application/x-bittorrent", fileOpener, "open", I18n.tr("FrostWire Torrent"), fileIcon);
                LimeAssociationOption torrent = new LimeAssociationOption(file, ApplicationSettings.HANDLE_TORRENTS, ".torrent", I18n.tr("\".torrent\" files"));
                ret.add(torrent);
            }
        }
        if (protocolOpener != null) {
            MagnetAssociation mag = new MagnetAssociation(PROGRAM, protocolOpener);
            LimeAssociationOption magOption = new LimeAssociationOption(mag, ApplicationSettings.HANDLE_MAGNETS, "magnet:", I18n.tr("\"magnet:\" links"));
            ret.add(magOption);
        }
        return Collections.unmodifiableCollection(ret);
    }
}

