/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.frostwire.search.torrent.TorrentSearchResult;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.search.AbstractUISearchResult;
import com.limegroup.gnutella.gui.search.SearchEngine;
import com.limegroup.gnutella.gui.search.SearchMediator;
import com.limegroup.gnutella.gui.search.SearchResultDataLine;
import com.limegroup.gnutella.gui.search.SearchResultMediator;
import com.limegroup.gnutella.gui.util.PopupUtils;
import javax.swing.JPopupMenu;

public class TorrentUISearchResult
extends AbstractUISearchResult {
    private TorrentSearchResult sr;

    TorrentUISearchResult(TorrentSearchResult sr, SearchEngine se, String query) {
        super(sr, se, query);
        this.sr = sr;
    }

    public String getTorrentUrl() {
        return this.sr.getTorrentUrl();
    }

    @Override
    public String getHash() {
        return this.sr.getHash();
    }

    @Override
    public void download(boolean partial) {
        GUIMediator gm = GUIMediator.instance();
        gm.openTorrentSearchResult(this.sr, partial);
        this.showSearchResultWebPage(false);
    }

    @Override
    public JPopupMenu createMenu(JPopupMenu popupMenu, SearchResultDataLine[] lines, SearchResultMediator resultPanel) {
        PopupUtils.addMenuItem(SearchMediator.DOWNLOAD_STRING, e -> this.download(false), popupMenu, lines.length > 0, 1);
        PopupUtils.addMenuItem(SearchMediator.DOWNLOAD_PARTIAL_FILES_STRING, resultPanel.DOWNLOAD_PARTIAL_FILES_LISTENER, popupMenu, lines.length == 1, 2);
        PopupUtils.addMenuItem(SearchMediator.TORRENT_DETAILS_STRING, e -> this.showSearchResultWebPage(true), popupMenu, lines.length == 1, 3);
        return popupMenu;
    }

    @Override
    public int getSeeds() {
        return this.sr.getSeeds();
    }
}

