/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.frostwire.gui.components.slides.MultimediaSlideshowPanel;
import com.frostwire.gui.components.slides.Slide;
import com.frostwire.gui.components.slides.SlideshowPanel;
import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.RefreshListener;
import com.limegroup.gnutella.gui.search.CancelSearchIconProxy;
import com.limegroup.gnutella.gui.search.SearchInformation;
import com.limegroup.gnutella.gui.search.SearchMediator;
import com.limegroup.gnutella.gui.search.SearchResultDataLine;
import com.limegroup.gnutella.gui.search.SearchResultMediator;
import com.limegroup.gnutella.gui.search.SearchTabbedPane;
import com.limegroup.gnutella.gui.search.UISearchResult;
import com.limegroup.gnutella.settings.SearchSettings;
import com.limegroup.gnutella.settings.UpdateManagerSettings;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.TabbedPaneUI;

public final class SearchResultDisplayer
implements RefreshListener {
    private JPanel MAIN_PANEL;
    private SearchTabbedPane tabbedPane;
    private static final List<SearchResultMediator> entries = new ArrayList<SearchResultMediator>();
    private static final int MIN_HEIGHT = 220;
    private JPanel results;
    private CardLayout switcher = new CardLayout();
    private ChangeListener _activeSearchListener;
    private final PaneListener PANE_LISTENER = new PaneListener();
    private SlideshowPanel promoSlides;

    SearchResultDisplayer() {
        this.MAIN_PANEL = new BoxPanel(1);
        this.MAIN_PANEL.setMinimumSize(new Dimension(0, 0));
        this.tabbedPane = new SearchTabbedPane();
        this.results = new JPanel();
        this.results.setPreferredSize(new Dimension(10000, 10000));
        this.results.setLayout(this.switcher);
        this.promoSlides = null;
        this.promoSlides = !UpdateManagerSettings.SHOW_PROMOTION_OVERLAYS.getValue() ? new MultimediaSlideshowPanel(this.getDefaultSlides()) : new MultimediaSlideshowPanel(UpdateManagerSettings.OVERLAY_SLIDESHOW_JSON_URL.getValue(), this.getDefaultSlides());
        JPanel p = (JPanel)((Object)this.promoSlides);
        Dimension promoDimensions = new Dimension(717, 380);
        p.setPreferredSize(promoDimensions);
        p.setSize(promoDimensions);
        p.setMaximumSize(promoDimensions);
        SearchResultMediator DUMMY = new SearchResultMediator(p);
        JPanel mainScreen = new JPanel(new BorderLayout());
        this.promoSlides.setupContainerAndControls(mainScreen, true);
        mainScreen.add((Component)DUMMY.getComponent(), "Center");
        this.results.add("dummy", mainScreen);
        this.switcher.first(this.results);
        this.setupTabbedPane();
        this.MAIN_PANEL.add(this.results);
        CancelSearchIconProxy.updateTheme();
    }

    public void switchToTabByOffset(int offset) {
        if (this.tabbedPane != null) {
            this.tabbedPane.switchToTabByOffset(offset);
        }
    }

    private List<Slide> getDefaultSlides() {
        Slide s1 = new Slide("http://static.frostwire.com/images/overlays/default_now_on_android.png", "http://www.frostwire.com/?from=defaultSlide", 240000L, null, null, null, null, null, null, 0L, 0, null, null, null, null, null, null, null, null, null, null, null, 512);
        Slide s2 = new Slide("http://static.frostwire.com/images/overlays/frostclick_default_overlay.jpg", "http://www.frostclick.com/?from=defaultSlide", 240000L, null, null, null, null, null, null, 0L, 0, null, null, null, null, null, null, null, null, null, null, null, 512);
        return Arrays.asList(s1, s2);
    }

    void setSearchListener(ChangeListener listener) {
        this._activeSearchListener = listener;
    }

    SearchResultMediator addResultTab(long token, List<String> searchTokens, SearchInformation info) {
        SearchResultMediator panel = new SearchResultMediator(token, searchTokens, info);
        if (this.MAIN_PANEL.getHeight() < 220) {
            GUIMediator.instance().getMainFrame().resizeSearchTransferDivider(220);
        }
        return this.addResultPanelInternal(panel, info.getTitle());
    }

    private void removeTabbedPaneListeners() {
        if (this.tabbedPane != null) {
            this.tabbedPane.removeMouseListener(this.PANE_LISTENER);
            this.tabbedPane.removeMouseMotionListener(this.PANE_LISTENER);
            this.tabbedPane.removeChangeListener(this.PANE_LISTENER);
        }
    }

    private void addTabbedPaneListeners() {
        if (this.tabbedPane != null) {
            this.tabbedPane.addMouseListener(this.PANE_LISTENER);
            this.tabbedPane.addMouseMotionListener(this.PANE_LISTENER);
            this.tabbedPane.addChangeListener(this.PANE_LISTENER);
        }
    }

    private void setupTabbedPane() {
        this.removeTabbedPaneListeners();
        this.tabbedPane = new SearchTabbedPane();
        this.tabbedPane.setRequestFocusEnabled(false);
        this.results.add("tabbedPane", this.tabbedPane);
        this.addTabbedPaneListeners();
    }

    private void resetTabbedPane() {
        int i;
        ArrayList<SearchResultMediator> ents = new ArrayList<SearchResultMediator>();
        ArrayList<Component> tabs = new ArrayList<Component>();
        ArrayList<String> titles = new ArrayList<String>();
        for (i = 0; i < this.tabbedPane.getTabCount() && i < entries.size(); ++i) {
            tabs.add(this.tabbedPane.getComponent(i));
            titles.add(this.tabbedPane.getTitleAt(i));
            ents.add(entries.get(i));
        }
        this.tabbedPane.removeAll();
        entries.clear();
        this.setupTabbedPane();
        for (i = 0; i < tabs.size(); ++i) {
            entries.add((SearchResultMediator)ents.get(i));
            this.tabbedPane.addTab((String)titles.get(i), (Component)tabs.get(i));
        }
    }

    private SearchResultMediator addResultPanelInternal(SearchResultMediator panel, String title) {
        entries.add(panel);
        try {
            this.tabbedPane.addTab(title, CancelSearchIconProxy.createSelected(), panel.getComponent());
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.resetTabbedPane();
            entries.add(panel);
            this.tabbedPane.addTab(title, CancelSearchIconProxy.createSelected(), panel.getComponent());
        }
        try {
            this.tabbedPane.setSelectedIndex(entries.size() - 1);
        }
        catch (IndexOutOfBoundsException ioobe) {
            this.resetTabbedPane();
            this.tabbedPane.setSelectedIndex(entries.size() - 1);
        }
        try {
            this.tabbedPane.setProgressActiveAt(entries.size() - 1, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (SearchSettings.PARALLEL_SEARCH.getValue() > 10) {
            SearchSettings.PARALLEL_SEARCH.revertToDefault();
        }
        if (entries.size() > SearchSettings.PARALLEL_SEARCH.getValue()) {
            this.killSearchAtIndex(0);
        }
        this.promoSlides.setVisible(false);
        this.switcher.last(this.results);
        this.MAIN_PANEL.revalidate();
        return panel;
    }

    void addQueryResult(long token, UISearchResult line, SearchResultMediator rp) {
        if (rp.isStopped()) {
            return;
        }
        if (!rp.matches(token)) {
            throw new IllegalArgumentException("guids don't match");
        }
        rp.add(line);
        int resultPanelIndex = entries.indexOf(rp);
        if (resultPanelIndex == -1) {
            return;
        }
        this.tabbedPane.setTitleAt(resultPanelIndex, this.titleOf(rp));
    }

    void updateSearchIcon(SearchResultMediator rp, boolean active) {
        int resultPanelIndex = entries.indexOf(rp);
        if (resultPanelIndex == -1) {
            return;
        }
        this.tabbedPane.setProgressActiveAt(resultPanelIndex, active);
    }

    private void showMenu(MouseEvent e) {
        SearchResultMediator rp = this.getSelectedResultPanel();
        if (rp != null) {
            JPopupMenu menu = rp.createPopupMenu(new SearchResultDataLine[0]);
            Point p = e.getPoint();
            if (menu != null) {
                try {
                    menu.show(this.MAIN_PANEL, p.x + 1, p.y - 6);
                }
                catch (IllegalComponentStateException illegalComponentStateException) {
                    // empty catch block
                }
            }
        }
    }

    SearchResultMediator getSelectedResultPanel() {
        int i = this.tabbedPane.getSelectedIndex();
        if (i == -1) {
            return null;
        }
        try {
            return entries.get(i);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    SearchResultMediator getResultPanelForGUID(long token) {
        for (SearchResultMediator rp : entries) {
            if (!rp.matches(token)) continue;
            return rp;
        }
        return null;
    }

    private int getIndexForPoint(int x, int y) {
        TabbedPaneUI ui = this.tabbedPane.getUI();
        return ui.tabForCoordinate(this.tabbedPane, x, y);
    }

    int getIndexForTabComponent(Component c) {
        for (int i = 0; i < entries.size(); ++i) {
            SearchResultMediator rp = entries.get(i);
            if (!rp.getComponent().equals(c)) continue;
            return i;
        }
        return -1;
    }

    public void closeCurrentTab() {
        int index = this.tabbedPane.getSelectedIndex();
        if (index != -1) {
            this.killSearchAtIndex(index);
        }
    }

    boolean closeTabAt(int i) {
        boolean closed = false;
        try {
            SearchResultMediator searchResultMediator = entries.get(i);
            if (searchResultMediator != null) {
                this.killSearchAtIndex(i);
                closed = true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return closed;
    }

    void closeAllTabs() {
        while (entries != null && entries.size() > 0) {
            this.closeTabAt(0);
        }
    }

    void closeOtherTabs() {
        if (entries == null || entries.size() < 2) {
            return;
        }
        int index = this.tabbedPane.getSelectedIndex();
        if (index != -1) {
            SearchResultMediator currentMediator = entries.get(index);
            int i = 0;
            while (entries.size() > 1 && i < entries.size()) {
                if (entries.get(i) != currentMediator) {
                    this.closeTabAt(i);
                    continue;
                }
                ++i;
            }
        }
    }

    void killSearchAtIndex(int i) {
        SearchResultMediator killed = entries.remove(i);
        try {
            this.tabbedPane.removeTabAt(i);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (ArrayIndexOutOfBoundsException oob) {
            this.resetTabbedPane();
            this.tabbedPane.removeTabAt(i);
        }
        this.fixIcons();
        SearchMediator.searchKilled(killed);
        if (entries.size() == 0) {
            try {
                this.promoSlides.setVisible(true);
                this.switcher.first(this.results);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    void setTabDisplayCount(SearchResultMediator rp) {
        int i;
        boolean found = false;
        for (i = 0; i < entries.size(); ++i) {
            SearchResultMediator panel = entries.get(i);
            if (panel != rp) continue;
            found = true;
            break;
        }
        if (found) {
            this.tabbedPane.setTitleAt(i, this.titleOf(rp));
        }
    }

    private void fixIcons() {
        int sel = this.tabbedPane.getSelectedIndex();
        for (int i = 0; i < entries.size() && i < this.tabbedPane.getTabCount(); ++i) {
            this.tabbedPane.setIconAt(i, i == sel ? CancelSearchIconProxy.createSelected() : CancelSearchIconProxy.createPlain());
        }
    }

    JComponent getComponent() {
        return this.MAIN_PANEL;
    }

    @Override
    public void refresh() {
        if (this.tabbedPane.isVisible() && this.tabbedPane.isShowing()) {
            Component comp;
            Rectangle allBounds = this.tabbedPane.getBounds();
            try {
                comp = this.tabbedPane.getSelectedComponent();
            }
            catch (ArrayIndexOutOfBoundsException aioobe) {
                this.resetTabbedPane();
                comp = this.tabbedPane.getSelectedComponent();
            }
            if (comp != null) {
                Rectangle compBounds = comp.getBounds();
                Rectangle allTabs = new Rectangle(allBounds.x, allBounds.y, allBounds.width, compBounds.y - 1);
                this.tabbedPane.repaint(allTabs);
            }
        }
    }

    private String titleOf(SearchResultMediator rp) {
        int total = rp.totalResults();
        String title = rp.getTitle();
        if (title.length() > 40) {
            title = title.substring(0, 39) + "...";
        }
        return title + " (" + total + " " + I18n.tr("results") + ")";
    }

    int tabCount() {
        int result = 0;
        if (entries != null && !entries.isEmpty()) {
            result = entries.size();
        }
        return result;
    }

    int currentTabIndex() {
        return this.tabbedPane.getSelectedIndex();
    }

    private class PaneListener
    extends MouseAdapter
    implements MouseListener,
    MouseMotionListener,
    ChangeListener {
        private int lastIdx = -1;

        private PaneListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (this.tryPopup(e)) {
                return;
            }
            if (SwingUtilities.isLeftMouseButton(e)) {
                int y;
                int x = e.getX();
                int idx = this.shouldKillIndex(x, y = e.getY());
                if (idx != -1) {
                    this.lastIdx = -1;
                    SearchResultDisplayer.this.killSearchAtIndex(idx);
                }
                if (idx == -1) {
                    this.stateChanged(null);
                }
            }
        }

        private int shouldKillIndex(int x, int y) {
            Icon icon;
            int idx = SearchResultDisplayer.this.getIndexForPoint(x, y);
            if (idx != -1 && (icon = SearchResultDisplayer.this.tabbedPane.getIconAt(idx)) != null && icon instanceof CancelSearchIconProxy && ((CancelSearchIconProxy)icon).shouldKill(x, y)) {
                return idx;
            }
            return -1;
        }

        private void resetIcon() {
            if (this.lastIdx != -1 && this.lastIdx < SearchResultDisplayer.this.tabbedPane.getTabCount()) {
                if (this.lastIdx == SearchResultDisplayer.this.tabbedPane.getSelectedIndex()) {
                    SearchResultDisplayer.this.tabbedPane.setIconAt(this.lastIdx, CancelSearchIconProxy.createSelected());
                } else {
                    SearchResultDisplayer.this.tabbedPane.setIconAt(this.lastIdx, CancelSearchIconProxy.createPlain());
                }
                this.lastIdx = -1;
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.tryPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.tryPopup(e);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.resetIcon();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        private boolean tryPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                int idx = SearchResultDisplayer.this.getIndexForPoint(e.getX(), e.getY());
                if (idx != -1) {
                    try {
                        SearchResultDisplayer.this.tabbedPane.setSelectedIndex(idx);
                    }
                    catch (ArrayIndexOutOfBoundsException aioobe) {
                        SearchResultDisplayer.this.resetTabbedPane();
                        SearchResultDisplayer.this.tabbedPane.setSelectedIndex(idx);
                    }
                }
                SearchResultDisplayer.this.showMenu(e);
                return true;
            }
            return false;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            SearchResultDisplayer.this._activeSearchListener.stateChanged(e);
            SearchResultDisplayer.this.fixIcons();
        }
    }
}

