/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.frostwire.gui.tabs.TransfersTab;
import com.frostwire.util.Logger;
import com.limegroup.gnutella.MagnetOptions;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.search.SearchInformation;
import com.limegroup.gnutella.gui.search.SearchMediator;
import com.limegroup.gnutella.util.QueryUtils;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import org.limewire.concurrent.ExecutorsHelper;

public class MagnetClipboardListener
extends WindowAdapter {
    private static final Logger LOG = Logger.getLogger(MagnetClipboardListener.class);
    private static final MagnetClipboardListener instance = new MagnetClipboardListener();
    private static final Clipboard CLIPBOARD = Toolkit.getDefaultToolkit().getSystemClipboard();
    private final StringSelection empty = new StringSelection("");
    private volatile String copiedText;
    private final ExecutorService clipboardParser = ExecutorsHelper.newProcessingQueue("clipboard parser");
    private Runnable parser = new Runnable(){

        @Override
        public void run() {
            MagnetClipboardListener.this.parseAndLaunch();
        }
    };

    private void parseAndLaunch() {
        String contents = MagnetClipboardListener.extractStringContentFromClipboard(this);
        if (contents == null) {
            return;
        }
        String copied = this.copiedText;
        if (copied != null && copied.equals(contents)) {
            return;
        }
        MagnetOptions[] opts = MagnetOptions.parseMagnets(contents);
        if (opts.length == 0) {
            return;
        }
        LOG.info("clipboard contains " + contents);
        this.purgeClipboard();
        MagnetClipboardListener.handleMagnets(opts, true);
    }

    private MagnetClipboardListener() {
    }

    public static MagnetClipboardListener getInstance() {
        return instance;
    }

    public void setCopiedText(String text) {
        this.copiedText = text;
    }

    @Override
    public void windowActivated(WindowEvent e) {
        this.clipboardParser.execute(this.parser);
    }

    private void purgeClipboard() {
        try {
            CLIPBOARD.setContents(this.empty, this.empty);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public static void handleMagnets(final MagnetOptions[] magnets, final boolean showDialog) {
        final MagnetOptions[] downloadCandidates = MagnetClipboardListener.extractDownloadableMagnets(magnets);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                if (!showDialog || downloadCandidates.length > 0) {
                    // empty if block
                }
                boolean oneSearchStarted = false;
                for (int i = 0; i < magnets.length; ++i) {
                    String query;
                    SearchInformation info;
                    if (magnets[i].isDownloadable() || !magnets[i].isKeywordTopicOnly() || oneSearchStarted || SearchMediator.validateInfo(info = SearchInformation.createKeywordSearch(query = QueryUtils.createQueryString(magnets[i].getKeywordTopic()), null, MediaType.getAnyTypeMediaType())) != 0) continue;
                    oneSearchStarted = true;
                    SearchMediator.instance().triggerSearch(info);
                }
                GUIMediator.instance().showTransfers(TransfersTab.FilterMode.DOWNLOADING);
            }
        };
        GUIMediator.safeInvokeLater(r);
    }

    public static String extractStringContentFromClipboard(Object requestor) {
        try {
            Transferable data = null;
            try {
                data = CLIPBOARD.getContents(requestor);
            }
            catch (IllegalStateException isx) {
                return null;
            }
            if (data == null) {
                return null;
            }
            if (!data.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                return null;
            }
            String contents = null;
            try {
                contents = (String)data.getTransferData(DataFlavor.stringFlavor);
            }
            catch (IOException iox) {
                LOG.info("problem occured while trying to parse clipboard, do nothing", iox);
            }
            catch (UnsupportedFlavorException ufx) {
                LOG.error("UnsupportedFlavor??", ufx);
            }
            return contents;
        }
        catch (Throwable throwable) {
            return "";
        }
    }

    public static String getMagnetOrTorrentURLFromClipboard() {
        try {
            String clipboardText = MagnetClipboardListener.extractStringContentFromClipboard(null);
            if (clipboardText == null) {
                return "";
            }
            if (clipboardText.contains("\n")) {
                clipboardText = clipboardText.split("\n")[0].trim();
            }
            if (clipboardText.startsWith("magnet:?xt=urn:btih:") || clipboardText.matches("^http.*\\.torrent$") || clipboardText.matches(".*soundcloud.com.*")) {
                return clipboardText;
            }
        }
        catch (Throwable e) {
            LOG.error("Error processing clipboard text", e);
        }
        return null;
    }

    private static MagnetOptions[] extractDownloadableMagnets(MagnetOptions[] magnets) {
        ArrayList<MagnetOptions> dls = new ArrayList<MagnetOptions>(magnets.length);
        for (int i = 0; i < magnets.length; ++i) {
            MagnetOptions magnet = magnets[i];
            if (magnet.isKeywordTopicOnly()) continue;
            dls.add(magnets[i]);
        }
        if (dls.size() == magnets.length) {
            return magnets;
        }
        return dls.toArray(new MagnetOptions[0]);
    }
}

