/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.frostwire.bittorrent.BTEngine;
import com.frostwire.gui.theme.ThemeMediator;
import com.frostwire.jlibtorrent.swig.ip_filter;
import com.frostwire.regex.Matcher;
import com.frostwire.regex.Pattern;
import com.frostwire.util.Logger;
import com.frostwire.util.http.JdkHttpClient;
import com.limegroup.gnutella.gui.FileChooserHandler;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.IconButton;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.gui.options.panes.IPFilterTableMediator;
import com.limegroup.gnutella.gui.options.panes.ipfilter.AddRangeManuallyDialog;
import com.limegroup.gnutella.gui.options.panes.ipfilter.IPFilterHttpListener;
import com.limegroup.gnutella.gui.options.panes.ipfilter.IPFilterInputStreamReader;
import com.limegroup.gnutella.gui.options.panes.ipfilter.IPRange;
import com.limegroup.gnutella.gui.util.BackgroundExecutorService;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutorService;
import java.util.zip.GZIPInputStream;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.io.IOUtils;
import org.limewire.concurrent.ExecutorsHelper;
import org.limewire.util.CommonUtils;

public class IPFilterPaneItem
extends AbstractPaneItem {
    private static final Pattern P2P_LINE_PATTERN = Pattern.compile("(.*)\\:(.*)\\-(.*)$", 4);
    private static final Logger LOG = Logger.getLogger(IPFilterPaneItem.class);
    public static final String TITLE = I18n.tr("IP Filter");
    public static final String LABEL = I18n.tr("You can manually enter IP addresses ranges to filter out, you can also import bulk addresses from an IP block list file or URL");
    private final String decompressingString = I18n.tr("Decompressing");
    private IPFilterTableMediator ipFilterTable = null;
    private JTextField fileUrlTextField;
    private JProgressBar progressBar;
    private JButton importButton;
    private JButton clearFilterButton;
    private JButton addRangeManuallyButton;
    private IconButton fileChooserIcon;
    private boolean initialized;
    private int lastPercentage = -1;
    private long lastPercentageUpdateTimestamp;
    private final ExecutorService httpExecutor = ExecutorsHelper.newProcessingQueue("IPFilterPanelItem-http");

    public IPFilterPaneItem() {
        super(TITLE, LABEL);
    }

    @Override
    public void initOptions() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        ip_filter ipFilter = null;
        BTEngine engine = BTEngine.getInstance();
        if (engine != null) {
            ipFilter = engine.swig().get_ip_filter();
        }
        if (ipFilter == null) {
            throw new RuntimeException("Check your logic. No BTEngine ip_filter instance available");
        }
        JPanel panel = new JPanel(new MigLayout("fillx, ins 0, insets, nogrid", "[][][][][][][][]"));
        this.ipFilterTable = IPFilterTableMediator.getInstance();
        BackgroundExecutorService.schedule(this::loadSerializedIPFilter);
        panel.add((Component)this.ipFilterTable.getComponent(), "span, pad 0 0 0 0, grow, wrap");
        panel.add((Component)new JLabel(I18n.tr("Enter the URL or local file path of an IP Filter list (p2p format only supported)")), "pad 0 5px, span, wrap");
        this.fileUrlTextField = new JTextField();
        ThemeMediator.fixKeyStrokes(this.fileUrlTextField);
        panel.add((Component)this.fileUrlTextField, "span 6, growx");
        this.fileChooserIcon = new IconButton("OPEN_IP_FILTER_FILE", 24, 24);
        panel.add((Component)this.fileChooserIcon, "span 1");
        this.importButton = new JButton(I18n.tr("Import"));
        panel.add((Component)this.importButton, "span 1, wrap");
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setStringPainted(true);
        this.progressBar.setVisible(false);
        panel.add((Component)this.progressBar, "growx, wrap");
        this.addRangeManuallyButton = new JButton(I18n.tr("Add IP Range Manually"));
        this.addRangeManuallyButton.addActionListener(e -> this.onAddRangeManuallyAction());
        panel.add(this.addRangeManuallyButton);
        this.clearFilterButton = new JButton(I18n.tr("Clear IP Block List"));
        this.clearFilterButton.addActionListener(e -> this.onClearFilterAction());
        panel.add(this.clearFilterButton);
        this.add(panel);
        this.fileChooserIcon.addActionListener(e -> this.onFileChooserIconAction());
        this.importButton.addActionListener(e -> this.onImportButtonAction());
    }

    private void onImportButtonAction() {
        this.enableImportControls(false);
        String filterDataPath = this.fileUrlTextField.getText().trim();
        if (null == filterDataPath || "".equals(filterDataPath)) {
            this.enableImportControls(true);
            return;
        }
        if (filterDataPath.toLowerCase().startsWith("http")) {
            LOG.info("onImportButtonAction() trying URL");
            try {
                URI uri = URI.create(filterDataPath);
                JdkHttpClient http = new JdkHttpClient();
                http.setListener(new IPFilterHttpListener(this, new File(CommonUtils.getUserSettingsDir(), "downloaded_blocklist.temp")));
                this.httpExecutor.execute(() -> {
                    try {
                        LOG.info("http.get() -> " + uri.toURL().toString());
                        http.get(uri.toURL().toString());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        this.enableImportControls(true);
                        this.fileUrlTextField.selectAll();
                    }
                });
            }
            catch (Throwable t) {
                LOG.error(t.getMessage(), t);
                GUIMediator.showError(I18n.tr("Invalid URI or file path"));
                this.enableImportControls(true);
                this.fileUrlTextField.selectAll();
                return;
            }
            return;
        }
        this.importFromIPBlockFileAsync(new File(filterDataPath), false);
    }

    private void onClearFilterAction() {
        this.enableImportControls(false);
        this.ipFilterTable.clearTable();
        File ipFilterDBFile = this.getIPFilterDBFile();
        ipFilterDBFile.delete();
        try {
            ipFilterDBFile.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.enableImportControls(true);
    }

    public void importFromIPBlockFileAsync(File potentialGunzipFile, boolean removeInputFileWhenDone) {
        BackgroundExecutorService.schedule(() -> {
            P2PIPFilterInputStreamReader ipFilterReader;
            File decompressedFile;
            LOG.info("importFromStreamAsync(): thread invoked", true);
            try {
                if (IPFilterPaneItem.isGZipped(potentialGunzipFile)) {
                    decompressedFile = this.gunzipFile(potentialGunzipFile, new File(CommonUtils.getUserSettingsDir(), "gunzipped_blocklist.temp"));
                    if (removeInputFileWhenDone) {
                        potentialGunzipFile.delete();
                    }
                } else {
                    decompressedFile = potentialGunzipFile;
                }
            }
            catch (IOException e) {
                LOG.error("importFromIPBlockFileAsync(): " + e.getMessage(), e);
                this.fileUrlTextField.selectAll();
                this.enableImportControls(true);
                return;
            }
            IPFilterFormat format = this.getIPFilterFileFormat(decompressedFile);
            if (format == null) {
                LOG.error("importFromStreamAsync(): IPFilterFormat could not be determined");
                this.fileUrlTextField.selectAll();
                this.enableImportControls(true);
                GUIMediator.showError(I18n.tr("Invalid IP Filter file format, only P2P (PeerGuardian) format supported"));
                return;
            }
            long decompressedFileSize = decompressedFile.length();
            P2PIPFilterInputStreamReader p2PIPFilterInputStreamReader = ipFilterReader = format == IPFilterFormat.P2P ? new P2PIPFilterInputStreamReader(decompressedFile) : null;
            if (ipFilterReader == null) {
                LOG.error("importFromStreamAsync(): Invalid IP Filter file format, only p2p format supported");
                this.fileUrlTextField.selectAll();
                this.enableImportControls(true);
                return;
            }
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(new File(CommonUtils.getUserSettingsDir(), "ip_filter.db"));
                IPFilterTableMediator.IPFilterModel dataModel = (IPFilterTableMediator.IPFilterModel)this.ipFilterTable.getDataModel();
                String importingString = I18n.tr("Importing");
                while (ipFilterReader.available() > 0) {
                    IPRange ipRange = ipFilterReader.readLine();
                    if (ipRange == null) continue;
                    try {
                        ipRange.writeObjectTo(fos);
                        dataModel.add(ipRange, dataModel.getRowCount());
                        if (dataModel.getRowCount() % 100 != 0) continue;
                        GUIMediator.safeInvokeLater(() -> this.updateProgressBar((int)((float)ipFilterReader.bytesRead() * 100.0f / (float)decompressedFileSize), importingString));
                    }
                    catch (Throwable t) {
                        LOG.warn(t.getMessage(), t);
                    }
                }
                GUIMediator.safeInvokeLater(() -> {
                    this.updateProgressBar(100, "");
                    this.ipFilterTable.refresh();
                    this.enableImportControls(true);
                    this.fileUrlTextField.setText("");
                    LOG.info("importFromStreamAsync() - done");
                });
                if (removeInputFileWhenDone) {
                    potentialGunzipFile.delete();
                }
                if (decompressedFile.getAbsolutePath().contains("gunzipped_blocklist.temp")) {
                    decompressedFile.delete();
                }
                IOUtils.closeQuietly(fos);
                ipFilterReader.close();
                this.enableImportControls(true);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            finally {
                IOUtils.closeQuietly(fos);
                ipFilterReader.close();
                this.enableImportControls(true);
            }
        });
    }

    private IPFilterFormat getIPFilterFileFormat(File decompressedFile) {
        byte[] sample = new byte[1024];
        try {
            FileInputStream fis = new FileInputStream(decompressedFile);
            fis.read(sample);
            fis.close();
        }
        catch (IOException e) {
            return null;
        }
        Matcher matcher = P2P_LINE_PATTERN.matcher(new String(sample, StandardCharsets.UTF_8));
        if (matcher.find() && matcher.find() && matcher.find()) {
            return IPFilterFormat.P2P;
        }
        return null;
    }

    private void onAddRangeManuallyAction() {
        new AddRangeManuallyDialog(this).setVisible(true);
    }

    private void onFileChooserIconAction() {
        File selectedFile = FileChooserHandler.getInputFile((Component)this.getContainer(), I18n.tr("Select the IP filter file (P2P/PeerGuardian format only supported)"), FileChooserHandler.getLastInputDirectory(), new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isFile();
            }

            @Override
            public String getDescription() {
                return null;
            }
        });
        if (selectedFile != null) {
            this.fileUrlTextField.setText(selectedFile.getAbsolutePath());
        }
    }

    private void loadSerializedIPFilter() {
        LOG.info("loadSerializedIPFilter() invoked - " + this.hashCode());
        File ipFilterDBFile = this.getIPFilterDBFile();
        if (!ipFilterDBFile.exists()) {
            try {
                ipFilterDBFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
            LOG.info("loadSerializedIPFilter(): done, initialized empty ip filter file");
            return;
        }
        if (ipFilterDBFile.length() == 0L) {
            LOG.info("loadSerializedIPFilter(): done, ip filter file existed but it was empty");
            return;
        }
        try {
            long start = System.currentTimeMillis();
            LOG.info("loadSerializedIPFilter(): loading " + ipFilterDBFile.length() + "  bytes from ip filter file");
            FileInputStream fis = new FileInputStream(ipFilterDBFile);
            int ranges = 0;
            IPFilterTableMediator.IPFilterModel dataModel = (IPFilterTableMediator.IPFilterModel)this.ipFilterTable.getDataModel();
            while (fis.available() > 0) {
                try {
                    dataModel.add(IPRange.readObjectFrom(fis), dataModel.getRowCount());
                    ++ranges;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (IllegalArgumentException e2) {
                    LOG.error("Invalid IPRange entry detected", e2);
                }
            }
            long end = System.currentTimeMillis();
            fis.close();
            long delta = end - start;
            LOG.info("loadSerializedIPFilter(): loaded " + ranges + " ip filter ranges in " + delta + "ms");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private File getIPFilterDBFile() {
        return new File(CommonUtils.getUserSettingsDir(), "ip_filter.db");
    }

    public void updateProgressBar(int percentage, String status) {
        if (percentage == this.lastPercentage) {
            return;
        }
        long timeSinceLastUpdate = System.currentTimeMillis() - this.lastPercentageUpdateTimestamp;
        if (this.lastPercentage < 99 && timeSinceLastUpdate < 1000L) {
            return;
        }
        this.lastPercentage = percentage;
        GUIMediator.safeInvokeLater(() -> {
            this.progressBar.setString(status + "...");
            this.progressBar.setValue(this.lastPercentage);
            this.progressBar.repaint();
            this.lastPercentageUpdateTimestamp = System.currentTimeMillis();
        });
    }

    private void onGunzipProgress(int percentage) {
        this.updateProgressBar(percentage, this.decompressingString);
    }

    public void enableImportControls(boolean enable) {
        GUIMediator.safeInvokeLater(() -> {
            this.fileUrlTextField.setEnabled(enable);
            this.fileChooserIcon.setEnabled(enable);
            this.importButton.setText(enable ? I18n.tr("Import") : I18n.tr("Importing..."));
            this.importButton.setEnabled(enable);
            this.clearFilterButton.setEnabled(enable);
            this.addRangeManuallyButton.setEnabled(enable);
            this.lastPercentageUpdateTimestamp = -1L;
            this.lastPercentage = -1;
            this.progressBar.setVisible(!enable);
            if (enable) {
                this.fileUrlTextField.requestFocus();
                this.fileUrlTextField.selectAll();
                this.updateProgressBar(0, "");
            }
        });
    }

    @Override
    public boolean applyOptions() throws IOException {
        return false;
    }

    @Override
    public boolean isDirty() {
        return false;
    }

    private static boolean isGZipped(File f) throws IOException {
        byte[] signature = new byte[2];
        FileInputStream fis = new FileInputStream(f);
        fis.read(signature);
        return signature[0] == 31 && signature[1] == -117;
    }

    private File gunzipFile(File gzipped, File gunzipped) {
        if (gunzipped.exists()) {
            gunzipped.delete();
            try {
                gunzipped.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        try {
            RandomAccessFile raf = new RandomAccessFile(gzipped, "r");
            raf.seek(raf.length() - 4L);
            int b4 = raf.read();
            int b3 = raf.read();
            int b2 = raf.read();
            int b1 = raf.read();
            raf.close();
            int uncompressedSize = b1 << 24 | (b2 << 16) + (b3 << 8) + b4;
            byte[] buffer = new byte[32768];
            GZIPInputStream gzipInputStream = new GZIPInputStream((InputStream)new FileInputStream(gzipped), buffer.length);
            FileOutputStream fileOutputStream = new FileOutputStream(gunzipped, false);
            int totalGunzipped = 0;
            while (gzipInputStream.available() == 1) {
                int read = gzipInputStream.read(buffer);
                if (read <= 0) continue;
                if (read != buffer.length) {
                    LOG.info("gunzipFile(): read = " + read);
                }
                fileOutputStream.write(buffer, 0, read);
                this.onGunzipProgress((int)((float)(totalGunzipped += read) * 100.0f / (float)uncompressedSize));
            }
            this.onGunzipProgress(100);
            gzipInputStream.close();
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (Throwable t) {
            LOG.error("gunzipFile(): " + t.getMessage(), t);
            gunzipped.delete();
            return null;
        }
        return new File(gunzipped.getAbsolutePath());
    }

    public void onRangeManuallyAdded(IPRange ipRange) {
        LOG.info("onRangeManuallyAdded() - " + ipRange);
    }

    private static class P2PIPFilterInputStreamReader
    implements IPFilterInputStreamReader {
        private BufferedReader br;
        private InputStream is;
        private int bytesRead;

        P2PIPFilterInputStreamReader(File uncompressedFile) {
            try {
                this.is = new FileInputStream(uncompressedFile);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            this.br = new BufferedReader(new InputStreamReader(this.is));
            this.bytesRead = 0;
        }

        @Override
        public IPRange readLine() {
            try {
                if (this.is.available() > 0) {
                    String line = this.br.readLine();
                    this.bytesRead += line.length();
                    while (line.startsWith("#") && this.is.available() > 0) {
                        line = this.br.readLine();
                        this.bytesRead += line.length();
                    }
                    Matcher matcher = P2P_LINE_PATTERN.matcher(line);
                    if (matcher.find()) {
                        return new IPRange(matcher.group(1), matcher.group(2), matcher.group(3));
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return null;
        }

        @Override
        public int bytesRead() {
            return this.bytesRead;
        }

        @Override
        public int available() {
            try {
                return this.is.available();
            }
            catch (IOException e) {
                e.printStackTrace();
                return -1;
            }
        }

        @Override
        public void close() {
            try {
                this.is.close();
                this.br.close();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    static enum IPFilterFormat {
        P2P;

    }
}

