/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options;

import com.frostwire.bittorrent.BTEngine;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.options.OptionsConstructor;
import com.limegroup.gnutella.gui.options.OptionsPaneManager;
import com.limegroup.gnutella.gui.options.OptionsTreeManager;
import com.limegroup.gnutella.gui.options.OptionsTreeNode;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.LibrarySettings;
import java.io.IOException;
import javax.swing.JDialog;
import org.limewire.setting.SettingsGroupManager;

public final class OptionsMediator {
    static final String ROOT_NODE_KEY = "OPTIONS_ROOT_NODE";
    private static final OptionsMediator INSTANCE = new OptionsMediator();
    private static OptionsPaneManager _paneManager = null;
    private static OptionsTreeManager _treeManager = null;
    private static OptionsConstructor _constructor = null;

    public static synchronized OptionsMediator instance() {
        return INSTANCE;
    }

    private OptionsMediator() {
        GUIMediator.setSplashScreenString(I18n.tr("Loading Options Window..."));
    }

    public final void setOptionsVisible(boolean visible) {
        this.setOptionsVisible(visible, null);
    }

    public final void setOptionsVisible(boolean visible, String key) {
        if (_constructor == null) {
            if (!visible) {
                return;
            }
            this.updateTheme();
        }
        _paneManager.initOptions();
        _constructor.setOptionsVisible(visible, key);
    }

    final void disposeOptions() {
        _constructor = null;
        _paneManager = null;
        _treeManager = null;
    }

    public final boolean isOptionsVisible() {
        if (_constructor == null) {
            return false;
        }
        return _constructor.isOptionsVisible();
    }

    public final void handleSelection(OptionsTreeNode node) {
        _paneManager.show(node);
        if (_constructor.isOptionsVisible()) {
            ApplicationSettings.OPTIONS_LAST_SELECTED_KEY.setValue(node.getTitleKey());
        }
    }

    public final void setSelection(String key) {
        _treeManager.setSelection(key);
    }

    public final void applyOptions() throws IOException {
        _paneManager.applyOptions();
        SettingsGroupManager.instance().save();
    }

    public final boolean isDirty() {
        if (_paneManager == null) {
            return false;
        }
        return _paneManager.isDirty();
    }

    final void revertOptions() {
        SettingsGroupManager.instance().revertToDefault();
        BTEngine.getInstance().revertToDefaultConfiguration();
        LibrarySettings.setupInitialLibraryFolders();
        GUIMediator.showMessage(I18n.tr("One or more options will take effect the next time FrostWire is restarted."));
    }

    public JDialog getMainOptionsComponent() {
        if (_constructor == null) {
            this.updateTheme();
        }
        return _constructor.getMainOptionsComponent();
    }

    private void updateTheme() {
        _paneManager = new OptionsPaneManager();
        _treeManager = new OptionsTreeManager();
        _constructor = new OptionsConstructor(_treeManager, _paneManager);
    }

    public void reinitPane(String paneKey) {
        _paneManager.reinitPane(paneKey);
    }
}

