/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options;

import com.frostwire.gui.searchfield.SearchField;
import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.DialogOption;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.PaddedPanel;
import com.limegroup.gnutella.gui.options.OptionsButtonPanel;
import com.limegroup.gnutella.gui.options.OptionsMediator;
import com.limegroup.gnutella.gui.options.OptionsPaneManager;
import com.limegroup.gnutella.gui.options.OptionsTreeManager;
import com.limegroup.gnutella.gui.options.OptionsTreeNode;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.gui.options.panes.AssociationPreferencePaneItem;
import com.limegroup.gnutella.gui.options.panes.AudioPlayerPaneItem;
import com.limegroup.gnutella.gui.options.panes.AutoCompletePaneItem;
import com.limegroup.gnutella.gui.options.panes.AutomaticInstallerDownloadPaneItem;
import com.limegroup.gnutella.gui.options.panes.BrowserPaneItem;
import com.limegroup.gnutella.gui.options.panes.BugsPaneItem;
import com.limegroup.gnutella.gui.options.panes.DetailsPaneItem;
import com.limegroup.gnutella.gui.options.panes.ExperimentalFeaturesPaneItem;
import com.limegroup.gnutella.gui.options.panes.IgnoreResultsPaneItem;
import com.limegroup.gnutella.gui.options.panes.ImageViewerPaneItem;
import com.limegroup.gnutella.gui.options.panes.LibraryFoldersPaneItem;
import com.limegroup.gnutella.gui.options.panes.MaximumSearchesPaneItem;
import com.limegroup.gnutella.gui.options.panes.NetworkInterfacePaneItem;
import com.limegroup.gnutella.gui.options.panes.PlayerPaneItem;
import com.limegroup.gnutella.gui.options.panes.PopupsPaneItem;
import com.limegroup.gnutella.gui.options.panes.ProxyLoginPaneItem;
import com.limegroup.gnutella.gui.options.panes.ProxyPaneItem;
import com.limegroup.gnutella.gui.options.panes.RouterConfigurationPaneItem;
import com.limegroup.gnutella.gui.options.panes.SearchEnginesPaneItem;
import com.limegroup.gnutella.gui.options.panes.ShowFrostWireRecommendationsPaneItem;
import com.limegroup.gnutella.gui.options.panes.ShowPromoOverlaysPaneItem;
import com.limegroup.gnutella.gui.options.panes.ShutdownPaneItem;
import com.limegroup.gnutella.gui.options.panes.SmartSearchDBPaneItem;
import com.limegroup.gnutella.gui.options.panes.StartupPaneItem;
import com.limegroup.gnutella.gui.options.panes.StatusBarBandwidthPaneItem;
import com.limegroup.gnutella.gui.options.panes.StatusBarConnectionQualityPaneItem;
import com.limegroup.gnutella.gui.options.panes.StatusBarFirewallPaneItem;
import com.limegroup.gnutella.gui.options.panes.TorrentConnectionPaneItem;
import com.limegroup.gnutella.gui.options.panes.TorrentGlobalSpeedPaneItem;
import com.limegroup.gnutella.gui.options.panes.TorrentSaveFolderPaneItem;
import com.limegroup.gnutella.gui.options.panes.TorrentSeedingSettingPaneItem;
import com.limegroup.gnutella.gui.options.panes.VideoPlayerPaneItem;
import com.limegroup.gnutella.gui.options.panes.iTunesPreferencePaneItem;
import com.limegroup.gnutella.gui.shell.FrostAssociations;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.UISettings;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JDialog;
import org.limewire.setting.IntSetting;
import org.limewire.setting.SettingsGroupManager;
import org.limewire.util.CommonUtils;
import org.limewire.util.OSUtils;

public final class OptionsConstructor {
    private final JDialog DIALOG;
    private final OptionsTreeManager TREE_MANAGER;
    private final OptionsPaneManager PANE_MANAGER;
    private final SearchField filterTextField;
    static final String SAVE_BASIC_KEY = "OPTIONS_SAVE_BASIC_MAIN_TITLE";
    public static final String SHARED_KEY = "OPTIONS_SHARED_MAIN_TITLE";
    static final String SHARED_BASIC_KEY = "OPTIONS_SHARED_BASIC_TITLE";
    static final String BITTORRENT_KEY = "OPTIONS_BITTORRENT_MAIN_TITLE";
    public static final String BITTORRENT_BASIC_KEY = "OPTIONS_BITTORRENT_BASIC_TITLE";
    public static final String BITTORRENT_ADVANCED_KEY = "OPTIONS_BITTORRENT_ADVANCED_TITLE";
    static final String SHUTDOWN_KEY = "OPTIONS_SHUTDOWN_MAIN_TITLE";
    public static final String LIBRARY_KEY = "OPTIONS_LIBRARY_MAIN_TITLE";
    static final String PLAYER_KEY = "OPTIONS_PLAYER_MAIN_TITLE";
    static final String STATUS_BAR_KEY = "OPTIONS_STATUS_BAR_MAIN_TITLE";
    static final String ITUNES_KEY = "OPTIONS_ITUNES_MAIN_TITLE";
    static final String ITUNES_IMPORT_KEY = "OPTIONS_ITUNES_PREFERENCE_MAIN_TITLE";
    static final String BUGS_KEY = "OPTIONS_BUGS_MAIN_TITLE";
    static final String APPS_KEY = "OPTIONS_APPS_MAIN_TITLE";
    static final String SEARCH_KEY = "OPTIONS_SEARCH_MAIN_TITLE";
    static final String FILTERS_KEY = "OPTIONS_FILTERS_MAIN_TITLE";
    static final String RESULTS_KEY = "OPTIONS_RESULTS_MAIN_TITLE";
    static final String IP_FILTER_KEY = "OPTIONS_IP_FILTER_MAIN_TITLE";
    static final String ADVANCED_KEY = "OPTIONS_ADVANCED_MAIN_TITLE";
    static final String PREFERENCING_KEY = "OPTIONS_PREFERENCING_MAIN_TITLE";
    static final String FIREWALL_KEY = "OPTIONS_FIREWALL_MAIN_TITLE";
    static final String EXPERIMENTAL_KEY = "OPTIONS_EXPERIMENTAL_MAIN_TITLE";
    static final String GUI_KEY = "OPTIONS_GUI_MAIN_TITLE";
    static final String STARTUP_KEY = "OPTIONS_STARTUP_MAIN_TITLE";
    static final String UXSTATS_KEY = "OPTIONS_UXSTATS_MAIN_TITLE";
    static final String PROXY_KEY = "OPTIONS_PROXY_MAIN_TITLE";
    static final String NETWORK_INTERFACE_KEY = "OPTIONS_NETWORK_INTERFACE_MAIN_TITLE";
    static final String ASSOCIATIONS_KEY = "OPTIONS_ASSOCIATIONS_MAIN_TITLE";
    private final Map<String, OptionsTreeNode> keysToNodes;

    public OptionsConstructor(OptionsTreeManager treeManager, OptionsPaneManager paneManager) {
        this.TREE_MANAGER = treeManager;
        this.PANE_MANAGER = paneManager;
        this.keysToNodes = new LinkedHashMap<String, OptionsTreeNode>();
        String title = I18n.tr("Options");
        boolean shouldBeModal = !OSUtils.isMacOSX();
        this.DIALOG = new JDialog(GUIMediator.getAppFrame(), title, shouldBeModal);
        this.DIALOG.setDefaultCloseOperation(0);
        GUIUtils.addHideAction((JComponent)this.DIALOG.getContentPane());
        if (UISettings.UI_OPTIONS_DIALOG_HEIGHT.getValue() < UISettings.UI_OPTIONS_DIALOG_HEIGHT.getDefaultValue()) {
            UISettings.UI_OPTIONS_DIALOG_HEIGHT.revertToDefault();
        }
        if (UISettings.UI_OPTIONS_DIALOG_WIDTH.getValue() < UISettings.UI_OPTIONS_DIALOG_WIDTH.getDefaultValue()) {
            UISettings.UI_OPTIONS_DIALOG_WIDTH.revertToDefault();
        }
        DialogSizeSettingUpdater.install(this.DIALOG, UISettings.UI_OPTIONS_DIALOG_WIDTH, UISettings.UI_OPTIONS_DIALOG_HEIGHT);
        this.DIALOG.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                try {
                    DialogOption answer = null;
                    if (OptionsMediator.instance().isDirty() && (answer = GUIMediator.showYesNoCancelMessage(I18n.tr("You have made changes to some of FrostWire's settings. Would you like to save these changes?"))) == DialogOption.YES) {
                        OptionsMediator.instance().applyOptions();
                        SettingsGroupManager.instance().save();
                    }
                    if (answer != DialogOption.CANCEL) {
                        OptionsConstructor.this.DIALOG.dispose();
                        OptionsMediator.instance().disposeOptions();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        PaddedPanel mainPanel = new PaddedPanel();
        Box splitBox = new Box(0);
        BoxPanel treePanel = new BoxPanel(1);
        BoxPanel filterPanel = new BoxPanel(0);
        treePanel.add(filterPanel);
        this.filterTextField = new SearchField();
        this.filterTextField.setPrompt(I18n.tr("Search here"));
        this.filterTextField.setMinimumSize(new Dimension(100, 27));
        this.filterTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionsConstructor.this.filter();
            }
        });
        filterPanel.add(this.filterTextField);
        filterPanel.add(Box.createHorizontalStrut(2));
        treePanel.add(Box.createVerticalStrut(3));
        Component treeComponent = this.TREE_MANAGER.getComponent();
        treePanel.add(treeComponent);
        Component paneComponent = this.PANE_MANAGER.getComponent();
        splitBox.add(treePanel);
        splitBox.add(paneComponent);
        mainPanel.add(splitBox);
        mainPanel.add(Box.createVerticalStrut(17));
        mainPanel.add(new OptionsButtonPanel().getComponent());
        this.DIALOG.getContentPane().add(mainPanel);
        OptionsTreeNode node = this.initializePanels();
        this.PANE_MANAGER.show(node);
    }

    private OptionsTreeNode initializePanels() {
        this.addGroupTreeNode("OPTIONS_ROOT_NODE", BITTORRENT_KEY, I18n.tr("BitTorrent"));
        this.addOption(BITTORRENT_KEY, BITTORRENT_BASIC_KEY, I18n.tr("Basic"), TorrentSaveFolderPaneItem.class, TorrentSeedingSettingPaneItem.class);
        this.addOption(BITTORRENT_KEY, BITTORRENT_ADVANCED_KEY, I18n.tr("Advanced"), TorrentGlobalSpeedPaneItem.class, TorrentConnectionPaneItem.class);
        this.addOption("OPTIONS_ROOT_NODE", LIBRARY_KEY, I18n.tr("Library"), LibraryFoldersPaneItem.class);
        this.addOption("OPTIONS_ROOT_NODE", PLAYER_KEY, I18n.tr("Player"), PlayerPaneItem.class);
        this.addOption("OPTIONS_ROOT_NODE", SEARCH_KEY, I18n.tr("Searching"), SearchEnginesPaneItem.class, MaximumSearchesPaneItem.class, SmartSearchDBPaneItem.class, DetailsPaneItem.class);
        this.addOption("OPTIONS_ROOT_NODE", STATUS_BAR_KEY, I18n.tr("Status Bar"), StatusBarConnectionQualityPaneItem.class, StatusBarFirewallPaneItem.class, StatusBarBandwidthPaneItem.class);
        if (this.isItunesSupported()) {
            this.addGroupTreeNode("OPTIONS_ROOT_NODE", ITUNES_KEY, I18n.tr("iTunes"));
            this.addOption(ITUNES_KEY, ITUNES_IMPORT_KEY, I18n.tr("Importing"), iTunesPreferencePaneItem.class);
        }
        if (!OSUtils.isWindows() && !OSUtils.isAnyMac()) {
            this.addOption("OPTIONS_ROOT_NODE", APPS_KEY, I18n.tr("Helper Apps"), BrowserPaneItem.class, ImageViewerPaneItem.class, VideoPlayerPaneItem.class, AudioPlayerPaneItem.class);
        }
        if (OSUtils.isWindows()) {
            this.addOption("OPTIONS_ROOT_NODE", GUI_KEY, I18n.tr("View"), PopupsPaneItem.class, ShowPromoOverlaysPaneItem.class, ShowFrostWireRecommendationsPaneItem.class, AutoCompletePaneItem.class);
        } else {
            this.addOption("OPTIONS_ROOT_NODE", GUI_KEY, I18n.tr("View"), PopupsPaneItem.class, ShowPromoOverlaysPaneItem.class, AutoCompletePaneItem.class);
        }
        this.addGroupTreeNode("OPTIONS_ROOT_NODE", FILTERS_KEY, I18n.tr("Filters"));
        this.addOption(FILTERS_KEY, RESULTS_KEY, I18n.tr("Keywords"), IgnoreResultsPaneItem.class);
        this.addGroupTreeNode("OPTIONS_ROOT_NODE", ADVANCED_KEY, I18n.tr("Advanced"));
        this.addOption(ADVANCED_KEY, PREFERENCING_KEY, I18n.tr("Updates"), AutomaticInstallerDownloadPaneItem.class);
        this.addOption(ADVANCED_KEY, EXPERIMENTAL_KEY, I18n.tr("Experimental"), ExperimentalFeaturesPaneItem.class);
        this.addOption(ADVANCED_KEY, FIREWALL_KEY, I18n.tr("Firewall"), RouterConfigurationPaneItem.class);
        this.addOption(ADVANCED_KEY, PROXY_KEY, I18n.tr("Proxy"), ProxyPaneItem.class, ProxyLoginPaneItem.class);
        this.addOption(ADVANCED_KEY, NETWORK_INTERFACE_KEY, I18n.tr("Network Interface"), NetworkInterfacePaneItem.class);
        if (FrostAssociations.anyAssociationsSupported()) {
            this.addOption(ADVANCED_KEY, ASSOCIATIONS_KEY, I18n.tr("File Associations"), AssociationPreferencePaneItem.class);
        }
        if (!CommonUtils.isPortable() && GUIUtils.shouldShowStartOnStartupWindow()) {
            this.addOption(ADVANCED_KEY, STARTUP_KEY, I18n.tr("System Boot"), StartupPaneItem.class);
        }
        if (!OSUtils.isAnyMac()) {
            this.addOption("OPTIONS_ROOT_NODE", SHUTDOWN_KEY, I18n.tr("System Tray"), ShutdownPaneItem.class);
        }
        this.addOption("OPTIONS_ROOT_NODE", BUGS_KEY, I18n.tr("Bug Reports"), BugsPaneItem.class);
        OptionsTreeNode node = this.keysToNodes.get(ApplicationSettings.OPTIONS_LAST_SELECTED_KEY.getValue());
        if (node == null) {
            ApplicationSettings.OPTIONS_LAST_SELECTED_KEY.revertToDefault();
            node = this.keysToNodes.get(ApplicationSettings.OPTIONS_LAST_SELECTED_KEY.getValue());
        }
        return node;
    }

    private boolean isItunesSupported() {
        return !CommonUtils.isPortable() && (OSUtils.isMacOSX() || OSUtils.isWindows());
    }

    private void addGroupTreeNode(String parentKey, String childKey, String label) {
        this.TREE_MANAGER.addNode(parentKey, childKey, label, label);
    }

    private OptionsTreeNode addOption(String parentKey, String childKey, String label, Class<? extends AbstractPaneItem> ... clazzes) {
        OptionsTreeNode node = this.TREE_MANAGER.addNode(parentKey, childKey, label, label + " " + this.extractLabels(clazzes));
        node.setClasses(clazzes);
        this.keysToNodes.put(childKey, node);
        return node;
    }

    private String extractLabels(Class<?> ... clazzes) {
        StringBuilder sb = new StringBuilder();
        for (Class<?> clazz : clazzes) {
            Field[] fields;
            for (Field field : fields = clazz.getFields()) {
                if ((field.getModifiers() & 0x10) == 0 || field.getType() != String.class) continue;
                try {
                    sb.append(field.get(null));
                    sb.append(" ");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return sb.toString();
    }

    final void setOptionsVisible(boolean visible, String key) {
        if (!visible) {
            this.DIALOG.dispose();
            OptionsMediator.instance().disposeOptions();
        } else {
            GUIUtils.centerOnScreen(this.DIALOG);
            if (key == null) {
                this.TREE_MANAGER.setSelection(ApplicationSettings.OPTIONS_LAST_SELECTED_KEY.getValue());
            } else {
                this.TREE_MANAGER.setSelection(key);
            }
            this.TREE_MANAGER.getComponent().requestFocusInWindow();
            this.DIALOG.setVisible(true);
        }
    }

    public final boolean isOptionsVisible() {
        return this.DIALOG.isVisible();
    }

    JDialog getMainOptionsComponent() {
        return this.DIALOG;
    }

    private void filter() {
        this.TREE_MANAGER.setFilterText(this.filterTextField.getText());
    }

    public static class DialogSizeSettingUpdater {
        public static void install(JDialog dialog, IntSetting widthSetting, IntSetting heightSetting) {
            int width = widthSetting.getValue();
            int height = heightSetting.getValue();
            dialog.setSize(width, height);
            dialog.addComponentListener(new SizeChangeListener(widthSetting, heightSetting));
        }

        private static class SizeChangeListener
        extends ComponentAdapter {
            private IntSetting widthSetting;
            private IntSetting heightSetting;

            public SizeChangeListener(IntSetting widthSetting, IntSetting heightSetting) {
                this.widthSetting = widthSetting;
                this.heightSetting = heightSetting;
            }

            @Override
            public void componentResized(ComponentEvent e) {
                Component c = e.getComponent();
                if (c.getWidth() != this.widthSetting.getValue() || c.getHeight() != this.heightSetting.getValue()) {
                    this.widthSetting.setValue(c.getWidth());
                    this.heightSetting.setValue(c.getHeight());
                }
            }
        }
    }
}

