/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.dnd;

import com.frostwire.gui.library.LibraryUtils;
import com.frostwire.gui.player.MediaPlayer;
import com.limegroup.gnutella.gui.dnd.FileTransferable;
import com.limegroup.gnutella.gui.dnd.LimeTransferHandler;
import com.limegroup.gnutella.gui.dnd.MagnetTransferHandler;
import com.limegroup.gnutella.gui.dnd.MulticastTransferHandler;
import com.limegroup.gnutella.gui.dnd.SendFileTransferHandler;
import com.limegroup.gnutella.gui.dnd.TorrentFilesTransferHandler;
import com.limegroup.gnutella.gui.dnd.TorrentURITransferHandler;
import com.limegroup.gnutella.util.URIUtils;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.InvalidDnDOperationException;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.TransferHandler;
import org.limewire.util.OSUtils;

public class DNDUtils {
    public static final List<LimeTransferHandler> DEFAULT_TRANSFER_HANDLERS = Collections.unmodifiableList(Arrays.asList(new MagnetTransferHandler(), new TorrentURITransferHandler(), new TorrentFilesTransferHandler(), new SendFileTransferHandler()));
    public static final LimeTransferHandler DEFAULT_TRANSFER_HANDLER = new MulticastTransferHandler(DEFAULT_TRANSFER_HANDLERS);

    static URI[] getURIs(Transferable transferable) throws UnsupportedFlavorException, IOException {
        String lines = (String)(DNDUtils.contains(transferable.getTransferDataFlavors(), FileTransferable.URIFlavor) ? transferable.getTransferData(FileTransferable.URIFlavor) : transferable.getTransferData(FileTransferable.URIFlavor16));
        StringTokenizer st = new StringTokenizer(lines, System.getProperty("line.separator"));
        ArrayList<URI> uris = new ArrayList<URI>();
        while (st.hasMoreTokens()) {
            String line = st.nextToken().trim();
            if (line.length() == 0) continue;
            try {
                URI uri = URIUtils.toURI(line);
                uris.add(uri);
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
        return uris.toArray(new URI[uris.size()]);
    }

    public static boolean contains(DataFlavor[] array, DataFlavor flavor) {
        for (DataFlavor anArray : array) {
            if (!flavor.equals(anArray)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsFileFlavors(DataFlavor[] flavors) {
        return flavors != null && (DNDUtils.contains(flavors, DataFlavor.javaFileListFlavor) || DNDUtils.contains(flavors, FileTransferable.URIFlavor) || DNDUtils.contains(flavors, FileTransferable.URIFlavor16));
    }

    public static File[] getFiles(Transferable transferable) throws UnsupportedFlavorException, IOException {
        if (DNDUtils.contains(transferable.getTransferDataFlavors(), DataFlavor.javaFileListFlavor)) {
            return ((List)transferable.getTransferData(DataFlavor.javaFileListFlavor)).toArray(new File[0]);
        }
        if (DNDUtils.contains(transferable.getTransferDataFlavors(), FileTransferable.URIFlavor) || DNDUtils.contains(transferable.getTransferDataFlavors(), FileTransferable.URIFlavor16)) {
            return DNDUtils.getFiles(DNDUtils.getURIs(transferable));
        }
        return new File[0];
    }

    public static File[] getFiles(URI[] uris) {
        ArrayList<File> files = new ArrayList<File>(uris.length);
        for (URI uri : uris) {
            String scheme = uri.getScheme();
            if (!uri.isAbsolute() || scheme == null || !scheme.equalsIgnoreCase("file")) continue;
            String path = uri.getPath();
            files.add(new File(path));
        }
        return files.toArray(new File[files.size()]);
    }

    public static boolean supportCanImport(DataFlavor dataFlavor, TransferHandler.TransferSupport support, TransferHandler fallbackTransferHandler, boolean fallback) {
        if (support.isDataFlavorSupported(dataFlavor)) {
            return true;
        }
        if (DNDUtils.containsFileFlavors(support.getDataFlavors())) {
            if (OSUtils.isMacOSX()) {
                return true;
            }
            try {
                File[] files = DNDUtils.getFiles(support.getTransferable());
                if (DNDUtils.containsPlayableFile(files)) {
                    return true;
                }
                if (files.length == 1 && files[0].getAbsolutePath().endsWith(".m3u")) {
                    return true;
                }
                return fallback && fallbackTransferHandler != null && fallbackTransferHandler.canImport(support);
            }
            catch (InvalidDnDOperationException e) {
                return true;
            }
            catch (Exception e) {
                return fallback && fallbackTransferHandler != null && fallbackTransferHandler.canImport(support);
            }
        }
        return false;
    }

    private static boolean containsPlayableFile(File[] files) {
        for (File file : files) {
            if (MediaPlayer.isPlayableFile(file)) {
                return true;
            }
            if (!file.isDirectory() || !LibraryUtils.directoryContainsAudio(file)) continue;
            return true;
        }
        return false;
    }
}

