/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LimeJProgressBar;
import com.limegroup.gnutella.gui.ResourceManager;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

class ShutdownWindow
extends JDialog {
    private static final long serialVersionUID = 446845150731872693L;
    private ImageIcon backgroundImage = ResourceManager.getImageFromResourcePath("org/limewire/gui/images/app_shutdown.jpg");

    ShutdownWindow() {
        super(GUIMediator.getAppFrame());
        this.setResizable(false);
        this.setTitle(I18n.tr("Shutting down FrostWire..."));
        this.setDefaultCloseOperation(0);
        JPanel backgroundPanel = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.drawImage(ShutdownWindow.this.backgroundImage.getImage(), 0, 0, null);
            }
        };
        backgroundPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                e.consume();
                GUIMediator.openURL("http://www.frostwire.com/android/?from=shutdown");
            }
        });
        backgroundPanel.setLayout(null);
        backgroundPanel.setSize(800, 500);
        this.add(backgroundPanel);
        Insets insets = backgroundPanel.getInsets();
        JLabel label = new JLabel(I18n.tr("Please wait while FrostWire shuts down..."));
        label.setFont(new Font("Dialog", 0, 16));
        Dimension labelPrefSize = label.getPreferredSize();
        backgroundPanel.add(label);
        label.setBounds(65 + insets.left, 400 + insets.top, labelPrefSize.width, labelPrefSize.height);
        LimeJProgressBar bar = new LimeJProgressBar();
        bar.setIndeterminate(true);
        bar.setStringPainted(false);
        backgroundPanel.add(bar);
        bar.setBounds(55 + insets.left, 428 + insets.top, 680, 30);
        ((JComponent)this.getContentPane()).setPreferredSize(new Dimension(800, 500));
        this.pack();
    }

    public static void main(String[] args) {
        ShutdownWindow window = new ShutdownWindow();
        window.setVisible(true);
    }
}

