/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.frostwire.util.Logger;
import com.limegroup.gnutella.gui.GUIMediator;
import java.io.File;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.util.List;

public class MacEventHandler {
    private static final Logger LOG = Logger.getLogger(MacEventHandler.class);
    private static MacEventHandler INSTANCE;

    public static synchronized MacEventHandler instance() {
        if (INSTANCE == null) {
            INSTANCE = new MacEventHandler();
        }
        return INSTANCE;
    }

    private MacEventHandler() {
        MacOSHandler.setAboutHandler(args -> this.handleAbout());
        MacOSHandler.setQuitHandler(args -> this.handleQuit());
        MacOSHandler.setAppReopenedListener(args -> this.handleReopen());
        MacOSHandler.setPreferencesHandler(args -> this.handlePreferences());
        MacOSHandler.setOpenFileHandler(args -> {
            List<File> files = MacOSHandler.getFiles(args[0]);
            if (files != null && files.size() > 0) {
                File file = files.get(0);
                LOG.debug("File: " + file);
                if (file.getName().toLowerCase().endsWith(".torrent")) {
                    GUIMediator.instance().openTorrentFile(file, false);
                }
            }
        });
        MacOSHandler.setOpenURIHandler(args -> {
            String uri = MacOSHandler.getURI(args[0]).toString();
            LOG.debug("URI: " + uri);
            if (uri.startsWith("magnet:?xt=urn:btih")) {
                GUIMediator.instance().openTorrentURI(uri, false);
            }
        });
    }

    private void handleAbout() {
        GUIMediator.showAboutWindow();
    }

    private void handleQuit() {
        GUIMediator.applyWindowSettings();
        GUIMediator.close(false);
    }

    private void handleReopen() {
        GUIMediator.handleReopen();
    }

    private void handlePreferences() {
        GUIMediator.instance().setOptionsVisible(true);
    }

    private static final class MacOSHandler
    implements InvocationHandler {
        private static final int javaVersion = MacOSHandler.javaVersion();
        private static final Class<?> applicationClass = MacOSHandler.applicationClass();
        private static final Object application = MacOSHandler.applicationObject();
        private final String handlerMethod;
        private final EventHandler handler;

        private MacOSHandler(String handlerMethod, EventHandler handler) {
            this.handlerMethod = handlerMethod;
            this.handler = handler;
        }

        @Override
        public final Object invoke(Object proxy, Method method, Object[] args) {
            try {
                if (this.handlerMethod.equals(method.getName()) && args.length > 0) {
                    this.handler.handle(args);
                }
            }
            catch (Throwable e) {
                LOG.error("Error invoking handler", e);
            }
            return null;
        }

        private static int javaVersion() {
            String versionStr = System.getProperty("java.version");
            if (versionStr.startsWith("1.8")) {
                return 8;
            }
            if (versionStr.startsWith("9")) {
                return 9;
            }
            if (versionStr.startsWith("10")) {
                return 10;
            }
            if (versionStr.startsWith("12")) {
                return 12;
            }
            throw new RuntimeException("Java version " + versionStr + " not supported");
        }

        private static Class<?> applicationClass() {
            try {
                if (javaVersion == 8) {
                    return Class.forName("com.apple.eawt.Application");
                }
                if (javaVersion >= 9) {
                    return Class.forName("java.awt.Desktop");
                }
            }
            catch (Throwable e) {
                LOG.error("Error getting application class", e);
            }
            return null;
        }

        private static Object applicationObject() {
            try {
                Method m = null;
                if (javaVersion == 8) {
                    m = applicationClass.getDeclaredMethod("getApplication", new Class[0]);
                }
                if (javaVersion >= 9) {
                    m = applicationClass.getDeclaredMethod("getDesktop", new Class[0]);
                }
                return m.invoke(null, new Object[0]);
            }
            catch (Throwable e) {
                LOG.error("Error creating application instance", e);
                return null;
            }
        }

        private static void setEventHandler(String methodName, String handlerName, String handlerMethod, EventHandler handler) {
            try {
                Class<?> handlerClass = Class.forName(handlerName);
                Method setMethod = null;
                try {
                    setMethod = applicationClass.getDeclaredMethod(methodName, handlerClass);
                }
                catch (NoSuchMethodException ignore) {
                    setMethod = applicationClass.getDeclaredMethod(methodName, handlerClass.getInterfaces()[0]);
                }
                MacOSHandler adapter = new MacOSHandler(handlerMethod, handler);
                Object proxy = Proxy.newProxyInstance(MacOSHandler.class.getClassLoader(), new Class[]{handlerClass}, (InvocationHandler)adapter);
                setMethod.invoke(application, proxy);
            }
            catch (Throwable e) {
                LOG.error("Error setting application handler", e);
            }
        }

        public static void setAboutHandler(EventHandler handler) {
            if (javaVersion == 8) {
                MacOSHandler.setEventHandler("setAboutHandler", "com.apple.eawt.AboutHandler", "handleAbout", handler);
            }
            if (javaVersion >= 9) {
                MacOSHandler.setEventHandler("setAboutHandler", "java.awt.desktop.AboutHandler", "handleAbout", handler);
            }
        }

        public static void setQuitHandler(EventHandler handler) {
            if (javaVersion == 8) {
                MacOSHandler.setEventHandler("setQuitHandler", "com.apple.eawt.QuitHandler", "handleQuitRequestWith", handler);
            }
            if (javaVersion >= 9) {
                MacOSHandler.setEventHandler("setQuitHandler", "java.awt.desktop.QuitHandler", "handleQuitRequestWith", handler);
            }
        }

        public static void setAppReopenedListener(EventHandler handler) {
            if (javaVersion == 8) {
                MacOSHandler.setEventHandler("addAppEventListener", "com.apple.eawt.AppReOpenedListener", "appReOpened", handler);
            }
            if (javaVersion >= 9) {
                MacOSHandler.setEventHandler("addAppEventListener", "java.awt.desktop.AppReopenedListener", "appReopened", handler);
            }
        }

        public static void setPreferencesHandler(EventHandler handler) {
            if (javaVersion == 8) {
                MacOSHandler.setEventHandler("setPreferencesHandler", "com.apple.eawt.PreferencesHandler", "handlePreferences", handler);
            }
            if (javaVersion >= 9) {
                MacOSHandler.setEventHandler("setPreferencesHandler", "java.awt.desktop.PreferencesHandler", "handlePreferences", handler);
            }
        }

        public static void setOpenFileHandler(EventHandler handler) {
            if (javaVersion == 8) {
                MacOSHandler.setEventHandler("setOpenFileHandler", "com.apple.eawt.OpenFilesHandler", "openFiles", handler);
            }
            if (javaVersion >= 9) {
                MacOSHandler.setEventHandler("setOpenFileHandler", "java.awt.desktop.OpenFilesHandler", "openFiles", handler);
            }
        }

        public static void setOpenURIHandler(EventHandler handler) {
            if (javaVersion == 8) {
                MacOSHandler.setEventHandler("setOpenURIHandler", "com.apple.eawt.OpenURIHandler", "openURI", handler);
            }
            if (javaVersion >= 9) {
                MacOSHandler.setEventHandler("setOpenURIHandler", "java.awt.desktop.OpenURIHandler", "openURI", handler);
            }
        }

        public static List<File> getFiles(Object event) {
            try {
                Method m = event.getClass().getMethod("getFiles", new Class[0]);
                return (List)m.invoke(event, new Object[0]);
            }
            catch (Throwable e) {
                LOG.error("Error invoking getFiles in event: " + event);
                return null;
            }
        }

        public static URI getURI(Object event) {
            try {
                Method m = event.getClass().getDeclaredMethod("getURI", new Class[0]);
                return (URI)m.invoke(event, new Object[0]);
            }
            catch (Throwable e) {
                LOG.error("Error invoking getFiles in event: " + event);
                return null;
            }
        }

        public static interface EventHandler {
            public void handle(Object[] var1);
        }
    }
}

