/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.ImageManipulator;
import com.limegroup.gnutella.gui.ResourceManager;
import com.limegroup.gnutella.settings.UISettings;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.commons.io.IOUtils;

public class ButtonIconController {
    private Icon NULL = new ImageIcon();
    private final Properties BUTTON_NAMES = ButtonIconController.loadButtonNameMap();
    private final Map<String, Icon> BUTTON_CACHE = new HashMap<String, Icon>();

    public void wipeButtonIconCache() {
        this.BUTTON_CACHE.clear();
    }

    public Icon getIconForButton(String buttonName) {
        if (buttonName == null) {
            return null;
        }
        String fileName = this.BUTTON_NAMES.getProperty(buttonName);
        if (fileName == null) {
            return null;
        }
        Icon icon = this.BUTTON_CACHE.get(fileName);
        if (icon == this.NULL) {
            return null;
        }
        if (icon != null) {
            return icon;
        }
        try {
            String retrieveName = UISettings.SMALL_ICONS.getValue() ? fileName + "_small" : fileName + "_large";
            icon = ResourceManager.getThemeImage(retrieveName);
            this.BUTTON_CACHE.put(fileName, icon);
        }
        catch (MissingResourceException mre) {
            try {
                icon = ResourceManager.getThemeImage(fileName);
                this.BUTTON_CACHE.put(fileName, icon);
            }
            catch (MissingResourceException mre2) {
                this.BUTTON_CACHE.put(fileName, this.NULL);
            }
        }
        return icon;
    }

    public Icon getSmallIconForButton(String buttonName) {
        String fileName = this.BUTTON_NAMES.getProperty(buttonName);
        if (fileName == null) {
            return null;
        }
        Icon icon = this.BUTTON_CACHE.get(fileName);
        if (icon == this.NULL) {
            return null;
        }
        if (icon != null) {
            return icon;
        }
        try {
            icon = ResourceManager.getThemeImage(fileName + "_small");
            this.BUTTON_CACHE.put(fileName, icon);
        }
        catch (MissingResourceException mre) {
            try {
                icon = ResourceManager.getThemeImage(fileName);
                this.BUTTON_CACHE.put(fileName, icon);
            }
            catch (MissingResourceException mre2) {
                this.BUTTON_CACHE.put(fileName, this.NULL);
            }
        }
        return icon;
    }

    public Icon getRolloverIconForButton(String buttonName) {
        String fileName = this.BUTTON_NAMES.getProperty(buttonName);
        if (fileName == null) {
            return null;
        }
        String rolloverName = fileName + "_rollover";
        Icon rollover = this.BUTTON_CACHE.get(rolloverName);
        if (rollover == this.NULL) {
            return null;
        }
        if (rollover != null) {
            return rollover;
        }
        Icon icon = this.BUTTON_CACHE.get(fileName);
        if (icon == this.NULL || icon == null) {
            this.BUTTON_CACHE.put(rolloverName, this.NULL);
            return null;
        }
        rollover = ImageManipulator.brighten(icon);
        if (rollover == null) {
            this.BUTTON_CACHE.put(rolloverName, this.NULL);
        } else {
            this.BUTTON_CACHE.put(rolloverName, rollover);
        }
        return rollover;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadButtonNameMap() {
        Properties p = new Properties();
        URL url = ResourceManager.getURLResource("icon_mapping.properties");
        BufferedInputStream is = null;
        try {
            if (url != null) {
                is = new BufferedInputStream(url.openStream());
                p.load(is);
            }
        }
        catch (IOException iOException) {
        }
        finally {
            IOUtils.closeQuietly(is);
        }
        return p;
    }
}

