/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.FileIconController;
import com.limegroup.gnutella.gui.search.NamedMediaType;
import java.io.File;
import javax.swing.Icon;
import org.apache.commons.io.FilenameUtils;

public class BasicFileIconController
implements FileIconController {
    @Override
    public Icon getIconForFile(File f) {
        if (f == null) {
            return null;
        }
        String extension = FilenameUtils.getExtension(f.getName());
        if (extension != null) {
            return this.getIconForExtension(extension);
        }
        return null;
    }

    @Override
    public Icon getIconForExtension(String ext) {
        NamedMediaType nmt = null;
        if (ext != null) {
            nmt = NamedMediaType.getFromExtension(ext);
        }
        if (nmt == null) {
            nmt = NamedMediaType.getFromDescription("*");
        }
        return nmt.getIcon();
    }

    @Override
    public boolean isIconForFileAvailable(File f) {
        return true;
    }

    @Override
    public boolean isValid() {
        return true;
    }
}

