/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.gui.I18n;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.limewire.collection.Comparators;
import org.limewire.util.FileUtils;

public class MediaType
implements Serializable {
    private static final long serialVersionUID = 3999062781289258389L;
    public static final String SCHEMA_ANY_TYPE = "*";
    public static final String SCHEMA_CUSTOM = "custom";
    public static final String SCHEMA_DOCUMENTS = "document";
    public static final String SCHEMA_PROGRAMS = "application";
    public static final String SCHEMA_AUDIO = "audio";
    public static final String SCHEMA_VIDEO = "video";
    public static final String SCHEMA_IMAGES = "image";
    public static final String SCHEMA_TORRENTS = "torrent";
    public static final String SCHEMA_OTHER = "other";
    public static final String ANY_TYPE = I18n.tr("All Types");
    public static final String DOCUMENTS = I18n.tr("Books/Docs");
    public static final String PROGRAMS = I18n.tr("Programs");
    public static final String AUDIO = I18n.tr("Audio");
    public static final String VIDEO = I18n.tr("Video");
    public static final String IMAGES = I18n.tr("Images");
    public static final String TORRENTS = I18n.tr("Torrents");
    private static final MediaType TYPE_ANY = new MediaType("*", ANY_TYPE, null){
        private static final long serialVersionUID = 8621997774686329539L;

        @Override
        public boolean matches(String ext) {
            return true;
        }
    };
    private static final MediaType TYPE_DOCUMENTS = new MediaType("document", DOCUMENTS, new String[]{"html", "htm", "xhtml", "mht", "mhtml", "xml", "txt", "ans", "asc", "diz", "eml", "pdf", "ps", "eps", "epsf", "dvi", "rtf", "wri", "doc", "mcw", "wps", "xls", "wk1", "dif", "csv", "ppt", "tsv", "hlp", "chm", "lit", "tex", "texi", "latex", "info", "man", "wp", "wpd", "wp5", "wk3", "wk4", "shw", "sdd", "sdw", "sdp", "sdc", "sxd", "sxw", "sxp", "sxc", "abw", "kwd", "mobi", "azw", "aeh", "lrf", "lrx", "cbr", "cbz", "cb7", "chm", "dnl", "djvu", "epub", "pdb", "fb2", "xeb", "ceb", "prc", "pkg", "opf", "pdg", "pdb", "tr2", "tr3", "cbr", "cbz", "cb7", "cbt", "cba", "docx"});
    private static final MediaType TYPE_LINUX_OSX_PROGRAMS = new MediaType("application", PROGRAMS, new String[]{"bin", "mdb", "sh", "csh", "awk", "pl", "rpm", "deb", "gz", "gzip", "z", "bz2", "zoo", "tar", "tgz", "taz", "shar", "hqx", "sit", "dmg", "7z", "jar", "zip", "nrg", "cue", "iso", "jnlp", "rar", "sh", "apk"});
    private static final MediaType TYPE_WINDOWS_PROGRAMS = new MediaType("application", PROGRAMS, new String[]{"exe", "zip", "jar", "cab", "msi", "msp", "arj", "rar", "ace", "lzh", "lha", "bin", "nrg", "cue", "iso", "jnlp", "apk"});
    private static final MediaType TYPE_PROGRAMS = new MediaType("application", PROGRAMS, MediaType.makeArray(MediaType.TYPE_LINUX_OSX_PROGRAMS.exts, MediaType.TYPE_WINDOWS_PROGRAMS.exts));
    private static final MediaType TYPE_AUDIO = new MediaType("audio", AUDIO, new String[]{"mp3", "mpa", "mp1", "mpga", "mp2", "ra", "rm", "ram", "rmj", "wma", "wav", "m4a", "m4p", "lqt", "ogg", "med", "aif", "aiff", "aifc", "au", "snd", "s3m", "aud", "mid", "midi", "rmi", "mod", "kar", "ac3", "shn", "fla", "flac", "cda", "mka", "aac"});
    private static final MediaType TYPE_VIDEO = new MediaType("video", VIDEO, new String[]{"mpg", "mpeg", "mpe", "mng", "mpv", "m1v", "vob", "mp2", "mpv2", "mp2v", "m2p", "m2v", "mpgv", "vcd", "mp4", "dv", "dvd", "div", "divx", "dvx", "smi", "smil", "rm", "ram", "rv", "rmm", "rmvb", "avi", "asf", "asx", "wmv", "qt", "mov", "fli", "flc", "flx", "flv", "wml", "vrml", "swf", "dcr", "jve", "nsv", "mkv", "ogm", "cdg", "srt", "sub", "idx", "webm", "3gp", "m4v"});
    private static final MediaType TYPE_IMAGES = new MediaType("image", IMAGES, new String[]{"gif", "png", "jpg", "jpeg", "jpe", "jif", "jiff", "jfif", "tif", "tiff", "iff", "lbm", "ilbm", "eps", "mac", "drw", "pct", "img", "bmp", "dib", "rle", "ico", "ani", "icl", "cur", "emf", "wmf", "pcx", "pcd", "tga", "pic", "fig", "psd", "wpg", "dcx", "cpt", "mic", "pbm", "pnm", "ppm", "xbm", "xpm", "xwd", "sgi", "fax", "rgb", "ras"});
    private static final MediaType TYPE_TORRENTS = new MediaType("torrent", TORRENTS, new String[]{"torrent"});
    private static final MediaType[] ALL_MEDIA_TYPES = new MediaType[]{TYPE_AUDIO, TYPE_DOCUMENTS, TYPE_IMAGES, TYPE_PROGRAMS, TYPE_TORRENTS, TYPE_VIDEO, TYPE_ANY};
    private final String schema;
    private final String descriptionKey;
    private final Set<String> exts;
    private final String[] extsArray;

    public MediaType(String schema, String descriptionKey, String[] extensions) {
        if (schema == null) {
            throw new NullPointerException("schema must not be null");
        }
        this.schema = schema;
        this.descriptionKey = descriptionKey;
        if (extensions == null) {
            this.exts = Collections.emptySet();
            this.extsArray = new String[0];
        } else {
            TreeSet<String> set = new TreeSet<String>(Comparators.caseInsensitiveStringComparator());
            set.addAll(Arrays.asList(extensions));
            this.exts = set;
            this.extsArray = this.exts.toArray(new String[0]);
        }
    }

    public boolean matches(String filename) {
        if (this.exts == null) {
            return true;
        }
        return FileUtils.hasExtension(filename, this.extsArray);
    }

    public String toString() {
        return this.schema;
    }

    public String getDescriptionKey() {
        return this.descriptionKey;
    }

    public String getMimeType() {
        return this.schema;
    }

    public Set<String> getExtensions() {
        return this.exts;
    }

    public static final MediaType[] getDefaultMediaTypes() {
        return ALL_MEDIA_TYPES;
    }

    public static MediaType getMediaTypeForSchema(String schema) {
        int i = ALL_MEDIA_TYPES.length;
        while (--i >= 0) {
            if (!schema.equals(MediaType.ALL_MEDIA_TYPES[i].schema)) continue;
            return ALL_MEDIA_TYPES[i];
        }
        return null;
    }

    public static MediaType getMediaTypeForExtension(String ext) {
        int i = ALL_MEDIA_TYPES.length;
        while (--i >= 0) {
            if (!MediaType.ALL_MEDIA_TYPES[i].exts.contains(ext)) continue;
            return ALL_MEDIA_TYPES[i];
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MediaType) {
            MediaType type = (MediaType)obj;
            return this.schema.equals(type.schema) && this.exts.equals(type.exts);
        }
        return false;
    }

    public static MediaType getAnyTypeMediaType() {
        return TYPE_ANY;
    }

    public static MediaType getAudioMediaType() {
        return TYPE_AUDIO;
    }

    public static MediaType getVideoMediaType() {
        return TYPE_VIDEO;
    }

    public static MediaType getImageMediaType() {
        return TYPE_IMAGES;
    }

    public static MediaType getTorrentMediaType() {
        return TYPE_TORRENTS;
    }

    public static MediaType getDocumentMediaType() {
        return TYPE_DOCUMENTS;
    }

    public static MediaType getProgramMediaType() {
        return TYPE_PROGRAMS;
    }

    private static String[] makeArray(Set<String> one, Set<String> two) {
        HashSet<String> all = new HashSet<String>(one);
        all.addAll(two);
        return all.toArray(new String[all.size()]);
    }

    public static class Aggregator {
        private List<MediaType> _filters = new LinkedList<MediaType>();

        private Aggregator() {
        }

        public boolean allow(String fName) {
            for (MediaType mt : this._filters) {
                if (!mt.matches(fName)) continue;
                return true;
            }
            return false;
        }
    }
}

