/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.util.filetypes;

import com.frostwire.util.filetypes.Action;
import com.frostwire.util.filetypes.RegisterFailedException;
import com.frostwire.util.filetypes.WinRegistryWrapper;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class WinRegistryUtil {
    private static final int MAX_CLSID_NUMBER = 1000;
    private static final int ERROR_SUCCESS = 0;
    private static final int ERROR_ITEM_EXISTED = 0;
    private static final int MAX_KEY_LENGTH = 255;
    private static final String VN_DEFAULT = "";
    private static final String SYS_USER_KN_PREFIX = "SOFTWARE\\Classes";
    private static final String VN_CONTENT = "Content type";
    private static final String KN_DEFAULTICON = "DefaultIcon";
    private static final String VN_DEFAULTGENERATOR = "Generated By";
    private static final String VALUE_DEFAULTGENERATOR = "Generated By Java-Association";
    private static final String KN_SHELL = "shell";
    private static final String KN_COMMAND = "command";
    private static final String KN_CURVER = "CurVer";
    private static final String KN_MIME = "MIME\\Database\\Content Type";
    private static final String VN_EXTENSION = "Extension";
    private static final String USER_FILE_EXT_KEY_PREFIX = "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\FileExts";
    private static final String USER_FILE_EXT_VALUENAME = "Application";
    private static final String USER_FILE_EXT_APP_PREFIX = "Applications";
    private static final int USER_LEVEL = 1;
    private static final int SYSTEM_LEVEL = 2;
    private static final int ROOT_LEVEL = 3;
    private static final String osName = System.getProperty("os.name");
    private static final String WIN2KOS = "Windows 2000";

    private WinRegistryUtil() {
    }

    private static int getHKeyByLevel(int regLevel) {
        int hKey;
        switch (regLevel) {
            case 1: {
                hKey = -2147483647;
                break;
            }
            case 2: {
                hKey = -2147483646;
                break;
            }
            case 3: {
                hKey = Integer.MIN_VALUE;
                break;
            }
            default: {
                hKey = Integer.MIN_VALUE;
            }
        }
        return hKey;
    }

    private static String genClassID(String fileExt, int regLevel) {
        boolean isClsIDExist = true;
        String temFileExt = fileExt.trim();
        if (temFileExt.charAt(0) == '.') {
            temFileExt = temFileExt.substring(1);
        }
        for (int i = 1; isClsIDExist && i < 1000; ++i) {
            String temClsIDKey;
            String appendix = Integer.toString(i);
            String temClsID = "class" + temFileExt + appendix;
            if (temClsID == null || (temClsIDKey = WinRegistryUtil.getClsIDKey(temClsID, regLevel)) == null || (isClsIDExist = WinRegistryUtil.isSubKeyExist(temClsIDKey, regLevel))) continue;
            return temClsID;
        }
        return null;
    }

    private static boolean isSubKeyExist(String subKey, int regLevel) {
        int hKey = WinRegistryUtil.getHKeyByLevel(regLevel);
        return WinRegistryWrapper.WinRegSubKeyExist(hKey, subKey) == 0;
    }

    private static boolean isValueExist(String subKey, String valueName, int regLevel) {
        int hKey;
        return WinRegistryUtil.isSubKeyExist(subKey, regLevel) && WinRegistryWrapper.WinRegValueExist(hKey = WinRegistryUtil.getHKeyByLevel(regLevel), subKey, valueName) == 0;
    }

    private static String getMimeTypeKey(String mimeType, int regLevel) {
        String mimeSubKey = "MIME\\Database\\Content Type\\" + mimeType;
        if (regLevel != 3) {
            mimeSubKey = "SOFTWARE\\Classes\\" + mimeSubKey;
        }
        return mimeSubKey;
    }

    private static String getFileExtKey(String fileExt, int regLevel) {
        String fileExtKey = fileExt;
        if (regLevel != 3) {
            fileExtKey = "SOFTWARE\\Classes\\" + fileExtKey;
        }
        return fileExtKey;
    }

    private static String getClsIDKey(String clsID, int regLevel) {
        String clsIDKey = clsID;
        if (regLevel != 3) {
            clsIDKey = "SOFTWARE\\Classes\\" + clsIDKey;
        }
        return clsIDKey;
    }

    private static String getIconKey(String fileExt, int regLevel) {
        String clsID = WinRegistryUtil.getClassIDByFileExt(fileExt, regLevel);
        if (clsID != null) {
            String iconKey = clsID + "\\" + KN_DEFAULTICON;
            if (regLevel != 3) {
                iconKey = "SOFTWARE\\Classes\\" + iconKey;
            }
            return iconKey;
        }
        return null;
    }

    private static void regCreateKeyEx(String subKey, int regLevel) throws RegisterFailedException {
        int hKey = WinRegistryUtil.getHKeyByLevel(regLevel);
        if (WinRegistryWrapper.WinRegCreateKeyEx(hKey, subKey) != 0) {
            throw new RegisterFailedException("Key " + subKey + " creation error!");
        }
    }

    private static void regDeleteKey(String subKey, int regLevel) throws RegisterFailedException {
        int hKey = WinRegistryUtil.getHKeyByLevel(regLevel);
        if (WinRegistryWrapper.WinRegDeleteKey(hKey, subKey) != 0) {
            throw new RegisterFailedException("Key " + subKey + " delete error.");
        }
    }

    private static String regQueryValueEx(String subKey, String valueName, int regLevel) {
        if (WinRegistryUtil.isValueExist(subKey, valueName, regLevel)) {
            int hKey = WinRegistryUtil.getHKeyByLevel(regLevel);
            return WinRegistryWrapper.WinRegQueryValueEx(hKey, subKey, valueName);
        }
        return null;
    }

    private static void regSetValueEx(String subKey, String valueName, String value, int regLevel) throws RegisterFailedException {
        int hKey;
        if (!WinRegistryUtil.isSubKeyExist(subKey, regLevel)) {
            WinRegistryUtil.regCreateKeyEx(subKey, regLevel);
        }
        if (WinRegistryWrapper.WinRegSetValueEx(hKey = WinRegistryUtil.getHKeyByLevel(regLevel), subKey, valueName, value) != 0) {
            throw new RegisterFailedException("Value: valueName setting error");
        }
    }

    private static String[] regGetSubKeys(String subKey, int regLevel) {
        int hKey = WinRegistryUtil.getHKeyByLevel(regLevel);
        return WinRegistryWrapper.WinRegGetSubKeys(hKey, subKey, 255);
    }

    private static String getDefaultValue(String subKey, int regLevel) {
        int hKey = WinRegistryUtil.getHKeyByLevel(regLevel);
        return WinRegistryWrapper.WinRegQueryValueEx(hKey, subKey, VN_DEFAULT);
    }

    private static void setDefaultValue(String subKey, String value, int regLevel) throws RegisterFailedException {
        int hKey;
        if (!WinRegistryUtil.isSubKeyExist(subKey, regLevel)) {
            WinRegistryUtil.regCreateKeyEx(subKey, regLevel);
        }
        if (WinRegistryWrapper.WinRegSetValueEx(hKey = WinRegistryUtil.getHKeyByLevel(regLevel), subKey, VN_DEFAULT, value) != 0) {
            throw new RegisterFailedException("Set default value for key " + subKey + " error.");
        }
        WinRegistryWrapper.WinRegFlushKey(hKey, subKey);
    }

    private static void addActionByClsID(Action action, String clsID, int regLevel) throws RegisterFailedException {
        String verb = action.getVerb();
        String desc = action.getDescription();
        String cmd = action.getCommand();
        String clsIDKey = WinRegistryUtil.getClsIDKey(clsID, regLevel);
        String shellKey = clsIDKey + "\\" + KN_SHELL;
        String verbKey = shellKey + "\\" + verb;
        String cmdKey = verbKey + "\\" + KN_COMMAND;
        if (cmdKey != null) {
            WinRegistryUtil.regCreateKeyEx(cmdKey, regLevel);
            if (cmd != null) {
                WinRegistryUtil.setDefaultValue(cmdKey, cmd, regLevel);
                if (desc != null && verbKey != null) {
                    WinRegistryUtil.setDefaultValue(verbKey, desc, regLevel);
                }
            }
        }
    }

    public static String getMimeTypeByFileExt(String fileExt, int regLevel) {
        String fileExtKey = WinRegistryUtil.getFileExtKey(fileExt, regLevel);
        if (fileExtKey != null) {
            return WinRegistryUtil.regQueryValueEx(fileExtKey, VN_CONTENT, regLevel);
        }
        return null;
    }

    public static String getMimeTypeByFileExt(String fileExt) {
        return WinRegistryUtil.getMimeTypeByFileExt(fileExt, 3);
    }

    public static void setMimeTypeByFileExt(String mimeType, String fileExt, int regLevel) throws RegisterFailedException {
        String fileExtKey = WinRegistryUtil.getFileExtKey(fileExt, regLevel);
        if (fileExtKey != null) {
            WinRegistryUtil.regSetValueEx(fileExtKey, VN_CONTENT, mimeType, regLevel);
        }
    }

    public static String getFileExtByMimeType(String mimeType, int regLevel) {
        String mimeSubKey = WinRegistryUtil.getMimeTypeKey(mimeType, regLevel);
        if (mimeSubKey != null) {
            return WinRegistryUtil.regQueryValueEx(mimeSubKey, VN_EXTENSION, regLevel);
        }
        return null;
    }

    public static String getFileExtByMimeType(String mimeType) {
        return WinRegistryUtil.getFileExtByMimeType(mimeType, 3);
    }

    public static void setFileExtByMimeType(String fileExt, String mimeType, int regLevel) throws RegisterFailedException {
        String mimeSubKey = WinRegistryUtil.getMimeTypeKey(mimeType, regLevel);
        if (mimeSubKey != null) {
            WinRegistryUtil.regSetValueEx(mimeSubKey, VN_EXTENSION, fileExt, regLevel);
        }
    }

    public static String getIconFileNameByFileExt(String fileExt, int regLevel) {
        String iconKey = WinRegistryUtil.getIconKey(fileExt, regLevel);
        if (iconKey == null) {
            return null;
        }
        String unDealedFileName = WinRegistryUtil.getDefaultValue(iconKey, regLevel);
        if (unDealedFileName == null) {
            return null;
        }
        return WinRegistryUtil.ExpandEnvironmentStrings(unDealedFileName);
    }

    public static String getIconFileNameByFileExt(String fileExt) {
        return WinRegistryUtil.getIconFileNameByFileExt(fileExt, 3);
    }

    public static void setIconFileNameByFileExt(String iconFileName, String fileExt, int regLevel) throws RegisterFailedException {
        String temClassID;
        String iconKey = WinRegistryUtil.getIconKey(fileExt, regLevel);
        if (iconKey == null && (temClassID = WinRegistryUtil.genClassID(fileExt, regLevel)) != null) {
            WinRegistryUtil.setClassIDByFileExt(fileExt, temClassID, regLevel);
            iconKey = WinRegistryUtil.getIconKey(fileExt, regLevel);
        }
        if (iconKey != null) {
            WinRegistryUtil.setDefaultValue(iconKey, iconFileName, regLevel);
        }
    }

    public static String getDescriptionByFileExt(String fileExt, int regLevel) {
        String clsIDKey;
        String classID = WinRegistryUtil.getClassIDByFileExt(fileExt, regLevel);
        if (classID != null && (clsIDKey = WinRegistryUtil.getClsIDKey(classID, regLevel)) != null) {
            return WinRegistryUtil.getDefaultValue(clsIDKey, regLevel);
        }
        return null;
    }

    public static String getDescriptionByFileExt(String fileExt) {
        return WinRegistryUtil.getDescriptionByFileExt(fileExt, 3);
    }

    public static void setDescriptionByFileExt(String description, String fileExt, int regLevel) throws RegisterFailedException {
        String clsIDKey;
        String classID = WinRegistryUtil.getClassIDByFileExt(fileExt, regLevel);
        if (classID == null && (classID = WinRegistryUtil.genClassID(fileExt, regLevel)) != null) {
            WinRegistryUtil.setClassIDByFileExt(fileExt, classID, regLevel);
        }
        if (classID != null && (clsIDKey = WinRegistryUtil.getClsIDKey(classID, regLevel)) != null) {
            WinRegistryUtil.setDefaultValue(clsIDKey, description, regLevel);
        }
    }

    public static void markGeneratorByFileExt(String fileExt, int regLevel) throws RegisterFailedException {
        String clsID = WinRegistryUtil.getClassIDByFileExt(fileExt, regLevel);
        String clsIDKey = WinRegistryUtil.getClsIDKey(clsID, regLevel);
        if (clsIDKey != null) {
            WinRegistryUtil.regSetValueEx(clsIDKey, VN_DEFAULTGENERATOR, VALUE_DEFAULTGENERATOR, regLevel);
        }
    }

    public static List<Action> getActionListByFileExt(String fileExt, int regLevel) {
        ArrayList<Action> actionList = null;
        String clsID = WinRegistryUtil.getClassIDByFileExt(fileExt, regLevel);
        if (clsID != null) {
            int verbsNum;
            String clsIDKey = WinRegistryUtil.getClsIDKey(clsID, regLevel);
            String shellKey = clsIDKey + "\\" + KN_SHELL;
            String[] verbs = null;
            if (shellKey != null) {
                verbs = WinRegistryUtil.regGetSubKeys(shellKey, regLevel);
            }
            if (verbs != null && (verbsNum = verbs.length) > 0) {
                actionList = new ArrayList<Action>();
                for (int i = 0; i < verbsNum; ++i) {
                    String verbKey = shellKey + "\\" + verbs[i];
                    String cmdKey = verbKey + "\\" + KN_COMMAND;
                    if (cmdKey == null) continue;
                    String temCmd = WinRegistryUtil.getDefaultValue(cmdKey, regLevel);
                    temCmd = temCmd == null ? VN_DEFAULT : WinRegistryUtil.ExpandEnvironmentStrings(temCmd);
                    Action oneAction = new Action(verbs[i], temCmd, WinRegistryUtil.getDefaultValue(verbKey, regLevel));
                    actionList.add(oneAction);
                }
            }
        }
        return actionList;
    }

    public static List<Action> getActionListByFileExt(String fileExt) {
        List<Action> rootActionList = WinRegistryUtil.getActionListByFileExt(fileExt, 3);
        List<Action> userDefinedList = WinRegistryUtil.getUserAddedActionListByFileExt(fileExt);
        if (userDefinedList != null) {
            return userDefinedList;
        }
        return rootActionList;
    }

    private static List<Action> getUserAddedActionListByFileExt(String fileExt) {
        int verbsNum;
        String fileExtKey = "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\FileExts\\" + fileExt;
        String valueName = USER_FILE_EXT_VALUENAME;
        int hKey = -2147483647;
        String appName = WinRegistryWrapper.WinRegQueryValueEx(hKey, fileExtKey, valueName);
        String[] verbs = null;
        String appShellKey = "Applications\\" + appName + "\\" + KN_SHELL;
        hKey = Integer.MIN_VALUE;
        verbs = WinRegistryWrapper.WinRegGetSubKeys(hKey, appShellKey, 255);
        ArrayList<Action> actionList = null;
        if (verbs != null && (verbsNum = verbs.length) > 0) {
            actionList = new ArrayList<Action>();
            for (int i = 0; i < verbsNum; ++i) {
                String verbKey = appShellKey + "\\" + verbs[i];
                String cmdKey = verbKey + "\\" + KN_COMMAND;
                if (cmdKey == null) continue;
                String temCmd = WinRegistryUtil.getDefaultValue(cmdKey, 3);
                temCmd = temCmd == null ? VN_DEFAULT : WinRegistryUtil.ExpandEnvironmentStrings(temCmd);
                Action oneAction = new Action(verbs[i], temCmd, WinRegistryUtil.getDefaultValue(verbKey, 3));
                actionList.add(oneAction);
            }
        }
        return actionList;
    }

    public static void setActionListByFileExt(List<Action> actionList, String fileExt, int regLevel) throws RegisterFailedException {
        String clsID = WinRegistryUtil.getClassIDByFileExt(fileExt, regLevel);
        if (clsID == null && (clsID = WinRegistryUtil.genClassID(fileExt, regLevel)) != null) {
            WinRegistryUtil.setClassIDByFileExt(fileExt, clsID, regLevel);
        }
        if (clsID != null && actionList != null) {
            for (Action oneAction : actionList) {
                if (oneAction == null || clsID == null) continue;
                WinRegistryUtil.addActionByClsID(oneAction, clsID, regLevel);
            }
        }
    }

    public static String getMimeTypeByURL(URL url) {
        return WinRegistryWrapper.WinFindMimeFromData(url);
    }

    public static String ExpandEnvironmentStrings(String cmdString) {
        return WinRegistryWrapper.WinExpandEnvironmentStrings(cmdString);
    }

    public static boolean isMimeTypeExist(String mimeType, int regLevel) {
        String mimeTypeKey = WinRegistryUtil.getMimeTypeKey(mimeType, regLevel);
        if (mimeTypeKey != null) {
            return WinRegistryUtil.isSubKeyExist(mimeTypeKey, regLevel);
        }
        return false;
    }

    public static boolean isMimeTypeExist(String mimeType) {
        return WinRegistryUtil.isMimeTypeExist(mimeType, 3);
    }

    public static boolean isFileExtExist(String fileExt, int regLevel) {
        String fileExtKey = WinRegistryUtil.getFileExtKey(fileExt, regLevel);
        if (fileExtKey != null) {
            return WinRegistryUtil.isSubKeyExist(fileExtKey, regLevel) || WinRegistryUtil.isWin2kUserDefinedFileExtExist(fileExt);
        }
        return false;
    }

    public static boolean isWin2kUserDefinedFileExtExist(String fileExt) {
        boolean win2kFileDefinedByUser = false;
        if (osName.equalsIgnoreCase(WIN2KOS)) {
            String fileExtKey = "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\FileExts\\" + fileExt;
            win2kFileDefinedByUser = WinRegistryUtil.isSubKeyExist(fileExtKey, 1);
        }
        return win2kFileDefinedByUser;
    }

    public static boolean isFileExtExist(String fileExt) {
        return WinRegistryUtil.isFileExtExist(fileExt, 3);
    }

    public static void addFileExt(String fileExt, int regLevel) throws RegisterFailedException {
        String fileExtKey = WinRegistryUtil.getFileExtKey(fileExt, regLevel);
        if (fileExtKey != null) {
            WinRegistryUtil.regCreateKeyEx(fileExtKey, regLevel);
        }
    }

    public static void removeFileExt(String fileExt, int regLevel) throws RegisterFailedException {
        if (WinRegistryUtil.isFileExtExist(fileExt, regLevel)) {
            String clsIDKey;
            String fileExtKey = WinRegistryUtil.getFileExtKey(fileExt, regLevel);
            String clsID = WinRegistryUtil.getClassIDByFileExt(fileExt, regLevel);
            if (clsID != null && (clsIDKey = WinRegistryUtil.getClsIDKey(clsID, regLevel)) != null) {
                WinRegistryUtil.regDeleteKey(clsIDKey, regLevel);
            }
            if (fileExtKey != null && WinRegistryUtil.isSubKeyExist(fileExtKey, regLevel)) {
                WinRegistryUtil.regDeleteKey(fileExtKey, regLevel);
            }
            if (WinRegistryUtil.isWin2kUserDefinedFileExtExist(fileExt)) {
                fileExtKey = "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\FileExts\\" + fileExt;
                WinRegistryUtil.regDeleteKey(fileExtKey, 1);
            }
        }
    }

    public static void addMimeType(String mimeType, int regLevel) throws RegisterFailedException {
        String temMimeKey = WinRegistryUtil.getMimeTypeKey(mimeType, regLevel);
        if (temMimeKey != null) {
            WinRegistryUtil.regCreateKeyEx(temMimeKey, regLevel);
        }
    }

    public static void removeMimeType(String mimeType, int regLevel) throws RegisterFailedException {
        String mimeKey;
        if (WinRegistryUtil.isMimeTypeExist(mimeType, regLevel) && (mimeKey = WinRegistryUtil.getMimeTypeKey(mimeType, regLevel)) != null) {
            WinRegistryUtil.regDeleteKey(mimeKey, regLevel);
        }
    }

    public static void setClassIDByFileExt(String fileExt, String classID, int regLevel) throws RegisterFailedException {
        String fileExtKey = WinRegistryUtil.getFileExtKey(fileExt, regLevel);
        String clsIDKey = WinRegistryUtil.getClsIDKey(classID, regLevel);
        if (fileExtKey != null) {
            if (!WinRegistryUtil.isSubKeyExist(fileExtKey, regLevel)) {
                WinRegistryUtil.addFileExt(fileExt, regLevel);
            }
            if (!WinRegistryUtil.isSubKeyExist(clsIDKey, regLevel) && clsIDKey != null) {
                WinRegistryUtil.regCreateKeyEx(clsIDKey, regLevel);
            }
            WinRegistryUtil.setDefaultValue(fileExtKey, classID, regLevel);
        }
    }

    public static String getClassIDByFileExt(String fileExt, int regLevel) {
        String fileExtKey = WinRegistryUtil.getFileExtKey(fileExt, regLevel);
        if (fileExtKey != null && WinRegistryUtil.isSubKeyExist(fileExtKey, regLevel)) {
            return WinRegistryUtil.getCurVerClassID(WinRegistryUtil.getDefaultValue(fileExtKey, regLevel), regLevel);
        }
        return null;
    }

    private static String getCurVerClassID(String defaultVerClassID, int regLevel) {
        String curVerClassIDKey = defaultVerClassID + "\\" + KN_CURVER;
        if (regLevel != 3) {
            curVerClassIDKey = "SOFTWARE\\Classes\\" + curVerClassIDKey;
        }
        if (WinRegistryUtil.isSubKeyExist(curVerClassIDKey, regLevel)) {
            return WinRegistryUtil.getDefaultValue(curVerClassIDKey, regLevel);
        }
        return defaultVerClassID;
    }

    public static void setMutualRef(String fileExt, String mimeType, int regLevel) throws RegisterFailedException {
        String mimeKey = WinRegistryUtil.getMimeTypeKey(mimeType, regLevel);
        String fileExtKey = WinRegistryUtil.getFileExtKey(fileExt, regLevel);
        if (mimeKey != null && fileExtKey != null && WinRegistryUtil.isSubKeyExist(fileExtKey, regLevel) && WinRegistryUtil.isSubKeyExist(mimeKey, regLevel)) {
            WinRegistryUtil.setMimeTypeByFileExt(mimeType, fileExt, regLevel);
            WinRegistryUtil.setFileExtByMimeType(fileExt, mimeType, regLevel);
        }
    }
}

