/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.util;

import java.util.logging.Level;

public final class Logger {
    private final java.util.logging.Logger jul;
    private final String name;

    private Logger(java.util.logging.Logger jul) {
        this.jul = jul;
        this.name = jul.getName();
    }

    public static Logger getLogger(Class<?> clazz) {
        return new Logger(java.util.logging.Logger.getLogger(clazz.getSimpleName()));
    }

    public String getName() {
        return this.name;
    }

    public void info(String msg, boolean showCallingMethodInfo) {
        this.jul.logp(Level.INFO, this.name, "", showCallingMethodInfo ? Logger.appendCallingMethodInfo(msg) : msg);
    }

    public void info(String msg) {
        this.info(msg, false);
    }

    public void info(String msg, Throwable e, boolean showCallingMethodInfo) {
        this.jul.logp(Level.INFO, this.name, "", showCallingMethodInfo ? Logger.appendCallingMethodInfo(msg) : msg, e);
    }

    public void info(String msg, Throwable e) {
        this.info(msg, e, false);
    }

    public void warn(String msg, boolean showCallingMethodInfo) {
        this.jul.logp(Level.INFO, this.name, "", showCallingMethodInfo ? Logger.appendCallingMethodInfo(msg) : msg);
    }

    public void warn(String msg) {
        this.warn(msg, false);
    }

    public void warn(String msg, Throwable e, boolean showCallingMethodInfo) {
        this.jul.logp(Level.INFO, this.name, "", showCallingMethodInfo ? Logger.appendCallingMethodInfo(msg) : msg, e);
    }

    public void warn(String msg, Throwable e) {
        this.warn(msg, e, false);
    }

    public void error(String msg, boolean showCallingMethodInfo) {
        this.jul.logp(Level.INFO, this.name, "", showCallingMethodInfo ? Logger.appendCallingMethodInfo(msg) : msg);
    }

    public void error(String msg) {
        this.error(msg, false);
    }

    public void error(String msg, Throwable e, boolean showCallingMethodInfo) {
        this.jul.logp(Level.INFO, this.name, "", showCallingMethodInfo ? Logger.appendCallingMethodInfo(msg) : msg, e);
    }

    public void error(String msg, Throwable e) {
        this.error(msg, e, false);
    }

    public void debug(String msg, boolean showCallingMethodInfo) {
        this.jul.logp(Level.INFO, this.name, "", showCallingMethodInfo ? Logger.appendCallingMethodInfo(msg) : msg);
    }

    public void debug(String msg) {
        this.debug(msg, false);
    }

    public void debug(String msg, Throwable e, boolean showCallingMethodInfo) {
        this.jul.logp(Level.INFO, this.name, "", showCallingMethodInfo ? Logger.appendCallingMethodInfo(msg) : msg, e);
    }

    public void debug(String msg, Throwable e) {
        this.debug(msg, e, false);
    }

    private static String getCallingMethodInfo() {
        Thread currentThread = Thread.currentThread();
        StackTraceElement[] stackTrace = currentThread.getStackTrace();
        String caller = " - <Thread not scheduled yet>";
        if (stackTrace.length >= 5) {
            StackTraceElement stackElement = stackTrace[5];
            caller = " - Called from <" + stackElement.getFileName() + "::" + stackElement.getMethodName() + ":" + stackElement.getLineNumber() + " on thread:" + currentThread.getName() + "(tid=" + currentThread.getId() + ")>";
        }
        return caller;
    }

    private static String appendCallingMethodInfo(String msg) {
        return msg + Logger.getCallingMethodInfo();
    }
}

