/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.tests;

import com.frostwire.search.SearchError;
import com.frostwire.search.SearchListener;
import com.frostwire.search.SearchResult;
import com.frostwire.search.nyaa.NyaaSearchPerformer;
import com.frostwire.search.nyaa.NyaaSearchResult;
import com.frostwire.util.HttpClientFactory;
import com.frostwire.util.UrlUtils;
import com.frostwire.util.http.HttpClient;
import java.util.List;

public class NyaaSearchPerformerTest {
    public static void main(String[] args) {
        String TEST_SEARCH_TERM = UrlUtils.encode("foo");
        HttpClient httpClient = HttpClientFactory.newInstance();
        NyaaSearchPerformer nyaa = new NyaaSearchPerformer("nyaa.si", 1L, TEST_SEARCH_TERM, 5000);
        nyaa.setListener(new SearchListener(){

            @Override
            public void onResults(long token, List<? extends SearchResult> results) {
                for (SearchResult searchResult : results) {
                    NyaaSearchResult sr = (NyaaSearchResult)searchResult;
                    System.out.println("NyaaSearchPerformer.SearchListener.onResults:");
                    System.out.println("\t DisplayName: " + sr.getDisplayName());
                    System.out.println("\t Source: " + sr.getSource());
                    System.out.println("\t DetailsUrl: " + sr.getDetailsUrl());
                    System.out.println("\t Filename: " + sr.getFilename());
                    System.out.println("\t Hash: " + sr.getHash());
                    System.out.println("\t TorrentUrl: " + sr.getTorrentUrl());
                    System.out.println("\t Seeds: " + sr.getSeeds());
                    System.out.println("\t Size: " + sr.getSize());
                }
            }

            @Override
            public void onError(long token, SearchError error) {
            }

            @Override
            public void onStopped(long token) {
            }
        });
        try {
            nyaa.perform();
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.out.println("Aborting test.");
            return;
        }
    }
}

