/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.search.soundcloud;

import com.frostwire.search.PagedWebSearchPerformer;
import com.frostwire.search.SearchResult;
import com.frostwire.search.soundcloud.SoundcloudItem;
import com.frostwire.search.soundcloud.SoundcloudPlaylist;
import com.frostwire.search.soundcloud.SoundcloudResponse;
import com.frostwire.search.soundcloud.SoundcloudSearchResult;
import com.frostwire.util.JsonUtils;
import java.util.LinkedList;
import java.util.List;

public final class SoundcloudSearchPerformer
extends PagedWebSearchPerformer {
    private static final String SOUNDCLOUD_CLIENTID = "KBuk0RhNCHjjzHf0m6wVb8So4pCQg5jW";
    private static final String SOUNDCLOUD_APP_VERSION = "1516627364";

    public SoundcloudSearchPerformer(String domainName, long token, String keywords, int timeout) {
        super(domainName, token, keywords, timeout, 1);
    }

    @Override
    protected String getUrl(int page, String encodedKeywords) {
        return "https://api-v2.soundcloud.com/search/tracks?q=" + encodedKeywords + "&limit=50&offset=0&client_id=" + SOUNDCLOUD_CLIENTID;
    }

    @Override
    protected List<? extends SearchResult> searchPage(String page) {
        LinkedList<SoundcloudSearchResult> result = new LinkedList<SoundcloudSearchResult>();
        SoundcloudResponse obj = JsonUtils.toObject(page, SoundcloudResponse.class);
        if (obj != null && obj.collection != null) {
            for (SoundcloudItem item : obj.collection) {
                if (this.isStopped() || item == null || !item.downloadable) continue;
                SoundcloudSearchResult sr = new SoundcloudSearchResult(item, SOUNDCLOUD_CLIENTID, SOUNDCLOUD_APP_VERSION);
                result.add(sr);
            }
        }
        return result;
    }

    public static String resolveUrl(String url) {
        return "http://api.soundcloud.com/resolve.json?url=" + url + "&client_id=" + SOUNDCLOUD_CLIENTID + "&app_version=" + SOUNDCLOUD_APP_VERSION;
    }

    public static LinkedList<SoundcloudSearchResult> fromJson(String json) {
        LinkedList<SoundcloudSearchResult> r = new LinkedList<SoundcloudSearchResult>();
        if (json.contains("\"collection\":")) {
            SoundcloudResponse obj = JsonUtils.toObject(json, SoundcloudResponse.class);
            if (obj != null && obj.collection != null) {
                for (SoundcloudItem item : obj.collection) {
                    if (item == null || !item.downloadable) continue;
                    SoundcloudSearchResult sr = new SoundcloudSearchResult(item, SOUNDCLOUD_CLIENTID, SOUNDCLOUD_APP_VERSION);
                    r.add(sr);
                }
            }
        } else if (json.contains("\"tracks\":")) {
            SoundcloudPlaylist obj = JsonUtils.toObject(json, SoundcloudPlaylist.class);
            if (obj != null && obj.tracks != null) {
                for (SoundcloudItem item : obj.tracks) {
                    if (item == null || !item.downloadable) continue;
                    SoundcloudSearchResult sr = new SoundcloudSearchResult(item, SOUNDCLOUD_CLIENTID, SOUNDCLOUD_APP_VERSION);
                    r.add(sr);
                }
            }
        } else {
            SoundcloudItem item = JsonUtils.toObject(json, SoundcloudItem.class);
            if (item != null) {
                SoundcloudSearchResult sr = new SoundcloudSearchResult(item, SOUNDCLOUD_CLIENTID, SOUNDCLOUD_APP_VERSION);
                r.add(sr);
            }
        }
        return r;
    }
}

