/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.search.filter;

import com.frostwire.search.SearchResult;
import com.frostwire.search.filter.FilterKey;
import com.frostwire.search.filter.SearchFilter;
import com.frostwire.search.filter.SearchGroup;
import com.frostwire.search.filter.SearchTable;
import com.frostwire.search.filter.SearchViewListener;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;

public final class SearchView {
    private final SearchTable table;
    private final SearchFilter filter;
    private final SortedMap<FilterKey, SearchGroup> groups;
    private SearchViewListener listener;

    public SearchView(SearchTable table, SearchFilter filter) {
        this.table = table;
        this.filter = filter;
        this.groups = new TreeMap<FilterKey, SearchGroup>();
        this.add(table.data());
    }

    public SearchFilter filter() {
        return this.filter;
    }

    public SortedMap<FilterKey, SearchGroup> groups() {
        return Collections.unmodifiableSortedMap(this.groups);
    }

    public void add(List<? extends SearchResult> results) {
        LinkedList<SearchResult> added = new LinkedList<SearchResult>();
        for (SearchResult searchResult : results) {
            if (!this.filter.accept(searchResult)) continue;
            FilterKey key = this.filter.key(searchResult);
            SearchGroup group = (SearchGroup)this.groups.get(key);
            if (group == null) {
                group = new SearchGroup(this.filter);
                this.groups.put(key, group);
            }
            group.add(searchResult);
            added.add(searchResult);
        }
        if (this.listener != null && added.size() > 0) {
            this.listener.viewAdded(this, added);
        }
    }

    public void refresh() {
        this.clear();
        this.add(this.table.data());
    }

    public SearchViewListener getListener() {
        return this.listener;
    }

    public void setListener(SearchViewListener listener) {
        this.listener = listener;
    }

    public void clear() {
        for (SearchGroup g : this.groups.values()) {
            g.clear();
        }
        this.groups.clear();
        if (this.listener != null) {
            this.listener.viewChanged(this);
        }
    }
}

