/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.search.filter;

import com.frostwire.search.SearchResult;
import com.frostwire.search.filter.FilterKey;
import com.frostwire.search.filter.SearchFilter;
import java.util.Comparator;

public final class SearchFilters {
    private SearchFilters() {
    }

    public static SearchFilter add(SearchFilter f1, SearchFilter f2) {
        return new AddFilter(f1, f2);
    }

    private static final class AddComparator
    implements Comparator<SearchResult> {
        private final Comparator<SearchResult> c1;
        private final Comparator<SearchResult> c2;

        public AddComparator(Comparator<SearchResult> c1, Comparator<SearchResult> c2) {
            this.c1 = c1;
            this.c2 = c2;
        }

        @Override
        public int compare(SearchResult o1, SearchResult o2) {
            int n = this.c1.compare(o1, o2);
            return n != 0 ? n : this.c2.compare(o1, o2);
        }
    }

    private static final class AddKey
    implements FilterKey {
        private final FilterKey k1;
        private final FilterKey k2;

        public AddKey(FilterKey k1, FilterKey k2) {
            this.k1 = k1;
            this.k2 = k2;
        }

        @Override
        public String display() {
            return this.k1.display() + ", " + this.k2.display();
        }

        @Override
        public int compareTo(FilterKey o) {
            if (!(o instanceof AddKey)) {
                return -1;
            }
            int n = this.k1.compareTo(((AddKey)o).k1);
            return n != 0 ? n : this.k2.compareTo(((AddKey)o).k2);
        }
    }

    private static final class AddFilter
    implements SearchFilter {
        private final SearchFilter f1;
        private final SearchFilter f2;

        public AddFilter(SearchFilter f1, SearchFilter f2) {
            this.f1 = f1;
            this.f2 = f2;
        }

        @Override
        public FilterKey key(SearchResult sr) {
            return new AddKey(this.f1.key(sr), this.f2.key(sr));
        }

        @Override
        public boolean accept(SearchResult sr) {
            return this.f1.accept(sr) && this.f2.accept(sr);
        }

        @Override
        public Comparator<SearchResult> comparator() {
            return new AddComparator(this.f1.comparator(), this.f2.comparator());
        }
    }
}

