/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.search;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;

final class KeywordMediaType
implements Serializable {
    private static final long serialVersionUID = 3999062781289258389L;
    public static final String SCHEMA_CUSTOM = "custom";
    public static final String SCHEMA_DOCUMENTS = "document";
    public static final String SCHEMA_PROGRAMS = "application";
    public static final String SCHEMA_AUDIO = "audio";
    public static final String SCHEMA_VIDEO = "video";
    public static final String SCHEMA_IMAGES = "image";
    public static final String SCHEMA_TORRENTS = "torrent";
    public static final String SCHEMA_OTHER = "other";
    private static final KeywordMediaType TYPE_DOCUMENTS = new KeywordMediaType(1, "document", new String[]{"html", "htm", "xhtml", "mht", "mhtml", "xml", "txt", "ans", "asc", "diz", "eml", "pdf", "ps", "eps", "epsf", "dvi", "rtf", "wri", "doc", "docx", "mcw", "wps", "xls", "wk1", "dif", "csv", "ppt", "tsv", "hlp", "chm", "lit", "tex", "texi", "latex", "info", "man", "wp", "wpd", "wp5", "wk3", "wk4", "shw", "sdd", "sdw", "sdp", "sdc", "sxd", "sxw", "sxp", "sxc", "abw", "kwd", "mobi", "azw", "aeh", "lrf", "lrx", "cbr", "cbz", "cb7", "chm", "dnl", "djvu", "epub", "pdb", "fb2", "xeb", "ceb", "prc", "pkg", "opf", "pdg", "pdb", "tr2", "tr3", "cbr", "cbz", "cb7", "cbt", "cba", "zip", "7z", "rar", "gzip", "tar", "gz", "cab", "msi", "ace", "sit", "dmg", "taz", "sh", "awk", "pl", "java", "py", "rb", "c", "cpp", "h", "hpp"});
    private static final KeywordMediaType TYPE_APPLICATIONS = new KeywordMediaType(2, "application", new String[]{"apk"});
    private static final KeywordMediaType TYPE_AUDIO = new KeywordMediaType(3, "audio", new String[]{"mp3", "mpa", "mp1", "mpga", "mp2", "ra", "rm", "ram", "rmj", "wma", "wav", "m4a", "m4p", "lqt", "ogg", "med", "aif", "aiff", "aifc", "au", "snd", "s3m", "aud", "mid", "midi", "rmi", "mod", "kar", "ac3", "shn", "fla", "flac", "cda", "mka, aac"});
    private static final KeywordMediaType TYPE_VIDEO = new KeywordMediaType(4, "video", new String[]{"mpg", "mpeg", "mpe", "mng", "mpv", "m1v", "vob", "mp2", "mpv2", "mp2v", "m2p", "m2v", "mpgv", "vcd", "mp4", "dv", "dvd", "div", "divx", "dvx", "smi", "smil", "rm", "ram", "rv", "rmm", "rmvb", "avi", "asf", "asx", "wmv", "qt", "mov", "fli", "flc", "flx", "flv", "wml", "vrml", "swf", "dcr", "jve", "nsv", "mkv", "ogm", "cdg", "srt", "sub", "idx", "webm", "3gp"});
    private static final KeywordMediaType TYPE_PICTURES = new KeywordMediaType(5, "image", new String[]{"gif", "png", "jpg", "jpeg", "jpe", "jif", "jiff", "jfif", "tif", "tiff", "iff", "lbm", "ilbm", "eps", "mac", "drw", "pct", "img", "bmp", "dib", "rle", "ico", "ani", "icl", "cur", "emf", "wmf", "pcx", "pcd", "tga", "pic", "fig", "psd", "wpg", "dcx", "cpt", "mic", "pbm", "pnm", "ppm", "xbm", "xpm", "xwd", "sgi", "fax", "rgb", "ras"});
    public static final KeywordMediaType TYPE_TORRENTS = new KeywordMediaType(6, "torrent", new String[]{"torrent"});
    private static final KeywordMediaType[] ALL_MEDIA_TYPES = new KeywordMediaType[]{TYPE_AUDIO, TYPE_DOCUMENTS, TYPE_PICTURES, TYPE_TORRENTS, TYPE_VIDEO, TYPE_APPLICATIONS};
    private final int id;
    private final String schema;
    private final Set<String> exts;
    private final boolean isDefault;

    public KeywordMediaType(int id, String schema, String[] extensions) {
        if (schema == null) {
            throw new NullPointerException("schema must not be null");
        }
        this.id = id;
        this.schema = schema;
        this.isDefault = true;
        if (extensions == null) {
            this.exts = Collections.emptySet();
        } else {
            TreeSet<String> set = new TreeSet<String>(new CaseInsensitiveStringComparator());
            set.addAll(Arrays.asList(extensions));
            this.exts = set;
        }
    }

    public int getId() {
        return this.id;
    }

    public boolean matches(String filename) {
        if (this.exts == null) {
            return true;
        }
        int j = filename.lastIndexOf(".");
        if (j == -1 || j == filename.length()) {
            return false;
        }
        String suffix = filename.substring(j + 1);
        return this.exts.contains(suffix);
    }

    public String toString() {
        return this.schema;
    }

    public String getMimeType() {
        return this.schema;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public Set<String> getExtensions() {
        return this.exts;
    }

    public static KeywordMediaType[] getDefaultMediaTypes() {
        return ALL_MEDIA_TYPES;
    }

    public static KeywordMediaType getMediaTypeForSchema(String schema) {
        int i = ALL_MEDIA_TYPES.length;
        while (--i >= 0) {
            if (!schema.equals(KeywordMediaType.ALL_MEDIA_TYPES[i].schema)) continue;
            return ALL_MEDIA_TYPES[i];
        }
        return null;
    }

    public static KeywordMediaType getMediaTypeForExtension(String ext) {
        if (ext == null) {
            return null;
        }
        int i = ALL_MEDIA_TYPES.length;
        while (--i >= 0) {
            if (!KeywordMediaType.ALL_MEDIA_TYPES[i].exts.contains(ext)) continue;
            return ALL_MEDIA_TYPES[i];
        }
        return null;
    }

    public static boolean isDefaultType(String schema) {
        int i = ALL_MEDIA_TYPES.length;
        while (--i >= 0) {
            if (!schema.equals(KeywordMediaType.ALL_MEDIA_TYPES[i].schema)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj instanceof KeywordMediaType) {
            KeywordMediaType type = (KeywordMediaType)obj;
            return this.schema.equals(type.schema) && this.exts.equals(type.exts) && this.isDefault == type.isDefault;
        }
        return false;
    }

    public int hashCode() {
        return 31 * (1 + this.id) * (11 * this.getExtensions().hashCode());
    }

    Object readResolve() throws ObjectStreamException {
        for (KeywordMediaType type : ALL_MEDIA_TYPES) {
            if (!this.equals(type)) continue;
            return type;
        }
        return this;
    }

    public static KeywordMediaType getAudioMediaType() {
        return TYPE_AUDIO;
    }

    public static KeywordMediaType getVideoMediaType() {
        return TYPE_VIDEO;
    }

    public static KeywordMediaType getImageMediaType() {
        return TYPE_PICTURES;
    }

    public static KeywordMediaType getTorrentMediaType() {
        return TYPE_TORRENTS;
    }

    public static KeywordMediaType getDocumentMediaType() {
        return TYPE_DOCUMENTS;
    }

    public static KeywordMediaType getApplicationsMediaType() {
        return TYPE_APPLICATIONS;
    }

    public static final class CaseInsensitiveStringComparator
    implements Comparator<String>,
    Serializable {
        private static final long serialVersionUID = 263123571237995212L;

        @Override
        public int compare(String o1, String o2) {
            return o1.compareToIgnoreCase(o2);
        }
    }
}

