/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.search;

import com.frostwire.regex.Pattern;
import com.frostwire.search.FileSearchResult;
import com.frostwire.search.KeywordMediaType;
import com.frostwire.search.SearchResult;
import com.frostwire.util.HistoHashMap;
import com.frostwire.util.Logger;
import com.frostwire.util.ThreadPool;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.io.FilenameUtils;

public final class KeywordDetector {
    private static final Logger LOG = Logger.getLogger(KeywordDetector.class);
    private static final Set<String> stopWords = new HashSet<String>();
    private static final Pattern REPLACE_ALL_PATTERN = Pattern.compile("[^\\p{L}0-9 .]|\\.{2,}");
    private final Map<Feature, HistoHashMap<String>> histoHashMaps = new HashMap<Feature, HistoHashMap<String>>();
    private KeywordDetectorListener keywordDetectorListener;
    private final HistogramUpdateRequestDispatcher histogramUpdateRequestsDispatcher = new HistogramUpdateRequestDispatcher();
    private ExecutorService threadPool;
    private int totalHistogramKeysCount = -1;

    public KeywordDetector() {
        this.histoHashMaps.put(Feature.SEARCH_SOURCE, new HistoHashMap());
        this.histoHashMaps.put(Feature.FILE_EXTENSION, new HistoHashMap());
        this.histoHashMaps.put(Feature.FILE_NAME, new HistoHashMap());
    }

    public int totalHistogramKeys() {
        if (this.totalHistogramKeysCount == -1) {
            this.getFilteredHistograms();
        }
        return this.totalHistogramKeysCount;
    }

    public void notifyKeywordDetectorListener() {
        if (this.keywordDetectorListener != null) {
            this.keywordDetectorListener.notifyHistogramsUpdate(this.getFilteredHistograms());
        }
    }

    public void setKeywordDetectorListener(KeywordDetectorListener listener) {
        this.keywordDetectorListener = listener;
    }

    public void addSearchTerms(Feature feature, String terms) {
        String[] pre_tokens = REPLACE_ALL_PATTERN.matcher(terms).replaceAll("").toLowerCase().split("\\s");
        if (pre_tokens.length == 0) {
            return;
        }
        for (String token : pre_tokens) {
            if (feature.minimumTokenLength > (token = token.trim()).length() || token.length() > feature.maximumTokenLength || stopWords.contains(token)) continue;
            this.updateHistogramTokenCount(feature, token);
        }
    }

    public void feedSearchResults(List<? extends SearchResult> copiedResults) {
        for (SearchResult searchResult : copiedResults) {
            String fileName;
            this.addSearchTerms(Feature.SEARCH_SOURCE, searchResult.getSource());
            if (!(searchResult instanceof FileSearchResult) || (fileName = ((FileSearchResult)searchResult).getFilename()) == null || fileName.isEmpty()) continue;
            this.addSearchTerms(Feature.FILE_NAME, fileName);
            String extension = FilenameUtils.getExtension(fileName);
            if ("youtube".equals(extension)) continue;
            KeywordMediaType mt = KeywordMediaType.getMediaTypeForExtension(extension);
            if (extension == null || extension.isEmpty() || mt == null) continue;
            this.addSearchTerms(Feature.FILE_EXTENSION, extension);
        }
    }

    private void updateHistogramTokenCount(Feature feature, String token) {
        HistoHashMap<String> histogram = this.histoHashMaps.get((Object)feature);
        if (histogram != null && token != null) {
            histogram.update(token);
        }
    }

    public void clearHistogramUpdateRequestDispatcher() {
        this.histogramUpdateRequestsDispatcher.clear();
    }

    public void shutdownHistogramUpdateRequestDispatcher() {
        this.histogramUpdateRequestsDispatcher.shutdown();
    }

    public Map<Feature, List<Map.Entry<String, Integer>>> getFilteredHistograms() {
        HashMap<Feature, List<Map.Entry<String, Integer>>> filteredHistograms = new HashMap<Feature, List<Map.Entry<String, Integer>>>();
        this.totalHistogramKeysCount = 0;
        for (Feature feature : this.histoHashMaps.keySet()) {
            List<Map.Entry<String, Integer>> histogram;
            List<Map.Entry<String, Integer>> filteredHistogram;
            HistoHashMap<String> histoHashMap = this.histoHashMaps.get((Object)feature);
            if (histoHashMap.getKeyCount() <= 0 || (filteredHistogram = KeywordDetector.highPassFilter(histogram = histoHashMap.histogram(), feature.filterThreshold)).size() <= 0) continue;
            filteredHistograms.put(feature, filteredHistogram);
            this.totalHistogramKeysCount += filteredHistogram.size();
        }
        return filteredHistograms;
    }

    public static List<Map.Entry<String, Integer>> highPassFilter(List<Map.Entry<String, Integer>> histogram, float threshold) {
        int high = 0;
        int totalCount = 0;
        for (Map.Entry<String, Integer> entry2 : histogram) {
            int count = entry2.getValue();
            totalCount += count;
            if (count <= high) continue;
            high = count;
        }
        LinkedList<Map.Entry<String, Integer>> filteredValues = new LinkedList<Map.Entry<String, Integer>>();
        for (Map.Entry<String, Integer> entry3 : histogram) {
            float rate = (float)entry3.getValue().intValue() / (float)(high + totalCount);
            if (entry3.getValue() <= 1 || !(rate >= threshold)) continue;
            filteredValues.add(entry3);
        }
        return filteredValues;
    }

    public void requestHistogramsUpdateAsync(List<SearchResult> filtered) {
        if (!this.histogramUpdateRequestsDispatcher.running.get()) {
            this.histogramUpdateRequestsDispatcher.start();
        }
        HistogramUpdateRequestTask histogramUpdateRequestTask = new HistogramUpdateRequestTask(this, filtered);
        this.histogramUpdateRequestsDispatcher.enqueue(histogramUpdateRequestTask);
    }

    public void reset() {
        this.histogramUpdateRequestsDispatcher.clear();
        if (this.histoHashMaps != null && !this.histoHashMaps.isEmpty()) {
            for (HistoHashMap<String> stringHistoHashMap : this.histoHashMaps.values()) {
                stringHistoHashMap.reset();
            }
        }
        this.notifyKeywordDetectorListener();
    }

    private static void feedStopWords(String ... words) {
        Collections.addAll(stopWords, words);
    }

    static {
        KeywordDetector.feedStopWords("-", "an", "and", "are", "as", "at", "be", "by", "for", "with", "when", "where");
        KeywordDetector.feedStopWords("from", "has", "he", "in", "is", "it", "its", "of", "on", "we", "why", "your");
        KeywordDetector.feedStopWords("that", "the", "to", "that", "this", "ft", "ft.", "feat", "feat.", "no", "me", "null");
        KeywordDetector.feedStopWords("can", "cant", "not", "get", "into", "have", "had", "put", "you", "dont", "youre");
        KeywordDetector.feedStopWords("son", "como", "en", "ser", "por", "d\u00c3\u00b3nde", "donde", "cuando", "el");
        KeywordDetector.feedStopWords("de", "tiene", "\u00c3\u00a9l", "en", "es", "su", "de", "en", "nosotros", "por", "qu\u00c3\u00a9", "que");
        KeywordDetector.feedStopWords("eso", "el", "esa", "esto", "yo", "usted", "tu", "los", "para");
        KeywordDetector.feedStopWords("filho", "como", "em", "quando", "nos");
        KeywordDetector.feedStopWords("tem", "ele", "seu", "n\u00c3\u00b3s", "quem");
        KeywordDetector.feedStopWords("isto", "voce", "voc\u00c3\u00aa", "seu");
        KeywordDetector.feedStopWords("fils", "sous", "par", "o\u00c3\u00b9", "ou", "quand");
        KeywordDetector.feedStopWords("leur", "dans", "nous", "par", "ce", "qui");
        KeywordDetector.feedStopWords("il", "le", "vous", "votre");
    }

    public static interface KeywordDetectorListener {
        public void notifyHistogramsUpdate(Map<Feature, List<Map.Entry<String, Integer>>> var1);

        public void onKeywordDetectorFinished();
    }

    private class HistogramUpdateRequestDispatcher
    implements Runnable {
        private static final long HISTOGRAM_REQUEST_TASK_DELAY_IN_MS = 1000L;
        private final AtomicLong lastHistogramUpdateRequestFinished;
        private final List<HistogramUpdateRequestTask> histogramUpdateRequests;
        private final AtomicBoolean running = new AtomicBoolean(false);
        private final ReentrantLock lock = new ReentrantLock();
        private final Condition loopLock = this.lock.newCondition();

        public HistogramUpdateRequestDispatcher() {
            this.histogramUpdateRequests = new LinkedList<HistogramUpdateRequestTask>();
            this.lastHistogramUpdateRequestFinished = new AtomicLong(0L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void enqueue(HistogramUpdateRequestTask updateRequestTask) {
            if (!this.running.get() || updateRequestTask == null) {
                return;
            }
            List<HistogramUpdateRequestTask> list = this.histogramUpdateRequests;
            synchronized (list) {
                this.histogramUpdateRequests.add(0, updateRequestTask);
                if (this.histogramUpdateRequests.size() > 4) {
                    Object[] requestsArray = this.histogramUpdateRequests.toArray();
                    ArrayList<HistogramUpdateRequestTask> head = new ArrayList<HistogramUpdateRequestTask>(4);
                    head.add((HistogramUpdateRequestTask)requestsArray[0]);
                    head.add((HistogramUpdateRequestTask)requestsArray[1]);
                    head.add((HistogramUpdateRequestTask)requestsArray[2]);
                    head.add((HistogramUpdateRequestTask)requestsArray[3]);
                    this.histogramUpdateRequests.clear();
                    this.histogramUpdateRequests.addAll(head);
                }
            }
            this.signalLoopLock();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.running.get()) {
                long timeSinceLastFinished;
                if (this.histogramUpdateRequests.size() > 0 && (timeSinceLastFinished = System.currentTimeMillis() - this.lastHistogramUpdateRequestFinished.get()) > 1000L) {
                    HistogramUpdateRequestTask histogramUpdateRequestTask;
                    List<HistogramUpdateRequestTask> list = this.histogramUpdateRequests;
                    synchronized (list) {
                        try {
                            histogramUpdateRequestTask = this.histogramUpdateRequests.remove(0);
                        }
                        catch (Throwable t) {
                            histogramUpdateRequestTask = null;
                        }
                    }
                    if (histogramUpdateRequestTask != null && this.running.get() && KeywordDetector.this.threadPool != null) {
                        try {
                            KeywordDetector.this.threadPool.execute(histogramUpdateRequestTask);
                        }
                        catch (Throwable t) {
                            LOG.error(t.getMessage(), t);
                        }
                    }
                }
                try {
                    if (this.histogramUpdateRequests.size() == 0 && KeywordDetector.this.keywordDetectorListener != null) {
                        KeywordDetector.this.keywordDetectorListener.onKeywordDetectorFinished();
                        this.signalLoopLock();
                    }
                    if (!this.running.get()) continue;
                    this.lock.lock();
                    this.loopLock.await(1L, TimeUnit.MINUTES);
                    this.lock.unlock();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            this.clear();
            this.shutdownThreadPool();
        }

        public void onLastHistogramRequestFinished() {
            if (this.running.get()) {
                this.lastHistogramUpdateRequestFinished.set(System.currentTimeMillis());
            }
            this.signalLoopLock();
        }

        public void start() {
            this.clear();
            this.running.set(true);
            KeywordDetector.this.threadPool = ThreadPool.newThreadPool("KeywordDetector-pool", 1, false);
            new Thread((Runnable)this, "HistogramUpdateRequestDispatcher").start();
        }

        public void shutdown() {
            this.running.set(false);
            this.signalLoopLock();
            this.shutdownThreadPool();
        }

        private void shutdownThreadPool() {
            if (KeywordDetector.this.threadPool != null) {
                try {
                    KeywordDetector.this.threadPool.shutdown();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            List<HistogramUpdateRequestTask> list = this.histogramUpdateRequests;
            synchronized (list) {
                this.histogramUpdateRequests.clear();
            }
            this.lastHistogramUpdateRequestFinished.set(0L);
            this.signalLoopLock();
        }

        private void signalLoopLock() {
            try {
                this.lock.lock();
                this.loopLock.signal();
            }
            catch (Throwable throwable) {
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private static class HistogramUpdateRequestTask
    implements Runnable {
        private final KeywordDetector keywordDetector;
        private final List<SearchResult> filtered;

        public HistogramUpdateRequestTask(KeywordDetector keywordDetector, List<SearchResult> filtered) {
            this.keywordDetector = keywordDetector;
            this.filtered = filtered != null ? new ArrayList<SearchResult>(filtered) : null;
        }

        @Override
        public void run() {
            if (this.keywordDetector != null) {
                try {
                    if (this.filtered != null) {
                        this.keywordDetector.reset();
                        this.keywordDetector.feedSearchResults(this.filtered);
                    }
                    this.keywordDetector.notifyKeywordDetectorListener();
                    this.keywordDetector.histogramUpdateRequestsDispatcher.onLastHistogramRequestFinished();
                }
                catch (Throwable t) {
                    LOG.error(t.getMessage(), t);
                }
            }
        }
    }

    public static enum Feature {
        SEARCH_SOURCE(0.015f, 4, 20),
        FILE_EXTENSION(0.0f, 3, 8),
        FILE_NAME(0.01f, 3, 20),
        MANUAL_ENTRY(0.0f, 2, 20);

        public final float filterThreshold;
        public final int minimumTokenLength;
        public final int maximumTokenLength;

        private Feature(float filterThreshold, int minimumTokenLength, int maximumTokenLength) {
            this.filterThreshold = filterThreshold;
            this.minimumTokenLength = minimumTokenLength;
            this.maximumTokenLength = maximumTokenLength;
        }
    }
}

