/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.platform;

import com.frostwire.platform.AppSettings;
import com.frostwire.platform.FileSystem;
import com.frostwire.platform.Platform;
import java.io.File;

public final class Platforms {
    private static Platform platform;

    private Platforms() {
    }

    public static Platform get() {
        if (platform == null) {
            throw new IllegalStateException("Platform can't be null");
        }
        return platform;
    }

    public static void set(Platform p) {
        if (p == null) {
            throw new IllegalArgumentException("Platform can't be set to null");
        }
        platform = p;
    }

    public static FileSystem fileSystem() {
        return Platforms.get().fileSystem();
    }

    public static AppSettings appSettings() {
        return Platforms.get().appSettings();
    }

    public static File data() {
        return Platforms.get().systemPaths().data();
    }

    public static File torrents() {
        return Platforms.get().systemPaths().torrents();
    }

    public static File temp() {
        return Platforms.get().systemPaths().temp();
    }
}

