/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mplayer;

import com.frostwire.mplayer.IcyInfoListener;
import com.frostwire.mplayer.Language;
import com.frostwire.mplayer.LanguageSource;
import com.frostwire.mplayer.MediaPlaybackState;
import com.frostwire.mplayer.MediaPlayer;
import com.frostwire.mplayer.MetaDataListener;
import com.frostwire.mplayer.PlayerPreferences;
import com.frostwire.mplayer.PositionListener;
import com.frostwire.mplayer.StateListener;
import com.frostwire.mplayer.TaskListener;
import com.frostwire.mplayer.VolumeListener;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseMediaPlayer
implements MediaPlayer,
MetaDataListener,
StateListener,
VolumeListener,
PositionListener,
TaskListener,
IcyInfoListener {
    private List<MetaDataListener> metaDataListeners;
    private List<StateListener> stateListeners;
    private List<VolumeListener> volumeListeners;
    private List<PositionListener> positionListeners;
    private List<TaskListener> taskListeners;
    private List<IcyInfoListener> icyInfoListeners;
    private MediaPlaybackState currentState;
    private int currentVolume;
    private int videoWidth;
    private int videoHeight;
    private int displayWidth;
    private int displayHeight;
    private float currentPositionInSecs;
    private float durationInSecs;
    private boolean durationInSecsSet;
    private List<Language> audioTracks;
    private List<Language> subtitles;
    private String activeAudioTrackId = "0";
    private LanguageSource activeSubtitleSource = null;
    private String activeSubtitleId = null;
    private String openedFile;
    protected PlayerPreferences preferences;

    public BaseMediaPlayer() {
        this(null);
    }

    public BaseMediaPlayer(PlayerPreferences preferences) {
        this.preferences = preferences;
        this.metaDataListeners = new ArrayList<MetaDataListener>(1);
        this.stateListeners = new ArrayList<StateListener>(1);
        this.volumeListeners = new ArrayList<VolumeListener>(1);
        this.positionListeners = new ArrayList<PositionListener>(1);
        this.taskListeners = new ArrayList<TaskListener>(1);
        this.icyInfoListeners = new ArrayList<IcyInfoListener>(1);
        this.initialize();
        this.setMetaDataListener(this);
        this.setStateListener(this);
        this.setVolumeListener(this);
        this.setPositionListener(this);
        this.setIcyInfoListener(this);
    }

    private void initialize() {
        this.openedFile = null;
        this.audioTracks = new ArrayList<Language>();
        this.subtitles = new ArrayList<Language>();
        this.activeAudioTrackId = "0";
        this.activeSubtitleId = null;
        this.activeSubtitleSource = null;
        this.durationInSecs = 0.0f;
        this.durationInSecsSet = false;
        this.currentPositionInSecs = 0.0f;
        this.currentState = MediaPlaybackState.Uninitialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMetaDataListener(MetaDataListener listener) {
        List<MetaDataListener> list = this.metaDataListeners;
        synchronized (list) {
            this.metaDataListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addStateListener(StateListener listener) {
        List<StateListener> list = this.stateListeners;
        synchronized (list) {
            this.stateListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addVolumeListener(VolumeListener listener) {
        List<VolumeListener> list = this.volumeListeners;
        synchronized (list) {
            this.volumeListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPositionListener(PositionListener listener) {
        List<PositionListener> list = this.positionListeners;
        synchronized (list) {
            this.positionListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIcyInfoListener(IcyInfoListener listener) {
        List<IcyInfoListener> list = this.icyInfoListeners;
        synchronized (list) {
            this.icyInfoListeners.add(listener);
        }
    }

    public abstract void setStateListener(StateListener var1);

    public abstract void setVolumeListener(VolumeListener var1);

    public abstract void setMetaDataListener(MetaDataListener var1);

    public abstract void setPositionListener(PositionListener var1);

    public abstract void setIcyInfoListener(IcyInfoListener var1);

    public abstract void doOpen(String var1, int var2);

    public abstract void doPause();

    public abstract void doResume();

    public abstract void doStop();

    public abstract void doSeek(float var1);

    public abstract void doSetVolume(int var1);

    public abstract void doLoadSubtitlesFile(String var1, boolean var2);

    public void doLoadSubtitlesFile(String file) {
        this.doLoadSubtitlesFile(file, true);
    }

    @Override
    public void open(String fileOrUrl, int initialVolume) {
        if (this.currentState == MediaPlaybackState.Uninitialized || this.currentState == MediaPlaybackState.Stopped) {
            this.openedFile = fileOrUrl;
            this.doOpen(fileOrUrl, initialVolume);
        } else {
            this.doStop();
            this.initialize();
            this.openedFile = fileOrUrl;
            this.doOpen(fileOrUrl, initialVolume);
        }
    }

    @Override
    public String getOpenedFile() {
        return this.openedFile;
    }

    public void loadSubtitlesFile(String file) {
        this.doLoadSubtitlesFile(file);
    }

    public void fastForward() {
        if (this.currentState == MediaPlaybackState.Playing || this.currentState == MediaPlaybackState.Paused) {
            this.seek((float)((double)this.currentPositionInSecs + 10.0));
        }
    }

    public void rewind() {
        if (this.currentState == MediaPlaybackState.Playing || this.currentState == MediaPlaybackState.Paused) {
            this.seek((float)((double)this.currentPositionInSecs - 10.0));
        }
    }

    @Override
    public void pause() {
        if (this.currentState == MediaPlaybackState.Playing) {
            this.doPause();
        }
    }

    @Override
    public void play() {
        if (this.currentState == MediaPlaybackState.Paused) {
            this.doResume();
        }
    }

    @Override
    public void togglePause() {
        if (this.currentState == MediaPlaybackState.Paused) {
            this.doResume();
        } else if (this.currentState == MediaPlaybackState.Playing) {
            this.doPause();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMetaDataListener(MetaDataListener listener) {
        List<MetaDataListener> list = this.metaDataListeners;
        synchronized (list) {
            while (this.metaDataListeners.contains(listener)) {
                this.metaDataListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeStateListener(StateListener listener) {
        List<StateListener> list = this.stateListeners;
        synchronized (list) {
            while (this.stateListeners.contains(listener)) {
                this.stateListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeVolumeListener(VolumeListener listener) {
        List<VolumeListener> list = this.volumeListeners;
        synchronized (list) {
            while (this.volumeListeners.contains(listener)) {
                this.volumeListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePositionListener(PositionListener listener) {
        List<PositionListener> list = this.positionListeners;
        synchronized (list) {
            while (this.positionListeners.contains(listener)) {
                this.positionListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeIcyInfoListener(IcyInfoListener listener) {
        List<IcyInfoListener> list = this.icyInfoListeners;
        synchronized (list) {
            while (this.icyInfoListeners.contains(listener)) {
                this.icyInfoListeners.remove(listener);
            }
        }
    }

    @Override
    public synchronized void seek(float timeInSecs) {
        if (timeInSecs < 0.0f) {
            timeInSecs = 0.0f;
        }
        if (timeInSecs > this.durationInSecs) {
            timeInSecs = this.durationInSecs;
        }
        if (this.currentState == MediaPlaybackState.Playing || this.currentState == MediaPlaybackState.Paused) {
            this.doSeek(timeInSecs);
        }
    }

    public void incrementVolume() {
        this.setVolume(this.getVolume() + 10);
    }

    public void decrementVolume() {
        this.setVolume(this.getVolume() - 10);
    }

    @Override
    public void setVolume(int volume) {
        if (this.currentState == MediaPlaybackState.Playing || this.currentState == MediaPlaybackState.Paused) {
            this.doSetVolume(volume);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receivedDisplayResolution(int width, int height) {
        this.displayWidth = width;
        this.displayHeight = height;
        List<MetaDataListener> list = this.metaDataListeners;
        synchronized (list) {
            for (MetaDataListener listener : this.metaDataListeners) {
                listener.receivedDisplayResolution(width, height);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receivedDuration(float durationInSecs) {
        this.durationInSecsSet = true;
        this.durationInSecs = durationInSecs;
        List<MetaDataListener> list = this.metaDataListeners;
        synchronized (list) {
            for (MetaDataListener listener : this.metaDataListeners) {
                listener.receivedDuration(durationInSecs);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receivedVideoResolution(int width, int height) {
        this.videoWidth = width;
        this.videoHeight = height;
        List<MetaDataListener> list = this.metaDataListeners;
        synchronized (list) {
            for (MetaDataListener listener : this.metaDataListeners) {
                listener.receivedVideoResolution(width, height);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void foundAudioTrack(Language language) {
        List<Object> list = this.audioTracks;
        synchronized (list) {
            this.audioTracks.add(language);
        }
        list = this.metaDataListeners;
        synchronized (list) {
            for (MetaDataListener listener : this.metaDataListeners) {
                listener.foundAudioTrack(language);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void foundSubtitle(Language language) {
        List<Object> list = this.subtitles;
        synchronized (list) {
            this.subtitles.add(language);
        }
        list = this.metaDataListeners;
        synchronized (list) {
            for (MetaDataListener listener : this.metaDataListeners) {
                listener.foundSubtitle(language);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void activeAudioTrackChanged(String audioTrackId) {
        this.activeAudioTrackId = audioTrackId;
        List<MetaDataListener> list = this.metaDataListeners;
        synchronized (list) {
            for (MetaDataListener listener : this.metaDataListeners) {
                listener.activeAudioTrackChanged(audioTrackId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void activeSubtitleChanged(String subtitleId, LanguageSource source) {
        this.activeSubtitleId = subtitleId;
        this.activeSubtitleSource = source;
        List<MetaDataListener> list = this.metaDataListeners;
        synchronized (list) {
            for (MetaDataListener listener : this.metaDataListeners) {
                listener.activeSubtitleChanged(subtitleId, source);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Language getSubtitleByIdAndSource(String subtitleId, LanguageSource source) {
        if (subtitleId == null) {
            return null;
        }
        List<Language> list = this.subtitles;
        synchronized (list) {
            for (Language l : this.subtitles) {
                if (l.id == null || !l.id.equals(subtitleId) || l.source != source) continue;
                return l;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stateChanged(MediaPlaybackState newState) {
        this.currentState = newState;
        List<StateListener> list = this.stateListeners;
        synchronized (list) {
            for (StateListener listener : this.stateListeners) {
                listener.stateChanged(newState);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void volumeChanged(int newVolume) {
        this.currentVolume = newVolume;
        List<VolumeListener> list = this.volumeListeners;
        synchronized (list) {
            for (VolumeListener listener : this.volumeListeners) {
                listener.volumeChanged(newVolume);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void positionChanged(float currentTimeInSecs) {
        if (this.currentPositionInSecs != currentTimeInSecs) {
            this.currentPositionInSecs = currentTimeInSecs;
            List<PositionListener> list = this.positionListeners;
            synchronized (list) {
                for (PositionListener listener : this.positionListeners) {
                    listener.positionChanged(currentTimeInSecs);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void newIcyInfoData(String data) {
        List<IcyInfoListener> list = this.icyInfoListeners;
        synchronized (list) {
            for (IcyInfoListener listener : this.icyInfoListeners) {
                listener.newIcyInfoData(data);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTaskListener(TaskListener listener) {
        List<TaskListener> list = this.taskListeners;
        synchronized (list) {
            this.taskListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTaskListener(TaskListener listener) {
        List<TaskListener> list = this.taskListeners;
        synchronized (list) {
            while (this.taskListeners.contains(listener)) {
                this.taskListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void taskStarted(String taskName) {
        List<TaskListener> list = this.taskListeners;
        synchronized (list) {
            for (TaskListener listener : this.taskListeners) {
                listener.taskStarted(taskName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void taskProgress(String taskName, int percent) {
        List<TaskListener> list = this.taskListeners;
        synchronized (list) {
            for (TaskListener listener : this.taskListeners) {
                listener.taskProgress(taskName, percent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void taskEnded(String taskName) {
        List<TaskListener> list = this.taskListeners;
        synchronized (list) {
            for (TaskListener listener : this.taskListeners) {
                listener.taskEnded(taskName);
            }
        }
    }

    @Override
    public void stop() {
        if (this.currentState == MediaPlaybackState.Playing || this.currentState == MediaPlaybackState.Paused) {
            this.doStop();
        }
    }

    @Override
    public MediaPlaybackState getCurrentState() {
        return this.currentState;
    }

    @Override
    public int getVolume() {
        return this.currentVolume;
    }

    public int getVideoWidth() {
        return this.videoWidth;
    }

    public int getVideoHeight() {
        return this.videoHeight;
    }

    public int getDisplayWidth() {
        return this.displayWidth;
    }

    public int getDisplayHeight() {
        return this.displayHeight;
    }

    @Override
    public float getPositionInSecs() {
        return this.currentPositionInSecs;
    }

    public void clearDurationInSecs() {
        this.durationInSecs = 0.0f;
        this.durationInSecsSet = false;
    }

    public void setDurationInSecs(float secs) {
        if (!this.durationInSecsSet) {
            this.durationInSecs = secs;
        }
    }

    @Override
    public float getDurationInSecs() {
        return this.durationInSecs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Language[] getAudioTracks() {
        ArrayList<Language> result = new ArrayList<Language>();
        List<Language> list = this.audioTracks;
        synchronized (list) {
            for (Language language : this.audioTracks) {
                result.add(language);
            }
        }
        return result.toArray(new Language[result.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Language[] getSubtitles() {
        ArrayList<Language> result = new ArrayList<Language>();
        List<Language> list = this.subtitles;
        synchronized (list) {
            for (Language language : this.subtitles) {
                result.add(language);
            }
        }
        return result.toArray(new Language[result.size()]);
    }

    public String getActiveAudioTrackId() {
        return this.activeAudioTrackId;
    }

    public String getActiveSubtitleId() {
        return this.activeSubtitleId;
    }

    public Language getActiveSubtitle() {
        return this.getSubtitleByIdAndSource(this.activeSubtitleId, this.activeSubtitleSource);
    }
}

