/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mp4;

import com.frostwire.mp4.Box;
import com.frostwire.mp4.IO;
import com.frostwire.mp4.InputChannel;
import com.frostwire.mp4.OutputChannel;
import java.io.IOException;
import java.nio.ByteBuffer;

public final class UnknownBox
extends Box {
    private static final int MAX_DATA_SIZE = 0x100000;
    protected byte[] data;

    UnknownBox(int type) {
        super(type);
    }

    @Override
    void read(InputChannel ch, ByteBuffer buf) throws IOException {
        int len = (int)this.length();
        if (len > 0) {
            if (len <= 0x100000) {
                this.data = new byte[len];
                buf = ByteBuffer.wrap(this.data);
                IO.read(ch, len, buf);
            } else {
                IO.skip(ch, (long)len, buf);
            }
        } else {
            IO.skip(ch, buf);
        }
    }

    @Override
    void write(OutputChannel ch, ByteBuffer buf) throws IOException {
        if (this.data != null) {
            buf = ByteBuffer.wrap(this.data);
            IO.write(ch, this.data.length, buf);
        }
    }

    @Override
    void update() {
        long s = 0L;
        if (this.data != null) {
            s += (long)this.data.length;
        }
        this.length(s);
    }
}

