/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mp4;

import com.frostwire.mp4.FullBox;
import com.frostwire.mp4.IO;
import com.frostwire.mp4.InputChannel;
import com.frostwire.mp4.OutputChannel;
import java.io.IOException;
import java.nio.ByteBuffer;

public final class TrackFragmentHeaderBox
extends FullBox {
    protected int track_ID;
    protected long base_data_offset;
    protected int sample_description_index;
    protected int default_sample_duration;
    protected int default_sample_size;
    protected int default_sample_flags;

    TrackFragmentHeaderBox() {
        super(tfhd);
    }

    public boolean baseDataOffsetPresent() {
        return (this.flags & 1) == 1;
    }

    public boolean sampleDescriptionIndexPresent() {
        return (this.flags & 2) == 2;
    }

    public boolean defaultSampleDurationPresent() {
        return (this.flags & 8) == 8;
    }

    public boolean defaultSampleSizePresent() {
        return (this.flags & 0x10) == 16;
    }

    public boolean defaultSampleFlagsPresent() {
        return (this.flags & 0x20) == 32;
    }

    public boolean durationIsEmpty() {
        return (this.flags & 0x10000) == 65536;
    }

    @Override
    void read(InputChannel ch, ByteBuffer buf) throws IOException {
        super.read(ch, buf);
        IO.read(ch, 4, buf);
        this.track_ID = buf.getInt();
        if ((this.flags & 1) == 1) {
            IO.read(ch, 8, buf);
            this.base_data_offset = buf.getLong();
        }
        if ((this.flags & 2) == 2) {
            IO.read(ch, 4, buf);
            this.sample_description_index = buf.getInt();
        }
        if ((this.flags & 8) == 8) {
            IO.read(ch, 4, buf);
            this.default_sample_duration = buf.getInt();
        }
        if ((this.flags & 0x10) == 16) {
            IO.read(ch, 4, buf);
            this.default_sample_size = buf.getInt();
        }
        if ((this.flags & 0x20) == 32) {
            IO.read(ch, 4, buf);
            this.default_sample_flags = buf.getInt();
        }
    }

    @Override
    void write(OutputChannel ch, ByteBuffer buf) throws IOException {
        super.write(ch, buf);
        buf.putInt(this.track_ID);
        IO.write(ch, 4, buf);
        if ((this.flags & 1) == 1) {
            buf.putLong(this.base_data_offset);
            IO.write(ch, 8, buf);
        }
        if ((this.flags & 2) == 2) {
            buf.putInt(this.sample_description_index);
            IO.write(ch, 4, buf);
        }
        if ((this.flags & 8) == 8) {
            buf.putInt(this.default_sample_duration);
            IO.write(ch, 4, buf);
        }
        if ((this.flags & 0x10) == 16) {
            buf.putInt(this.default_sample_size);
            IO.write(ch, 4, buf);
        }
        if ((this.flags & 0x20) == 32) {
            buf.putInt(this.default_sample_flags);
            IO.write(ch, 4, buf);
        }
    }

    @Override
    void update() {
        long s = 0L;
        s += 4L;
        s += 4L;
        if ((this.flags & 1) == 1) {
            this.size += 8;
        }
        if ((this.flags & 2) == 2) {
            this.size += 4;
        }
        if ((this.flags & 8) == 8) {
            this.size += 4;
        }
        if ((this.flags & 0x10) == 16) {
            this.size += 4;
        }
        if ((this.flags & 0x20) == 32) {
            this.size += 4;
        }
        this.length(s);
    }
}

