/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mp4;

import com.frostwire.mp4.BoxEntry;
import com.frostwire.mp4.FullBox;
import com.frostwire.mp4.IO;
import com.frostwire.mp4.InputChannel;
import com.frostwire.mp4.IsoMedia;
import com.frostwire.mp4.OutputChannel;
import java.io.IOException;
import java.nio.ByteBuffer;

public final class SampleToChunkBox
extends FullBox {
    protected int entry_count;
    protected Entry[] entries;

    SampleToChunkBox() {
        super(stsc);
    }

    @Override
    void read(InputChannel ch, ByteBuffer buf) throws IOException {
        super.read(ch, buf);
        IO.read(ch, 4, buf);
        this.entry_count = buf.getInt();
        this.entries = new Entry[this.entry_count];
        for (int i = 0; i < this.entry_count; ++i) {
            Entry e = new Entry();
            IO.read(ch, 12, buf);
            e.get(buf);
            this.entries[i] = e;
        }
    }

    @Override
    void write(OutputChannel ch, ByteBuffer buf) throws IOException {
        super.write(ch, buf);
        buf.putInt(this.entry_count);
        IO.write(ch, 4, buf);
        IsoMedia.write(ch, this.entry_count, 12, this.entries, buf);
    }

    @Override
    void update() {
        long s = 0L;
        s += 4L;
        s += 4L;
        this.length(s += (long)(this.entry_count * 12));
    }

    public static final class Entry
    extends BoxEntry {
        public int first_chunk;
        public int samples_per_chunk;
        public int sample_description_index;

        @Override
        void get(ByteBuffer buf) {
            this.first_chunk = buf.getInt();
            this.samples_per_chunk = buf.getInt();
            this.sample_description_index = buf.getInt();
        }

        @Override
        void put(ByteBuffer buf) {
            buf.putInt(this.first_chunk);
            buf.putInt(this.samples_per_chunk);
            buf.putInt(this.sample_description_index);
        }
    }
}

