/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mp4;

import com.frostwire.mp4.AppleAlbumArtistBox;
import com.frostwire.mp4.AppleAlbumBox;
import com.frostwire.mp4.AppleArtistBox;
import com.frostwire.mp4.AppleCoverBox;
import com.frostwire.mp4.AppleItemListBox;
import com.frostwire.mp4.AppleMediaTypeBox;
import com.frostwire.mp4.AppleNameBox;
import com.frostwire.mp4.Bits;
import com.frostwire.mp4.Box;
import com.frostwire.mp4.BoxEntry;
import com.frostwire.mp4.ChunkOffsetBox;
import com.frostwire.mp4.CompositionOffsetBox;
import com.frostwire.mp4.ContainerBox;
import com.frostwire.mp4.FileTypeBox;
import com.frostwire.mp4.HandlerBox;
import com.frostwire.mp4.IO;
import com.frostwire.mp4.InputChannel;
import com.frostwire.mp4.IsoFile;
import com.frostwire.mp4.IsoMedia;
import com.frostwire.mp4.MediaDataBox;
import com.frostwire.mp4.MediaHeaderBox;
import com.frostwire.mp4.MetaBox;
import com.frostwire.mp4.MovieBox;
import com.frostwire.mp4.MovieFragmentBox;
import com.frostwire.mp4.Mp4Info;
import com.frostwire.mp4.OutputChannel;
import com.frostwire.mp4.SampleSizeBox;
import com.frostwire.mp4.SampleTableBox;
import com.frostwire.mp4.SampleToChunkBox;
import com.frostwire.mp4.SoundMediaHeaderBox;
import com.frostwire.mp4.SyncSampleBox;
import com.frostwire.mp4.TimeToSampleBox;
import com.frostwire.mp4.TrackBox;
import com.frostwire.mp4.TrackExtendsBox;
import com.frostwire.mp4.TrackFragmentHeaderBox;
import com.frostwire.mp4.TrackHeaderBox;
import com.frostwire.mp4.TrackRunBox;
import com.frostwire.mp4.UserDataBox;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.ListIterator;

public final class Mp4Demuxer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void audio(File input, File output, Mp4Info inf, DemuxerListener l) throws IOException {
        RandomAccessFile in = new RandomAccessFile(input, "r");
        RandomAccessFile out = new RandomAccessFile(output, "rw");
        out.setLength(0L);
        try {
            boolean fragments;
            ByteBuffer buf = ByteBuffer.allocate(102400);
            LinkedList<Box> head = IsoFile.head(in, buf);
            SoundMediaHeaderBox smhd = (SoundMediaHeaderBox)Box.findFirst(head, Box.smhd);
            TrackBox trak = (TrackBox)smhd.parent.parent.parent;
            TrackHeaderBox tkhd = (TrackHeaderBox)trak.findFirst(Box.tkhd);
            boolean bl = fragments = Box.findFirst(head, Box.mvex) != null;
            if (fragments) {
                Mp4Demuxer.muxFragments(new RandomAccessFile[]{in}, out, inf, buf, l);
            } else {
                Mp4Demuxer.trackSimple(tkhd.trackId(), in, out, inf, buf, l);
            }
        }
        finally {
            IO.close(in);
            IO.close(out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void muxFragments(File video, File audio, File output, Mp4Info inf, DemuxerListener l) throws IOException {
        RandomAccessFile v_in = new RandomAccessFile(video, "r");
        RandomAccessFile a_in = new RandomAccessFile(audio, "r");
        RandomAccessFile out = new RandomAccessFile(output, "rw");
        out.setLength(0L);
        try {
            ByteBuffer buf = ByteBuffer.allocate(102400);
            Mp4Demuxer.muxFragments(new RandomAccessFile[]{v_in, a_in}, out, inf, buf, l);
        }
        finally {
            IO.close(v_in);
            IO.close(a_in);
            IO.close(out);
        }
    }

    private static void trackSimple(int id, RandomAccessFile input, RandomAccessFile output, Mp4Info inf, ByteBuffer buf, final DemuxerListener l) throws IOException {
        int i;
        int trackId = id;
        final InputChannel in = new InputChannel(input.getChannel());
        OutputChannel out = new OutputChannel(output.getChannel());
        final LinkedList<Box> boxes = new LinkedList<Box>();
        IsoMedia.read(in, input.length(), null, buf, new IsoMedia.OnBoxListener(){

            @Override
            public boolean onBox(Box b) {
                Mp4Demuxer.notifyCount(l, in.count());
                if (b.parent == null) {
                    boxes.add(b);
                }
                return b.type != Box.mdat;
            }
        });
        FileTypeBox ftyp = (FileTypeBox)Box.findFirst(boxes, Box.ftyp);
        ftyp.major_brand = inf.majorBrand;
        ftyp.minor_version = 0;
        ftyp.compatible_brands = inf.compatibleBrands;
        MovieBox moov = (MovieBox)Box.findFirst(boxes, Box.moov);
        TrackBox trak = null;
        ListIterator it = moov.boxes.listIterator();
        while (it.hasNext()) {
            Box b = (Box)it.next();
            if (b.type != Box.trak) continue;
            TrackHeaderBox tkhd = (TrackHeaderBox)b.findFirst(Box.tkhd);
            if (tkhd.trackId() != trackId) {
                it.remove();
                continue;
            }
            trak = (TrackBox)b;
        }
        TrackHeaderBox tkhd = (TrackHeaderBox)Box.findFirst(boxes, Box.tkhd);
        tkhd.enabled(true);
        tkhd.inMovie(true);
        tkhd.inPreview(true);
        tkhd.inPoster(true);
        MediaHeaderBox mdhd = (MediaHeaderBox)Box.findFirst(boxes, Box.mdhd);
        mdhd.language("eng");
        for (UserDataBox b : moov.find(Box.udta)) {
            moov.boxes.remove(b);
        }
        UserDataBox udta = Mp4Demuxer.createUdta(inf);
        moov.boxes.add(udta);
        MediaDataBox mdat = (MediaDataBox)Box.findFirst(boxes, Box.mdat);
        SampleToChunkBox stsc = (SampleToChunkBox)trak.findFirst(Box.stsc);
        SampleSizeBox stsz = (SampleSizeBox)trak.findFirst(Box.stsz);
        ChunkOffsetBox stco = (ChunkOffsetBox)trak.findFirst(Box.stco);
        int[] chunkSize = new int[stco.entry_count];
        int chunkIdx = 0;
        int sampleIdx = 0;
        for (int i2 = 0; i2 < stsc.entry_count; ++i2) {
            int a = stsc.entries[i2].first_chunk;
            int b = i2 < stsc.entry_count - 1 ? stsc.entries[i2 + 1].first_chunk : a + 1;
            for (int j = a; j < b; ++j) {
                int sampleSize = 0;
                for (int k = 0; k < stsc.entries[i2].samples_per_chunk; ++k) {
                    sampleSize += stsz.sample_size != 0 ? stsz.sample_size : stsz.entries[sampleIdx].entry_size;
                    ++sampleIdx;
                }
                int n = chunkIdx++;
                chunkSize[n] = chunkSize[n] + sampleSize;
            }
        }
        int[] chunkOffsetOrg = new int[stco.entry_count];
        int offset = (int)(ContainerBox.length(boxes) - mdat.length());
        for (i = 0; i < stco.entry_count; ++i) {
            chunkOffsetOrg[i] = stco.entries[i].chunk_offset;
            stco.entries[i].chunk_offset = offset;
            offset += chunkSize[i];
        }
        IsoMedia.write(out, boxes, buf, IsoMedia.OnBoxListener.ALL);
        for (i = 0; i < stco.entry_count; ++i) {
            int pos = (int)in.count();
            int skp = chunkOffsetOrg[i] - pos;
            if (skp == 0 && i == stco.entry_count - 1) continue;
            IO.skip(in, (long)skp, buf);
            Mp4Demuxer.notifyCount(l, in.count());
            IO.copy(in, out, chunkSize[i], buf);
            Mp4Demuxer.notifyCount(l, in.count());
        }
    }

    private static void muxFragments(RandomAccessFile[] inputs, RandomAccessFile output, Mp4Info inf, ByteBuffer buf, DemuxerListener l) throws IOException {
        boolean readChunk;
        int n = inputs.length;
        InputChannel[] ins = new InputChannel[n];
        FragmentCtx[] ctxs = new FragmentCtx[n];
        for (int i = 0; i < n; ++i) {
            RandomAccessFile input = inputs[i];
            ins[i] = new InputChannel(input.getChannel());
            ctxs[i] = new FragmentCtx(input.length());
        }
        OutputChannel out = new OutputChannel(output.getChannel());
        for (int i = 0; i < n; ++i) {
            FragmentCtx ctx = ctxs[i];
            ctx.moov = (MovieBox)Mp4Demuxer.readUntil(ins[i], Box.moov, buf);
            ctx.trex = (TrackExtendsBox)ctx.moov.findFirst(Box.trex);
        }
        long mdatOffset = 0L;
        do {
            readChunk = false;
            for (int i = 0; i < n; ++i) {
                InputChannel in = ins[i];
                FragmentCtx ctx = ctxs[i];
                if (in.count() >= ctx.len) continue;
                readChunk = true;
                ctx.moof = (MovieFragmentBox)Mp4Demuxer.readUntil(in, Box.moof, buf);
                ctx.mdat = (MediaDataBox)Mp4Demuxer.readUntil(in, Box.mdat, buf);
            }
            if (mdatOffset == 0L) {
                mdatOffset = Mp4Demuxer.calcMdatOffset(ctxs, inf);
                output.seek(mdatOffset);
            }
            long readCount = 0L;
            for (int i = 0; i < n; ++i) {
                InputChannel in = ins[i];
                FragmentCtx ctx = ctxs[i];
                if (in.count() >= ctx.len) continue;
                Mp4Demuxer.processChunk(ctx, mdatOffset + out.count());
                IO.copy(in, out, ctx.mdat.length(), buf);
                readCount += in.count();
            }
            Mp4Demuxer.notifyCount(l, readCount);
        } while (readChunk);
        LinkedList<Box> boxes = new LinkedList<Box>();
        FileTypeBox ftyp = new FileTypeBox();
        ftyp.major_brand = inf.majorBrand;
        ftyp.minor_version = 0;
        ftyp.compatible_brands = inf.compatibleBrands;
        boxes.add(ftyp);
        MovieBox moov = new MovieBox();
        moov.boxes.add(ctxs[0].moov.findFirst(Box.mvhd));
        for (int i = 0; i < n; ++i) {
            TrackBox trak = Mp4Demuxer.createTrak(i + 1, ctxs[i]);
            moov.boxes.add(trak);
        }
        boxes.add(moov);
        UserDataBox udta = Mp4Demuxer.createUdta(inf);
        moov.boxes.add(udta);
        MediaDataBox mdat = new MediaDataBox();
        mdat.length(0L);
        boxes.add(mdat);
        long len = ContainerBox.length(boxes);
        if (len > mdatOffset) {
            throw new IOException("Movie header bigger than mdat offset");
        }
        mdat.length(output.length() - len);
        output.seek(0L);
        IsoMedia.write(out, boxes, buf, IsoMedia.OnBoxListener.ALL);
    }

    private static <T extends Box> T readNext(InputChannel ch, ByteBuffer buf) throws IOException {
        IO.read(ch, 8, buf);
        int size = buf.getInt();
        int type = buf.getInt();
        Long largesize = null;
        if (size == 1) {
            IO.read(ch, 8, buf);
            largesize = buf.getLong();
        }
        byte[] usertype = null;
        if (type == Box.uuid) {
            usertype = new byte[16];
            IO.read(ch, 16, buf);
            buf.get(usertype);
        }
        Box b = Box.empty(type);
        b.size = size;
        b.largesize = largesize;
        b.usertype = usertype;
        long r = ch.count();
        b.read(ch, buf);
        r = ch.count() - r;
        long length = b.length();
        if (r < length && type != Box.mdat) {
            IsoMedia.read(ch, length - r, b, buf, null);
        }
        return (T)b;
    }

    private static <T extends Box> T readUntil(InputChannel ch, int type, ByteBuffer buf) throws IOException {
        T b = null;
        try {
            while (true) {
                T t = Mp4Demuxer.readNext(ch, buf);
                b = t;
                if (((Box)t).type != type) {
                    continue;
                }
                break;
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return b;
    }

    private static int calcMdatOffset(FragmentCtx[] ctxs, Mp4Info inf) {
        int len = 0;
        for (FragmentCtx ctx : ctxs) {
            MovieFragmentBox moof = ctx.moof;
            MediaDataBox mdat = ctx.mdat;
            int n = (int)(ctx.len / (long)mdat.size);
            len += n * moof.size * 4;
        }
        len += 100000;
        return len += inf.jpg != null ? inf.jpg.length : 0;
    }

    private static void processChunk(FragmentCtx ctx, long offset) {
        TrackFragmentHeaderBox tfhd = (TrackFragmentHeaderBox)ctx.moof.findFirst(Box.tfhd);
        TrackRunBox trun = (TrackRunBox)ctx.moof.findFirst(Box.trun);
        SampleToChunkBox.Entry stscEntry = new SampleToChunkBox.Entry();
        stscEntry.first_chunk = ctx.chunkNumber;
        stscEntry.samples_per_chunk = trun.sample_count;
        stscEntry.sample_description_index = 1;
        ctx.stscList.add(stscEntry);
        ChunkOffsetBox.Entry stcoEntry = new ChunkOffsetBox.Entry();
        stcoEntry.chunk_offset = (int)offset;
        ctx.stcoList.add(stcoEntry);
        boolean first = true;
        for (TrackRunBox.Entry entry2 : trun.entries) {
            BoxEntry e;
            if (trun.sampleDurationPresent()) {
                if (ctx.sttsList.isEmpty() || ctx.sttsList.get((int)(ctx.sttsList.size() - 1)).sample_delta != entry2.sample_duration) {
                    e = new TimeToSampleBox.Entry();
                    e.sample_count = 1;
                    e.sample_delta = entry2.sample_duration;
                    ctx.sttsList.add((TimeToSampleBox.Entry)e);
                } else {
                    e = ctx.sttsList.get(ctx.sttsList.size() - 1);
                    ++e.sample_count;
                }
            } else if (tfhd.defaultSampleDurationPresent()) {
                e = new TimeToSampleBox.Entry();
                e.sample_count = 1;
                e.sample_delta = tfhd.default_sample_duration;
                ctx.sttsList.add((TimeToSampleBox.Entry)e);
            } else {
                e = new TimeToSampleBox.Entry();
                e.sample_count = 1;
                e.sample_delta = ctx.trex.default_sample_duration;
                ctx.sttsList.add((TimeToSampleBox.Entry)e);
            }
            if (trun.sampleCompositionTimeOffsetsPresent()) {
                if (ctx.cttsList.isEmpty() || ctx.cttsList.get((int)(ctx.cttsList.size() - 1)).sample_offset != entry2.sample_composition_time_offset) {
                    e = new CompositionOffsetBox.Entry();
                    ((CompositionOffsetBox.Entry)e).sample_count = 1;
                    ((CompositionOffsetBox.Entry)e).sample_offset = entry2.sample_composition_time_offset;
                    ctx.cttsList.add((CompositionOffsetBox.Entry)e);
                } else {
                    e = ctx.cttsList.get(ctx.cttsList.size() - 1);
                    ++((CompositionOffsetBox.Entry)e).sample_count;
                }
            }
            SampleSizeBox.Entry stszEntry = new SampleSizeBox.Entry();
            stszEntry.entry_size = entry2.sample_size;
            ctx.stszList.add(stszEntry);
            int sampleFlags = trun.sampleFlagsPresent() ? entry2.sample_flags : (first && trun.firstSampleFlagsPresent() ? trun.first_sample_flags : (tfhd.defaultSampleFlagsPresent() ? tfhd.default_sample_flags : ctx.trex.default_sample_flags));
            if ((sampleFlags & 0x10000) >> 16 > 0) {
                SyncSampleBox.Entry e2 = new SyncSampleBox.Entry();
                e2.sample_number = ctx.sampleNumber;
                ctx.stssList.add(e2);
            }
            ++ctx.sampleNumber;
            first = false;
        }
        ++ctx.chunkNumber;
    }

    private static TrackBox createTrak(int id, FragmentCtx ctx) {
        ChunkOffsetBox stco;
        SampleToChunkBox stsc;
        SampleSizeBox stsz;
        SyncSampleBox stss;
        CompositionOffsetBox ctts;
        SampleTableBox stbl = (SampleTableBox)ctx.moov.findFirst(Box.stbl);
        TimeToSampleBox stts = (TimeToSampleBox)stbl.findFirst(Box.stts);
        if (stts != null) {
            stts.entry_count = ctx.sttsList.size();
            stts.entries = ctx.sttsList.toArray(new TimeToSampleBox.Entry[0]);
        }
        if ((ctts = (CompositionOffsetBox)stbl.findFirst(Box.ctts)) != null) {
            ctts.entry_count = ctx.cttsList.size();
            ctts.entries = ctx.cttsList.toArray(new CompositionOffsetBox.Entry[0]);
        }
        if ((stss = (SyncSampleBox)stbl.findFirst(Box.stss)) != null) {
            stss.entry_count = ctx.stssList.size();
            stss.entries = ctx.stssList.toArray(new SyncSampleBox.Entry[0]);
        }
        if ((stsz = (SampleSizeBox)stbl.findFirst(Box.stsz)) != null) {
            stsz.sample_size = 0;
            stsz.sample_count = ctx.stszList.size();
            stsz.entries = ctx.stszList.toArray(new SampleSizeBox.Entry[0]);
        }
        if ((stsc = (SampleToChunkBox)stbl.findFirst(Box.stsc)) != null) {
            stsc.entry_count = ctx.stscList.size();
            stsc.entries = ctx.stscList.toArray(new SampleToChunkBox.Entry[0]);
        }
        if ((stco = (ChunkOffsetBox)stbl.findFirst(Box.stco)) != null) {
            stco.entry_count = ctx.stcoList.size();
            stco.entries = ctx.stcoList.toArray(new ChunkOffsetBox.Entry[0]);
        }
        TrackBox trak = (TrackBox)ctx.moov.findFirst(Box.trak);
        TrackHeaderBox tkhd = (TrackHeaderBox)trak.findFirst(Box.tkhd);
        tkhd.trackId(id);
        tkhd.enabled(true);
        tkhd.inMovie(true);
        tkhd.inPreview(true);
        tkhd.inPoster(true);
        MediaHeaderBox mdhd = (MediaHeaderBox)trak.findFirst(Box.mdhd);
        mdhd.language("eng");
        return trak;
    }

    private static UserDataBox createUdta(Mp4Info inf) {
        UserDataBox udta = new UserDataBox();
        MetaBox meta = new MetaBox();
        udta.boxes.add(meta);
        HandlerBox hdlr = new HandlerBox();
        hdlr.handler_type = Bits.make4cc("mdir");
        meta.boxes.add(hdlr);
        AppleItemListBox ilst = new AppleItemListBox();
        meta.boxes.add(ilst);
        if (inf.title != null) {
            AppleNameBox cnam = new AppleNameBox();
            cnam.value(inf.title);
            ilst.boxes.add(cnam);
        }
        if (inf.author != null) {
            AppleArtistBox cART = new AppleArtistBox();
            cART.value(inf.author);
            ilst.boxes.add(cART);
            AppleAlbumArtistBox aART = new AppleAlbumArtistBox();
            aART.value(inf.author);
            ilst.boxes.add(aART);
        }
        if (inf.album != null) {
            AppleAlbumBox calb = new AppleAlbumBox();
            calb.value(inf.album);
            ilst.boxes.add(calb);
        }
        AppleMediaTypeBox stik = new AppleMediaTypeBox();
        stik.value(1);
        ilst.boxes.add(stik);
        if (inf.jpg != null) {
            AppleCoverBox covr = new AppleCoverBox();
            covr.setJpg(inf.jpg);
            ilst.boxes.add(covr);
        }
        return udta;
    }

    private static void notifyCount(DemuxerListener l, long count) {
        if (l != null) {
            l.onRead(count);
        }
    }

    public static interface DemuxerListener {
        public void onRead(long var1);
    }

    private static final class FragmentCtx {
        final long len;
        final LinkedList<TimeToSampleBox.Entry> sttsList;
        final LinkedList<CompositionOffsetBox.Entry> cttsList;
        final LinkedList<SyncSampleBox.Entry> stssList;
        final LinkedList<SampleSizeBox.Entry> stszList;
        final LinkedList<SampleToChunkBox.Entry> stscList;
        final LinkedList<ChunkOffsetBox.Entry> stcoList;
        MovieBox moov;
        TrackExtendsBox trex;
        MovieFragmentBox moof;
        MediaDataBox mdat;
        int sampleNumber;
        int chunkNumber;

        public FragmentCtx(long len) {
            this.len = len;
            this.sttsList = new LinkedList();
            this.cttsList = new LinkedList();
            this.stssList = new LinkedList();
            this.stszList = new LinkedList();
            this.stscList = new LinkedList();
            this.stcoList = new LinkedList();
            this.sampleNumber = 1;
            this.chunkNumber = 1;
        }
    }
}

