/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mp4;

import com.frostwire.mp4.Utf8;
import java.io.UnsupportedEncodingException;

final class Bits {
    private Bits() {
    }

    public static byte int3(int x) {
        return (byte)(x >> 24);
    }

    public static byte int2(int x) {
        return (byte)(x >> 16);
    }

    public static byte int1(int x) {
        return (byte)(x >> 8);
    }

    public static byte int0(int x) {
        return (byte)x;
    }

    public static int int32(byte b3, byte b2, byte b1, byte b0) {
        return b3 << 24 | (b2 & 0xFF) << 16 | (b1 & 0xFF) << 8 | b0 & 0xFF;
    }

    public static String make4cc(int c) {
        byte[] code = new byte[]{Bits.int3(c), Bits.int2(c), Bits.int1(c), Bits.int0(c)};
        try {
            return new String(code, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static int make4cc(String c) {
        byte[] code;
        try {
            code = c.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return Bits.int32(code[0], code[1], code[2], code[3]);
    }

    public static String iso639(byte[] arr) {
        if (arr.length != 2) {
            throw new IllegalArgumentException("array must be of length 2");
        }
        int bits = Bits.int32((byte)0, (byte)0, arr[0], arr[1]);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 3; ++i) {
            int c = bits >> (2 - i) * 5 & 0x1F;
            sb.append((char)(c + 96));
        }
        return sb.toString();
    }

    public static byte[] iso639(String s) {
        byte[] arr = Utf8.convert(s);
        if (arr.length != 3) {
            throw new IllegalArgumentException("string must be of length 3");
        }
        int bits = 0;
        for (int i = 0; i < 3; ++i) {
            bits += arr[i] - 96 << (2 - i) * 5;
        }
        byte b1 = Bits.int1(bits);
        byte b0 = Bits.int0(bits);
        return new byte[]{b1, b0};
    }
}

