/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mp4;

import com.frostwire.mp4.Box;
import com.frostwire.mp4.IO;
import com.frostwire.mp4.InputChannel;
import com.frostwire.mp4.OutputChannel;
import java.io.IOException;
import java.nio.ByteBuffer;

public class AppleDataBox
extends Box {
    protected int dataLength;
    protected int data4cc = data;
    protected int dataType;
    protected short dataCountry;
    protected short dataLanguage;

    AppleDataBox(int type) {
        super(type);
    }

    public final int dataType() {
        return this.dataType;
    }

    public final void dataType(int value) {
        this.dataType = value;
    }

    @Override
    void read(InputChannel ch, ByteBuffer buf) throws IOException {
        IO.read(ch, 16, buf);
        this.dataLength = buf.getInt();
        this.data4cc = buf.getInt();
        this.dataType = buf.getInt();
        this.dataCountry = buf.getShort();
        this.dataLanguage = buf.getShort();
    }

    @Override
    void write(OutputChannel ch, ByteBuffer buf) throws IOException {
        buf.putInt(this.dataLength);
        buf.putInt(this.data4cc);
        buf.putInt(this.dataType);
        buf.putShort(this.dataCountry);
        buf.putShort(this.dataLanguage);
        IO.write(ch, 16, buf);
    }
}

