/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mp3;

import com.frostwire.mp3.AbstractID3v2Tag;
import com.frostwire.mp3.BufferTools;
import com.frostwire.mp3.InvalidDataException;
import com.frostwire.mp3.NoSuchTagException;
import com.frostwire.mp3.UnsupportedTagException;

public class ID3v23Tag
extends AbstractID3v2Tag {
    public static final String VERSION = "3.0";

    public ID3v23Tag() {
        this.version = VERSION;
    }

    public ID3v23Tag(byte[] buffer) throws NoSuchTagException, UnsupportedTagException, InvalidDataException {
        super(buffer);
    }

    @Override
    protected void unpackFlags(byte[] buffer) {
        this.unsynchronisation = BufferTools.checkBit(buffer[5], 7);
        this.extendedHeader = BufferTools.checkBit(buffer[5], 6);
        this.experimental = BufferTools.checkBit(buffer[5], 5);
    }

    @Override
    protected void packFlags(byte[] bytes, int offset) {
        bytes[offset + 5] = BufferTools.setBit(bytes[offset + 5], 7, this.unsynchronisation);
        bytes[offset + 5] = BufferTools.setBit(bytes[offset + 5], 6, this.extendedHeader);
        bytes[offset + 5] = BufferTools.setBit(bytes[offset + 5], 5, this.experimental);
    }
}

