/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.updates;

import com.frostwire.gui.updates.ProgressMonitor;
import com.frostwire.util.Logger;
import com.frostwire.util.ZipUtils;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.ResourceManager;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.limewire.util.CommonUtils;
import org.limewire.util.OSUtils;

public final class PortableUpdater {
    private static final Logger LOG = Logger.getLogger(PortableUpdater.class);
    private static final String PORTABLE_UPDATER_SCRIPT_WINDOWS = "portable_updater.js";
    private static final String PORTABLE_UPDATER_SCRIPT_MACOSX = "portable_updater.sh";
    private static final String TEMP_DIR = "FrostWire_temp";
    private final File zipFile;
    private final File tempDir;
    private final File destDir;

    public PortableUpdater(File zipFile) {
        if (OSUtils.isWindows()) {
            PortableUpdater.createScript(PORTABLE_UPDATER_SCRIPT_WINDOWS);
        } else if (OSUtils.isMacOSX()) {
            PortableUpdater.createScript(PORTABLE_UPDATER_SCRIPT_MACOSX);
        }
        File rootFolder = CommonUtils.getPortableRootFolder();
        this.zipFile = zipFile;
        this.tempDir = new File(FilenameUtils.normalize(new File(rootFolder, TEMP_DIR).getAbsolutePath()));
        this.destDir = new File(FilenameUtils.normalize(new File(rootFolder, this.getDestDirName()).getAbsolutePath()));
    }

    public void update() {
        ProgressMonitor progressMonitor = new ProgressMonitor(GUIMediator.getAppFrame(), I18n.tr("Uncompressing files"), "", 0, 100);
        progressMonitor.setMillisToDecideToPopup(0);
        progressMonitor.setMillisToPopup(0);
        progressMonitor.setProgress(0);
        UncompressTask task = new UncompressTask(progressMonitor);
        task.execute();
    }

    private String getDestDirName() {
        String name = "FrostWire";
        if (OSUtils.isWindows()) {
            name = "FrostWire";
        } else if (OSUtils.isMacOSX()) {
            name = "FrostWire.app";
        }
        return name;
    }

    private void fixExecutablePermissions(File file, String[] exePaths) {
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                this.fixExecutablePermissions(child, exePaths);
            }
        } else {
            for (String path : exePaths) {
                if (!file.getPath().contains(path)) continue;
                file.setExecutable(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createScript(String scriptName) {
        FileOutputStream out;
        BufferedInputStream is;
        block4: {
            File fileJS = new File(CommonUtils.getUserSettingsDir(), scriptName);
            URL url = ResourceManager.getURLResource(scriptName);
            is = null;
            out = null;
            try {
                if (url == null) break block4;
                is = new BufferedInputStream(url.openStream());
                out = new FileOutputStream(fileJS);
                IOUtils.copy((InputStream)is, (OutputStream)out);
                fileJS.setExecutable(true);
            }
            catch (IOException e) {
                try {
                    LOG.error("Error creating script", e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(is);
                    IOUtils.closeQuietly(out);
                    throw throwable;
                }
                IOUtils.closeQuietly(is);
                IOUtils.closeQuietly(out);
            }
        }
        IOUtils.closeQuietly(is);
        IOUtils.closeQuietly(out);
    }

    private static String[] createWSHScriptCommand(File source, File dest) {
        ArrayList<String> command = new ArrayList<String>();
        command.add("wscript");
        command.add("//B");
        command.add("//NoLogo");
        command.add(new File(CommonUtils.getUserSettingsDir(), PORTABLE_UPDATER_SCRIPT_WINDOWS).getAbsolutePath());
        command.add(source.getAbsolutePath());
        command.add(dest.getAbsolutePath());
        return command.toArray(new String[0]);
    }

    private static String[] createMacOSXScriptCommand(File source, File dest) {
        ArrayList<String> command = new ArrayList<String>();
        command.add(new File(CommonUtils.getUserSettingsDir(), PORTABLE_UPDATER_SCRIPT_MACOSX).getAbsolutePath());
        command.add(source.getAbsolutePath());
        command.add(dest.getAbsolutePath());
        return command.toArray(new String[0]);
    }

    private class UncompressTask
    extends SwingWorker<Void, Void> {
        private final ProgressMonitor progressMonitor;

        public UncompressTask(ProgressMonitor progressMonitor) {
            this.progressMonitor = progressMonitor;
        }

        @Override
        public Void doInBackground() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    UncompressTask.this.progressMonitor.setProgress(0);
                }
            });
            ZipUtils.unzip(PortableUpdater.this.zipFile, PortableUpdater.this.tempDir, new ZipUtils.ZipListener(){

                @Override
                public void onUnzipping(final String fileName, final int progress) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            UncompressTask.this.progressMonitor.setNote(fileName);
                            UncompressTask.this.progressMonitor.setProgress(progress);
                        }
                    });
                }

                @Override
                public boolean isCanceled() {
                    return UncompressTask.this.progressMonitor.isCanceled();
                }
            });
            return null;
        }

        @Override
        public void done() {
            this.progressMonitor.close();
            try {
                if (OSUtils.isWindows()) {
                    Runtime.getRuntime().exec(PortableUpdater.createWSHScriptCommand(PortableUpdater.this.tempDir, PortableUpdater.this.destDir));
                } else if (OSUtils.isMacOSX()) {
                    PortableUpdater.this.fixExecutablePermissions(PortableUpdater.this.tempDir, new String[]{"MacOS", "Home/bin"});
                    Runtime.getRuntime().exec(PortableUpdater.createMacOSXScriptCommand(PortableUpdater.this.tempDir, PortableUpdater.this.destDir));
                }
            }
            catch (IOException e) {
                LOG.error("Failed to execute update script", e);
            }
            GUIMediator.shutdown();
        }
    }
}

