/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.theme;

import com.frostwire.gui.theme.AbstractSkinPainter;
import com.frostwire.gui.theme.SkinColors;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import javax.swing.JComponent;

public final class SkinScrollBarTrackPainter
extends AbstractSkinPainter {
    private final State state;

    public SkinScrollBarTrackPainter(State state) {
        this.state = state;
    }

    @Override
    protected void doPaint(Graphics2D g, JComponent c, int width, int height, Object[] extendedCacheKeys) {
        if (this.testValid(0, 0, width, height)) {
            Shape s = this.shapeGenerator.createRectangle(0, 0, width, height);
            g.setPaint(this.getScrollBarTrackPaint(s));
            g.fill(s);
            g.setColor(SkinColors.SCROLL_TRACK_BORDER_COLOR);
            g.draw(s);
        }
    }

    private Paint getScrollBarTrackPaint(Shape s) {
        switch (this.state) {
            case Disabled: {
                return this.createVerticalGradient(s, SkinColors.SCROLL_TRACK_DISABLED_COLORS);
            }
            case Enabled: {
                return this.createVerticalGradient(s, SkinColors.SCROLL_TRACK_ENABLED_COLORS);
            }
        }
        throw new IllegalArgumentException("Not supported state");
    }

    public static enum State {
        Disabled,
        Enabled;

    }
}

