/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.theme;

import com.frostwire.gui.theme.SkinPanelUI;
import com.frostwire.gui.theme.ThemeMediator;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.beans.PropertyChangeEvent;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.JToolTip;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTextAreaUI;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthToolTipUI;

public final class SkinMultilineToolTipUI
extends SynthToolTipUI {
    private static final int TOOLTIP_WIDTH = 400;
    private final JTextArea textArea = new JTextArea();
    private final CellRendererPane rendererPane = new CellRendererPane();

    public static ComponentUI createUI(JComponent comp) {
        ThemeMediator.testComponentCreationThreadingViolation();
        return new SkinPanelUI();
    }

    public SkinMultilineToolTipUI() {
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
        this.textArea.setEditable(false);
        this.textArea.setOpaque(false);
        this.textArea.setUI(new BasicTextAreaUI());
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return this.calculatePreferredSize(c);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        super.propertyChange(e);
        String name = e.getPropertyName();
        if (name.equals("tiptext")) {
            JToolTip tip = (JToolTip)e.getSource();
            String text = tip.getTipText();
            this.textArea.setText(text);
        }
    }

    @Override
    protected void paint(SynthContext context, Graphics g) {
        JToolTip toolTip = (JToolTip)context.getComponent();
        Insets insets = toolTip.getInsets();
        Rectangle paintTextR = new Rectangle(insets.left, insets.top, toolTip.getWidth() - (insets.left + insets.right), toolTip.getHeight() - (insets.top + insets.bottom));
        g.setColor(context.getStyle().getColor(context, ColorType.TEXT_FOREGROUND));
        g.setFont(toolTip.getFont());
        this.rendererPane.paintComponent(g, this.textArea, toolTip, insets.left + 2, insets.top, paintTextR.width, paintTextR.height, true);
    }

    private Dimension calculatePreferredSize(JComponent c) {
        Dimension dimension;
        try {
            String textAreaText = this.textArea.getText();
            if (textAreaText == null || textAreaText.isEmpty()) {
                dimension = new Dimension(0, 0);
            } else {
                AttributedString text = new AttributedString(textAreaText);
                Font font = c.getFont();
                FontMetrics fm = c.getFontMetrics(font);
                FontRenderContext frc = fm.getFontRenderContext();
                AttributedCharacterIterator charIt = text.getIterator();
                LineBreakMeasurer lineMeasurer = new LineBreakMeasurer(charIt, frc);
                float formatWidth = 352.0f;
                lineMeasurer.setPosition(charIt.getBeginIndex());
                int noLines = 0;
                while (lineMeasurer.getPosition() < charIt.getEndIndex()) {
                    lineMeasurer.nextLayout(formatWidth);
                    ++noLines;
                }
                if (lineMeasurer.getPosition() < textAreaText.length()) {
                    ++noLines;
                }
                int width = 400;
                int height = fm.getHeight() * noLines + 10;
                dimension = new Dimension(width, height);
            }
        }
        catch (Throwable e) {
            dimension = new Dimension(0, 0);
        }
        return dimension;
    }
}

