/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.theme;

import com.frostwire.gui.theme.FilePane;
import com.frostwire.gui.theme.SkinMenu;
import com.frostwire.gui.theme.SkinPopupMenu;
import com.frostwire.gui.theme.SkinRadioButtonMenuItem;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;

public class FilePaneEx
extends FilePane {
    private static final long serialVersionUID = 153183794490651820L;
    private SkinPopupMenu contextMenu;
    private SkinMenu viewMenu;
    private String viewMenuLabelText;
    private boolean listViewWindowsStyle;
    private static final int VIEWTYPE_COUNT = 2;
    private String[] viewTypeActionNames;

    public FilePaneEx(FilePane.FileChooserUIAccessor fileChooserUIAccessor) {
        super(fileChooserUIAccessor);
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        Locale l = this.getFileChooser().getLocale();
        this.listViewWindowsStyle = UIManager.getBoolean("FileChooser.listViewWindowsStyle");
        this.viewMenuLabelText = UIManager.getString((Object)"FileChooser.viewMenuLabelText", l);
        this.viewTypeActionNames = new String[2];
        this.viewTypeActionNames[0] = UIManager.getString((Object)"FileChooser.listViewActionLabelText", l);
        this.viewTypeActionNames[1] = UIManager.getString((Object)"FileChooser.detailsViewActionLabelText", l);
    }

    @Override
    public JMenu getViewMenu() {
        if (this.viewMenu == null) {
            this.viewMenu = new SkinMenu(this.viewMenuLabelText);
            ButtonGroup viewButtonGroup = new ButtonGroup();
            for (int i = 0; i < 2; ++i) {
                SkinRadioButtonMenuItem mi = new SkinRadioButtonMenuItem(new ViewTypeAction(i));
                viewButtonGroup.add(mi);
                this.viewMenu.add(mi);
            }
            this.updateViewMenu();
        }
        return this.viewMenu;
    }

    private void updateViewMenu() {
        if (this.viewMenu != null) {
            Component[] comps = this.viewMenu.getMenuComponents();
            for (int i = 0; i < comps.length; ++i) {
                SkinRadioButtonMenuItem mi;
                if (!(comps[i] instanceof SkinRadioButtonMenuItem) || ((ViewTypeAction)(mi = (SkinRadioButtonMenuItem)comps[i]).getAction()).viewType != this.getViewType()) continue;
                mi.setSelected(true);
            }
        }
    }

    @Override
    public JPopupMenu getComponentPopupMenu() {
        SkinMenu viewMenu = (SkinMenu)this.getViewMenu();
        if (this.contextMenu == null) {
            this.contextMenu = new SkinPopupMenu();
            if (viewMenu != null) {
                this.contextMenu.add(viewMenu);
                if (this.listViewWindowsStyle) {
                    this.contextMenu.addSeparator();
                }
            }
            ActionMap actionMap = this.getActionMap();
            Action refreshAction = actionMap.get("refresh");
            Action newFolderAction = actionMap.get("New Folder");
            if (refreshAction != null) {
                this.contextMenu.add(refreshAction);
                if (this.listViewWindowsStyle && newFolderAction != null) {
                    this.contextMenu.addSeparator();
                }
            }
            if (newFolderAction != null) {
                this.contextMenu.add(newFolderAction);
            }
        }
        if (viewMenu != null) {
            viewMenu.getPopupMenu().setInvoker(viewMenu);
        }
        return this.contextMenu;
    }

    class ViewTypeAction
    extends AbstractAction {
        private static final long serialVersionUID = 3795594739034737323L;
        private int viewType;

        ViewTypeAction(int viewType) {
            String cmd;
            super(FilePaneEx.this.viewTypeActionNames[viewType]);
            this.viewType = viewType;
            switch (viewType) {
                case 0: {
                    cmd = "viewTypeList";
                    break;
                }
                case 1: {
                    cmd = "viewTypeDetails";
                    break;
                }
                default: {
                    cmd = (String)this.getValue("Name");
                }
            }
            this.putValue("ActionCommandKey", cmd);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FilePaneEx.this.setViewType(this.viewType);
        }
    }
}

