/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.tabs;

import com.frostwire.gui.bittorrent.BTDownload;
import com.frostwire.gui.bittorrent.BTDownloadMediator;
import com.frostwire.gui.bittorrent.BittorrentDownload;
import com.frostwire.gui.bittorrent.HttpDownload;
import com.frostwire.gui.bittorrent.SoundcloudDownload;
import com.frostwire.gui.bittorrent.TorrentFetcherDownload;
import com.frostwire.gui.components.transfers.TransferDetailComponent;
import com.frostwire.gui.tabs.AbstractTab;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.util.BackgroundExecutorService;
import com.limegroup.gnutella.settings.UISettings;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.border.CompoundBorder;
import net.miginfocom.swing.MigLayout;

public final class TransfersTab
extends AbstractTab {
    private final BTDownloadMediator downloadMediator;
    private JSplitPane transferDetailSplitter;
    private TransferDetailComponent transferDetailComponent;
    private TransfersFilterModeListener transfersFilterModeListener;
    public static final String FILTER_TEXT_HINT = I18n.tr("filter transfers here");
    private JToggleButton filterAllButton;
    private JToggleButton filterDownloadingButton;
    private JToggleButton filterSeedingButton;
    private JToggleButton filterFinishedButton;
    private JPanel mainComponent;
    private JTextArea filterText;
    private final boolean dedicatedTransfersTabAvailable = !UISettings.UI_SEARCH_TRANSFERS_SPLIT_VIEW.getValue();
    private int lastSplitterLocationWithDetailsVisible = -1;

    public TransfersTab(BTDownloadMediator downloadMediator) {
        super(I18n.tr("Transfers"), I18n.tr("Transfers tab description goes here."), "transfers_tab");
        this.downloadMediator = downloadMediator;
        this.initComponents();
    }

    public void showTransfers(FilterMode mode) {
        if (mode == FilterMode.ALL) {
            this.filterAllButton.doClick();
        } else if (mode == FilterMode.DOWNLOADING) {
            this.filterDownloadingButton.doClick();
        } else if (mode == FilterMode.FINISHED) {
            this.filterFinishedButton.doClick();
        } else if (mode == FilterMode.SEEDING) {
            this.filterSeedingButton.doClick();
        }
    }

    private void initComponents() {
        this.mainComponent = new JPanel(new MigLayout("fill, insets 6px 0px 0px 0px, gap 0", "[][][grow]"));
        this.mainComponent.add((Component)new JLabel(I18n.tr("Transfers")), "h 30!, gapleft 10px, left");
        this.mainComponent.add((Component)this.createTextFilterComponent(), "w 200!, h 30!, gapleft 5px, center, shrink");
        this.mainComponent.add((Component)this.createFilterToggleButtons(), "w 500!, h 30!, pad 2 0 0 0, right, wrap");
        if (this.dedicatedTransfersTabAvailable) {
            this.transferDetailSplitter = new JSplitPane(0);
            this.transferDetailSplitter.setDividerLocation(270);
            this.transferDetailSplitter.setResizeWeight(1.0);
            JComponent transfersComponent = this.downloadMediator.getComponent();
            transfersComponent.setMinimumSize(new Dimension(100, 200));
            this.transferDetailSplitter.add(transfersComponent);
            this.transferDetailComponent = new TransferDetailComponent(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    TransfersTab.this.downloadMediator.clearSelection();
                }
            });
            this.transferDetailSplitter.add(this.transferDetailComponent);
            this.mainComponent.add((Component)this.transferDetailSplitter, "cell 0 1 3 1, grow, pushy, hmax 10000px, wrap");
        } else {
            this.mainComponent.add((Component)this.downloadMediator.getComponent(), "cell 0 1 3 1, grow, pushy, wrap");
        }
        this.setTransfersFilterModeListener(this.downloadMediator);
        this.downloadMediator.setBTDownloadSelectionListener(new TransferTableSelectionListener());
    }

    private void hideTransferDetailsComponent() {
        if (!this.dedicatedTransfersTabAvailable) {
            return;
        }
        this.lastSplitterLocationWithDetailsVisible = this.transferDetailSplitter.getDividerLocation();
        this.transferDetailComponent.setVisible(false);
    }

    private void showTransferDetailsComponent(BittorrentDownload selected) {
        if (!this.dedicatedTransfersTabAvailable) {
            return;
        }
        boolean transferDetailComponentWasAlreadyVisible = this.transferDetailComponent.isVisible();
        this.transferDetailComponent.setVisible(true);
        this.transferDetailComponent.updateData(selected);
        if (!transferDetailComponentWasAlreadyVisible) {
            Container parent = this.transferDetailSplitter.getParent();
            int h = parent.getSize().height;
            this.lastSplitterLocationWithDetailsVisible = 2 * h / 3;
            if (h > 800) {
                this.lastSplitterLocationWithDetailsVisible = h - 500;
            }
            this.transferDetailSplitter.setDividerLocation(this.lastSplitterLocationWithDetailsVisible);
        }
    }

    private void setTransfersFilterModeListener(TransfersFilterModeListener transfersFilterModeListener) {
        this.transfersFilterModeListener = transfersFilterModeListener;
    }

    private JTextArea createTextFilterComponent() {
        this.filterText = new JTextArea();
        this.filterText.setEditable(true);
        this.filterText.setText(FILTER_TEXT_HINT);
        this.filterText.setFont(new Font("Helvetica", 0, 12));
        this.filterText.setForeground(Color.GRAY);
        this.filterText.addMouseListener(new TextFilterMouseAdapter());
        this.filterText.addKeyListener(new TextFilterKeyAdapter());
        this.filterText.addFocusListener(new TextFilterFocusAdapter());
        this.filterText.selectAll();
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(this.filterText.getBorder(), BorderFactory.createEmptyBorder(4, 2, 2, 2));
        this.filterText.setBorder(compoundBorder);
        return this.filterText;
    }

    private JPanel createFilterToggleButtons() {
        JPanel filterButtonsContainer = new JPanel(new MigLayout("align right, ins 0 0 0 8"));
        ButtonGroup filterGroup = new ButtonGroup();
        this.filterAllButton = new JToggleButton(I18n.tr("All"), true);
        this.filterDownloadingButton = new JToggleButton(I18n.tr("Downloading"), false);
        this.filterSeedingButton = new JToggleButton(I18n.tr("Seeding"), false);
        this.filterFinishedButton = new JToggleButton(I18n.tr("Finished"), false);
        this.filterAllButton.addActionListener(new OnFilterButtonToggledListener(FilterMode.ALL));
        this.filterDownloadingButton.addActionListener(new OnFilterButtonToggledListener(FilterMode.DOWNLOADING));
        this.filterSeedingButton.addActionListener(new OnFilterButtonToggledListener(FilterMode.SEEDING));
        this.filterFinishedButton.addActionListener(new OnFilterButtonToggledListener(FilterMode.FINISHED));
        Font smallHelvetica = new Font("Helvetica", 0, 12);
        Dimension buttonDimension = new Dimension(115, 28);
        this.applyFontAndDimensionToButtons(smallHelvetica, buttonDimension, this.filterAllButton, this.filterDownloadingButton, this.filterSeedingButton, this.filterFinishedButton);
        filterGroup.add(this.filterAllButton);
        filterGroup.add(this.filterDownloadingButton);
        filterGroup.add(this.filterSeedingButton);
        filterGroup.add(this.filterFinishedButton);
        filterButtonsContainer.add(this.filterAllButton);
        filterButtonsContainer.add(this.filterDownloadingButton);
        filterButtonsContainer.add(this.filterSeedingButton);
        filterButtonsContainer.add(this.filterFinishedButton);
        return filterButtonsContainer;
    }

    private void applyFontAndDimensionToButtons(Font font, Dimension dimension, JComponent ... buttons) {
        for (JComponent button : buttons) {
            button.setFont(font);
            button.setMinimumSize(dimension);
            button.setMaximumSize(dimension);
            button.setPreferredSize(dimension);
        }
    }

    @Override
    public JComponent getComponent() {
        return this.mainComponent;
    }

    private void onTextFilterKeyTyped() {
        String text = this.filterText.getText();
        if (text.equals("")) {
            this.restoreFilterTextHint();
        } else {
            this.filterText.setForeground(Color.BLACK);
        }
        if (this.transfersFilterModeListener != null) {
            this.transfersFilterModeListener.onFilterUpdate(text);
        }
    }

    private void clearFilterTextHint() {
        if (this.filterText.getText().equals(FILTER_TEXT_HINT)) {
            this.filterText.setText("");
            this.filterText.setForeground(Color.BLACK);
        }
    }

    private void restoreFilterTextHint() {
        this.filterText.setText(FILTER_TEXT_HINT);
        this.filterText.setForeground(Color.GRAY);
        this.filterText.selectAll();
    }

    private void onFilterTextFocusLost() {
        if (this.filterText.getText().equals("")) {
            this.restoreFilterTextHint();
        }
    }

    private class OnFilterButtonToggledListener
    implements ActionListener {
        private final FilterMode filterMode;

        OnFilterButtonToggledListener(FilterMode filterMode) {
            this.filterMode = filterMode;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (TransfersTab.this.transfersFilterModeListener != null) {
                TransfersTab.this.filterText.setText("");
                TransfersTab.this.transfersFilterModeListener.onFilterUpdate(this.filterMode, TransfersTab.this.filterText.getText());
            }
        }
    }

    private class TextFilterFocusAdapter
    extends FocusAdapter {
        private TextFilterFocusAdapter() {
        }

        @Override
        public void focusLost(FocusEvent e) {
            TransfersTab.this.onFilterTextFocusLost();
        }
    }

    private class TextFilterKeyAdapter
    extends KeyAdapter {
        private TextFilterKeyAdapter() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            TransfersTab.this.onTextFilterKeyTyped();
        }

        @Override
        public void keyReleased(KeyEvent e) {
            TransfersTab.this.onTextFilterKeyTyped();
        }
    }

    private class TextFilterMouseAdapter
    extends MouseAdapter {
        private TextFilterMouseAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            TransfersTab.this.clearFilterTextHint();
        }

        @Override
        public void mousePressed(MouseEvent e) {
            TransfersTab.this.clearFilterTextHint();
        }
    }

    private class TransferTableSelectionListener
    implements BTDownloadMediator.BTDownloadSelectionListener {
        private TransferTableSelectionListener() {
        }

        @Override
        public void onTransferSelected(BTDownload selected) {
            if (!TransfersTab.this.dedicatedTransfersTabAvailable) {
                TransfersTab.this.hideTransferDetailsComponent();
                return;
            }
            if (selected == null || selected instanceof SoundcloudDownload || selected instanceof HttpDownload || selected instanceof TorrentFetcherDownload) {
                TransfersTab.this.hideTransferDetailsComponent();
            } else if (selected instanceof BittorrentDownload) {
                BittorrentDownload bittorrentDownload = (BittorrentDownload)selected;
                TransfersTab.this.showTransferDetailsComponent(bittorrentDownload);
                BackgroundExecutorService.schedule(() -> {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    GUIMediator.safeInvokeLater(() -> TransfersTab.this.downloadMediator.ensureDownloadVisible(bittorrentDownload));
                });
            }
        }
    }

    public static interface TransfersFilterModeListener {
        public void onFilterUpdate(FilterMode var1, String var2);

        public void onFilterUpdate(String var1);
    }

    public static enum FilterMode {
        ALL,
        DOWNLOADING,
        SEEDING,
        FINISHED;

    }
}

