/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.player;

import com.frostwire.alexandria.PlaylistItem;
import java.io.File;

public class MediaSource {
    private final File file;
    private final String url;
    private final PlaylistItem playlistItem;
    String titleText = "";
    String toolTipText = "";

    public MediaSource(File file) {
        if (file == null) {
            throw new NullPointerException("File cannot be null");
        }
        this.file = file;
        this.url = null;
        this.playlistItem = null;
        this.titleText = this.file.getName();
        this.toolTipText = this.file.getAbsolutePath();
    }

    public MediaSource(String url) {
        if (url == null) {
            throw new NullPointerException("Url cannot be null");
        }
        this.file = null;
        this.url = url;
        this.playlistItem = null;
        this.titleText = "internet ";
        this.toolTipText = "";
    }

    public MediaSource(PlaylistItem playlistItem) {
        if (playlistItem == null) {
            throw new NullPointerException("PlaylistItem cannot be null");
        }
        this.file = null;
        this.url = null;
        this.playlistItem = playlistItem;
        String artistName = playlistItem.getTrackArtist();
        String songTitle = playlistItem.getTrackTitle();
        String albumToolTip = playlistItem.getTrackAlbum() != null && playlistItem.getTrackAlbum().length() > 0 ? " - " + playlistItem.getTrackAlbum() : "";
        String yearToolTip = playlistItem.getTrackYear() != null && playlistItem.getTrackYear().length() > 0 ? " (" + playlistItem.getTrackYear() + ")" : "";
        this.titleText = artistName + " - " + songTitle;
        this.toolTipText = artistName + " - " + songTitle + albumToolTip + yearToolTip;
    }

    public String toString() {
        String name = this.getFile() != null ? this.getFile().getName() : this.url;
        return "[MediaSource@" + this.hashCode() + ": " + name + "]";
    }

    public File getFile() {
        return this.file;
    }

    public String getURL() {
        return this.url;
    }

    public PlaylistItem getPlaylistItem() {
        return this.playlistItem;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MediaSource)) {
            return false;
        }
        MediaSource o = (MediaSource)obj;
        if (this.file != null && o.file != null) {
            return this.file.equals(o.file);
        }
        if (this.url != null && o.url != null) {
            return this.url.equals(o.url);
        }
        return this.playlistItem != null && o.playlistItem != null && this.playlistItem.equals(o.playlistItem);
    }

    public String getTitleText() {
        return this.titleText;
    }

    public String getToolTipText() {
        return this.toolTipText;
    }
}

